/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.coref;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Executable;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageAnalyser;
import gate.Node;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.ResourceReference;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.util.Benchmark;
import gate.util.Benchmarkable;
import gate.util.Err;
import gate.util.SimpleFeatureMapImpl;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@CreoleResource(isPrivate=true)
public class PronominalCoref
extends AbstractLanguageAnalyser
implements Benchmarkable {
    private static final long serialVersionUID = 3860815557386683264L;
    public static final String COREF_DOCUMENT_PARAMETER_NAME = "document";
    public static final String COREF_ANN_SET_PARAMETER_NAME = "annotationSetName";
    public static final String TRANSD_ENCODING_PARAMETER_NAME = "encoding";
    public static final String TRANSD_GRAMMAR_URL_PARAMETER_NAME = "grammarURL";
    private static final boolean DEBUG = false;
    private ResourceReference qtGrammarURL;
    private ResourceReference pleonGrammarURL;
    private static final String QUOTED_TEXT_TYPE = "QuotedText";
    private static final String PLEONASTIC_TYPE = "PleonasticIt";
    private static final String PRP_CATEGORY = "PRP";
    private static final String PRP$_CATEGORY = "PRP$";
    private static final int SENTENCES_IN_SCOPE = 3;
    private static AnnotationOffsetComparator ANNOTATION_OFFSET_COMPARATOR = new AnnotationOffsetComparator();
    private String annotationSetName;
    private LanguageAnalyser qtTransducer;
    private LanguageAnalyser pleonTransducer;
    private AnnotationSet defaultAnnotations;
    private transient Sentence[] textSentences;
    private transient Quote[] quotedText;
    private Annotation[] pleonasticIt;
    private Map<Annotation, String> personGender;
    private HashMap<Annotation, Annotation> anaphor2antecedent;
    private static final FeatureMap PRP_RESTRICTION = new SimpleFeatureMapImpl();
    private boolean resolveIt = true;
    private Set<String> inanimatedSet;
    private String inanimatedEntityTypes;
    private String benchmarkId;

    public ResourceReference getQuotedGrammarURL() {
        return this.qtGrammarURL;
    }

    @CreoleParameter(defaultValue="resources/coref/quoted_text.jape")
    public void setQuotedGrammarURL(ResourceReference qtGrammarURL) {
        this.qtGrammarURL = qtGrammarURL;
    }

    @Deprecated
    public void setQuotedGrammarURL(URL qtGrammarURL) {
        try {
            this.setQuotedGrammarURL(new ResourceReference(qtGrammarURL));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error converting URL to ResourceReference", e);
        }
    }

    public ResourceReference getPleonasmGrammarURL() {
        return this.pleonGrammarURL;
    }

    @CreoleParameter(defaultValue="resources/coref/pleonasm.jape")
    public void setPleonasmGrammarURL(ResourceReference pleonGrammarURL) {
        this.pleonGrammarURL = pleonGrammarURL;
    }

    @Deprecated
    public void setPleonasmGrammarURL(URL pleonGrammarURL) {
        try {
            this.setPleonasmGrammarURL(new ResourceReference(pleonGrammarURL));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error converting URL to ResourceReference", e);
        }
    }

    public Resource init() throws ResourceInstantiationException {
        this.personGender = new HashMap<Annotation, String>();
        this.anaphor2antecedent = new HashMap();
        this.inanimatedSet = new HashSet<String>();
        FeatureMap params = Factory.newFeatureMap();
        params.put((Object)TRANSD_GRAMMAR_URL_PARAMETER_NAME, (Object)this.qtGrammarURL);
        params.put((Object)TRANSD_ENCODING_PARAMETER_NAME, (Object)"UTF-8");
        if (this.qtTransducer == null) {
            this.features = Factory.newFeatureMap();
            Gate.setHiddenAttribute((FeatureMap)this.features, (boolean)true);
            this.qtTransducer = (LanguageAnalyser)Factory.createResource((String)"gate.creole.Transducer", (FeatureMap)params, (FeatureMap)this.features);
            this.qtTransducer.setName("PronominalCoref-QT " + System.currentTimeMillis());
        } else {
            this.qtTransducer.setParameterValues(params);
            this.qtTransducer.reInit();
        }
        params = Factory.newFeatureMap();
        params.put((Object)TRANSD_GRAMMAR_URL_PARAMETER_NAME, (Object)this.pleonGrammarURL);
        params.put((Object)TRANSD_ENCODING_PARAMETER_NAME, (Object)"UTF-8");
        if (this.pleonTransducer == null) {
            this.features = Factory.newFeatureMap();
            Gate.setHiddenAttribute((FeatureMap)this.features, (boolean)true);
            this.pleonTransducer = (LanguageAnalyser)Factory.createResource((String)"gate.creole.Transducer", (FeatureMap)params, (FeatureMap)this.features);
            this.pleonTransducer.setName("PronominalCoref-Pleon " + System.currentTimeMillis());
        } else {
            this.pleonTransducer.setParameterValues(params);
            this.pleonTransducer.reInit();
        }
        return this;
    }

    public void cleanup() {
        super.cleanup();
        Factory.deleteResource((Resource)this.qtTransducer);
        Factory.deleteResource((Resource)this.pleonTransducer);
    }

    public void setDocument(Document newDocument) {
        this.qtTransducer.setDocument(newDocument);
        this.pleonTransducer.setDocument(newDocument);
        super.setDocument(newDocument);
    }

    public void setAnnotationSetName(String annotationSetName) {
        this.annotationSetName = annotationSetName;
    }

    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public void setResolveIt(Boolean newValue) {
        this.resolveIt = newValue;
    }

    public Boolean getResolveIt() {
        return this.resolveIt;
    }

    public void execute() throws ExecutionException {
        if (null == this.document) {
            throw new ExecutionException("[coreference] Document is not set!");
        }
        this.preprocess();
        SimpleFeatureMapImpl constraintPRP = new SimpleFeatureMapImpl();
        constraintPRP.put((Object)"category", (Object)PRP_CATEGORY);
        AnnotationSet personalPronouns = this.defaultAnnotations.get("Token", (FeatureMap)constraintPRP);
        SimpleFeatureMapImpl constraintPRP$ = new SimpleFeatureMapImpl();
        constraintPRP$.put((Object)"category", (Object)PRP$_CATEGORY);
        AnnotationSet possesivePronouns = this.defaultAnnotations.get("Token", (FeatureMap)constraintPRP$);
        ArrayList pronouns = new ArrayList();
        if (personalPronouns != null && !personalPronouns.isEmpty()) {
            pronouns.addAll(personalPronouns);
        }
        if (possesivePronouns != null && !possesivePronouns.isEmpty()) {
            pronouns.addAll(possesivePronouns);
        }
        if (pronouns.isEmpty()) {
            return;
        }
        Annotation[] arrPronouns = pronouns.toArray(new Annotation[pronouns.size()]);
        Arrays.sort(arrPronouns, ANNOTATION_OFFSET_COMPARATOR);
        int prnSentIndex = 0;
        for (int i = 0; i < arrPronouns.length; ++i) {
            Annotation currPronoun = arrPronouns[i];
            while (this.textSentences[prnSentIndex].getEndOffset() < currPronoun.getEndNode().getOffset()) {
                ++prnSentIndex;
            }
            Sentence currSentence = this.textSentences[prnSentIndex];
            assert (currSentence.getStartOffset() <= currPronoun.getStartNode().getOffset());
            assert (currSentence.getEndOffset() >= currPronoun.getEndNode().getOffset());
            Annotation antc = this.findAntecedent(currPronoun, prnSentIndex);
            this.anaphor2antecedent.put(currPronoun, antc);
        }
    }

    public Map<Annotation, Annotation> getResolvedAnaphora() {
        return this.anaphor2antecedent;
    }

    private Annotation findAntecedent(Annotation currPronoun, int prnSentIndex) {
        assert (null != currPronoun);
        assert (prnSentIndex >= 0);
        assert (currPronoun.getType().equals("Token"));
        assert (currPronoun.getFeatures().get((Object)"category").equals(PRP_CATEGORY) || currPronoun.getFeatures().get((Object)"category").equals(PRP$_CATEGORY));
        String strPronoun = (String)currPronoun.getFeatures().get((Object)"string");
        assert (null != strPronoun);
        if (strPronoun.equalsIgnoreCase("HE") || strPronoun.equalsIgnoreCase("HIM") || strPronoun.equalsIgnoreCase("HIS") || strPronoun.equalsIgnoreCase("HIMSELF")) {
            return this._resolve$HE$HIM$HIS$HIMSELF$(currPronoun, prnSentIndex);
        }
        if (strPronoun.equalsIgnoreCase("SHE") || strPronoun.equalsIgnoreCase("HER") || strPronoun.equalsIgnoreCase("HERS") || strPronoun.equalsIgnoreCase("HERSELF")) {
            return this._resolve$SHE$HER$HERS$HERSELF$(currPronoun, prnSentIndex);
        }
        if (strPronoun.equalsIgnoreCase("IT") || strPronoun.equalsIgnoreCase("ITS") || strPronoun.equalsIgnoreCase("ITSELF")) {
            return this._resolve$IT$ITS$ITSELF$(currPronoun, prnSentIndex);
        }
        if (strPronoun.equalsIgnoreCase("I") || strPronoun.equalsIgnoreCase("ME") || strPronoun.equalsIgnoreCase("MY") || strPronoun.equalsIgnoreCase("MINE") || strPronoun.equalsIgnoreCase("MYSELF")) {
            return this._resolve$I$ME$MY$MINE$MYSELF$(currPronoun, prnSentIndex);
        }
        return null;
    }

    boolean isPleonastic(Annotation pronoun) {
        Annotation pleonasm;
        assert (null != pronoun);
        String str = (String)pronoun.getFeatures().get((Object)"string");
        assert (str.equalsIgnoreCase("IT"));
        if (this.pleonasticIt.length == 0) {
            return false;
        }
        int closestPleonasmIndex = Arrays.binarySearch(this.pleonasticIt, pronoun, ANNOTATION_OFFSET_COMPARATOR);
        if (closestPleonasmIndex < 0) {
            closestPleonasmIndex = -closestPleonasmIndex - 1 - 1;
        }
        if (closestPleonasmIndex < 0) {
            closestPleonasmIndex = 0;
        }
        boolean result = (pleonasm = this.pleonasticIt[closestPleonasmIndex]).getStartNode().getOffset().intValue() <= pronoun.getStartNode().getOffset().intValue() && pleonasm.getEndNode().getOffset().intValue() >= pronoun.getEndNode().getOffset().intValue();
        return result;
    }

    private Annotation _resolve$HE$HIM$HIS$HIMSELF$(Annotation pronoun, int sentenceIndex) {
        assert (pronoun.getType().equals("Token"));
        assert (pronoun.getFeatures().get((Object)"category").equals(PRP_CATEGORY) || pronoun.getFeatures().get((Object)"category").equals(PRP$_CATEGORY));
        String pronounString = (String)pronoun.getFeatures().get((Object)"string");
        assert (pronounString.equalsIgnoreCase("HE") || pronounString.equalsIgnoreCase("HIM") || pronounString.equalsIgnoreCase("HIS") || pronounString.equalsIgnoreCase("HIMSELF"));
        boolean antecedentFound = false;
        int scopeFirstIndex = sentenceIndex - 3;
        if (scopeFirstIndex < 0) {
            scopeFirstIndex = 0;
        }
        int currSentenceIndex = sentenceIndex;
        Annotation bestAntecedent = null;
        while (currSentenceIndex >= scopeFirstIndex || !antecedentFound) {
            Sentence currSentence = this.textSentences[currSentenceIndex];
            AnnotationSet persons = currSentence.getPersons();
            for (Annotation currPerson : persons) {
                String gender = this.personGender.get(currPerson);
                if (null != gender && !gender.equalsIgnoreCase("MALE") && !gender.equalsIgnoreCase("UNKNOWN")) continue;
                antecedentFound = true;
                if (null == bestAntecedent) {
                    bestAntecedent = currPerson;
                    continue;
                }
                bestAntecedent = this._chooseAntecedent$HE$HIM$HIS$SHE$HER$HERS$HIMSELF$HERSELF$(bestAntecedent, currPerson, pronoun);
            }
            if (0 != currSentenceIndex--) continue;
            break;
        }
        return bestAntecedent;
    }

    private Annotation _resolve$SHE$HER$HERS$HERSELF$(Annotation pronoun, int sentenceIndex) {
        assert (pronoun.getType().equals("Token"));
        assert (pronoun.getFeatures().get((Object)"category").equals(PRP_CATEGORY) || pronoun.getFeatures().get((Object)"category").equals(PRP$_CATEGORY));
        String pronounString = (String)pronoun.getFeatures().get((Object)"string");
        assert (pronounString.equalsIgnoreCase("SHE") || pronounString.equalsIgnoreCase("HER") || pronounString.equalsIgnoreCase("HERS") || pronounString.equalsIgnoreCase("HERSELF"));
        boolean antecedentFound = false;
        int scopeFirstIndex = sentenceIndex - 3;
        if (scopeFirstIndex < 0) {
            scopeFirstIndex = 0;
        }
        int currSentenceIndex = sentenceIndex;
        Annotation bestAntecedent = null;
        while (currSentenceIndex >= scopeFirstIndex || !antecedentFound) {
            Sentence currSentence = this.textSentences[currSentenceIndex];
            AnnotationSet persons = currSentence.getPersons();
            for (Annotation currPerson : persons) {
                String gender = this.personGender.get(currPerson);
                if (null != gender && !gender.equalsIgnoreCase("FEMALE") && !gender.equalsIgnoreCase("UNKNOWN")) continue;
                antecedentFound = true;
                if (null == bestAntecedent) {
                    bestAntecedent = currPerson;
                    continue;
                }
                bestAntecedent = this._chooseAntecedent$HE$HIM$HIS$SHE$HER$HERS$HIMSELF$HERSELF$(bestAntecedent, currPerson, pronoun);
            }
            if (0 != currSentenceIndex--) continue;
            break;
        }
        return bestAntecedent;
    }

    private Annotation _resolve$IT$ITS$ITSELF$(Annotation pronoun, int sentenceIndex) {
        if (!this.resolveIt) {
            return null;
        }
        assert (pronoun.getType().equals("Token"));
        assert (pronoun.getFeatures().get((Object)"category").equals(PRP_CATEGORY) || pronoun.getFeatures().get((Object)"category").equals(PRP$_CATEGORY));
        String pronounString = (String)pronoun.getFeatures().get((Object)"string");
        assert (pronounString.equalsIgnoreCase("IT") || pronounString.equalsIgnoreCase("ITS") || pronounString.equalsIgnoreCase("ITSELF"));
        if (pronounString.equalsIgnoreCase("IT") && this.isPleonastic(pronoun)) {
            return null;
        }
        int scopeFirstIndex = sentenceIndex - 1;
        if (scopeFirstIndex < 0) {
            scopeFirstIndex = 0;
        }
        int currSentenceIndex = sentenceIndex;
        Annotation bestAntecedent = null;
        while (currSentenceIndex >= scopeFirstIndex) {
            Sentence currSentence = this.textSentences[currSentenceIndex];
            AnnotationSet org_loc = currSentence.getInanimated();
            for (Annotation currOrgLoc : org_loc) {
                if (null == bestAntecedent) {
                    if (currOrgLoc.getStartNode().getOffset() >= pronoun.getStartNode().getOffset()) continue;
                    bestAntecedent = currOrgLoc;
                    continue;
                }
                bestAntecedent = this._chooseAntecedent$IT$ITS$ITSELF$(bestAntecedent, currOrgLoc, pronoun);
            }
            if (0 != currSentenceIndex--) continue;
            break;
        }
        return bestAntecedent;
    }

    private Annotation _resolve$I$ME$MY$MINE$MYSELF$(Annotation pronoun, int sentenceIndex) {
        Set<Annotation> precCandidates;
        assert (pronoun.getType().equals("Token"));
        assert (pronoun.getFeatures().get((Object)"category").equals(PRP_CATEGORY) || pronoun.getFeatures().get((Object)"category").equals(PRP$_CATEGORY));
        String pronounString = (String)pronoun.getFeatures().get((Object)"string");
        assert (pronounString.equalsIgnoreCase("I") || pronounString.equalsIgnoreCase("MY") || pronounString.equalsIgnoreCase("ME") || pronounString.equalsIgnoreCase("MINE") || pronounString.equalsIgnoreCase("MYSELF"));
        if (0 == this.quotedText.length) {
            return null;
        }
        Annotation bestAntecedent = null;
        int closestQuoteIndex = Arrays.binarySearch(this.quotedText, pronoun, ANNOTATION_OFFSET_COMPARATOR);
        if (closestQuoteIndex < 0) {
            closestQuoteIndex = -closestQuoteIndex - 1 - 1;
        }
        if (closestQuoteIndex < 0) {
            closestQuoteIndex = 0;
        }
        Quote quoteContext = this.quotedText[closestQuoteIndex];
        if (pronoun.getStartNode().getOffset().intValue() > quoteContext.getEndOffset().intValue() || pronoun.getEndNode().getOffset().intValue() < quoteContext.getStartOffset().intValue()) {
            return null;
        }
        Set<Annotation> succCandidates = quoteContext.getAntecedentCandidates(1);
        if (!succCandidates.isEmpty()) {
            for (Annotation currCandidate : succCandidates) {
                if (null != bestAntecedent && ANNOTATION_OFFSET_COMPARATOR.compare(bestAntecedent, currCandidate) <= 0) continue;
                bestAntecedent = currCandidate;
            }
        }
        if (null == bestAntecedent && !(precCandidates = quoteContext.getAntecedentCandidates(2)).isEmpty()) {
            for (Annotation currCandidate : precCandidates) {
                if (null != bestAntecedent && ANNOTATION_OFFSET_COMPARATOR.compare(bestAntecedent, currCandidate) >= 0) continue;
                bestAntecedent = currCandidate;
            }
        }
        if (null == bestAntecedent && !(precCandidates = quoteContext.getAntecedentCandidates(3)).isEmpty()) {
            for (Annotation currCandidate : precCandidates) {
                if (null != bestAntecedent && ANNOTATION_OFFSET_COMPARATOR.compare(bestAntecedent, currCandidate) <= 0) continue;
                bestAntecedent = currCandidate;
            }
        }
        return bestAntecedent;
    }

    private void preprocess() throws ExecutionException {
        this.personGender.clear();
        this.anaphor2antecedent.clear();
        this.defaultAnnotations = this.annotationSetName == null || this.annotationSetName.equals("") ? this.document.getAnnotations() : this.document.getAnnotations(this.annotationSetName);
        if (this.defaultAnnotations == null || this.defaultAnnotations.isEmpty()) {
            Err.prln((String)"Coref Warning: No annotations found for processing!");
            return;
        }
        if (this.inanimatedEntityTypes == null || this.inanimatedEntityTypes.equals("")) {
            this.inanimatedEntityTypes = "Organization;Location";
        }
        String[] types = this.inanimatedEntityTypes.split(";");
        this.inanimatedSet.addAll(Arrays.asList(types));
        AnnotationSet qtSet = this.defaultAnnotations.get(QUOTED_TEXT_TYPE);
        if (qtSet != null && !qtSet.isEmpty()) {
            this.defaultAnnotations.removeAll((Collection)qtSet);
        }
        Benchmark.executeWithBenchmarking((Executable)this.qtTransducer, (String)Benchmark.createBenchmarkId((String)"qtTransducer", (String)this.getBenchmarkId()), (Object)((Object)this), null);
        AnnotationSet pleonSet = this.defaultAnnotations.get(PLEONASTIC_TYPE);
        if (pleonSet != null && !pleonSet.isEmpty()) {
            this.defaultAnnotations.removeAll((Collection)pleonSet);
        }
        Benchmark.executeWithBenchmarking((Executable)this.pleonTransducer, (String)Benchmark.createBenchmarkId((String)"pleonTransducer", (String)this.getBenchmarkId()), (Object)((Object)this), null);
        AnnotationSet sentenceAnnotations = this.defaultAnnotations.get("Sentence");
        this.textSentences = new Sentence[sentenceAnnotations.size()];
        Annotation[] sentenceArray = (Annotation[])sentenceAnnotations.toArray((Object[])new Annotation[sentenceAnnotations.size()]);
        Arrays.sort(sentenceArray, ANNOTATION_OFFSET_COMPARATOR);
        for (int i = 0; i < sentenceArray.length; ++i) {
            Annotation currSentence = sentenceArray[i];
            Long sentStartOffset = currSentence.getStartNode().getOffset();
            Long sentEndOffset = currSentence.getEndNode().getOffset();
            AnnotationSet tempASOffsets = this.defaultAnnotations.getContained(sentStartOffset, sentEndOffset);
            AnnotationSet sentPersons = tempASOffsets.get("Person");
            AnnotationSet sentInans = tempASOffsets.get(this.inanimatedSet);
            this.textSentences[i] = new Sentence(i, 0, sentStartOffset, sentEndOffset, sentPersons, sentInans);
            for (Annotation currPerson : sentPersons) {
                String gender = this.findPersonGender(currPerson);
                this.personGender.put(currPerson, gender);
            }
        }
        AnnotationSet sentQuotes = this.defaultAnnotations.get(QUOTED_TEXT_TYPE);
        if (null == sentQuotes) {
            this.quotedText = new Quote[0];
        } else {
            this.quotedText = new Quote[sentQuotes.size()];
            Annotation[] quotesArray = (Annotation[])sentQuotes.toArray((Object[])new Annotation[sentQuotes.size()]);
            Arrays.sort(quotesArray, ANNOTATION_OFFSET_COMPARATOR);
            for (int i = 0; i < quotesArray.length; ++i) {
                this.quotedText[i] = new Quote(quotesArray[i], i);
            }
        }
        AnnotationSet plaonasticSet = this.defaultAnnotations.get(PLEONASTIC_TYPE);
        if (null == plaonasticSet) {
            this.pleonasticIt = new Annotation[0];
        } else {
            this.pleonasticIt = new Annotation[plaonasticSet.size()];
            Annotation[] quotesArray = (Annotation[])plaonasticSet.toArray((Object[])new Annotation[plaonasticSet.size()]);
            Arrays.sort(quotesArray, ANNOTATION_OFFSET_COMPARATOR);
            for (int i = 0; i < this.pleonasticIt.length; ++i) {
                this.pleonasticIt[i] = quotesArray[i];
            }
        }
    }

    private String findPersonGender(Annotation person) {
        List orthoMatches;
        String result = (String)person.getFeatures().get((Object)"gender");
        if (null == result && null != (orthoMatches = (List)person.getFeatures().get((Object)"matches"))) {
            for (Integer correferringID : orthoMatches) {
                Annotation coreferringEntity = this.defaultAnnotations.get(correferringID);
                if (coreferringEntity == null) continue;
                assert (coreferringEntity.getType().equalsIgnoreCase("Person"));
                String correferringGender = (String)coreferringEntity.getFeatures().get((Object)"gender");
                if (null == correferringGender) continue;
                result = correferringGender;
                break;
            }
        }
        return result;
    }

    private Annotation _chooseAntecedent$HE$HIM$HIS$SHE$HER$HERS$HIMSELF$HERSELF$(Annotation ant1, Annotation ant2, Annotation pronoun) {
        assert (null != ant1);
        assert (null != ant2);
        assert (null != pronoun);
        assert (pronoun.getFeatures().get((Object)"category").equals(PRP_CATEGORY) || pronoun.getFeatures().get((Object)"category").equals(PRP$_CATEGORY));
        String pronounString = (String)pronoun.getFeatures().get((Object)"string");
        assert (pronounString.equalsIgnoreCase("SHE") || pronounString.equalsIgnoreCase("HER") || pronounString.equalsIgnoreCase("HERS") || pronounString.equalsIgnoreCase("HERSELF") || pronounString.equalsIgnoreCase("HE") || pronounString.equalsIgnoreCase("HIM") || pronounString.equalsIgnoreCase("HIS") || pronounString.equalsIgnoreCase("HIMSELF"));
        Long offset1 = ant1.getStartNode().getOffset();
        Long offset2 = ant2.getStartNode().getOffset();
        Long offsetPrn = pronoun.getStartNode().getOffset();
        long diff1 = offsetPrn - offset1;
        long diff2 = offsetPrn - offset2;
        if (diff1 == 0L) {
            return ant2;
        }
        if (diff2 == 0L) {
            return ant1;
        }
        if (diff1 > 0L && diff2 > 0L) {
            if (diff1 < diff2) {
                return ant1;
            }
            return ant2;
        }
        if (diff1 < 0L && diff2 < 0L) {
            if (Math.abs(diff1) < Math.abs(diff2)) {
                return ant1;
            }
            return ant2;
        }
        assert (Math.abs(diff1 + diff2) < Math.abs(diff1) + Math.abs(diff2));
        if (diff1 > 0L) {
            return ant1;
        }
        return ant2;
    }

    private Annotation _chooseAntecedent$IT$ITS$ITSELF$(Annotation ant1, Annotation ant2, Annotation pronoun) {
        assert (null != ant1);
        assert (null != ant2);
        assert (null != pronoun);
        assert (pronoun.getFeatures().get((Object)"category").equals(PRP_CATEGORY) || pronoun.getFeatures().get((Object)"category").equals(PRP$_CATEGORY));
        String pronounString = (String)pronoun.getFeatures().get((Object)"string");
        assert (pronounString.equalsIgnoreCase("IT") || pronounString.equalsIgnoreCase("ITS") || pronounString.equalsIgnoreCase("ITSELF"));
        Long offset1 = ant1.getStartNode().getOffset();
        Long offset2 = ant2.getStartNode().getOffset();
        Long offsetPrn = pronoun.getStartNode().getOffset();
        long diff1 = offsetPrn - offset1;
        long diff2 = offsetPrn - offset2;
        if (diff1 == 0L) {
            return ant2;
        }
        if (diff2 == 0L) {
            return ant1;
        }
        if (diff1 > 0L && diff2 > 0L) {
            if (diff1 < diff2) {
                return ant1;
            }
            return ant2;
        }
        if (diff1 > 0L) {
            assert (Math.abs(diff1 + diff2) < Math.abs(diff1) + Math.abs(diff2));
            return ant1;
        }
        if (diff2 > 0L) {
            assert (Math.abs(diff1 + diff2) < Math.abs(diff1) + Math.abs(diff2));
            return ant2;
        }
        return null;
    }

    public String getInanimatedEntityTypes() {
        return this.inanimatedEntityTypes;
    }

    public void setInanimatedEntityTypes(String inanimatedEntityTypes) {
        this.inanimatedEntityTypes = inanimatedEntityTypes;
    }

    public String getBenchmarkId() {
        if (this.benchmarkId == null) {
            return this.getName();
        }
        return this.benchmarkId;
    }

    public void setBenchmarkId(String benchmarkId) {
        this.benchmarkId = benchmarkId;
    }

    static {
        PRP_RESTRICTION.put((Object)"category", (Object)PRP_CATEGORY);
    }

    private class Sentence {
        private int sentNumber;
        private int paraNumber;
        private Long startOffset;
        private Long endOffset;
        private AnnotationSet persons;
        private AnnotationSet inanimated;

        public Sentence(int sentNumber, int paraNumber, Long startOffset, Long endOffset, AnnotationSet persons, AnnotationSet inanimated) {
            this.sentNumber = sentNumber;
            this.paraNumber = paraNumber;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.persons = persons;
            this.inanimated = inanimated;
        }

        public Long getStartOffset() {
            return this.startOffset;
        }

        public Long getEndOffset() {
            return this.endOffset;
        }

        public AnnotationSet getPersons() {
            return this.persons;
        }

        public AnnotationSet getInanimated() {
            return this.inanimated;
        }
    }

    private class Quote {
        public static final int ANTEC_AFTER = 1;
        public static final int ANTEC_BEFORE = 2;
        public static final int ANTEC_BACK = 3;
        private Set<Annotation> antecedentsBefore;
        private Set<Annotation> antecedentsAfter;
        private Set<Annotation> antecedentsBackInContext;
        private Annotation quoteAnnotation;
        private int quoteIndex;

        public Quote(Annotation quoteAnnotation, int index) {
            this.quoteAnnotation = quoteAnnotation;
            this.quoteIndex = index;
            this.init();
        }

        private void init() {
            int quoteEndPos;
            int endSentenceIndex;
            int startSentenceIndex;
            assert (null != PronominalCoref.this.textSentences);
            SimpleFeatureMapImpl prpTokenRestriction = new SimpleFeatureMapImpl();
            prpTokenRestriction.put((Object)"category", (Object)PronominalCoref.PRP_CATEGORY);
            int quoteStartPos = Arrays.binarySearch(PronominalCoref.this.textSentences, this.quoteAnnotation.getStartNode(), ANNOTATION_OFFSET_COMPARATOR);
            int n = startSentenceIndex = quoteStartPos >= 0 ? quoteStartPos : -quoteStartPos - 1 - 1;
            if (startSentenceIndex < 0) {
                startSentenceIndex = 0;
            }
            this.antecedentsBefore = this.generateAntecedentCandidates(startSentenceIndex, this.quoteIndex, 2);
            if (startSentenceIndex > 0) {
                this.antecedentsBackInContext = this.generateAntecedentCandidates(startSentenceIndex - 1, this.quoteIndex, 3);
            }
            int n2 = endSentenceIndex = (quoteEndPos = Arrays.binarySearch(PronominalCoref.this.textSentences, this.quoteAnnotation.getEndNode(), ANNOTATION_OFFSET_COMPARATOR)) >= 0 ? quoteEndPos : -quoteEndPos - 1 - 1;
            if (endSentenceIndex < 0) {
                endSentenceIndex = 0;
            }
            this.antecedentsAfter = this.generateAntecedentCandidates(endSentenceIndex, this.quoteIndex, 1);
        }

        private Set<Annotation> generateAntecedentCandidates(int sentenceNumber, int quoteNumber, int mode) {
            AnnotationSet pronouns;
            assert (sentenceNumber >= 0);
            assert (quoteNumber >= 0);
            assert (mode == 1 || mode == 2 || mode == 3);
            Sentence sentence = PronominalCoref.this.textSentences[sentenceNumber];
            HashSet<Annotation> antecedents = new HashSet<Annotation>((Collection<Annotation>)sentence.getPersons());
            AnnotationSet annotations = null;
            switch (mode) {
                case 2: {
                    annotations = PronominalCoref.this.defaultAnnotations.getContained(sentence.getStartOffset(), this.getStartOffset());
                    break;
                }
                case 1: {
                    annotations = PronominalCoref.this.defaultAnnotations.getContained(this.getEndOffset(), sentence.getEndOffset());
                    break;
                }
                case 3: {
                    annotations = PronominalCoref.this.defaultAnnotations.getContained(sentence.getStartOffset(), sentence.getEndOffset());
                }
            }
            if (null != annotations && null != (pronouns = annotations.get("Token", PRP_RESTRICTION))) {
                for (Annotation currPronoun : pronouns) {
                    String pronounString = (String)currPronoun.getFeatures().get((Object)"string");
                    if (null == pronounString || !pronounString.equalsIgnoreCase("he") && !pronounString.equalsIgnoreCase("she")) continue;
                    antecedents.add(currPronoun);
                }
            }
            Iterator itPersons = antecedents.iterator();
            while (itPersons.hasNext()) {
                Annotation currPerson = (Annotation)itPersons.next();
                if (2 == mode && currPerson.getStartNode().getOffset().intValue() > this.getStartOffset().intValue()) {
                    itPersons.remove();
                    continue;
                }
                if (1 == mode && currPerson.getStartNode().getOffset().intValue() < this.getEndOffset().intValue()) {
                    itPersons.remove();
                    continue;
                }
                if (3 != mode || quoteNumber <= 0) continue;
                Quote prevQuote = PronominalCoref.this.quotedText[quoteNumber - 1];
                if (currPerson.getStartNode().getOffset() >= prevQuote.getEndOffset()) continue;
                itPersons.remove();
            }
            return antecedents;
        }

        public Long getStartOffset() {
            return this.quoteAnnotation.getStartNode().getOffset();
        }

        public Long getEndOffset() {
            return this.quoteAnnotation.getEndNode().getOffset();
        }

        public Set<Annotation> getAntecedentCandidates(int type) {
            switch (type) {
                case 1: {
                    return null != this.antecedentsAfter ? this.antecedentsAfter : new HashSet<Annotation>();
                }
                case 2: {
                    return null != this.antecedentsBefore ? this.antecedentsBefore : new HashSet<Annotation>();
                }
                case 3: {
                    return null != this.antecedentsBackInContext ? this.antecedentsBackInContext : new HashSet<Annotation>();
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private static class AnnotationOffsetComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 4529121506801473785L;

        private AnnotationOffsetComparator() {
        }

        private int _getOffset(Object o) {
            if (o instanceof Annotation) {
                return ((Annotation)o).getEndNode().getOffset().intValue();
            }
            if (o instanceof Sentence) {
                return ((Sentence)o).getStartOffset().intValue();
            }
            if (o instanceof Quote) {
                return ((Quote)o).getStartOffset().intValue();
            }
            if (o instanceof Node) {
                return ((Node)o).getOffset().intValue();
            }
            throw new IllegalArgumentException();
        }

        public int compare(Object o1, Object o2) {
            assert (null != o1);
            assert (null != o2);
            assert (o1 instanceof Annotation || o1 instanceof Sentence || o1 instanceof Quote || o1 instanceof Node);
            assert (o2 instanceof Annotation || o2 instanceof Sentence || o2 instanceof Quote || o2 instanceof Node);
            int offset1 = this._getOffset(o1);
            int offset2 = this._getOffset(o2);
            return offset1 - offset2;
        }
    }
}

