/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.util.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SourceInfo {
    private List<BlockInfo> blocks = new ArrayList<BlockInfo>();
    private String className = null;
    private String phaseName = null;
    private String sectionName = null;

    public SourceInfo(String className, String phaseName, String sectionName) {
        this.className = className;
        this.phaseName = phaseName;
        this.sectionName = sectionName;
    }

    public String addBlock(String previousCode, String codeBlock) {
        if (!codeBlock.startsWith("  // JAPE Source:")) {
            return codeBlock;
        }
        String info = codeBlock.substring(18, codeBlock.indexOf("\n")).trim();
        String code = codeBlock.substring(codeBlock.indexOf("\n") + 1);
        String japeURL = info.substring(0, info.lastIndexOf(":"));
        int lineNumber = Integer.parseInt(info.substring(info.lastIndexOf(":") + 1));
        int startLine = previousCode.split("\n").length + 1;
        int endLine = startLine + code.split("\n").length;
        int startOffset = previousCode.length();
        int endOffset = previousCode.length() + code.length();
        this.blocks.add(new BlockInfo(japeURL, lineNumber, startLine, endLine, startOffset, endOffset));
        return code;
    }

    public String getSource(String source, int javaLineNumber) {
        for (BlockInfo info : this.blocks) {
            if (!info.contains(javaLineNumber)) continue;
            return info.getSource(source, info.getJapeLineNumber(javaLineNumber));
        }
        return "";
    }

    public StackTraceElement getStackTraceElement(int javaLineNumber) {
        for (BlockInfo info : this.blocks) {
            StackTraceElement japeSTE = info.getStackTraceElement(javaLineNumber);
            if (japeSTE == null) continue;
            return japeSTE;
        }
        return null;
    }

    public void enhanceTheThrowable(Throwable t) {
        if (t.getCause() != null) {
            this.enhanceTheThrowable(t.getCause());
        }
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>();
        for (StackTraceElement ste : t.getStackTrace()) {
            if (ste.getClassName().equals(this.className)) {
                StackTraceElement japeSTE = null;
                if (ste.getLineNumber() >= 0) {
                    BlockInfo info;
                    Iterator<BlockInfo> iterator = this.blocks.iterator();
                    while (iterator.hasNext() && (japeSTE = (info = iterator.next()).getStackTraceElement(ste.getLineNumber())) == null) {
                    }
                } else {
                    japeSTE = new StackTraceElement(this.phaseName, this.sectionName, null, -1);
                }
                stack.add(japeSTE != null ? japeSTE : ste);
                continue;
            }
            stack.add(ste);
        }
        t.setStackTrace(stack.toArray(new StackTraceElement[stack.size()]));
    }

    private class BlockInfo {
        String japeURL;
        int japeLine;
        int startLine;
        int endLine;
        int startOffset;
        int endOffset;

        BlockInfo(String japeURL, int japeLine, int startLine, int endLine, int startOffset, int endOffset) {
            this.japeURL = japeURL;
            this.japeLine = japeLine;
            this.startLine = startLine;
            this.endLine = endLine;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public boolean contains(int lineNumber) {
            return this.startLine <= lineNumber && lineNumber <= this.endLine;
        }

        public String getNumberedSource(String source) {
            return Strings.addLineNumbers((String)this.getSource(source), (int)this.japeLine);
        }

        public String getSource(String source, int line) {
            String[] lines = this.getSource(source).split("\n");
            return lines[line - this.japeLine];
        }

        public int getJapeLineNumber(int javaLineNumber) {
            if (!this.contains(javaLineNumber)) {
                return -1;
            }
            return this.japeLine + (javaLineNumber - this.startLine);
        }

        public StackTraceElement getStackTraceElement(int javaLineNumber) {
            int japeLineNumber = this.getJapeLineNumber(javaLineNumber);
            if (japeLineNumber == -1) {
                return null;
            }
            return new StackTraceElement(SourceInfo.this.phaseName, SourceInfo.this.sectionName, this.japeURL, japeLineNumber);
        }

        public String getSource(String source) {
            return source.substring(this.startOffset, this.endOffset);
        }
    }
}

