/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Controller;
import gate.Corpus;
import gate.Document;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.ExecutionException;
import gate.creole.ontology.Ontology;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.jape.ActionContext;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.JapeFactory;
import gate.jape.Transducer;
import gate.jape.parser.ParseCpsl;
import gate.jape.parser.ParseException;
import gate.util.Benchmarkable;
import gate.util.GateClassLoader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Vector;

public class Batch
implements JapeConstants,
Benchmarkable {
    private static final long serialVersionUID = -5787362511680231837L;
    private URL japeURL;
    private String encoding;
    private Transducer transducer;
    private ActionContext actionContext;
    private transient GateClassLoader classLoader = null;
    private FeatureMap features;
    private transient Vector<ProgressListener> progressListeners;
    private transient Vector<StatusListener> statusListeners;
    private boolean enableDebugging;

    public void setActionContext(ActionContext ac) {
        this.actionContext = ac;
    }

    public void finalize() throws Throwable {
        Gate.getClassLoader().forgetClassLoader(this.classLoader);
        super.finalize();
    }

    public Batch(URL url, String encoding) throws JapeException {
        this.japeURL = url;
        this.encoding = encoding;
        this.classLoader = Gate.getClassLoader().getDisposableClassLoader(url.toExternalForm() + System.currentTimeMillis(), true);
        this.parseJape();
        this.linkListeners();
    }

    public Batch(URL url, String encoding, StatusListener sListener) throws JapeException {
        this.addStatusListener(sListener);
        this.japeURL = url;
        this.encoding = encoding;
        this.classLoader = Gate.getClassLoader().getDisposableClassLoader(url.toExternalForm() + System.currentTimeMillis(), true);
        this.parseJape();
        this.linkListeners();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.classLoader = Gate.getClassLoader().getDisposableClassLoader(in.toString(), true);
        in.defaultReadObject();
        this.linkListeners();
    }

    protected void linkListeners() {
        if (this.transducer != null) {
            this.transducer.addStatusListener(new StatusListener(){

                public void statusChanged(String text) {
                    Batch.this.fireStatusChanged(text);
                }
            });
            this.transducer.addProgressListener(new ProgressListener(){

                public void progressChanged(int value) {
                    Batch.this.fireProgressChanged(value);
                }

                public void processFinished() {
                    Batch.this.fireProcessFinished();
                }
            });
        }
    }

    public synchronized void interrupt() {
        this.transducer.interrupt();
    }

    public Transducer getTransducer() {
        return this.transducer;
    }

    private void parseJape() throws JapeException {
        try {
            ParseCpsl parser = JapeFactory.newJapeParser(this.japeURL, this.encoding);
            StatusListener listener = null;
            listener = new StatusListener(){

                public void statusChanged(String text) {
                    Batch.this.fireStatusChanged(text);
                }
            };
            parser.addStatusListener(listener);
            this.transducer = parser.MultiPhaseTransducer();
            parser.removeStatusListener(listener);
            this.transducer.addStatusListener(listener);
            this.transducer.finish(this.classLoader);
            this.transducer.removeStatusListener(listener);
        }
        catch (ParseException e) {
            throw new JapeException("Batch: error parsing transducer: " + e.getMessage());
        }
        catch (IOException e) {
            throw new JapeException("Batch: couldn't open JAPE file: " + e.getMessage());
        }
    }

    public void transduce(Corpus coll) throws JapeException, ExecutionException {
        for (Document doc : coll) {
            this.transduce(doc, doc.getAnnotations(), doc.getAnnotations());
        }
    }

    public void transduce(Document doc) throws JapeException, ExecutionException {
        this.transduce(doc, doc.getAnnotations(), doc.getAnnotations());
    }

    public void transduce(Document doc, AnnotationSet inputAS, AnnotationSet outputAS) throws JapeException, ExecutionException {
        if (inputAS == null || inputAS.isEmpty()) {
            return;
        }
        this.transducer.setActionContext(this.actionContext);
        this.transducer.transduce(doc, inputAS, outputAS);
    }

    public void setFeatures(FeatureMap newFeatures) {
        this.features = newFeatures;
    }

    public FeatureMap getFeatures() {
        return this.features;
    }

    public synchronized void removeProgressListener(ProgressListener l) {
        if (this.progressListeners != null && this.progressListeners.contains(l)) {
            Vector v = (Vector)this.progressListeners.clone();
            v.removeElement(l);
            this.progressListeners = v;
        }
    }

    public synchronized void addProgressListener(ProgressListener l) {
        Vector v;
        Vector vector = v = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.progressListeners = v;
        }
    }

    protected void fireProgressChanged(int e) {
        if (this.progressListeners != null) {
            int count = this.progressListeners.size();
            for (int i = 0; i < count; ++i) {
                this.progressListeners.elementAt(i).progressChanged(e);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            int count = this.progressListeners.size();
            for (int i = 0; i < count; ++i) {
                this.progressListeners.elementAt(i).processFinished();
            }
        }
    }

    public synchronized void removeStatusListener(StatusListener l) {
        if (this.statusListeners != null && this.statusListeners.contains(l)) {
            Vector v = (Vector)this.statusListeners.clone();
            v.removeElement(l);
            this.statusListeners = v;
        }
    }

    public synchronized void addStatusListener(StatusListener l) {
        Vector v;
        Vector vector = v = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.statusListeners = v;
        }
    }

    protected void fireStatusChanged(String e) {
        if (this.statusListeners != null) {
            int count = this.statusListeners.size();
            for (int i = 0; i < count; ++i) {
                this.statusListeners.elementAt(i).statusChanged(e);
            }
        }
    }

    public void setOntology(Ontology ontology) {
        this.transducer.setOntology(ontology);
    }

    public boolean isEnableDebugging() {
        return this.enableDebugging;
    }

    public void setEnableDebugging(boolean enableDebugging) {
        this.enableDebugging = enableDebugging;
        if (this.transducer != null) {
            this.transducer.setEnableDebugging(enableDebugging);
        }
    }

    public String getBenchmarkId() {
        return this.transducer.getBenchmarkId();
    }

    public void setBenchmarkId(String benchmarkId) {
        this.transducer.setBenchmarkId(benchmarkId);
    }

    public void runControllerExecutionAbortedBlock(ActionContext ac, Controller c, Throwable t, Ontology o) throws ExecutionException {
        this.transducer.runControllerExecutionAbortedBlock(ac, c, t, o);
    }

    public void runControllerExecutionFinishedBlock(ActionContext ac, Controller c, Ontology o) throws ExecutionException {
        this.transducer.runControllerExecutionFinishedBlock(ac, c, o);
    }

    public void runControllerExecutionStartedBlock(ActionContext ac, Controller c, Ontology o) throws ExecutionException {
        this.transducer.runControllerExecutionStartedBlock(ac, c, o);
    }
}

