/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.Gazetteer;
import gate.creole.gazetteer.GazetteerEvent;
import gate.creole.gazetteer.GazetteerList;
import gate.creole.gazetteer.GazetteerListener;
import gate.creole.gazetteer.GazetteerNode;
import gate.creole.gazetteer.LinearDefinition;
import gate.creole.gazetteer.LinearNode;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.gui.ActionsPublisher;
import gate.gui.MainFrame;
import gate.swing.XJFileChooser;
import gate.swing.XJTable;
import gate.util.Err;
import gate.util.ExtensionFileFilter;
import gate.util.Files;
import gate.util.GateRuntimeException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

@CreoleResource(name="Gazetteer Editor", comment="Gazetteer viewer and editor.", helpURL="http://gate.ac.uk/userguide/sec:gazetteers:anniegazeditor", guiType=GuiType.LARGE, mainViewer=true, resourceDisplayed="gate.creole.gazetteer.AbstractGazetteer")
public class GazetteerEditor
extends AbstractVisualResource
implements GazetteerListener,
ActionsPublisher {
    protected Gazetteer gazetteer;
    protected LinearDefinition linearDefinition;
    protected LinearNode selectedLinearNode;
    protected Collator collator;
    protected List<Action> actions;
    protected XJTable definitionTable;
    protected DefaultTableModel definitionTableModel = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int column) {
            return GazetteerEditor.this.editable;
        }
    };
    protected XJTable listTable;
    protected ListTableModel listTableModel;
    protected JComboBox<String> newListComboBox;
    protected JButton newListButton;
    protected JButton addColumnsButton;
    protected JTextField listEntryTextField;
    protected JCheckBox regexCheckBox;
    protected JCheckBox caseInsensitiveCheckBox;
    protected JCheckBox onlyValueCheckBox;
    protected JLabel listCountLabel;
    protected boolean editable;

    public GazetteerEditor() {
        this.definitionTableModel.addColumn("List name");
        this.definitionTableModel.addColumn("Major");
        this.definitionTableModel.addColumn("Minor");
        this.definitionTableModel.addColumn("Language");
        this.definitionTableModel.addColumn("Annotation type");
        this.listTableModel = new ListTableModel();
        this.actions = new ArrayList<Action>();
        this.actions.add(new SaveAndReinitialiseGazetteerAction());
        this.actions.add(new SaveAsGazetteerAction());
    }

    public Resource init() throws ResourceInstantiationException {
        this.initGUI();
        this.initListeners();
        return this;
    }

    protected void initGUI() {
        this.collator = Collator.getInstance(Locale.ENGLISH);
        this.collator.setStrength(2);
        JPanel definitionPanel = new JPanel(new BorderLayout());
        JPanel definitionTopPanel = new JPanel(new FlowLayout(0));
        this.newListComboBox = new JComboBox();
        this.newListComboBox.setEditable(true);
        this.newListComboBox.setPrototypeDisplayValue("123456789012345");
        this.newListComboBox.setToolTipText("Lists available in the gazetteer directory");
        this.newListButton = new JButton("Add");
        JTextField listTextComponent = (JTextField)this.newListComboBox.getEditor().getEditorComponent();
        listTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void update(DocumentEvent e) {
                Document document = e.getDocument();
                try {
                    String value = document.getText(0, document.getLength());
                    if (value.trim().length() == 0) {
                        GazetteerEditor.this.newListButton.setEnabled(false);
                        GazetteerEditor.this.newListButton.setText("Add");
                    } else if (value.contains(":")) {
                        GazetteerEditor.this.newListButton.setEnabled(false);
                        GazetteerEditor.this.newListButton.setText("Colon Char Forbidden");
                    } else if (GazetteerEditor.this.linearDefinition.getLists().contains(value)) {
                        GazetteerEditor.this.newListButton.setEnabled(false);
                        GazetteerEditor.this.newListButton.setText("Existing");
                    } else {
                        GazetteerEditor.this.newListButton.setEnabled(true);
                        GazetteerEditor.this.newListButton.setText("Add");
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        });
        this.newListComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    GazetteerEditor.this.newListButton.doClick();
                }
            }
        });
        this.newListButton.setToolTipText("<html>Add a list in the gazetteer&nbsp;&nbsp;<font color=#667799><small>Enter&nbsp;&nbsp;</small></font></html>");
        this.newListButton.setMargin(new Insets(2, 2, 2, 2));
        this.newListButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GazetteerList gazetteerList;
                String listName = (String)GazetteerEditor.this.newListComboBox.getEditor().getItem();
                GazetteerEditor.this.newListComboBox.removeItem(listName);
                GazetteerEditor.this.definitionTableModel.addRow(new Object[]{listName, "", "", "", ""});
                LinearNode linearNode = new LinearNode(listName, "", "", "", "");
                GazetteerEditor.this.linearDefinition.add(linearNode);
                GazetteerEditor.this.linearDefinition.getNodesByListNames().put(listName, linearNode);
                try {
                    gazetteerList = GazetteerEditor.this.linearDefinition.loadSingleList(listName, true);
                }
                catch (ResourceInstantiationException rie) {
                    rie.printStackTrace();
                    return;
                }
                GazetteerEditor.this.linearDefinition.getListsByNode().put(linearNode, gazetteerList);
                final int row = GazetteerEditor.this.definitionTable.rowModelToView(GazetteerEditor.this.definitionTable.getRowCount() - 1);
                final int column = GazetteerEditor.this.definitionTable.convertColumnIndexToView(0);
                GazetteerEditor.this.definitionTable.setRowSelectionInterval(row, row);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GazetteerEditor.this.definitionTable.scrollRectToVisible(GazetteerEditor.this.definitionTable.getCellRect(row, column, true));
                        GazetteerEditor.this.definitionTable.requestFocusInWindow();
                    }
                });
            }
        });
        definitionTopPanel.add(this.newListComboBox);
        definitionTopPanel.add(this.newListButton);
        definitionPanel.add((Component)definitionTopPanel, "North");
        this.definitionTable = new XJTable(){

            protected void processKeyEvent(KeyEvent e) {
                if (GazetteerEditor.this.editable && e.getKeyCode() == 127 && (e.getModifiersEx() & 0x40) != 0) {
                    new DeleteSelectedLinearNodeAction().actionPerformed(null);
                } else {
                    super.processKeyEvent(e);
                }
            }
        };
        this.definitionTable.setSelectionMode(2);
        this.definitionTable.setRowSelectionAllowed(true);
        this.definitionTable.setColumnSelectionAllowed(false);
        this.definitionTable.setEnableHidingColumns(true);
        this.definitionTable.setAutoResizeMode(0);
        this.definitionTable.setModel((TableModel)this.definitionTableModel);
        this.definitionTable.setSortable(true);
        this.definitionTable.setSortedColumn(0);
        this.definitionTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                GazetteerList gazetteerList;
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setForeground(table.getForeground());
                LinearNode linearNode = GazetteerEditor.this.linearDefinition.getNodesByListNames().get(value);
                if (linearNode != null && (gazetteerList = GazetteerEditor.this.linearDefinition.getListsByNode().get(linearNode)) != null && gazetteerList.isModified()) {
                    this.setForeground(Color.RED);
                }
                return this;
            }
        });
        definitionPanel.add((Component)new JScrollPane((Component)this.definitionTable), "Center");
        JPanel listPanel = new JPanel(new BorderLayout());
        JPanel listTopPanel = new JPanel(new FlowLayout(0));
        this.listEntryTextField = new JTextField(10);
        this.listEntryTextField.setEnabled(false);
        final JButton filterListButton = new JButton("Filter");
        filterListButton.setToolTipText("Filter the list on the text entered");
        filterListButton.setMargin(new Insets(2, 2, 2, 2));
        filterListButton.setEnabled(false);
        filterListButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filter = GazetteerEditor.this.listEntryTextField.getText().trim();
                GazetteerEditor.this.listTableModel.setFilterText(filter);
                GazetteerEditor.this.listTableModel.fireTableDataChanged();
            }
        });
        final JButton newEntryButton = new JButton("Add");
        newEntryButton.setToolTipText("<html>Add the text in the list&nbsp;&nbsp;<font color=#667799><small>Enter&nbsp;&nbsp;</small></font></html>");
        newEntryButton.setMargin(new Insets(2, 2, 2, 2));
        newEntryButton.setEnabled(false);
        newEntryButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GazetteerNode newGazetteerNode = new GazetteerNode(GazetteerEditor.this.listEntryTextField.getText());
                newGazetteerNode.setSeparator(GazetteerEditor.this.listTableModel.gazetteerList.getSeparator());
                GazetteerEditor.this.listTableModel.addRow(newGazetteerNode);
                GazetteerEditor.this.listTableModel.setFilterText("");
                GazetteerEditor.this.listEntryTextField.setText("");
                GazetteerEditor.this.listTableModel.fireTableDataChanged();
                final int row = GazetteerEditor.this.listTable.rowModelToView(GazetteerEditor.this.listTable.getRowCount() - 1);
                final int column = GazetteerEditor.this.listTable.convertColumnIndexToView(0);
                GazetteerEditor.this.listEntryTextField.setText("");
                GazetteerEditor.this.listEntryTextField.requestFocusInWindow();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GazetteerEditor.this.listTable.scrollRectToVisible(GazetteerEditor.this.listTable.getCellRect(row, column, true));
                        GazetteerEditor.this.listTable.setRowSelectionInterval(row, row);
                        GazetteerEditor.this.listTable.setColumnSelectionInterval(column, column);
                        GazetteerList gazetteerList = GazetteerEditor.this.linearDefinition.getListsByNode().get(GazetteerEditor.this.selectedLinearNode);
                        gazetteerList.setModified(true);
                        GazetteerEditor.this.definitionTable.repaint();
                    }
                });
            }
        });
        this.listEntryTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    newEntryButton.doClick();
                }
            }
        });
        this.listEntryTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void update(DocumentEvent e) {
                Document document = e.getDocument();
                try {
                    String value = document.getText(0, document.getLength());
                    if (value.trim().length() == 0) {
                        newEntryButton.setEnabled(false);
                        newEntryButton.setText("Add");
                        filterListButton.setEnabled(false);
                        GazetteerEditor.this.listTableModel.setFilterText("");
                        GazetteerEditor.this.listTableModel.fireTableDataChanged();
                    } else if (GazetteerEditor.this.linearDefinition.getSeparator() != null && GazetteerEditor.this.linearDefinition.getSeparator().length() > 0 && value.contains(GazetteerEditor.this.linearDefinition.getSeparator())) {
                        newEntryButton.setEnabled(false);
                        newEntryButton.setText("Char Forbidden: " + GazetteerEditor.this.linearDefinition.getSeparator());
                        filterListButton.setEnabled(false);
                    } else {
                        GazetteerList gazetteerList = GazetteerEditor.this.linearDefinition.getListsByNode().get(GazetteerEditor.this.selectedLinearNode);
                        boolean found = false;
                        for (GazetteerNode object : gazetteerList) {
                            GazetteerNode node = object;
                            if (!node.getEntry().equals(value)) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            newEntryButton.setEnabled(false);
                            newEntryButton.setText("Existing ");
                        } else {
                            newEntryButton.setEnabled(GazetteerEditor.this.editable);
                            newEntryButton.setText("Add");
                        }
                        filterListButton.setEnabled(true);
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        });
        this.addColumnsButton = new JButton("+Cols");
        this.addColumnsButton.setToolTipText("Add a couple of columns: Feature, Value");
        this.addColumnsButton.setMargin(new Insets(2, 2, 2, 2));
        this.addColumnsButton.setEnabled(false);
        this.addColumnsButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GazetteerEditor.this.linearDefinition.getSeparator() == null || GazetteerEditor.this.linearDefinition.getSeparator().length() == 0) {
                    String separator = JOptionPane.showInputDialog((Component)MainFrame.getInstance(), "Type a character separator to separate\nfeatures in the gazetteers lists.", "Feature Separator", 3);
                    if (separator == null || separator.equals("")) {
                        return;
                    }
                    GazetteerEditor.this.linearDefinition.setSeparator(separator);
                }
                GazetteerEditor.this.listTableModel.addEmptyFeatureColumns();
                GazetteerEditor.this.listEntryTextField.setText("");
                GazetteerEditor.this.listTableModel.setFilterText("");
                GazetteerEditor.this.listTableModel.fireTableStructureChanged();
            }
        });
        listTopPanel.add(this.listEntryTextField);
        listTopPanel.add(filterListButton);
        listTopPanel.add(newEntryButton);
        listTopPanel.add(this.addColumnsButton);
        this.listCountLabel = new JLabel();
        listTopPanel.add(this.listCountLabel);
        listPanel.add((Component)listTopPanel, "North");
        this.listTable = new XJTable(){

            protected void processKeyEvent(KeyEvent e) {
                if (GazetteerEditor.this.editable && e.getKeyCode() == 127 && (e.getModifiersEx() & 0x40) != 0) {
                    new DeleteSelectedGazetteerNodeAction().actionPerformed(null);
                } else {
                    super.processKeyEvent(e);
                }
            }
        };
        this.listTable.setSelectionMode(1);
        this.listTable.setRowSelectionAllowed(true);
        this.listTable.setColumnSelectionAllowed(true);
        this.listTable.setEnableHidingColumns(true);
        this.listTable.setAutoResizeMode(0);
        this.listTable.setModel((TableModel)this.listTableModel);
        this.listTable.setSortable(true);
        this.listTable.setSortedColumn(0);
        listPanel.add((Component)new JScrollPane((Component)this.listTable), "Center");
        this.caseInsensitiveCheckBox = new JCheckBox("Match Case");
        listTopPanel.add(this.caseInsensitiveCheckBox);
        this.caseInsensitiveCheckBox.setSelected(true);
        this.caseInsensitiveCheckBox.setToolTipText("Match Case");
        this.caseInsensitiveCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GazetteerEditor.this.listTableModel.setFilterText(GazetteerEditor.this.listEntryTextField.getText());
                GazetteerEditor.this.listTableModel.fireTableDataChanged();
            }
        });
        this.regexCheckBox = new JCheckBox("Regex");
        listTopPanel.add(this.regexCheckBox);
        this.regexCheckBox.setToolTipText("Regular Expression");
        this.regexCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GazetteerEditor.this.listTableModel.setFilterText(GazetteerEditor.this.listEntryTextField.getText());
                GazetteerEditor.this.listTableModel.fireTableDataChanged();
            }
        });
        this.onlyValueCheckBox = new JCheckBox("Value");
        listTopPanel.add(this.onlyValueCheckBox);
        this.onlyValueCheckBox.setToolTipText("Filter only Value column");
        this.onlyValueCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GazetteerEditor.this.listTableModel.setFilterText(GazetteerEditor.this.listEntryTextField.getText());
                GazetteerEditor.this.listTableModel.fireTableDataChanged();
            }
        });
        JSplitPane splitPane = new JSplitPane(1, true);
        splitPane.add(definitionPanel);
        splitPane.add(listPanel);
        splitPane.setResizeWeight(0.33);
        this.setLayout(new BorderLayout());
        this.add(splitPane, "Center");
    }

    protected void initListeners() {
        this.definitionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() || GazetteerEditor.this.definitionTable.isEditing()) {
                    return;
                }
                if (GazetteerEditor.this.definitionTable.getSelectedRowCount() != 1) {
                    GazetteerEditor.this.listTableModel.setGazetteerList(new GazetteerList());
                    GazetteerEditor.this.selectedLinearNode = null;
                    GazetteerEditor.this.listEntryTextField.setEnabled(false);
                    GazetteerEditor.this.addColumnsButton.setEnabled(false);
                } else {
                    String listName = (String)GazetteerEditor.this.definitionTable.getValueAt(GazetteerEditor.this.definitionTable.getSelectedRow(), GazetteerEditor.this.definitionTable.convertColumnIndexToView(0));
                    GazetteerEditor.this.selectedLinearNode = GazetteerEditor.this.linearDefinition.getNodesByListNames().get(listName);
                    if (GazetteerEditor.this.selectedLinearNode != null) {
                        GazetteerEditor.this.listTableModel.setGazetteerList(GazetteerEditor.this.linearDefinition.getListsByNode().get(GazetteerEditor.this.selectedLinearNode));
                    }
                    GazetteerEditor.this.listEntryTextField.setEnabled(true);
                    GazetteerEditor.this.addColumnsButton.setEnabled(GazetteerEditor.this.editable);
                }
                if (!GazetteerEditor.this.listEntryTextField.getText().equals("")) {
                    GazetteerEditor.this.listEntryTextField.setText("");
                }
                GazetteerEditor.this.listTableModel.setFilterText("");
                GazetteerEditor.this.listTableModel.fireTableStructureChanged();
                if (GazetteerEditor.this.definitionTable.getSelectedRow() != -1 && GazetteerEditor.this.selectedLinearNode != null) {
                    for (int col = 0; col < GazetteerEditor.this.listTable.getColumnCount(); ++col) {
                        GazetteerEditor.this.listTable.setComparator(col, (Comparator)GazetteerEditor.this.collator);
                    }
                    GazetteerEditor.this.listTableModel.fireTableDataChanged();
                }
            }
        });
        this.definitionTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (GazetteerEditor.this.selectedLinearNode == null) {
                    return;
                }
                int row = e.getFirstRow();
                int column = e.getColumn();
                GazetteerList gazetteerList = GazetteerEditor.this.linearDefinition.getListsByNode().get(GazetteerEditor.this.selectedLinearNode);
                switch (e.getType()) {
                    case 0: {
                        if (row == -1 || column == -1) {
                            return;
                        }
                        if (column == 0) {
                            String newListFileName = (String)GazetteerEditor.this.definitionTableModel.getValueAt(row, column);
                            String oldListFileName = GazetteerEditor.this.selectedLinearNode.getList();
                            if (oldListFileName != null && oldListFileName.equals(newListFileName)) {
                                return;
                            }
                            try {
                                gazetteerList.store();
                                MainFrame.getInstance().statusChanged("Previous list saved in " + gazetteerList.getURL().getPath());
                            }
                            catch (ResourceInstantiationException rie) {
                                Err.prln((String)("Unable to save the list.\n" + rie.getMessage()));
                                return;
                            }
                            try {
                                File source = Files.fileFromURL((URL)gazetteerList.getURL());
                                File destination = new File(source.getParentFile(), newListFileName);
                                gazetteerList.setURL(destination.toURI().toURL());
                                gazetteerList.setModified(false);
                            }
                            catch (MalformedURLException mue) {
                                Err.prln((String)("File name invalid.\n" + mue.getMessage()));
                                return;
                            }
                            GazetteerEditor.this.linearDefinition.getListsByNode().remove(GazetteerEditor.this.selectedLinearNode);
                            GazetteerEditor.this.selectedLinearNode.setList(newListFileName);
                            GazetteerEditor.this.linearDefinition.getListsByNode().put(GazetteerEditor.this.selectedLinearNode, gazetteerList);
                            GazetteerEditor.this.linearDefinition.getNodesByListNames().remove(oldListFileName);
                            GazetteerEditor.this.linearDefinition.getNodesByListNames().put(newListFileName, GazetteerEditor.this.selectedLinearNode);
                            GazetteerEditor.this.linearDefinition.setModified(true);
                            break;
                        }
                        if (column == 1) {
                            String newMajorType = (String)GazetteerEditor.this.definitionTableModel.getValueAt(row, column);
                            String oldMajorType = GazetteerEditor.this.selectedLinearNode.getMajorType();
                            if (oldMajorType != null && oldMajorType.equals(newMajorType)) {
                                return;
                            }
                            GazetteerEditor.this.linearDefinition.getListsByNode().remove(GazetteerEditor.this.selectedLinearNode);
                            GazetteerEditor.this.selectedLinearNode.setMajorType(newMajorType);
                            GazetteerEditor.this.linearDefinition.getListsByNode().put(GazetteerEditor.this.selectedLinearNode, gazetteerList);
                            GazetteerEditor.this.linearDefinition.getNodesByListNames().put(GazetteerEditor.this.selectedLinearNode.getList(), GazetteerEditor.this.selectedLinearNode);
                            GazetteerEditor.this.linearDefinition.setModified(true);
                            break;
                        }
                        if (column == 2) {
                            String newMinorType = (String)GazetteerEditor.this.definitionTableModel.getValueAt(row, column);
                            String oldMinorType = GazetteerEditor.this.selectedLinearNode.getMinorType();
                            if (oldMinorType != null && oldMinorType.equals(newMinorType)) {
                                return;
                            }
                            GazetteerEditor.this.linearDefinition.getListsByNode().remove(GazetteerEditor.this.selectedLinearNode);
                            GazetteerEditor.this.selectedLinearNode.setMinorType(newMinorType);
                            GazetteerEditor.this.linearDefinition.getListsByNode().put(GazetteerEditor.this.selectedLinearNode, gazetteerList);
                            GazetteerEditor.this.linearDefinition.getNodesByListNames().put(GazetteerEditor.this.selectedLinearNode.getList(), GazetteerEditor.this.selectedLinearNode);
                            GazetteerEditor.this.linearDefinition.setModified(true);
                            break;
                        }
                        if (column == 3) {
                            String newLanguage = (String)GazetteerEditor.this.definitionTableModel.getValueAt(row, column);
                            String oldLanguage = GazetteerEditor.this.selectedLinearNode.getLanguage();
                            if (oldLanguage != null && oldLanguage.equals(newLanguage)) {
                                return;
                            }
                            GazetteerEditor.this.linearDefinition.getListsByNode().remove(GazetteerEditor.this.selectedLinearNode);
                            GazetteerEditor.this.selectedLinearNode.setLanguage(newLanguage);
                            GazetteerEditor.this.linearDefinition.getListsByNode().put(GazetteerEditor.this.selectedLinearNode, gazetteerList);
                            GazetteerEditor.this.linearDefinition.getNodesByListNames().put(GazetteerEditor.this.selectedLinearNode.getList(), GazetteerEditor.this.selectedLinearNode);
                            GazetteerEditor.this.linearDefinition.setModified(true);
                            break;
                        }
                        if (column != 4) break;
                        String newAnnotationType = (String)GazetteerEditor.this.definitionTableModel.getValueAt(row, column);
                        String oldAnnotationType = GazetteerEditor.this.selectedLinearNode.getAnnotationType();
                        if (oldAnnotationType != null && oldAnnotationType.equals(newAnnotationType)) {
                            return;
                        }
                        GazetteerEditor.this.linearDefinition.getListsByNode().remove(GazetteerEditor.this.selectedLinearNode);
                        GazetteerEditor.this.selectedLinearNode.setAnnotationType(newAnnotationType);
                        GazetteerEditor.this.linearDefinition.getListsByNode().put(GazetteerEditor.this.selectedLinearNode, gazetteerList);
                        GazetteerEditor.this.linearDefinition.getNodesByListNames().put(GazetteerEditor.this.selectedLinearNode.getList(), GazetteerEditor.this.selectedLinearNode);
                        GazetteerEditor.this.linearDefinition.setModified(true);
                        break;
                    }
                }
            }
        });
        this.definitionTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                this.processMouseEvent(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                this.processMouseEvent(me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                JTable table = (JTable)me.getSource();
                int row = table.rowAtPoint(me.getPoint());
                if (me.isPopupTrigger() && !table.isRowSelected(row)) {
                    table.getSelectionModel().setSelectionInterval(row, row);
                }
                this.processMouseEvent(me);
            }

            protected void processMouseEvent(MouseEvent me) {
                XJTable table = (XJTable)me.getSource();
                if (me.isPopupTrigger() && table.getSelectedRowCount() > 0) {
                    JPopupMenu popup = new JPopupMenu();
                    if (table.getSelectedRowCount() == 1) {
                        popup.add(new ReloadGazetteerListAction());
                        popup.addSeparator();
                    }
                    popup.add(new DeleteSelectedLinearNodeAction());
                    popup.show((Component)table, me.getX(), me.getY());
                }
            }
        });
        this.listTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                this.processMouseEvent(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                this.processMouseEvent(me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                JTable table = (JTable)me.getSource();
                int row = table.rowAtPoint(me.getPoint());
                if (me.isPopupTrigger() && !table.isRowSelected(row)) {
                    table.getSelectionModel().setSelectionInterval(row, row);
                }
                this.processMouseEvent(me);
            }

            protected void processMouseEvent(MouseEvent me) {
                XJTable table = (XJTable)me.getSource();
                if (me.isPopupTrigger() && table.getSelectedRowCount() > 0) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new CopySelectionAction());
                    popup.add(new PasteSelectionAction());
                    popup.addSeparator();
                    popup.add(new FillDownSelectionAction());
                    popup.add(new ClearSelectionAction());
                    popup.addSeparator();
                    popup.add(new DeleteSelectedGazetteerNodeAction());
                    popup.show((Component)table, me.getX(), me.getY());
                }
            }
        });
        this.listTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                GazetteerEditor.this.listCountLabel.setText(String.valueOf(GazetteerEditor.this.listTableModel.getRowCount()) + " entries ");
            }
        });
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("control S"), "save");
        actionMap.put("save", this.actions.get(0));
        inputMap.put(KeyStroke.getKeyStroke("control shift S"), "save as");
        actionMap.put("save as", this.actions.get(1));
        inputMap = this.listTable.getInputMap(2);
        actionMap = this.listTable.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("control V"), "paste table selection");
        actionMap.put("paste table selection", new PasteSelectionAction());
    }

    public void setTarget(Object target) {
        if (null == target) {
            throw new GateRuntimeException("The resource set is null.");
        }
        if (!(target instanceof Gazetteer)) {
            throw new GateRuntimeException("The resource set must be of type gate.creole.gazetteer.Gazetteer\nand not " + target.getClass());
        }
        if (((Gazetteer)target).getListsURL() == null) {
            throw new IllegalArgumentException("Not a file-based gazetteer.");
        }
        ((Gazetteer)target).addGazetteerListener(this);
        this.processGazetteerEvent(new GazetteerEvent(target, 1));
    }

    @Override
    public void processGazetteerEvent(GazetteerEvent e) {
        this.gazetteer = (Gazetteer)e.getSource();
        this.editable = true;
        if (e.getType() == 1) {
            this.linearDefinition = this.gazetteer.getLinearDefinition();
            if (null == this.linearDefinition) {
                throw new GateRuntimeException("Linear definition of a gazetteer should not be null.");
            }
            try {
                if (this.linearDefinition.getSeparator() != null && this.linearDefinition.getSeparator().length() > 0) {
                    this.linearDefinition.loadLists(true);
                }
            }
            catch (ResourceInstantiationException rie) {
                rie.printStackTrace();
                return;
            }
            this.definitionTableModel.setRowCount(0);
            ArrayList<String> values = new ArrayList<String>();
            for (LinearNode object : this.linearDefinition.getNodes()) {
                LinearNode node = object;
                values.add(node.getList() == null ? "" : node.getList());
                values.add(node.getMajorType() == null ? "" : node.getMajorType());
                values.add(node.getMinorType() == null ? "" : node.getMinorType());
                values.add(node.getLanguage() == null ? "" : node.getLanguage());
                values.add(node.getAnnotationType() == null ? "" : node.getAnnotationType());
                this.definitionTableModel.addRow(values.toArray());
                values.clear();
            }
            for (int col = 0; col < this.definitionTable.getColumnCount(); ++col) {
                this.definitionTable.setComparator(col, (Comparator)this.collator);
            }
            File defFile = null;
            try {
                defFile = Files.fileFromURL((URL)this.gazetteer.getListsURL().toURL());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
            catch (IllegalArgumentException iae) {
                this.editable = false;
                this.newListComboBox.setModel(new DefaultComboBoxModel());
                this.newListComboBox.setEnabled(false);
                this.newListButton.setEnabled(false);
                return;
            }
            File gazetteerDirectory = new File(defFile.getParent());
            File[] files = gazetteerDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".lst") && !GazetteerEditor.this.linearDefinition.getLists().contains(name);
                }
            });
            String[] filenames = new String[files == null ? 0 : files.length];
            for (int i = 0; i < filenames.length; ++i) {
                filenames[i] = files[i].getName();
            }
            Arrays.sort(filenames, this.collator);
            this.newListComboBox.setModel(new DefaultComboBoxModel<String>(filenames));
            this.newListComboBox.setEnabled(true);
            if (filenames.length == 0) {
                this.newListButton.setEnabled(false);
            }
        }
    }

    public List<Action> getActions() {
        return this.actions;
    }

    protected class ClearSelectionAction
    extends AbstractAction {
        public ClearSelectionAction() {
            super("Clear Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control DELETE"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = GazetteerEditor.this.listTable.getSelectedRows();
            int[] columns = GazetteerEditor.this.listTable.getSelectedColumns();
            GazetteerEditor.this.listTable.clearSelection();
            for (int column : columns) {
                for (int row : rows) {
                    GazetteerEditor.this.listTableModel.setValueAt("", GazetteerEditor.this.listTable.rowViewToModel(row), GazetteerEditor.this.listTable.convertColumnIndexToModel(column));
                }
                GazetteerEditor.this.listTableModel.fireTableDataChanged();
            }
        }
    }

    protected class PasteSelectionAction
    extends AbstractAction {
        public PasteSelectionAction() {
            super("Paste Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control V"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int firstRow = GazetteerEditor.this.listTable.getSelectedRow();
            int firstColumn = GazetteerEditor.this.listTable.getSelectedColumn();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String valueCopied = null;
            try {
                if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    valueCopied = (String)clipboard.getContents(null).getTransferData(DataFlavor.stringFlavor);
                }
            }
            catch (UnsupportedFlavorException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (valueCopied == null) {
                return;
            }
            int rowToPaste = firstRow;
            for (String rowCopied : valueCopied.split("\n")) {
                int columnToPaste = firstColumn;
                for (String cellCopied : rowCopied.split("\t")) {
                    GazetteerEditor.this.listTableModel.setValueAt(cellCopied, GazetteerEditor.this.listTable.rowViewToModel(rowToPaste), GazetteerEditor.this.listTable.convertColumnIndexToModel(columnToPaste));
                    if (columnToPaste + 1 > GazetteerEditor.this.listTable.getColumnCount()) break;
                    ++columnToPaste;
                }
                if (rowToPaste + 1 > GazetteerEditor.this.listTable.getRowCount()) break;
                ++rowToPaste;
            }
            GazetteerEditor.this.listTableModel.fireTableDataChanged();
        }
    }

    protected class CopySelectionAction
    extends AbstractAction {
        public CopySelectionAction() {
            super("Copy Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control C"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GazetteerEditor.this.listTable.getActionMap().get("copy").actionPerformed(new ActionEvent(GazetteerEditor.this.listTable, 1001, null));
        }
    }

    protected class FillDownSelectionAction
    extends AbstractAction {
        public FillDownSelectionAction() {
            super("Fill Down Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control D"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = GazetteerEditor.this.listTable.getSelectedRows();
            int[] columns = GazetteerEditor.this.listTable.getSelectedColumns();
            GazetteerEditor.this.listTable.clearSelection();
            for (int column : columns) {
                String firstCell = (String)GazetteerEditor.this.listTable.getValueAt(rows[0], column);
                for (int row : rows) {
                    GazetteerEditor.this.listTableModel.setValueAt(firstCell, GazetteerEditor.this.listTable.rowViewToModel(row), GazetteerEditor.this.listTable.convertColumnIndexToModel(column));
                }
                GazetteerEditor.this.listTableModel.fireTableDataChanged();
            }
        }
    }

    protected class DeleteSelectedGazetteerNodeAction
    extends AbstractAction {
        public DeleteSelectedGazetteerNodeAction() {
            super(GazetteerEditor.this.listTable.getSelectedRowCount() > 1 ? "Delete Rows" : "Delete Row");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift DELETE"));
        }

        @Override
        public boolean isEnabled() {
            return GazetteerEditor.this.editable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            int[] rowsToDelete = GazetteerEditor.this.listTable.getSelectedRows();
            GazetteerEditor.this.listTable.clearSelection();
            for (i = 0; i < rowsToDelete.length; ++i) {
                rowsToDelete[i] = GazetteerEditor.this.listTable.rowViewToModel(rowsToDelete[i]);
            }
            Arrays.sort(rowsToDelete);
            for (i = rowsToDelete.length - 1; i >= 0; --i) {
                GazetteerEditor.this.listTableModel.removeRow(rowsToDelete[i]);
            }
            GazetteerEditor.this.listTableModel.fireTableDataChanged();
        }
    }

    protected class DeleteSelectedLinearNodeAction
    extends AbstractAction {
        public DeleteSelectedLinearNodeAction() {
            super(GazetteerEditor.this.definitionTable.getSelectedRowCount() > 1 ? "Delete Rows" : "Delete Row");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift DELETE"));
        }

        @Override
        public boolean isEnabled() {
            return GazetteerEditor.this.editable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            int[] rowsToDelete = GazetteerEditor.this.definitionTable.getSelectedRows();
            GazetteerEditor.this.definitionTable.clearSelection();
            for (i = 0; i < rowsToDelete.length; ++i) {
                rowsToDelete[i] = GazetteerEditor.this.definitionTable.rowViewToModel(rowsToDelete[i]);
            }
            Arrays.sort(rowsToDelete);
            for (i = rowsToDelete.length - 1; i >= 0; --i) {
                GazetteerEditor.this.definitionTableModel.removeRow(rowsToDelete[i]);
                GazetteerEditor.this.linearDefinition.remove(rowsToDelete[i]);
            }
        }
    }

    protected class SaveAsGazetteerAction
    extends AbstractAction {
        public SaveAsGazetteerAction() {
            super("Save as...");
            this.putValue("ShortDescription", "Save the definition and all the lists");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control shift S"));
        }

        @Override
        public boolean isEnabled() {
            return GazetteerEditor.this.editable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XJFileChooser fileChooser = MainFrame.getFileChooser();
            ExtensionFileFilter filter = new ExtensionFileFilter("Gazetteer files", new String[]{"def"});
            fileChooser.addChoosableFileFilter((FileFilter)filter);
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.setDialogTitle("Select a file name...");
            fileChooser.setResource(GazetteerEditor.class.getName());
            int result = fileChooser.showSaveDialog((Component)((Object)GazetteerEditor.this));
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                if (selectedFile == null) {
                    return;
                }
                try {
                    URL previousURL = GazetteerEditor.this.linearDefinition.getURL();
                    GazetteerEditor.this.linearDefinition.setURL(selectedFile.toURI().toURL());
                    GazetteerEditor.this.linearDefinition.store();
                    GazetteerEditor.this.linearDefinition.setURL(previousURL);
                    Iterator<GazetteerList> iterator = GazetteerEditor.this.linearDefinition.getListsByNode().values().iterator();
                    while (iterator.hasNext()) {
                        GazetteerList object;
                        GazetteerList gazetteerList = object = iterator.next();
                        previousURL = gazetteerList.getURL();
                        gazetteerList.setURL(new File(selectedFile.getParentFile(), Files.fileFromURL((URL)gazetteerList.getURL()).getName()).toURI().toURL());
                        gazetteerList.store();
                        gazetteerList.setURL(previousURL);
                        gazetteerList.setModified(false);
                    }
                    MainFrame.getInstance().statusChanged("Gazetteer saved in " + selectedFile.getAbsolutePath());
                    GazetteerEditor.this.definitionTable.repaint();
                }
                catch (ResourceInstantiationException re) {
                    MainFrame.getInstance().statusChanged("Unable to save the Gazetteer.");
                    Err.prln((String)("Unable to save the Gazetteer.\n" + re.getMessage()));
                }
                catch (MalformedURLException mue) {
                    mue.printStackTrace();
                }
            }
        }
    }

    protected class SaveAndReinitialiseGazetteerAction
    extends AbstractAction {
        public SaveAndReinitialiseGazetteerAction() {
            super("Save and Reinitialise");
            this.putValue("ShortDescription", "Save the definition and all the lists then reinitialise");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control S"));
        }

        @Override
        public boolean isEnabled() {
            return GazetteerEditor.this.editable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (GazetteerEditor.this.linearDefinition.isModified()) {
                    GazetteerEditor.this.linearDefinition.store();
                }
                for (GazetteerList object : GazetteerEditor.this.linearDefinition.getListsByNode().values()) {
                    GazetteerList gazetteerList = object;
                    if (!gazetteerList.isModified()) continue;
                    gazetteerList.store();
                }
                GazetteerEditor.this.gazetteer.reInit();
                MainFrame.getInstance().statusChanged("Gazetteer saved in " + GazetteerEditor.this.linearDefinition.getURL().getPath());
                GazetteerEditor.this.definitionTable.repaint();
            }
            catch (ResourceInstantiationException re) {
                MainFrame.getInstance().statusChanged("Unable to save the Gazetteer.");
                Err.prln((String)("Unable to save the Gazetteer.\n" + re.getMessage()));
            }
        }
    }

    protected class ReloadGazetteerListAction
    extends AbstractAction {
        public ReloadGazetteerListAction() {
            super("Reload List");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GazetteerEditor.this.selectedLinearNode == null) {
                return;
            }
            GazetteerList gazetteerList = GazetteerEditor.this.linearDefinition.getListsByNode().get(GazetteerEditor.this.selectedLinearNode);
            gazetteerList.clear();
            try {
                gazetteerList.load(true);
            }
            catch (ResourceInstantiationException rie) {
                rie.printStackTrace();
                return;
            }
            int row = GazetteerEditor.this.definitionTable.getSelectedRow();
            GazetteerEditor.this.definitionTable.clearSelection();
            GazetteerEditor.this.definitionTable.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    protected class ListTableModel
    extends AbstractTableModel {
        private int columnCount = -1;
        private String filter = "";
        private GazetteerList gazetteerList;
        private GazetteerList gazetteerListFiltered = new GazetteerList();

        @Override
        public int getRowCount() {
            return this.gazetteerListFiltered.size();
        }

        @Override
        public int getColumnCount() {
            if (this.columnCount > -1) {
                return this.columnCount;
            }
            if (this.gazetteerListFiltered == null) {
                return 0;
            }
            this.columnCount = 1;
            for (GazetteerNode object : this.gazetteerListFiltered) {
                GazetteerNode node = object;
                Map<String, Object> map = node.getFeatureMap();
                if (map == null || this.columnCount >= 2 * map.size() + 1) continue;
                this.columnCount = 2 * map.size() + 1;
            }
            return this.columnCount;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Value";
            }
            int featureCount = (column + column % 2) / 2;
            if (column % 2 == 1) {
                return "Feature " + featureCount;
            }
            return "Value " + featureCount;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return GazetteerEditor.this.editable;
        }

        @Override
        public Object getValueAt(int row, int column) {
            GazetteerNode node = this.gazetteerListFiltered.get(row);
            if (column == 0) {
                return node.getEntry();
            }
            Map<String, Object> featureMap = node.getFeatureMap();
            if (featureMap == null || featureMap.size() * 2 < column) {
                return "";
            }
            ArrayList<String> features = new ArrayList<String>(featureMap.keySet());
            int featureCount = (column + column % 2) / 2;
            if (column % 2 == 1) {
                return features.get(featureCount - 1);
            }
            return featureMap.get(features.get(featureCount - 1));
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row == -1 || column == -1) {
                return;
            }
            if (GazetteerEditor.this.linearDefinition.getSeparator() != null && GazetteerEditor.this.linearDefinition.getSeparator().length() > 0 && ((String)value).contains(GazetteerEditor.this.linearDefinition.getSeparator())) {
                final Point point = GazetteerEditor.this.listTable.getCellRect(GazetteerEditor.this.listTable.getSelectedRow(), GazetteerEditor.this.listTable.getSelectedColumn(), true).getLocation();
                point.translate(GazetteerEditor.this.listTable.getLocationOnScreen().x, GazetteerEditor.this.listTable.getLocationOnScreen().y);
                final Timer timer = new Timer("GazetteerEditor tooltip timer", true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!GazetteerEditor.this.listTable.isShowing()) {
                            return;
                        }
                        JToolTip toolTip = GazetteerEditor.this.listTable.createToolTip();
                        toolTip.setTipText("No separator character allowed: [" + GazetteerEditor.this.linearDefinition.getSeparator() + "]");
                        PopupFactory popupFactory = PopupFactory.getSharedInstance();
                        final Popup popup = popupFactory.getPopup((Component)GazetteerEditor.this.listTable, toolTip, point.x, point.y - 20);
                        popup.show();
                        Date timeToRun = new Date(System.currentTimeMillis() + 3000L);
                        timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        popup.hide();
                                    }
                                });
                            }
                        }, timeToRun);
                    }
                });
                value = ((String)value).replaceAll("\\Q" + GazetteerEditor.this.linearDefinition.getSeparator() + "\\E", "");
            }
            GazetteerNode gazetteerNode = this.gazetteerListFiltered.get(row);
            if (column == 0) {
                gazetteerNode.setEntry((String)value);
            } else {
                LinkedHashMap<String, Object> newFeatureMap = new LinkedHashMap<String, Object>();
                int col = 1;
                while (col + 1 < this.getColumnCount()) {
                    String feature = (String)(col == column ? value : this.getValueAt(row, col));
                    String val = (String)(col + 1 == column ? value : (String)this.getValueAt(row, col + 1));
                    newFeatureMap.put(feature, val);
                    col += 2;
                }
                gazetteerNode.setFeatureMap(newFeatureMap);
                this.fireTableRowsUpdated(row, row);
            }
            this.gazetteerList.setModified(true);
            GazetteerEditor.this.definitionTable.repaint();
        }

        @Override
        public void fireTableStructureChanged() {
            this.columnCount = -1;
            super.fireTableStructureChanged();
        }

        @Override
        public void fireTableChanged(TableModelEvent e) {
            if (this.gazetteerList == null) {
                return;
            }
            if (this.filter.length() < 1) {
                this.gazetteerListFiltered.clear();
                this.gazetteerListFiltered.addAll(this.gazetteerList);
                super.fireTableChanged(e);
            } else {
                this.filterRows();
                super.fireTableChanged(new TableModelEvent(this));
            }
        }

        public void setFilterText(String filter) {
            this.filter = filter;
        }

        protected void filterRows() {
            Pattern pattern;
            String patternText = this.filter;
            String prefixPattern = GazetteerEditor.this.regexCheckBox.isSelected() ? "" : "\\Q";
            String suffixPattern = GazetteerEditor.this.regexCheckBox.isSelected() ? "" : "\\E";
            patternText = prefixPattern + patternText + suffixPattern;
            try {
                pattern = GazetteerEditor.this.caseInsensitiveCheckBox.isSelected() ? Pattern.compile(patternText) : Pattern.compile(patternText, 2);
            }
            catch (PatternSyntaxException e) {
                return;
            }
            this.gazetteerListFiltered.clear();
            Iterator<GazetteerNode> iterator = this.gazetteerList.iterator();
            while (iterator.hasNext()) {
                GazetteerNode object;
                GazetteerNode node = object = iterator.next();
                boolean match = false;
                Map<String, Object> map = node.getFeatureMap();
                if (map != null && !GazetteerEditor.this.onlyValueCheckBox.isSelected()) {
                    for (String key : map.keySet()) {
                        if (!pattern.matcher(key).find() && !pattern.matcher((String)map.get(key)).find()) continue;
                        match = true;
                        break;
                    }
                }
                if (!match && !pattern.matcher(node.getEntry()).find()) continue;
                this.gazetteerListFiltered.add(node);
            }
        }

        public void addEmptyFeatureColumns() {
            GazetteerNode node;
            if (this.getColumnCount() == 1) {
                GazetteerNode node2 = this.gazetteerListFiltered.get(0);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("", "");
                node2.setFeatureMap(map);
            } else {
                for (GazetteerNode object : this.gazetteerListFiltered) {
                    node = object;
                    Map<String, Object> map = node.getFeatureMap();
                    if (map == null || 2 * map.size() + 1 != this.getColumnCount()) continue;
                    map.put("", "");
                    break;
                }
            }
            Iterator<GazetteerNode> iterator = this.gazetteerList.iterator();
            while (iterator.hasNext()) {
                GazetteerNode object;
                node = object = iterator.next();
                node.setSeparator(GazetteerEditor.this.linearDefinition.getSeparator());
            }
        }

        public void addRow(GazetteerNode gazetteerNode) {
            this.gazetteerList.add(gazetteerNode);
        }

        public void removeRow(int row) {
            this.gazetteerList.remove(this.gazetteerListFiltered.get(row));
        }

        public void setGazetteerList(GazetteerList gazetteerList) {
            this.gazetteerList = gazetteerList;
        }
    }
}

