/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.splitter;

import gate.AnnotationSet;
import gate.Executable;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.AbstractProcessingResource;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.ResourceInstantiationException;
import gate.creole.ResourceReference;
import gate.creole.gazetteer.DefaultGazetteer;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.util.Benchmark;
import gate.util.Benchmarkable;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;

@CreoleResource(name="ANNIE Sentence Splitter", comment="ANNIE sentence splitter.", helpURL="http://gate.ac.uk/userguide/sec:annie:splitter", icon="sentence-splitter")
public class SentenceSplitter
extends AbstractLanguageAnalyser
implements Benchmarkable {
    private static final long serialVersionUID = -5335682060379173111L;
    public static final String SPLIT_DOCUMENT_PARAMETER_NAME = "document";
    public static final String SPLIT_INPUT_AS_PARAMETER_NAME = "inputASName";
    public static final String SPLIT_OUTPUT_AS_PARAMETER_NAME = "outputASName";
    public static final String SPLIT_ENCODING_PARAMETER_NAME = "encoding";
    public static final String SPLIT_GAZ_URL_PARAMETER_NAME = "gazetteerListsURL";
    public static final String SPLIT_TRANSD_URL_PARAMETER_NAME = "transducerURL";
    private String benchmarkId;
    DefaultGazetteer gazetteer;
    AbstractLanguageAnalyser transducer;
    private ResourceReference transducerURL;
    private String encoding;
    private ResourceReference gazetteerListsURL;
    private String inputASName;
    private String outputASName;

    public Resource init() throws ResourceInstantiationException {
        FeatureMap features;
        FeatureMap params = Factory.newFeatureMap();
        if (this.gazetteerListsURL != null) {
            params.put((Object)"listsURL", (Object)this.gazetteerListsURL);
        }
        params.put((Object)SPLIT_ENCODING_PARAMETER_NAME, (Object)this.encoding);
        if (this.gazetteer == null) {
            this.fireStatusChanged("Creating the gazetteer");
            features = Factory.newFeatureMap();
            Gate.setHiddenAttribute((FeatureMap)features, (boolean)true);
            this.gazetteer = (DefaultGazetteer)Factory.createResource((String)"gate.creole.gazetteer.DefaultGazetteer", (FeatureMap)params, (FeatureMap)features);
            this.gazetteer.setName("Gazetteer " + System.currentTimeMillis());
        } else {
            this.gazetteer.setParameterValues(params);
            this.gazetteer.reInit();
        }
        this.fireProgressChanged(10);
        params = Factory.newFeatureMap();
        if (this.transducerURL != null) {
            params.put((Object)"grammarURL", (Object)this.transducerURL);
        }
        params.put((Object)SPLIT_ENCODING_PARAMETER_NAME, (Object)this.encoding);
        if (this.transducer == null) {
            this.fireStatusChanged("Creating the JAPE transducer");
            features = Factory.newFeatureMap();
            Gate.setHiddenAttribute((FeatureMap)features, (boolean)true);
            this.transducer = (AbstractLanguageAnalyser)Factory.createResource((String)"gate.creole.Transducer", (FeatureMap)params, (FeatureMap)features);
            this.transducer.setName("Transducer " + System.currentTimeMillis());
        } else {
            this.transducer.setParameterValues(params);
            this.transducer.reInit();
        }
        this.fireProgressChanged(100);
        this.fireProcessFinished();
        return this;
    }

    public void cleanup() {
        Factory.deleteResource((Resource)this.gazetteer);
        Factory.deleteResource((Resource)this.transducer);
    }

    public void execute() throws ExecutionException {
        AnnotationSet sentences;
        AnnotationSet outputAS;
        FeatureMap params;
        this.interrupted = false;
        if (this.inputASName != null && this.inputASName.equals("")) {
            this.inputASName = null;
        }
        if (this.outputASName != null && this.outputASName.equals("")) {
            this.outputASName = null;
        }
        AbstractProcessingResource.IntervalProgressListener pListener = null;
        StatusListener sListener = null;
        this.fireProgressChanged(5);
        pListener = new AbstractProcessingResource.IntervalProgressListener((AbstractProcessingResource)this, 5, 10);
        sListener = new StatusListener(){

            public void statusChanged(String text) {
                SentenceSplitter.this.fireStatusChanged(text);
            }
        };
        try {
            params = Factory.newFeatureMap();
            params.put((Object)SPLIT_DOCUMENT_PARAMETER_NAME, (Object)this.document);
            params.put((Object)"annotationSetName", (Object)this.inputASName);
            this.gazetteer.setParameterValues(params);
            this.gazetteer.addProgressListener((ProgressListener)pListener);
            this.gazetteer.addStatusListener(sListener);
            this.gazetteer.execute();
        }
        catch (ResourceInstantiationException e) {
            throw new ExecutionException((Throwable)e);
        }
        finally {
            this.gazetteer.setDocument(null);
            this.gazetteer.removeProgressListener((ProgressListener)pListener);
            this.gazetteer.removeStatusListener(sListener);
        }
        if (this.isInterrupted()) {
            throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" sentence splitter has been abruptly interrupted!");
        }
        pListener = new AbstractProcessingResource.IntervalProgressListener((AbstractProcessingResource)this, 11, 90);
        try {
            params = Factory.newFeatureMap();
            params.put((Object)SPLIT_DOCUMENT_PARAMETER_NAME, (Object)this.document);
            params.put((Object)SPLIT_INPUT_AS_PARAMETER_NAME, (Object)this.inputASName);
            params.put((Object)SPLIT_OUTPUT_AS_PARAMETER_NAME, (Object)this.inputASName);
            this.transducer.setParameterValues(params);
            this.transducer.addProgressListener((ProgressListener)pListener);
            this.transducer.addStatusListener(sListener);
            Benchmark.executeWithBenchmarking((Executable)this.transducer, (String)Benchmark.createBenchmarkId((String)"SentenceSplitterTransducer", (String)this.getBenchmarkId()), (Object)((Object)this), null);
        }
        catch (ResourceInstantiationException e) {
            throw new ExecutionException((Throwable)e);
        }
        finally {
            this.transducer.setDocument(null);
            this.transducer.removeProgressListener((ProgressListener)pListener);
            this.transducer.removeStatusListener(sListener);
        }
        AnnotationSet inputAS = this.inputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.inputASName);
        AnnotationSet annotationSet = outputAS = this.outputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.outputASName);
        if (inputAS != outputAS) {
            outputAS.addAll((Collection)inputAS.get("Sentence"));
        }
        if ((sentences = outputAS.get("Sentence")) == null || sentences.isEmpty()) {
            try {
                outputAS.add(Long.valueOf(0L), this.document.getContent().size(), "Sentence", Factory.newFeatureMap());
            }
            catch (InvalidOffsetException ioe) {
                throw new GateRuntimeException((Throwable)ioe);
            }
        }
        Long endSentences = sentences.lastNode().getOffset();
        AnnotationSet remainingTokens = inputAS.get("Token", endSentences, inputAS.lastNode().getOffset());
        if (remainingTokens != null && !remainingTokens.isEmpty()) {
            try {
                outputAS.add(remainingTokens.firstNode().getOffset(), remainingTokens.lastNode().getOffset(), "Sentence", Factory.newFeatureMap());
            }
            catch (InvalidOffsetException ioe) {
                throw new ExecutionException((Throwable)ioe);
            }
        }
        this.fireProcessFinished();
    }

    public synchronized void interrupt() {
        this.interrupted = true;
        this.gazetteer.interrupt();
        this.transducer.interrupt();
    }

    @Optional
    @CreoleParameter(defaultValue="resources/sentenceSplitter/grammar/main-single-nl.jape", comment="The URL to the custom Jape grammar file", suffixes="jape")
    public void setTransducerURL(ResourceReference newTransducerURL) {
        this.transducerURL = newTransducerURL;
    }

    @Deprecated
    public void setTransducerURL(URL newTransducerURL) {
        try {
            this.setTransducerURL(new ResourceReference(newTransducerURL));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error converting URL to ResourceReference", e);
        }
    }

    public ResourceReference getTransducerURL() {
        return this.transducerURL;
    }

    @CreoleParameter(comment="The encoding used for reading the definition files", defaultValue="UTF-8")
    public void setEncoding(String newEncoding) {
        this.encoding = newEncoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Optional
    @CreoleParameter(defaultValue="resources/sentenceSplitter/gazetteer/lists.def", comment="The URL to the custom list lookup definition file", suffixes="def")
    public void setGazetteerListsURL(ResourceReference newGazetteerListsURL) {
        this.gazetteerListsURL = newGazetteerListsURL;
    }

    @Deprecated
    public void setGazetteerListsURL(URL newGazetteerListsURL) {
        try {
            this.setGazetteerListsURL(new ResourceReference(newGazetteerListsURL));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error converting URL to ResourceReference", e);
        }
    }

    public ResourceReference getGazetteerListsURL() {
        return this.gazetteerListsURL;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="The annotation set to be used as input that must contain 'Token' annotations")
    public void setInputASName(String newInputASName) {
        this.inputASName = newInputASName;
    }

    public String getInputASName() {
        return this.inputASName;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="The annotation set to be used as output for 'Sentence' and 'Split' annotations")
    public void setOutputASName(String newOutputASName) {
        this.outputASName = newOutputASName;
    }

    public String getOutputASName() {
        return this.outputASName;
    }

    public String getBenchmarkId() {
        if (this.benchmarkId == null) {
            return this.getName();
        }
        return this.benchmarkId;
    }

    public void setBenchmarkId(String benchmarkId) {
        this.benchmarkId = benchmarkId;
    }
}

