/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.creole.gazetteer.InvalidFormatException;
import java.io.Serializable;

public class MappingNode
implements Serializable {
    private static final long serialVersionUID = -4410243081697344856L;
    private String list;
    private String classID;
    private String ontologyID;

    public MappingNode(String node) throws InvalidFormatException {
        int firstColumn = node.indexOf(58);
        int lastColumn = node.lastIndexOf(58);
        if (-1 == firstColumn || -1 == lastColumn) {
            throw new InvalidFormatException();
        }
        this.list = node.substring(0, firstColumn);
        this.ontologyID = node.substring(firstColumn + 1, lastColumn);
        this.classID = node.substring(lastColumn + 1);
    }

    public MappingNode(String aList, String anOntologyID, String aClassID) {
        this.list = aList;
        this.classID = aClassID;
        this.ontologyID = anOntologyID;
    }

    public void setList(String aList) {
        this.list = aList;
    }

    public String getList() {
        return this.list;
    }

    public void setClassID(String theClassID) {
        this.classID = theClassID;
    }

    public String getClassID() {
        return this.classID;
    }

    public void setOntologyID(String id) {
        this.ontologyID = id;
    }

    public String getOntologyID() {
        return this.ontologyID;
    }

    public String toString() {
        return this.list + ":" + this.ontologyID + ":" + this.classID;
    }
}

