/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.coref;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.coref.AbstractCoreferencer;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.util.Err;
import gate.util.OffsetComparator;
import gate.util.SimpleFeatureMapImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

@CreoleResource(name="ANNIE Nominal Coreferencer", comment="Nominal Coreference resolution component", helpURL="http://gate.ac.uk/userguide/sec:annie:pronom-coref", icon="nominal-coreferencer")
public class NominalCoref
extends AbstractCoreferencer {
    private static final long serialVersionUID = 1497388811557744017L;
    public static final String COREF_DOCUMENT_PARAMETER_NAME = "document";
    public static final String COREF_ANN_SET_PARAMETER_NAME = "annotationSetName";
    private static final String PERSON_CATEGORY = "Person";
    private static final String JOBTITLE_CATEGORY = "JobTitle";
    private static final String ORGANIZATION_CATEGORY = "Organization";
    private static final String LOOKUP_CATEGORY = "Lookup";
    private static final String ORGANIZATION_NOUN_CATEGORY = "organization_noun";
    private String annotationSetName;
    private AnnotationSet defaultAnnotations;
    private HashMap<Annotation, Annotation> anaphor2antecedent = new HashMap();

    public NominalCoref() {
        super("NOMINAL");
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        return super.init();
    }

    @Override
    public void reInit() throws ResourceInstantiationException {
        this.anaphor2antecedent = new HashMap();
        this.init();
    }

    @Override
    public void setDocument(Document newDocument) {
        super.setDocument(newDocument);
    }

    @Override
    @RunTime
    @Optional
    @CreoleParameter(comment="The annotation set to be used for the generated annotations")
    public void setAnnotationSetName(String annotationSetName) {
        this.annotationSetName = annotationSetName;
    }

    @Override
    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public void execute() throws ExecutionException {
        if (null == this.document) {
            throw new ExecutionException("[coreference] Document is not set!");
        }
        this.preprocess();
        Object[] tokens = (Annotation[])this.defaultAnnotations.get("Token").toArray((Object[])new Annotation[0]);
        Arrays.sort(tokens, new OffsetComparator());
        int currentToken = 0;
        HashSet<String> personConstraint = new HashSet<String>();
        personConstraint.add(PERSON_CATEGORY);
        AnnotationSet people = this.defaultAnnotations.get(personConstraint);
        HashSet<String> jobTitleConstraint = new HashSet<String>();
        jobTitleConstraint.add(JOBTITLE_CATEGORY);
        AnnotationSet jobTitles = this.defaultAnnotations.get(jobTitleConstraint);
        SimpleFeatureMapImpl orgNounConstraint = new SimpleFeatureMapImpl();
        orgNounConstraint.put((Object)"majorType", (Object)ORGANIZATION_NOUN_CATEGORY);
        AnnotationSet orgNouns = this.defaultAnnotations.get(LOOKUP_CATEGORY, (FeatureMap)orgNounConstraint);
        HashSet<String> orgConstraint = new HashSet<String>();
        orgConstraint.add(ORGANIZATION_CATEGORY);
        AnnotationSet organizations = this.defaultAnnotations.get(orgConstraint);
        HashSet nominals = new HashSet();
        if (people != null) {
            nominals.addAll(people);
        }
        if (jobTitles != null) {
            nominals.addAll(jobTitles);
        }
        if (orgNouns != null) {
            nominals.addAll(orgNouns);
        }
        if (organizations != null) {
            nominals.addAll(organizations);
        }
        Annotation[] nominalArray = nominals.toArray(new Annotation[0]);
        Arrays.sort(nominalArray, new OffsetComparator());
        ArrayList<Annotation> previousPeople = new ArrayList<Annotation>();
        ArrayList<Annotation> previousOrgs = new ArrayList<Annotation>();
        for (int i = 0; i < nominalArray.length; ++i) {
            Annotation lastToken;
            Annotation nominal = nominalArray[i];
            currentToken = this.advanceTokenPosition(nominal, currentToken, tokens);
            if (nominal.getType().equals(PERSON_CATEGORY)) {
                Annotation personToken;
                String personCategory;
                Annotation[] personTokens = this.getSortedTokens(nominal);
                if (personTokens.length == 1 && ((personCategory = (String)(personToken = personTokens[0]).getFeatures().get((Object)"category")).equals("PP") || personCategory.equals("PRP") || personCategory.equals("PRP$") || personCategory.equals("PRPR$"))) continue;
                previousPeople.add(0, nominal);
                continue;
            }
            if (nominal.getType().equals(JOBTITLE_CATEGORY)) {
                Annotation nextAnnotation;
                Object previousToken;
                String previousValue;
                Annotation[] jobTitleTokens = this.getSortedTokens(nominal);
                lastToken = jobTitleTokens[jobTitleTokens.length - 1];
                String tokenCategory = (String)lastToken.getFeatures().get((Object)"category");
                if (!tokenCategory.equals("NN") || this.overlapsAnnotations(nominal, people) || currentToken != 0 && ((previousValue = (String)(previousToken = tokens[currentToken - 1]).getFeatures().get((Object)"string")).equalsIgnoreCase("a") || previousValue.equalsIgnoreCase("an") || previousValue.equalsIgnoreCase("other") || previousValue.equalsIgnoreCase("another"))) continue;
                if (i < nominalArray.length - 1 && (nextAnnotation = nominalArray[i + 1]).getType().equals(PERSON_CATEGORY)) {
                    String tokenString;
                    previousToken = tokens[currentToken - 1];
                    previousValue = (String)previousToken.getFeatures().get((Object)"string");
                    int interveningTokens = this.countInterveningTokens(nominal, nextAnnotation, currentToken, tokens);
                    if (interveningTokens == 0 && !previousValue.equalsIgnoreCase("the") || interveningTokens == 1 && !(tokenString = (String)this.getFollowingToken(nominal, currentToken, tokens).getFeatures().get((Object)"string")).equals(",") && !tokenString.equals("-")) continue;
                    this.anaphor2antecedent.put(nominal, nextAnnotation);
                    continue;
                }
                if (previousPeople.size() == 0) {
                    SimpleFeatureMapImpl personFeatures = new SimpleFeatureMapImpl();
                    personFeatures.put((Object)"ENTITY_MENTION_TYPE", (Object)"NOMINAL");
                    this.defaultAnnotations.add(nominal.getStartNode(), nominal.getEndNode(), PERSON_CATEGORY, (FeatureMap)personFeatures);
                    continue;
                }
                int personIndex = 0;
                Annotation previousPerson = (Annotation)previousPeople.get(personIndex);
                String personGender = (String)previousPerson.getFeatures().get((Object)"gender");
                String jobTitleGender = (String)nominal.getFeatures().get((Object)"gender");
                if (personGender != null && jobTitleGender != null && !personGender.equals(jobTitleGender)) continue;
                this.anaphor2antecedent.put(nominal, previousPerson);
                continue;
            }
            if (nominal.getType().equals(ORGANIZATION_CATEGORY)) {
                previousOrgs.add(0, nominal);
                continue;
            }
            if (!nominal.getType().equals(LOOKUP_CATEGORY) || previousOrgs.size() == 0) continue;
            Annotation[] orgNounTokens = (Annotation[])this.defaultAnnotations.get("Token", nominal.getStartNode().getOffset(), nominal.getEndNode().getOffset()).toArray((Object[])new Annotation[0]);
            Arrays.sort(orgNounTokens, new OffsetComparator());
            lastToken = orgNounTokens[orgNounTokens.length - 1];
            if (!lastToken.getFeatures().get((Object)"category").equals("NN")) continue;
            this.anaphor2antecedent.put(nominal, (Annotation)previousOrgs.get(0));
        }
        this.generateCorefChains(this.anaphor2antecedent);
    }

    private boolean overlapsAnnotations(Annotation a, AnnotationSet annotations) {
        for (Annotation current : annotations) {
            if (!a.overlaps(current)) continue;
            return true;
        }
        return false;
    }

    private int advanceTokenPosition(Annotation target, int currentPosition, Object[] tokens) {
        block3: {
            long currentOffset;
            long targetOffset;
            block2: {
                targetOffset = target.getStartNode().getOffset();
                if (targetOffset <= (currentOffset = ((Annotation)tokens[currentPosition]).getStartNode().getOffset().longValue())) break block2;
                while (targetOffset > currentOffset) {
                    currentOffset = ((Annotation)tokens[++currentPosition]).getStartNode().getOffset();
                }
                break block3;
            }
            if (targetOffset >= currentOffset) break block3;
            while (targetOffset < currentOffset) {
                currentOffset = ((Annotation)tokens[--currentPosition]).getStartNode().getOffset();
            }
        }
        return currentPosition;
    }

    private int countInterveningTokens(Annotation first, Annotation second, int currentPosition, Object[] tokens) {
        int interveningTokens = 0;
        long startOffset = first.getEndNode().getOffset();
        long endOffset = second.getStartNode().getOffset();
        long currentOffset = ((Annotation)tokens[currentPosition]).getStartNode().getOffset();
        while (currentOffset < endOffset) {
            if (currentOffset >= startOffset) {
                ++interveningTokens;
            }
            currentOffset = ((Annotation)tokens[++currentPosition]).getStartNode().getOffset();
        }
        return interveningTokens;
    }

    private Annotation getFollowingToken(Annotation current, int currentPosition, Object[] tokens) {
        long endOffset = current.getEndNode().getOffset();
        long currentOffset = ((Annotation)tokens[currentPosition]).getStartNode().getOffset();
        while (currentOffset < endOffset) {
            currentOffset = ((Annotation)tokens[++currentPosition]).getStartNode().getOffset();
        }
        return (Annotation)tokens[currentPosition];
    }

    private String stringValue(Annotation ann) {
        Annotation[] tokens = this.getSortedTokens(ann);
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < tokens.length; ++i) {
            Annotation token = tokens[i];
            output.append(token.getFeatures().get((Object)"string"));
            if (i >= tokens.length - 1) continue;
            output.append(" ");
        }
        return output.toString();
    }

    private Annotation[] getSortedTokens(Annotation a) {
        Annotation[] annotationTokens = (Annotation[])this.defaultAnnotations.get("Token", a.getStartNode().getOffset(), a.getEndNode().getOffset()).toArray((Object[])new Annotation[0]);
        Arrays.sort(annotationTokens, new OffsetComparator());
        return annotationTokens;
    }

    public Map<Annotation, Annotation> getResolvedAnaphora() {
        return this.anaphor2antecedent;
    }

    private void preprocess() throws ExecutionException {
        this.anaphor2antecedent.clear();
        this.defaultAnnotations = this.annotationSetName == null || this.annotationSetName.equals("") ? this.document.getAnnotations() : this.document.getAnnotations(this.annotationSetName);
        if (this.defaultAnnotations == null || this.defaultAnnotations.isEmpty()) {
            Err.prln((String)"Coref Warning: No annotations found for processing!");
            return;
        }
    }
}

