/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.coref;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.coref.PronominalCoref;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.util.GateRuntimeException;
import gate.util.SimpleFeatureMapImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@CreoleResource(name="ANNIE Pronominal Coreferencer", comment="Pronominal Coreference resolution component.", helpURL="http://gate.ac.uk/userguide/sec:annie:pronom-coref", icon="pronominal-coreferencer")
public class Coreferencer
extends AbstractLanguageAnalyser {
    private static final long serialVersionUID = -2343178168872843239L;
    public static final String COREF_DOCUMENT_PARAMETER_NAME = "document";
    public static final String COREF_ANN_SET_PARAMETER_NAME = "annotationSetName";
    public static final String COREF_TYPE_FEATURE_NAME = "ENTITY_MENTION_TYPE";
    public static final String COREF_ANTECEDENT_FEATURE_NAME = "antecedent_offset";
    private static final boolean DEBUG = false;
    private static final Logger log = Logger.getLogger(Coreferencer.class);
    private PronominalCoref pronominalModule = new PronominalCoref();

    public Resource init() throws ResourceInstantiationException {
        this.pronominalModule = (PronominalCoref)Factory.createResource((String)"gate.creole.coref.PronominalCoref");
        return this;
    }

    public void reInit() throws ResourceInstantiationException {
        this.pronominalModule.reInit();
    }

    public void setDocument(Document newDocument) {
        this.pronominalModule.setDocument(newDocument);
        super.setDocument(newDocument);
    }

    public void cleanup() {
        super.cleanup();
        this.pronominalModule.cleanup();
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="The annotation set to be used for the generated annotations")
    public void setAnnotationSetName(String annotationSetName) {
        this.pronominalModule.setAnnotationSetName(annotationSetName);
    }

    public String getAnnotationSetName() {
        return this.pronominalModule.getAnnotationSetName();
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="Whether or not to resolve it pronouns", defaultValue="false")
    public void setResolveIt(Boolean newValue) {
        this.pronominalModule.setResolveIt(newValue);
    }

    public Boolean getResolveIt() {
        return this.pronominalModule.getResolveIt();
    }

    public void execute() throws ExecutionException {
        this.fireStatusChanged("Pronominal Coreferencer processing: " + this.document.getName());
        this.pronominalModule.execute();
        this.generateCorefChains();
        this.fireStatusChanged("Pronominal Coreferencer completed");
    }

    private void generateCorefChains() throws GateRuntimeException {
        Map<Annotation, Annotation> ana2ant = this.pronominalModule.getResolvedAnaphora();
        String asName = this.getAnnotationSetName();
        AnnotationSet outputSet = null;
        outputSet = null == asName || asName.equals("") ? this.getDocument().getAnnotations() : this.getDocument().getAnnotations(asName);
        for (Map.Entry<Annotation, Annotation> currLink : ana2ant.entrySet()) {
            ArrayList<Integer> matches;
            Annotation anaphor = currLink.getKey();
            Annotation antecedent = currLink.getValue();
            if (null == antecedent) continue;
            Object matchesObj = antecedent.getFeatures().get((Object)"matches");
            ArrayList<Integer> arrayList = matches = matchesObj instanceof List ? (ArrayList<Integer>)matchesObj : null;
            if (matchesObj != null && matches == null) {
                log.warn((Object)"Illegal value for matches feature was ignored.");
            }
            if (null == matches) {
                List<ArrayList<Integer>> matchesList;
                Map matchesMap;
                matches = new ArrayList<Integer>();
                matches.add(antecedent.getId());
                antecedent.getFeatures().put((Object)"matches", matches);
                if (this.document.getFeatures().containsKey((Object)"MatchesAnnots")) {
                    matchesMap = (Map)this.document.getFeatures().get((Object)"MatchesAnnots");
                    matchesList = (List)matchesMap.get(this.getAnnotationSetName());
                    if (matchesList == null) {
                        matchesList = new ArrayList();
                        matchesMap.put(this.getAnnotationSetName(), matchesList);
                    }
                    matchesList.add(matches);
                } else {
                    matchesMap = new HashMap();
                    matchesList = new ArrayList();
                    matchesMap.put(this.getAnnotationSetName(), matchesList);
                    matchesList.add(matches);
                    this.document.getFeatures().put((Object)"MatchesAnnots", matchesMap);
                }
            }
            SimpleFeatureMapImpl features = new SimpleFeatureMapImpl();
            features.put((Object)COREF_TYPE_FEATURE_NAME, (Object)"PRONOUN");
            features.put((Object)"matches", matches);
            features.put((Object)COREF_ANTECEDENT_FEATURE_NAME, (Object)antecedent.getStartNode().getOffset());
            AnnotationSet existing = outputSet.get(antecedent.getType(), anaphor.getStartNode().getOffset(), anaphor.getEndNode().getOffset());
            if (existing.size() > 0) {
                Annotation annot = (Annotation)existing.iterator().next();
                annot.getFeatures().putAll((Map)features);
                matches.add(annot.getId());
                continue;
            }
            matches.add(outputSet.add(anaphor.getStartNode(), anaphor.getEndNode(), antecedent.getType(), (FeatureMap)features));
        }
    }

    public String getInanimatedEntityTypes() {
        return this.pronominalModule.getInanimatedEntityTypes();
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="List of annotation types for non animated entities", defaultValue="Organization;Location")
    public void setInanimatedEntityTypes(String inanimatedEntityTypes) {
        this.pronominalModule.setInanimatedEntityTypes(inanimatedEntityTypes);
    }
}

