/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annotdelete;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.util.GateRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@CreoleResource(name="Document Reset PR", icon="document-reset", comment="Remove named annotation sets or reset the default annotation set", helpURL="http://gate.ac.uk/userguide/sec:misc-creole:reset")
public class AnnotationDeletePR
extends AbstractLanguageAnalyser {
    private static final long serialVersionUID = 4738446480871610387L;
    public static final String TRANSD_DOCUMENT_PARAMETER_NAME = "document";
    public static final String TRANSD_ANNOT_TYPES_PARAMETER_NAME = "annotationTypes";
    public static final String TRANSD_SETS_KEEP_PARAMETER_NAME = "setsToKeep";
    public static final String TRANSD_SETS_KEEP_ORIGIANL_MARKUPS_ANNOT_SET = "keppOriginalMarkupsAS";
    protected String markupSetName = "Original markups";
    protected List<String> annotationTypes;
    protected List<String> setsToKeep;
    protected List<String> setsToRemove = null;
    protected Boolean keepOriginalMarkupsAS;

    @RunTime
    @Optional
    @CreoleParameter(comment="A list of annotation set names to reset/remove. If non-empty, ignore the parameters which specify what to keep")
    public void setSetsToRemove(List<String> setsToRemove) {
        this.setsToRemove = setsToRemove;
    }

    public List<String> getSetsToRemove() {
        return this.setsToRemove;
    }

    public Resource init() throws ResourceInstantiationException {
        return super.init();
    }

    public void reInit() throws ResourceInstantiationException {
        this.init();
    }

    public void execute() throws ExecutionException {
        Map matchesMap;
        if (this.document == null) {
            throw new GateRuntimeException("No document to process!");
        }
        Object matchesMapObject = this.document.getFeatures().get((Object)"MatchesAnnots");
        Map map = matchesMap = matchesMapObject instanceof Map ? (Map)matchesMapObject : null;
        if (this.setsToRemove != null && !this.setsToRemove.isEmpty()) {
            for (String setName : this.setsToRemove) {
                if (setName == null || setName.equals("")) {
                    if (this.annotationTypes == null || this.annotationTypes.isEmpty()) {
                        this.document.getAnnotations().clear();
                        this.removeFromDocumentCorefData(null, matchesMap);
                    } else {
                        this.removeSubSet(this.document.getAnnotations(), matchesMap);
                    }
                    this.document.getAnnotations().getRelations().clear();
                    continue;
                }
                if (this.annotationTypes == null || this.annotationTypes.isEmpty()) {
                    this.document.removeAnnotationSet(setName);
                    this.removeFromDocumentCorefData(setName, matchesMap);
                    continue;
                }
                this.removeSubSet(this.document.getAnnotations(setName), matchesMap);
            }
            if (matchesMap != null) {
                this.document.getFeatures().put((Object)"MatchesAnnots", (Object)matchesMap);
            }
        } else {
            Map namedSets;
            ArrayList<String> keepSets = new ArrayList<String>();
            if (this.setsToKeep != null) {
                keepSets.addAll(this.setsToKeep);
            }
            if (this.keepOriginalMarkupsAS.booleanValue() && !keepSets.contains(this.markupSetName)) {
                keepSets.add(this.markupSetName);
            }
            if (!keepSets.contains(null) && !keepSets.contains("")) {
                if (this.annotationTypes == null || this.annotationTypes.isEmpty()) {
                    this.document.getAnnotations().clear();
                    this.removeFromDocumentCorefData(null, matchesMap);
                } else {
                    this.removeSubSet(this.document.getAnnotations(), matchesMap);
                }
                this.document.getAnnotations().getRelations().clear();
            }
            if ((namedSets = this.document.getNamedAnnotationSets()) != null && !namedSets.isEmpty()) {
                ArrayList setNames = new ArrayList(namedSets.keySet());
                for (String setName : setNames) {
                    if (setName == null || keepSets.contains(setName)) continue;
                    if (this.annotationTypes == null || this.annotationTypes.isEmpty()) {
                        this.document.removeAnnotationSet(setName);
                        this.removeFromDocumentCorefData(setName, matchesMap);
                        continue;
                    }
                    this.removeSubSet(this.document.getAnnotations(setName), matchesMap);
                }
            }
            if (matchesMap != null) {
                this.document.getFeatures().put((Object)"MatchesAnnots", (Object)matchesMap);
            }
        }
    }

    private void removeFromDocumentCorefData(String currentSet, Map<String, List<List<Integer>>> matchesMap) {
        if (matchesMap == null) {
            return;
        }
        if (currentSet == null) {
            List<List<Integer>> matches = matchesMap.get(currentSet);
            if (matches == null || matches.size() == 0) {
                return;
            }
            matchesMap.put(currentSet, new ArrayList());
        } else {
            matchesMap.remove(currentSet);
        }
    }

    private void removeAnnotationsFromCorefData(AnnotationSet annotations, String setName, Map<String, List<List<Integer>>> matchesMap) {
        if (matchesMap == null) {
            return;
        }
        List<List<Integer>> matches = matchesMap.get(setName);
        if (matches == null) {
            return;
        }
        ArrayList annots = new ArrayList(annotations);
        for (int i = 0; i < annots.size(); ++i) {
            Annotation toRemove = (Annotation)annots.get(i);
            Iterator<List<Integer>> idIters = matches.iterator();
            List<Object> ids = new ArrayList();
            while (idIters.hasNext() && !(ids = idIters.next()).remove(toRemove.getId())) {
            }
            if (ids.size() != 0) continue;
            matches.remove(ids);
        }
        if (matches.size() == 0) {
            matchesMap.remove(setName);
        }
    }

    private void removeSubSet(AnnotationSet theSet, Map<String, List<List<Integer>>> matchMap) {
        AnnotationSet toRemove = theSet.get(new HashSet<String>(this.annotationTypes));
        if (toRemove == null || toRemove.isEmpty()) {
            return;
        }
        theSet.removeAll((Collection)toRemove);
        this.removeAnnotationsFromCorefData(toRemove, theSet.getName(), matchMap);
    }

    public void setMarkupASName(String newMarkupASName) {
        this.markupSetName = newMarkupASName;
    }

    public String getMarkupASName() {
        return this.markupSetName;
    }

    public List<String> getAnnotationTypes() {
        return this.annotationTypes;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="The annotation types to delete otherwise delete all")
    public void setAnnotationTypes(List<String> newTypes) {
        this.annotationTypes = newTypes;
    }

    public List<String> getSetsToKeep() {
        return this.setsToKeep;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="The annotation sets to keep otherwise delete all", defaultValue="Key")
    public void setSetsToKeep(List<String> newSetNames) {
        this.setsToKeep = newSetNames != null ? new ArrayList<String>(newSetNames) : new ArrayList();
    }

    public Boolean getKeepOriginalMarkupsAS() {
        return this.keepOriginalMarkupsAS;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="Should we keep the 'Original markups' annotation set?", defaultValue="true")
    public void setKeepOriginalMarkupsAS(Boolean emptyDefaultAnnotationSet) {
        this.keepOriginalMarkupsAS = emptyDefaultAnnotationSet;
    }
}

