/*
 * Decompiled with CFR 0.152.
 */
package hepple.postag;

import gate.util.BomStrippingInputStreamReader;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import hepple.postag.InvalidRuleException;
import hepple.postag.Lexicon;
import hepple.postag.Rule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;

public class POSTagger {
    protected Map<String, List<Rule>> rules;
    Lexicon lexicon;
    private String encoding;
    static final String staart = "STAART";
    private String[] staartLex = new String[]{"STAART"};
    private String[] deflex_NNP = new String[]{"NNP"};
    private String[] deflex_JJ = new String[]{"JJ"};
    private String[] deflex_CD = new String[]{"CD"};
    private String[] deflex_NNS = new String[]{"NNS"};
    private String[] deflex_RB = new String[]{"RB"};
    private String[] deflex_VBG = new String[]{"VBG"};
    private String[] deflex_NN = new String[]{"NN"};
    public String[] wordBuff = new String[]{"STAART", "STAART", "STAART", "STAART", "STAART", "STAART", "STAART"};
    public String[] tagBuff = new String[]{"STAART", "STAART", "STAART", "STAART", "STAART", "STAART", "STAART"};
    public String[][] lexBuff = new String[][]{this.staartLex, this.staartLex, this.staartLex, this.staartLex, this.staartLex, this.staartLex, this.staartLex};

    public POSTagger(URL lexiconURL, URL rulesURL) throws InvalidRuleException, IOException {
        this(lexiconURL, rulesURL, null, " ");
    }

    public POSTagger(URL lexiconURL, URL rulesURL, String encoding) throws InvalidRuleException, IOException {
        this(lexiconURL, rulesURL, encoding, " ");
    }

    public POSTagger(URL lexiconURL, URL rulesURL, String encoding, String separator) throws InvalidRuleException, IOException {
        this.encoding = encoding;
        this.lexicon = new Lexicon(lexiconURL, encoding, separator);
        this.rules = new HashMap<String, List<Rule>>();
        this.readRules(rulesURL);
    }

    public Rule createNewRule(String ruleId) throws InvalidRuleException {
        try {
            String className = "hepple.postag.rules.Rule_" + ruleId;
            Class<?> ruleClass = Class.forName(className);
            return (Rule)ruleClass.newInstance();
        }
        catch (Exception e) {
            throw new InvalidRuleException("Could not create rule " + ruleId + "!\n" + e.toString());
        }
    }

    public List<List<String[]>> runTagger(List<List<String>> sentences) {
        ArrayList<List<String[]>> output = new ArrayList<List<String[]>>();
        ArrayList<Object> taggedSentence = new ArrayList<String[]>();
        for (List<String> sentence : sentences) {
            for (String newWord : sentence) {
                this.oneStep(newWord, taggedSentence);
            }
            for (int i = 0; i < 6; ++i) {
                this.oneStep(staart, taggedSentence);
            }
            output.add(taggedSentence);
            taggedSentence = new ArrayList();
        }
        return output;
    }

    protected boolean oneStep(String word, List<String[]> taggedSentence) {
        String taggedWord;
        for (int i = 1; i < 7; ++i) {
            this.wordBuff[i - 1] = this.wordBuff[i];
            this.tagBuff[i - 1] = this.tagBuff[i];
            this.lexBuff[i - 1] = this.lexBuff[i];
        }
        this.wordBuff[6] = word;
        this.lexBuff[6] = this.classifyWord(word);
        this.tagBuff[6] = this.lexBuff[6][0];
        List<Rule> rulesToApply = this.rules.get(this.lexBuff[3][0]);
        if (rulesToApply != null && rulesToApply.size() > 0) {
            Iterator<Rule> rulesIter = rulesToApply.iterator();
            while (rulesIter.hasNext() && !rulesIter.next().apply(this)) {
            }
        }
        if ((taggedWord = this.wordBuff[0]) != staart) {
            taggedSentence.add(new String[]{taggedWord, this.tagBuff[0]});
            if (this.wordBuff[1] == staart) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRules(URL rulesURL) throws IOException, InvalidRuleException {
        BomStrippingInputStreamReader rulesReader = null;
        try {
            rulesReader = this.encoding == null ? new BomStrippingInputStreamReader(rulesURL.openStream()) : new BomStrippingInputStreamReader(rulesURL.openStream(), this.encoding);
            String line = rulesReader.readLine();
            while (line != null) {
                ArrayList<String> ruleParts = new ArrayList<String>();
                StringTokenizer tokens = new StringTokenizer(line);
                while (tokens.hasMoreTokens()) {
                    ruleParts.add(tokens.nextToken());
                }
                if (ruleParts.size() < 3) {
                    throw new InvalidRuleException(line);
                }
                Rule newRule = this.createNewRule((String)ruleParts.get(2));
                newRule.initialise(ruleParts);
                List<Rule> existingRules = this.rules.get(newRule.from);
                if (existingRules == null) {
                    existingRules = new ArrayList<Rule>();
                    this.rules.put(newRule.from, existingRules);
                }
                existingRules.add(newRule);
                line = rulesReader.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(rulesReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)rulesReader);
    }

    public void showRules() {
        System.out.println(this.rules);
    }

    protected String[] classifyWord(String wd) {
        int i;
        if (staart.equals(wd)) {
            return this.staartLex;
        }
        List categories = (List)this.lexicon.get(wd);
        if (categories != null) {
            String[] result = new String[categories.size()];
            for (int i2 = 0; i2 < result.length; ++i2) {
                result[i2] = (String)categories.get(i2);
            }
            return result;
        }
        if ('A' <= wd.charAt(0) && wd.charAt(0) <= 'Z') {
            return this.deflex_NNP;
        }
        for (i = 1; i < wd.length() - 1; ++i) {
            if (wd.charAt(i) != '-') continue;
            return this.deflex_JJ;
        }
        for (i = 0; i < wd.length(); ++i) {
            if ('0' > wd.charAt(i) || wd.charAt(i) > '9') continue;
            return this.deflex_CD;
        }
        if (wd.endsWith("ed") || wd.endsWith("us") || wd.endsWith("ic") || wd.endsWith("ble") || wd.endsWith("ive") || wd.endsWith("ary") || wd.endsWith("ful") || wd.endsWith("ical") || wd.endsWith("less")) {
            return this.deflex_JJ;
        }
        if (wd.endsWith("s")) {
            return this.deflex_NNS;
        }
        if (wd.endsWith("ly")) {
            return this.deflex_RB;
        }
        if (wd.endsWith("ing")) {
            return this.deflex_VBG;
        }
        return this.deflex_NN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            POSTagger.help();
        }
        try {
            int opt;
            LongOpt[] options = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("lexicon", 0, null, 108), new LongOpt("rules", 0, null, 114)};
            Getopt getopt = new Getopt("HepTag", args, "hl:r:", options);
            String lexiconUrlString = null;
            String rulesUrlString = null;
            block9: while ((opt = getopt.getopt()) != -1) {
                switch (opt) {
                    case 104: {
                        POSTagger.help();
                        System.exit(0);
                        continue block9;
                    }
                    case 108: {
                        lexiconUrlString = getopt.getOptarg();
                        continue block9;
                    }
                    case 114: {
                        rulesUrlString = getopt.getOptarg();
                        continue block9;
                    }
                }
                System.err.println("Invalid option " + args[getopt.getOptind() - 1] + "!");
                System.exit(1);
            }
            String[] fileNames = new String[args.length - getopt.getOptind()];
            for (int i = getopt.getOptind(); i < args.length; ++i) {
                fileNames[i - getopt.getOptind()] = args[i];
            }
            URL lexiconURL = lexiconUrlString == null ? POSTagger.class.getResource("/hepple/resources/sample_lexicon") : new File(lexiconUrlString).toURI().toURL();
            URL rulesURL = rulesUrlString == null ? POSTagger.class.getResource("/hepple/resources/sample_ruleset.big") : new File(rulesUrlString).toURI().toURL();
            POSTagger tagger = new POSTagger(lexiconURL, rulesURL);
            for (int i = 0; i < fileNames.length; ++i) {
                String file = fileNames[i];
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(file));
                    String line = reader.readLine();
                    while (line != null) {
                        StringTokenizer tokens = new StringTokenizer(line);
                        ArrayList<String> sentence = new ArrayList<String>();
                        while (tokens.hasMoreTokens()) {
                            sentence.add(tokens.nextToken());
                        }
                        ArrayList<List<String>> sentences = new ArrayList<List<String>>();
                        sentences.add(sentence);
                        List<List<String[]>> result = tagger.runTagger(sentences);
                        for (List<String[]> sentenceFromTagger : result) {
                            Iterator<String[]> sentIter = sentenceFromTagger.iterator();
                            while (sentIter.hasNext()) {
                                String[] tag = sentIter.next();
                                System.out.print(tag[0] + "/" + tag[1]);
                                if (sentIter.hasNext()) {
                                    System.out.print(" ");
                                    continue;
                                }
                                System.out.println();
                            }
                        }
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void help() {
        System.out.println("NAME\nHepTag - a Part-of-Speech tagger\nsee http://www.dcs.shef.ac.uk/~hepple/papers/acl00/abstract.html \n\nSYNOPSIS\n\tjava hepple.postag.POSTagger [options] file1 [file2 ...]\n\nOPTIONS:\n-h, --help \n\tdisplays this message\n-l, --lexicon <lexicon file>\n\tuses specified lexicon\n-r, --rules <rules file>\n\tuses specified rules");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<List<String>> readInput(String file) throws IOException {
        ArrayList<List<String>> arrayList;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            ArrayList<List<String>> result = new ArrayList<List<String>>();
            while (line != null) {
                StringTokenizer tokens = new StringTokenizer(line);
                ArrayList<String> sentence = new ArrayList<String>();
                while (tokens.hasMoreTokens()) {
                    sentence.add(tokens.nextToken());
                }
                result.add(sentence);
                line = reader.readLine();
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return arrayList;
    }
}

