/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.jape.constraint.ConstraintFactory;
import gate.jape.parser.ParseCpsl;
import gate.util.BomStrippingInputStreamReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class JapeFactory {
    static Class<? extends ParseCpsl> japeParserClass = ParseCpsl.class;
    private static ConstraintFactory japeConstraintFactory = new ConstraintFactory();

    public static Class<? extends ParseCpsl> getJapeParserClass() {
        return japeParserClass;
    }

    public static void setJapeParserClass(Class<? extends ParseCpsl> newClass) {
        japeParserClass = newClass;
    }

    public static ParseCpsl newJapeParser(Reader stream, Map<String, Object> existingMacros) {
        try {
            Constructor<? extends ParseCpsl> c = japeParserClass.getConstructor(Reader.class, Map.class);
            return c.newInstance(stream, existingMacros);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static ParseCpsl newJapeParser(URL japeURL, String encoding) throws IOException {
        BomStrippingInputStreamReader stream = new BomStrippingInputStreamReader(japeURL.openStream(), encoding);
        ParseCpsl parser = JapeFactory.newJapeParser((Reader)stream, new HashMap<String, Object>());
        parser.setBaseURL(japeURL);
        parser.setEncoding(encoding);
        return parser;
    }

    public static ConstraintFactory getConstraintFactory() {
        return japeConstraintFactory;
    }
}

