/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.Annotation;
import gate.AnnotationSet;
import gate.FeatureMap;
import gate.creole.ANNIEConstants;
import gate.creole.ontology.Ontology;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.JapeFactory;
import gate.jape.constraint.AnnotationFeatureAccessor;
import gate.jape.constraint.ConstraintPredicate;
import gate.util.Err;
import gate.util.SimpleFeatureMapImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Constraint
implements JapeConstants,
ANNIEConstants,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7856281017609822483L;
    private String annotType;
    private boolean negated = false;
    private List<ConstraintPredicate> predicates = new ArrayList<ConstraintPredicate>();
    protected ConstraintPredicate ontLookupClassPred;
    protected FeatureMap ontFeatureMap;

    public Constraint(String annotType) {
        this.annotType = annotType;
    }

    public Constraint(String annotType, FeatureMap attrs) {
        this(annotType);
        for (Map.Entry entry : attrs.entrySet()) {
            this.addAttribute(entry.getKey().toString(), entry.getValue());
        }
    }

    public void negate() {
        this.negated = true;
    }

    public void changeSign() {
        this.negated = !this.negated;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public String getAnnotType() {
        return this.annotType;
    }

    public List<ConstraintPredicate> getAttributeSeq() {
        return this.predicates;
    }

    public void addAttribute(ConstraintPredicate attr) {
        this.predicates.add(attr);
        if (attr.getAccessor() instanceof AnnotationFeatureAccessor) {
            String featureName = (String)attr.getAccessor().getKey();
            if (featureName.equals("class")) {
                this.ontLookupClassPred = attr;
                this.getOntFeatureMap().put((Object)"class", this.ontLookupClassPred.getValue());
                if (!attr.getOperator().equals("==")) {
                    Err.println((String)("Warning: If an ontology is specified at runtime, Ontology class feature will be compared using ontology subsumption, not " + attr.getOperator()));
                }
            } else if (featureName.equals("ontology")) {
                this.getOntFeatureMap().put((Object)"ontology", attr.getValue());
            }
        }
    }

    protected FeatureMap getOntFeatureMap() {
        if (this.ontFeatureMap == null) {
            this.ontFeatureMap = new SimpleFeatureMapImpl();
        }
        return this.ontFeatureMap;
    }

    public void addAttribute(String name, Object value) {
        ConstraintPredicate attr = JapeFactory.getConstraintFactory().createPredicate(name, value);
        this.addAttribute(attr);
    }

    public void addAttributes(Collection<ConstraintPredicate> attrs) {
        for (ConstraintPredicate pred : attrs) {
            this.addAttribute(pred);
        }
    }

    public Object clone() {
        Constraint newC = null;
        try {
            newC = (Constraint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
        newC.annotType = this.annotType;
        newC.predicates = new ArrayList<ConstraintPredicate>(this.predicates);
        return newC;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Constraint)) {
            return super.equals(other);
        }
        Constraint o = (Constraint)other;
        return o.negated == this.negated && o.annotType.equals(this.annotType) && o.predicates.equals(this.predicates);
    }

    public int hashCode() {
        int hashCode = this.negated ? 0 : 629;
        hashCode = 37 * hashCode + this.annotType.hashCode();
        hashCode = 37 * hashCode + this.predicates.hashCode();
        return hashCode;
    }

    public void finish() {
    }

    public String toString() {
        return this.getDisplayString("Constraint: ");
    }

    public String getDisplayString(String prefix) {
        StringBuffer buf = new StringBuffer(prefix);
        if (this.negated) {
            buf.append("!");
        }
        buf.append(this.annotType);
        if (!this.predicates.isEmpty()) {
            buf.append("(");
            buf.append(this.getAttributesString());
            buf.append(")");
        }
        return buf.toString();
    }

    public String getAttributesString() {
        StringBuffer retVal = new StringBuffer();
        Iterator<ConstraintPredicate> iter = this.predicates.iterator();
        while (iter.hasNext()) {
            ConstraintPredicate attr = iter.next();
            retVal.append(attr);
            if (!iter.hasNext()) continue;
            retVal.append(",");
        }
        return retVal.toString();
    }

    public String shortDesc() {
        return this.getDisplayString("");
    }

    public List<Annotation> matches(Collection<Annotation> annots, Ontology ontology, AnnotationSet context) {
        ArrayList<Annotation> retVal = new ArrayList<Annotation>();
        if (annots == null) {
            return retVal;
        }
        for (Annotation annot : annots) {
            if (!this.matches(annot, ontology, context)) continue;
            retVal.add(annot);
            if (!this.negated) continue;
            break;
        }
        return retVal;
    }

    public final boolean matches(Annotation annot, Ontology ontologyLR, AnnotationSet context) {
        if (annot == null) {
            return false;
        }
        if (!annot.getType().equals(this.getAnnotType())) {
            return false;
        }
        if (this.predicates == null || this.predicates.isEmpty()) {
            return true;
        }
        for (ConstraintPredicate predicate : this.predicates) {
            boolean successful = false;
            try {
                successful = predicate == this.ontLookupClassPred && ontologyLR != null ? annot.getFeatures().subsumes(ontologyLR, this.ontFeatureMap) : predicate.matches(annot, context);
            }
            catch (JapeException je) {
                Err.println((String)je.getMessage());
            }
            if (successful) continue;
            return false;
        }
        return true;
    }

    public boolean matches(Annotation annot, AnnotationSet context) {
        return this.matches(annot, null, context);
    }
}

