/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.Gate;
import gate.creole.ResourceReference;
import gate.creole.Transducer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.net.URL;

public class Compiler {
    private static String defaultEncoding = "UTF-8";

    public static void main(String[] args) throws Exception {
        boolean verbose = false;
        int argsIndex = 0;
        while (args[argsIndex].toCharArray()[0] == '-') {
            if (!args[argsIndex++].equals("-v")) continue;
            verbose = true;
        }
        if (verbose) {
            System.out.print("Initializing GATE...");
        }
        Gate.runInSandbox((boolean)true);
        Gate.init();
        if (verbose) {
            System.out.println(" Done");
        }
        while (argsIndex < args.length) {
            File in = new File(args[argsIndex]);
            if (verbose) {
                System.out.print("Compiling " + in.getAbsolutePath() + "... ");
            }
            Compiler.compile(in.toURI().toURL(), Compiler.serFromJape(in));
            if (verbose) {
                System.out.println("Done");
            }
            ++argsIndex;
        }
    }

    public static void compile(URL jape, File ser) throws Exception {
        Transducer transducer = new Transducer();
        transducer.setGrammarURL(new ResourceReference(jape));
        transducer.setEncoding(defaultEncoding);
        transducer.init();
        FileOutputStream out = new FileOutputStream(ser);
        ObjectOutputStream s = new ObjectOutputStream(out);
        transducer.serialize(s);
        s.flush();
        s.close();
        out.close();
    }

    private static File serFromJape(File jape) {
        String base = jape.getAbsolutePath();
        if (base.toLowerCase().endsWith(".jape")) {
            base = base.substring(0, base.length() - 5);
        }
        return new File(base + ".ser");
    }
}

