/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.tokeniser;

import gate.creole.tokeniser.InvalidRuleException;
import gate.creole.tokeniser.SimpleTokeniser;
import gate.creole.tokeniser.TokeniserException;
import gate.creole.tokeniser.UnicodeType;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;

class DFSMState
implements Serializable {
    private static final long serialVersionUID = 7584872407097617987L;
    String[][] tokenDesc;
    DFSMState[] transitionFunction = new DFSMState[SimpleTokeniser.maxTypeId];
    String rhs;
    int myIndex = index.getAndIncrement();
    static final AtomicInteger index = new AtomicInteger(0);

    public DFSMState(SimpleTokeniser owner) {
        owner.dfsmStates.add(this);
    }

    void put(UnicodeType type, DFSMState state) {
        this.put(type.type, state);
    }

    void put(int index, DFSMState state) {
        this.transitionFunction[index] = state;
    }

    DFSMState next(int type) {
        return this.transitionFunction[type];
    }

    String getEdgesGML() {
        StringBuffer res = new StringBuffer(1024);
        for (int i = 0; i < this.transitionFunction.length; ++i) {
            DFSMState nextState = this.transitionFunction[i];
            if (null == nextState) continue;
            res.append("edge [ source ");
            res.append(this.myIndex);
            res.append(" target ");
            res.append(nextState.getIndex());
            res.append(" label \"");
            res.append(SimpleTokeniser.typeMnemonics.get(i));
            res.append("\" ]\n");
        }
        return res.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void buildTokenDesc() throws TokeniserException {
        String ignorables = " \t\f";
        String token = null;
        String type = null;
        String attribute = null;
        String value = null;
        StringBuffer prefix = new StringBuffer(1024);
        StringBuffer read = new StringBuffer(1024);
        LinkedList<String> attributes = new LinkedList<String>();
        LinkedList<String> values = new LinkedList<String>();
        StringTokenizer mainSt = new StringTokenizer(this.rhs, ignorables + "\\\";=", true);
        int phase = 0;
        while (mainSt.hasMoreTokens()) {
            token = SimpleTokeniser.skipIgnoreTokens(mainSt);
            if (token.equals("\\")) {
                if (null == prefix) {
                    prefix = new StringBuffer(mainSt.nextToken());
                    continue;
                }
                prefix.append(mainSt.nextToken());
                continue;
            }
            if (null != prefix) {
                read.append(prefix.toString());
                prefix = null;
            }
            if (token.equals("\"")) {
                read = new StringBuffer(mainSt.nextToken("\""));
                if (read.toString().equals("\"")) {
                    read = new StringBuffer(1024);
                } else {
                    mainSt.nextToken(ignorables + "\\\";=");
                }
            } else if (token.equals("=")) {
                if (phase != true) throw new TokeniserException("Invalid attribute format: " + read);
                attribute = read.toString();
                read = new StringBuffer(1024);
                phase = 2;
            } else if (token.equals(";")) {
                if (phase == 0) {
                    type = read.toString();
                    read = new StringBuffer(1024);
                    attributes.addLast(type);
                    values.addLast("");
                    phase = 1;
                } else {
                    if (phase != 2) throw new TokeniserException("Invalid value format: " + read);
                    value = read.toString();
                    read = new StringBuffer(1024);
                    phase = 3;
                }
            } else {
                read.append(token);
            }
            if (phase != 3) continue;
            attributes.addLast(attribute);
            values.addLast(value);
            phase = 1;
        }
        if (attributes.size() < 1) {
            throw new InvalidRuleException("Invalid right hand side " + this.rhs);
        }
        this.tokenDesc = new String[attributes.size()][2];
        for (int i = 0; i < attributes.size(); ++i) {
            this.tokenDesc[i][0] = (String)attributes.get(i);
            this.tokenDesc[i][1] = (String)values.get(i);
        }
    }

    void setRhs(String rhs) {
        this.rhs = rhs;
    }

    String getRhs() {
        return this.rhs;
    }

    boolean isFinal() {
        return null != this.rhs;
    }

    int getIndex() {
        return this.myIndex;
    }

    String[][] getTokenDesc() {
        return this.tokenDesc;
    }
}

