/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.creole.AbstractLanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.InvalidFormatException;
import gate.creole.gazetteer.MappingNode;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class MappingDefinition
extends AbstractLanguageResource
implements List<MappingNode> {
    private static final long serialVersionUID = 3617291212063848503L;
    private static final String ENCODING = "UTF-8";
    private List<MappingNode> nodes = new ArrayList<MappingNode>();
    private URL url;
    private Set<String> lists = new HashSet<String>();
    private Map<String, MappingNode> nodesByList = new HashMap<String, MappingNode>();

    public List<String> getUrls() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            result.add(this.nodes.get(i).getOntologyID());
        }
        return new ArrayList<String>(result);
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL aUrl) {
        this.url = aUrl;
    }

    public void load() throws ResourceInstantiationException, InvalidFormatException {
        if (null == this.url) {
            throw new ResourceInstantiationException("URL not set (null).");
        }
        try {
            String line;
            BomStrippingInputStreamReader mapReader = new BomStrippingInputStreamReader(this.url.openStream(), ENCODING);
            while (null != (line = mapReader.readLine())) {
                if (0 == line.trim().length()) continue;
                MappingNode node = new MappingNode(line);
                this.add(node);
            }
            mapReader.close();
        }
        catch (InvalidFormatException ife) {
            throw new InvalidFormatException(this.url, "on load");
        }
        catch (IOException ioe) {
            throw new ResourceInstantiationException((Exception)ioe);
        }
    }

    public void store() throws ResourceInstantiationException {
        if (null == this.url) {
            throw new ResourceInstantiationException("URL not set (null).");
        }
        try {
            File fileo = Files.fileFromURL((URL)this.url);
            fileo.delete();
            BufferedWriter mapWriter = new BufferedWriter(new FileWriter(fileo));
            for (int index = 0; index < this.nodes.size(); ++index) {
                mapWriter.write(this.nodes.get(index).toString());
                mapWriter.newLine();
            }
            mapWriter.close();
        }
        catch (IOException ioe) {
            throw new ResourceInstantiationException((Exception)ioe);
        }
    }

    public Set<String> getLists() {
        return new HashSet<String>(this.lists);
    }

    public MappingNode getNodeByList(String list) {
        return this.nodesByList.get(list);
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.nodes.contains(o);
    }

    @Override
    public Iterator<MappingNode> iterator() {
        return new SafeIterator();
    }

    @Override
    public Object[] toArray() {
        return this.nodes.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.nodes.toArray(a);
    }

    @Override
    public boolean add(MappingNode o) {
        boolean result = false;
        String list = o.getList();
        if (!this.nodesByList.containsKey(list)) {
            result = this.nodes.add(o);
            this.nodesByList.put(list, o);
            this.lists.add(list);
        }
        return result;
    }

    @Override
    public void add(int index, MappingNode o) {
        String list = o.getList();
        if (!this.nodesByList.containsKey(list)) {
            this.nodes.add(index, o);
            this.nodesByList.put(list, o);
            this.lists.add(list);
        }
    }

    @Override
    public MappingNode set(int index, MappingNode o) {
        throw new UnsupportedOperationException("this method has not been implemented");
    }

    @Override
    public MappingNode get(int index) {
        return this.nodes.get(index);
    }

    @Override
    public boolean remove(Object o) {
        boolean result = false;
        if (o instanceof MappingNode) {
            result = this.nodes.remove(o);
            String list = ((MappingNode)o).getList();
            this.lists.remove(list);
            this.nodesByList.remove(list);
        }
        return result;
    }

    @Override
    public MappingNode remove(int index) {
        MappingNode result = null;
        result = this.nodes.remove(index);
        if (null != result) {
            String list = result.getList();
            this.lists.remove(list);
            this.nodesByList.remove(list);
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.nodes.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends MappingNode> c) {
        boolean result = false;
        for (MappingNode mappingNode : c) {
            result |= this.add(mappingNode);
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends MappingNode> c) {
        int size = this.nodes.size();
        for (MappingNode mappingNode : c) {
            this.add(index++, mappingNode);
        }
        return size != this.nodes.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(o);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int aprioriSize = this.nodes.size();
        ArrayList<MappingNode> scrap = new ArrayList<MappingNode>();
        for (int index = 0; index < this.nodes.size(); ++index) {
            MappingNode node = this.nodes.get(index);
            if (!c.contains(node)) continue;
            scrap.add(node);
        }
        this.removeAll(scrap);
        return aprioriSize != this.nodes.size();
    }

    @Override
    public void clear() {
        this.nodes.clear();
        this.lists.clear();
        this.nodesByList.clear();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lists == null ? 0 : this.lists.hashCode());
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        result = 31 * result + (this.nodesByList == null ? 0 : this.nodesByList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappingDefinition other = (MappingDefinition)obj;
        if (this.lists == null ? other.lists != null : !this.lists.equals(other.lists)) {
            return false;
        }
        if (this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes)) {
            return false;
        }
        return !(this.nodesByList == null ? other.nodesByList != null : !this.nodesByList.equals(other.nodesByList));
    }

    @Override
    public List<MappingNode> subList(int i1, int i2) {
        return this.nodes.subList(i1, i2);
    }

    @Override
    public ListIterator<MappingNode> listIterator(int index) {
        throw new UnsupportedOperationException("this method is not implemented");
    }

    @Override
    public ListIterator<MappingNode> listIterator() {
        throw new UnsupportedOperationException("this method is not implemented");
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.nodes.lastIndexOf(o);
    }

    @Override
    public int indexOf(Object o) {
        return this.nodes.indexOf(o);
    }

    private class SafeIterator
    implements Iterator<MappingNode> {
        private int index = 0;
        private boolean removeCalled = false;

        private SafeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < MappingDefinition.this.nodes.size();
        }

        @Override
        public MappingNode next() {
            this.removeCalled = false;
            return (MappingNode)MappingDefinition.this.nodes.get(this.index++);
        }

        @Override
        public void remove() {
            if (!this.removeCalled && this.index > 0) {
                --this.index;
                MappingDefinition.this.remove(MappingDefinition.this.nodes.get(this.index));
            }
            this.removeCalled = true;
        }
    }
}

