/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class Lookup
implements Serializable {
    private static final long serialVersionUID = 4107354748136747541L;
    public Map<String, Object> features = null;
    public String majorType;
    public String minorType;
    public String languages;
    public String oClass;
    public String ontology;
    public String list;
    public String annotationType;

    public Lookup(String theList, String major, String minor, String theLanguages, String annotationType) {
        this.majorType = major;
        this.minorType = minor;
        this.languages = theLanguages;
        this.list = theList;
        this.annotationType = annotationType;
    }

    public Lookup(String theList, String major, String minor, String theLanguages) {
        this(theList, major, minor, theLanguages, "Lookup");
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        boolean longVersion = false;
        boolean hasArbitaryFeatures = false;
        if (null != this.ontology && null != this.oClass) {
            longVersion = true;
        }
        if (null != this.features) {
            hasArbitaryFeatures = true;
        }
        if (longVersion) {
            b.append(this.list);
            b.append(".");
        }
        b.append(this.majorType);
        b.append(".");
        if (null != this.minorType) {
            b.append(this.minorType);
            if (null != this.languages) {
                b.append(".");
                b.append(this.languages);
            }
        }
        if (longVersion) {
            b.append("|");
            b.append(this.ontology);
            b.append(":");
            b.append(this.oClass);
        }
        if (hasArbitaryFeatures) {
            ArrayList<String> sortedKeys = new ArrayList<String>(this.features.keySet());
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                b.append("|");
                b.append(key);
                b.append(":");
                b.append(this.features.get(key));
            }
        }
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Lookup) {
            return obj.toString().equals(this.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

