/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Controller;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.AbstractProcessingResource;
import gate.creole.ControllerAwarePR;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.ResourceReference;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.creole.ontology.Ontology;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.gui.ActionsPublisher;
import gate.gui.MainFrame;
import gate.jape.Batch;
import gate.jape.DefaultActionContext;
import gate.jape.JapeException;
import gate.jape.JapeFactory;
import gate.jape.constraint.AnnotationAccessor;
import gate.jape.constraint.ConstraintPredicate;
import gate.swing.XJFileChooser;
import gate.util.Benchmarkable;
import gate.util.Err;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;

@CreoleResource(name="JAPE Transducer", comment="A module for executing Jape grammars.", helpURL="http://gate.ac.uk/userguide/chap:jape", icon="jape")
public class Transducer
extends AbstractLanguageAnalyser
implements ActionsPublisher,
Benchmarkable,
ControllerAwarePR {
    private static final long serialVersionUID = -8789395272116846595L;
    public static final String TRANSD_DOCUMENT_PARAMETER_NAME = "document";
    public static final String TRANSD_INPUT_AS_PARAMETER_NAME = "inputASName";
    public static final String TRANSD_OUTPUT_AS_PARAMETER_NAME = "outputASName";
    public static final String TRANSD_ENCODING_PARAMETER_NAME = "encoding";
    public static final String TRANSD_GRAMMAR_URL_PARAMETER_NAME = "grammarURL";
    public static final String TRANSD_BINARY_GRAMMAR_URL_PARAMETER_NAME = "binaryGrammarURL";
    public static final String TRANSD_OPERATORS_PARAMETER_NAME = "operators";
    public static final String TRANSD_ANNOTATION_ACCESSORS_PARAMETER_NAME = "annotationAccessors";
    protected List<Action> actionList;
    protected DefaultActionContext actionContext;
    protected ResourceReference grammarURL;
    protected ResourceReference binaryGrammarURL;
    protected Batch batch;
    protected String encoding;
    protected String inputASName;
    protected String outputASName;
    protected Ontology ontology;
    protected List<String> operators = null;
    protected List<String> annotationAccessors = null;
    protected Boolean enableDebugging = Boolean.FALSE;

    public Transducer() {
        this.actionList = new ArrayList<Action>();
        this.actionList.add(null);
        this.actionList.add(new SerializeTransducerAction());
    }

    public Resource init() throws ResourceInstantiationException {
        block23: {
            try {
                this.fireProgressChanged(0);
                this.initCustomConstraints();
                if (this.binaryGrammarURL != null) {
                    try (ObjectInputStream s = new ObjectInputStream(this.binaryGrammarURL.openStream());){
                        this.batch = (Batch)s.readObject();
                        break block23;
                    }
                }
                if (this.grammarURL != null) {
                    if (this.encoding != null) {
                        this.batch = new Batch(this.grammarURL.toURL(), this.encoding, (StatusListener)new AbstractProcessingResource.InternalStatusListener((AbstractProcessingResource)this));
                        if (this.enableDebugging != null) {
                            this.batch.setEnableDebugging(this.enableDebugging);
                        } else {
                            this.batch.setEnableDebugging(false);
                        }
                        this.batch.setOntology(this.ontology);
                        break block23;
                    }
                    throw new ResourceInstantiationException("encoding is not set!");
                }
                throw new ResourceInstantiationException("Neither grammarURL or binaryGrammarURL parameters are set!");
            }
            catch (JapeException | IOException | ClassNotFoundException e) {
                String message = "Error while parsing the grammar ";
                if (this.grammarURL != null) {
                    message = message + "(" + this.grammarURL.toExternalForm() + ")";
                }
                message = message + ":";
                throw new ResourceInstantiationException(message, (Exception)e);
            }
            finally {
                this.fireProcessFinished();
            }
        }
        this.actionContext = this.initActionContext();
        this.batch.setActionContext(this.actionContext);
        this.batch.addProgressListener((ProgressListener)new AbstractProcessingResource.IntervalProgressListener((AbstractProcessingResource)this, 0, 100));
        return this;
    }

    protected DefaultActionContext initActionContext() {
        return new DefaultActionContext();
    }

    public void execute() throws ExecutionException {
        this.interrupted = false;
        if (this.document == null) {
            throw new ExecutionException("No document provided!");
        }
        if (this.inputASName != null && this.inputASName.equals("")) {
            this.inputASName = null;
        }
        if (this.outputASName != null && this.outputASName.equals("")) {
            this.outputASName = null;
        }
        this.actionContext.setCorpus(this.corpus);
        this.actionContext.setPRFeatures(this.features);
        this.actionContext.setPR((ProcessingResource)this);
        try {
            this.batch.transduce(this.document, this.inputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.inputASName), this.outputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.outputASName));
        }
        catch (JapeException je) {
            throw new ExecutionException((Throwable)((Object)je));
        }
    }

    public List<Action> getActions() {
        ArrayList<Action> result = new ArrayList<Action>();
        result.addAll(this.actionList);
        return result;
    }

    protected void initCustomConstraints() throws ResourceInstantiationException {
        Class<Serializable> clazz;
        if (this.operators != null) {
            for (String opName : this.operators) {
                clazz = null;
                try {
                    clazz = Class.forName(opName, true, (ClassLoader)Gate.getClassLoader()).asSubclass(ConstraintPredicate.class);
                }
                catch (ClassNotFoundException e) {
                    try {
                        clazz = Class.forName(opName, true, Thread.currentThread().getContextClassLoader()).asSubclass(ConstraintPredicate.class);
                    }
                    catch (ClassNotFoundException e1) {
                        throw new ResourceInstantiationException("Cannot load class for operator: " + opName, (Exception)e1);
                    }
                }
                catch (ClassCastException cce) {
                    throw new ResourceInstantiationException("Operator class '" + opName + "' must implement ConstraintPredicate");
                }
                try {
                    ConstraintPredicate predicate = clazz.newInstance();
                    String opSymbol = predicate.getOperator();
                    JapeFactory.getConstraintFactory().addOperator(opSymbol, clazz);
                }
                catch (Exception e) {
                    throw new ResourceInstantiationException("Cannot instantiate class for operator: " + opName, e);
                }
            }
        }
        if (this.annotationAccessors != null) {
            for (String accessorName : this.annotationAccessors) {
                clazz = null;
                try {
                    clazz = Class.forName(accessorName, true, (ClassLoader)Gate.getClassLoader()).asSubclass(AnnotationAccessor.class);
                }
                catch (ClassNotFoundException e) {
                    try {
                        clazz = Class.forName(accessorName, true, Thread.currentThread().getContextClassLoader()).asSubclass(AnnotationAccessor.class);
                    }
                    catch (ClassNotFoundException e1) {
                        throw new ResourceInstantiationException("Cannot load class for accessor: " + accessorName, (Exception)e1);
                    }
                }
                catch (ClassCastException cce) {
                    throw new ResourceInstantiationException("Operator class '" + accessorName + "' must implement AnnotationAccessor");
                }
                try {
                    AnnotationAccessor aa = (AnnotationAccessor)clazz.newInstance();
                    String accSymbol = (String)aa.getKey();
                    JapeFactory.getConstraintFactory().addMetaProperty(accSymbol, clazz);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ResourceInstantiationException("Cannot instantiate class for accessor: " + accessorName, (Exception)e);
                }
            }
        }
    }

    public void serialize(ObjectOutputStream out) throws IOException {
        out.writeObject(this.batch);
        out.flush();
    }

    public synchronized void interrupt() {
        this.interrupted = true;
        this.batch.interrupt();
    }

    @CreoleParameter(comment="The URL to the grammar file.", suffixes="jape", disjunction="grammar", priority=1)
    public void setGrammarURL(ResourceReference newGrammarURL) {
        this.grammarURL = newGrammarURL;
    }

    @Deprecated
    public void setGrammarURL(URL grammar) {
        try {
            this.setGrammarURL(new ResourceReference(grammar));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error converting URL to ResourceReference", e);
        }
    }

    public ResourceReference getGrammarURL() {
        return this.grammarURL;
    }

    @CreoleParameter(comment="The encoding used for reading the grammar", defaultValue="UTF-8")
    public void setEncoding(String newEncoding) {
        this.encoding = newEncoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="The annotation set to be used as input for the transducer")
    public void setInputASName(String newInputASName) {
        this.inputASName = newInputASName;
    }

    public String getInputASName() {
        return this.inputASName;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="The annotation set to be used as output for the transducer")
    public void setOutputASName(String newOutputASName) {
        this.outputASName = newOutputASName;
    }

    public String getOutputASName() {
        return this.outputASName;
    }

    public Boolean getEnableDebugging() {
        return this.enableDebugging;
    }

    @RunTime
    @CreoleParameter(defaultValue="false")
    public void setEnableDebugging(Boolean enableDebugging) {
        this.enableDebugging = enableDebugging;
    }

    public List<String> getOperators() {
        return this.operators;
    }

    @Optional
    @CreoleParameter(comment="Class names that implement gate.jape.constraint.ConstraintPredicate.")
    public void setOperators(List<String> operators) {
        this.operators = operators;
    }

    public List<String> getAnnotationAccessors() {
        return this.annotationAccessors;
    }

    @Optional
    @CreoleParameter(comment="Class names that implement gate.jape.constraint.AnnotationAccessor.")
    public void setAnnotationAccessors(List<String> annotationAccessors) {
        this.annotationAccessors = annotationAccessors;
    }

    public String getBenchmarkId() {
        return this.batch.getBenchmarkId();
    }

    public void setBenchmarkId(String benchmarkId) {
        this.batch.setBenchmarkId(benchmarkId);
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="The ontology to be used by this transducer")
    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
        if (this.batch != null) {
            this.batch.setOntology(ontology);
        }
    }

    public ResourceReference getBinaryGrammarURL() {
        return this.binaryGrammarURL;
    }

    @CreoleParameter(comment="The URL to the binary grammar file.", suffixes="jape", disjunction="grammar", priority=100)
    public void setBinaryGrammarURL(ResourceReference binaryGrammarURL) {
        this.binaryGrammarURL = binaryGrammarURL;
    }

    public void setBinaryGrammarURL(URL binaryGrammarURL) {
        try {
            this.setBinaryGrammarURL(new ResourceReference(binaryGrammarURL));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error converting URL to ResourceReference", e);
        }
    }

    public void controllerExecutionStarted(Controller c) throws ExecutionException {
        this.actionContext.setController(c);
        this.actionContext.setCorpus(this.corpus);
        this.actionContext.setPRFeatures(this.features);
        this.actionContext.setPRName(this.getName());
        this.actionContext.setPR((ProcessingResource)this);
        this.actionContext.setDebuggingEnabled(this.enableDebugging);
        this.batch.runControllerExecutionStartedBlock(this.actionContext, c, this.ontology);
    }

    public void controllerExecutionFinished(Controller c) throws ExecutionException {
        this.batch.runControllerExecutionFinishedBlock(this.actionContext, c, this.ontology);
        this.actionContext.setCorpus(null);
        this.actionContext.setController(null);
        this.actionContext.setPR(null);
    }

    public void controllerExecutionAborted(Controller c, Throwable t) throws ExecutionException {
        this.batch.runControllerExecutionAbortedBlock(this.actionContext, c, t, this.ontology);
        this.actionContext.setCorpus(null);
        this.actionContext.setController(null);
        this.actionContext.setPR(null);
    }

    protected class SerializeTransducerAction
    extends AbstractAction {
        private static final long serialVersionUID = 4248612378452393237L;

        public SerializeTransducerAction() {
            super("Serialize Transducer");
            this.putValue("ShortDescription", "Serializes the Transducer as binary file");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    XJFileChooser fileChooser = MainFrame.getFileChooser();
                    fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.setMultiSelectionEnabled(false);
                    if (fileChooser.showSaveDialog(null) == 0) {
                        File file = fileChooser.getSelectedFile();
                        try (ObjectOutputStream s = new ObjectOutputStream(new FileOutputStream(file));){
                            MainFrame.lockGUI((String)"Serializing JAPE Transducer...");
                            Transducer.this.serialize(s);
                        }
                        catch (IOException ioe) {
                            JOptionPane.showMessageDialog((Component)MainFrame.getInstance(), "Error!\n" + ioe.toString(), "GATE", 0);
                            ioe.printStackTrace(Err.getPrintWriter());
                        }
                        finally {
                            MainFrame.unlockGUI();
                        }
                    }
                }
            };
            Thread thread = new Thread(runnable, "Transduer Serialization");
            thread.setPriority(1);
            thread.start();
        }
    }
}

