/*
 * Decompiled with CFR 0.152.
 */
package gate.jape.constraint;

import gate.AnnotationSet;
import gate.jape.JapeException;
import gate.jape.constraint.AbstractConstraintPredicate;

public class EqualPredicate
extends AbstractConstraintPredicate {
    private static final long serialVersionUID = 3833632644179230280L;

    @Override
    public String getOperator() {
        return "==";
    }

    @Override
    public boolean doMatch(Object annotValue, AnnotationSet context) throws JapeException {
        if (this.value == null && annotValue != null) {
            return false;
        }
        if (this.value.equals(annotValue)) {
            return true;
        }
        if (annotValue instanceof String && !(this.value instanceof String)) {
            String annotValueString = (String)annotValue;
            try {
                if (this.value instanceof Long) {
                    return this.value.equals(Long.valueOf(annotValueString));
                }
                if (this.value instanceof Double) {
                    return this.value.equals(Double.valueOf(annotValueString));
                }
                if (this.value instanceof Boolean) {
                    return this.value.equals(Boolean.valueOf(annotValueString));
                }
                throw new JapeException("Cannot compare values for attribute '" + this.getAccessor() + "' because cannot compare '" + this.value + "' to '" + annotValue + "'.");
            }
            catch (NumberFormatException otherType) {
                return false;
            }
        }
        return false;
    }
}

