/*
 * Decompiled with CFR 0.152.
 */
package gate.jape.constraint;

import gate.jape.Constraint;
import gate.jape.constraint.AnnotationAccessor;
import gate.jape.constraint.AnnotationFeatureAccessor;
import gate.jape.constraint.CleanStringAccessor;
import gate.jape.constraint.ConstraintPredicate;
import gate.jape.constraint.ContainsPredicate;
import gate.jape.constraint.EqualPredicate;
import gate.jape.constraint.GreaterEqualPredicate;
import gate.jape.constraint.GreaterPredicate;
import gate.jape.constraint.LengthAccessor;
import gate.jape.constraint.LesserEqualPredicate;
import gate.jape.constraint.LesserPredicate;
import gate.jape.constraint.NotContainsPredicate;
import gate.jape.constraint.NotEqualPredicate;
import gate.jape.constraint.NotRegExpFindPredicate;
import gate.jape.constraint.NotRegExpMatchPredicate;
import gate.jape.constraint.NotWithinPredicate;
import gate.jape.constraint.RegExpFindPredicate;
import gate.jape.constraint.RegExpMatchPredicate;
import gate.jape.constraint.StringAccessor;
import gate.jape.constraint.WithinPredicate;
import java.util.HashMap;
import java.util.Map;

public class ConstraintFactory {
    protected Map<String, Class<? extends ConstraintPredicate>> operatorImplMap = new HashMap<String, Class<? extends ConstraintPredicate>>();
    protected Map<String, Class<? extends AnnotationAccessor>> metaPropertyMap = new HashMap<String, Class<? extends AnnotationAccessor>>();

    public ConstraintFactory() {
        this.initOperatorMap();
        this.initMetaPropertyMap();
    }

    protected void initOperatorMap() {
        this.addOperator("==", EqualPredicate.class);
        this.addOperator("!=", NotEqualPredicate.class);
        this.addOperator(">", GreaterPredicate.class);
        this.addOperator("<", LesserPredicate.class);
        this.addOperator(">=", GreaterEqualPredicate.class);
        this.addOperator("<=", LesserEqualPredicate.class);
        this.addOperator("=~", RegExpFindPredicate.class);
        this.addOperator("!~", NotRegExpFindPredicate.class);
        this.addOperator("==~", RegExpMatchPredicate.class);
        this.addOperator("!=~", NotRegExpMatchPredicate.class);
        this.addOperator("contains", ContainsPredicate.class);
        this.addOperator("notContains", NotContainsPredicate.class);
        this.addOperator("within", WithinPredicate.class);
        this.addOperator("notWithin", NotWithinPredicate.class);
    }

    protected void initMetaPropertyMap() {
        this.addMetaProperty("string", StringAccessor.class);
        this.addMetaProperty("cleanString", CleanStringAccessor.class);
        this.addMetaProperty("length", LengthAccessor.class);
    }

    public void addOperator(String operator, Class<? extends ConstraintPredicate> clazz) {
        this.operatorImplMap.put(operator, clazz);
    }

    public void addMetaProperty(String metaProperty, Class<? extends AnnotationAccessor> clazz) {
        this.metaPropertyMap.put(metaProperty, clazz);
    }

    public Constraint createConstraint(String annotType) {
        return new Constraint(annotType);
    }

    public AnnotationAccessor createDefaultAccessor(Object key) {
        return new AnnotationFeatureAccessor(key);
    }

    public AnnotationAccessor createMetaPropertyAccessor(String propName) {
        AnnotationAccessor retVal = null;
        Class<? extends AnnotationAccessor> clazz = this.metaPropertyMap.get(propName);
        if (clazz == null) {
            throw new IllegalArgumentException("No meta property associated with name: " + propName);
        }
        try {
            retVal = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create accessor for name '" + propName + "'", e);
        }
        return retVal;
    }

    public ConstraintPredicate createPredicate(String name, Object value) {
        return this.createPredicate(this.createDefaultAccessor(name), value);
    }

    public ConstraintPredicate createPredicate(AnnotationAccessor accessor, Object value) {
        return this.createPredicate("==", accessor, value);
    }

    public ConstraintPredicate createPredicate(String operator, AnnotationAccessor accessor, Object value) {
        ConstraintPredicate retVal = null;
        Class<? extends ConstraintPredicate> clazz = this.operatorImplMap.get(operator);
        if (clazz == null) {
            throw new IllegalArgumentException("No predicate associated with operator: " + operator);
        }
        try {
            retVal = clazz.newInstance();
            retVal.setAccessor(accessor);
            retVal.setValue(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create predicate for operator '" + operator + "' with accessor '" + accessor + "' and value '" + value + "'", e);
        }
        return retVal;
    }
}

