/*
 * Decompiled with CFR 0.152.
 */
package gate.jape.constraint;

import gate.AnnotationSet;
import gate.jape.JapeException;
import gate.jape.constraint.AbstractConstraintPredicate;

public abstract class ComparablePredicate
extends AbstractConstraintPredicate {
    private static final long serialVersionUID = -5667456294601338967L;
    protected Comparable comparableValue;

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Comparable)) {
            String classString = value == null ? "null" : value.getClass().toString();
            throw new IllegalArgumentException("Value for attribute '" + this.getAccessor() + "' must be a Comparable type, not a " + classString);
        }
        this.comparableValue = (Comparable)value;
        super.setValue(value);
    }

    @Override
    public boolean doMatch(Object value, AnnotationSet context) throws JapeException {
        if (value == null) {
            return false;
        }
        return this.doMatch(value);
    }

    protected abstract boolean doMatch(Object var1) throws JapeException;

    protected int compareValue(Object obj) throws JapeException {
        if (!(obj instanceof Comparable)) {
            String classString = obj == null ? "null" : obj.getClass().toString();
            throw new JapeException("Value passed to compare to attribute '" + this.getAccessor() + "' must be a Comparable type, not a " + classString);
        }
        Comparable passedValue = (Comparable)obj;
        try {
            return this.comparableValue.compareTo(passedValue);
        }
        catch (ClassCastException notSameType) {
            try {
                if (this.comparableValue instanceof Long) {
                    return this.comparableValue.compareTo(Long.valueOf(passedValue.toString()));
                }
                if (this.comparableValue instanceof Double) {
                    return this.comparableValue.compareTo(Double.valueOf(passedValue.toString()));
                }
                throw new JapeException("Cannot compare values for attribute '" + this.getAccessor() + "' because cannot compare '" + this.comparableValue + "' to '" + passedValue + "'.");
            }
            catch (NumberFormatException nfe) {
                throw new JapeException("Cannot compare values for attribute '" + this.getAccessor() + "' because cannot compare '" + this.comparableValue + "' to '" + passedValue + "'.");
            }
        }
    }
}

