/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Controller;
import gate.Document;
import gate.creole.ExecutionException;
import gate.creole.ontology.Ontology;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.jape.ActionContext;
import gate.jape.JapeException;
import gate.util.Benchmarkable;
import gate.util.GateClassLoader;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class Transducer
implements Serializable,
Benchmarkable {
    private static final long serialVersionUID = -5607520609825899179L;
    protected String name;
    protected Ontology ontology = null;
    protected Map<Object, Object> benchmarkFeatures = new HashMap<Object, Object>();
    protected String benchmarkID;
    protected boolean interrupted = false;
    private boolean debugMode = false;
    private boolean matchGroupMode = false;
    private boolean negationCompatMode;
    private URL baseURL;
    private transient Vector<ProgressListener> progressListeners;
    private transient Vector<StatusListener> statusListeners;
    protected boolean enableDebugging;
    protected ActionContext actionContext;

    public String getName() {
        return this.name;
    }

    public String getBenchmarkId() {
        if (this.benchmarkID == null) {
            return this.getName();
        }
        return this.benchmarkID;
    }

    public void setBenchmarkId(String benchmarkId) {
        this.benchmarkID = benchmarkId;
    }

    public abstract void transduce(Document var1, AnnotationSet var2, AnnotationSet var3) throws JapeException, ExecutionException;

    public abstract void finish(GateClassLoader var1);

    public abstract void cleanUp();

    public abstract String toString(String var1);

    public synchronized boolean isInterrupted() {
        return this.interrupted;
    }

    public synchronized void interrupt() {
        this.interrupted = true;
    }

    public void setBaseURL(URL newBaseURL) {
        this.baseURL = newBaseURL;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public synchronized void removeProgressListener(ProgressListener l) {
        if (this.progressListeners != null && this.progressListeners.contains(l)) {
            Vector v = (Vector)this.progressListeners.clone();
            v.removeElement(l);
            this.progressListeners = v;
        }
    }

    public synchronized void addProgressListener(ProgressListener l) {
        Vector v;
        Vector vector = v = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.progressListeners = v;
        }
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setMatchGroupMode(boolean mode) {
        this.matchGroupMode = mode;
    }

    public boolean isMatchGroupMode() {
        return this.matchGroupMode;
    }

    protected void fireProgressChanged(int e) {
        if (this.progressListeners != null && !this.progressListeners.isEmpty()) {
            Vector<ProgressListener> listeners = this.progressListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).progressChanged(e);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector<ProgressListener> listeners = this.progressListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).processFinished();
            }
        }
    }

    public synchronized void removeStatusListener(StatusListener l) {
        if (this.statusListeners != null && this.statusListeners.contains(l)) {
            Vector v = (Vector)this.statusListeners.clone();
            v.removeElement(l);
            this.statusListeners = v;
        }
    }

    public synchronized void addStatusListener(StatusListener l) {
        Vector v;
        Vector vector = v = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.statusListeners = v;
        }
    }

    protected void fireStatusChanged(String e) {
        if (this.statusListeners != null) {
            Vector<StatusListener> listeners = this.statusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).statusChanged(e);
            }
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    public boolean isEnableDebugging() {
        return this.enableDebugging;
    }

    public void setEnableDebugging(boolean enableDebugging) {
        this.enableDebugging = enableDebugging;
    }

    public boolean isNegationCompatMode() {
        return this.negationCompatMode;
    }

    public void setNegationCompatMode(boolean negationCompatMode) {
        this.negationCompatMode = negationCompatMode;
    }

    public void setActionContext(ActionContext ac) {
        this.actionContext = ac;
    }

    void runControllerExecutionStartedBlock(ActionContext ac, Controller c, Ontology o) throws ExecutionException {
    }

    void runControllerExecutionFinishedBlock(ActionContext ac, Controller c, Ontology o) throws ExecutionException {
    }

    void runControllerExecutionAbortedBlock(ActionContext ac, Controller c, Throwable t, Ontology o) throws ExecutionException {
    }
}

