/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Document;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.LeftHandSide;
import gate.jape.RightHandSide;
import gate.jape.Transducer;
import gate.util.GateClassLoader;
import gate.util.Strings;
import java.io.Serializable;

public class Rule
extends Transducer
implements JapeConstants,
Serializable {
    private static final long serialVersionUID = 564304936210127542L;
    private static final boolean DEBUG = false;
    private LeftHandSide lhs;
    private RightHandSide rhs;
    private int priority;
    private int position;
    private int pendingPosition = -1;
    private boolean weFinished = false;

    public Rule(String name, int position, int priority, LeftHandSide lhs, RightHandSide rhs) {
        this.name = name;
        this.position = position;
        this.priority = priority;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public Rule(Rule existingRule) {
        this.name = existingRule.name;
        this.position = existingRule.position;
        this.priority = existingRule.priority;
        this.lhs = existingRule.lhs;
        this.rhs = new RightHandSide(existingRule.rhs);
    }

    public int getPriority() {
        return this.priority;
    }

    public int getPosition() {
        return this.position;
    }

    public int pending() {
        return this.pendingPosition;
    }

    public boolean finished() {
        return this.weFinished;
    }

    @Override
    public void finish(GateClassLoader classloader) {
        this.lhs.finish();
        this.rhs.finish(classloader);
    }

    @Override
    public void transduce(Document doc, AnnotationSet inputAS, AnnotationSet outputAS) throws JapeException {
    }

    @Override
    public void cleanUp() {
        RightHandSide.cleanUp();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String pad) {
        String newline = Strings.getNl();
        String newPad = Strings.addPadding((String)pad, (int)4);
        StringBuffer buf = new StringBuffer(pad + "Rule: name(" + this.name + "); position(" + this.position + "); priority(" + this.priority + "); pendingPosition(" + this.pendingPosition + "); weFinished(" + this.weFinished + "); lhs(" + newline + this.lhs.toString(newPad) + newline + pad + "); rhs(" + newline + this.rhs.toString(newPad) + newline + pad + ");");
        buf.append(newline + pad + ") Rule." + newline);
        return buf.toString();
    }

    public LeftHandSide getLHS() {
        return this.lhs;
    }

    public RightHandSide getRHS() {
        return this.rhs;
    }

    @Override
    public void addStatusListener(StatusListener listener) {
    }

    @Override
    public void removeStatusListener(StatusListener listener) {
    }

    public void addProcessProgressListener(ProgressListener listener) {
    }

    public void removeProcessProgressListener(ProgressListener listener) {
    }
}

