/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Controller;
import gate.Document;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.ontology.Ontology;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.jape.ActionContext;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.Transducer;
import gate.util.Benchmark;
import gate.util.Err;
import gate.util.GateClassLoader;
import gate.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultiPhaseTransducer
extends Transducer
implements JapeConstants,
Serializable {
    private static final long serialVersionUID = -1817675404943909246L;
    private List<Transducer> phases = new ArrayList<Transducer>();

    public MultiPhaseTransducer(String name) {
        this();
        this.setName(name);
    }

    @Override
    public synchronized void interrupt() {
        this.interrupted = true;
        Iterator<Transducer> phasesIter = this.phases.iterator();
        while (phasesIter.hasNext()) {
            phasesIter.next().interrupt();
        }
    }

    public MultiPhaseTransducer() {
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setOntology(Ontology ontology) {
        super.setOntology(ontology);
        Iterator<Transducer> phasesIter = this.phases.iterator();
        while (phasesIter.hasNext()) {
            phasesIter.next().setOntology(ontology);
        }
    }

    public void addPhase(String name, Transducer phase) {
        this.phases.add(phase);
    }

    public void orderPhases(String[] phaseNames) {
        Err.println((String)"oops: MPT.orderPhases not done yet :-(");
    }

    @Override
    public void finish(GateClassLoader classloader) {
        Iterator<Transducer> i = this.phases.iterator();
        while (i.hasNext()) {
            i.next().finish(classloader);
        }
    }

    @Override
    public void transduce(Document doc, AnnotationSet input, AnnotationSet output) throws JapeException, ExecutionException {
        this.interrupted = false;
        ProgressListener pListener = null;
        StatusListener sListener = null;
        pListener = new ProgressListener(){
            int phasesCnt;
            int donePhases;
            {
                this.phasesCnt = MultiPhaseTransducer.this.phases.size();
                this.donePhases = 0;
            }

            public void processFinished() {
                ++this.donePhases;
                if (this.donePhases == this.phasesCnt) {
                    MultiPhaseTransducer.this.fireProcessFinished();
                }
            }

            public void progressChanged(int i) {
                int value = (this.donePhases * 100 + i) / this.phasesCnt;
                MultiPhaseTransducer.this.fireProgressChanged(value);
            }
        };
        sListener = new StatusListener(){

            public void statusChanged(String text) {
                MultiPhaseTransducer.this.fireStatusChanged(text);
            }
        };
        for (Transducer t : this.phases) {
            if (this.isInterrupted()) {
                throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" Jape transducer has been abruptly interrupted!");
            }
            try {
                this.fireStatusChanged("Transducing " + doc.getName() + " (Phase: " + t.getName() + ")...");
                String savedBenchmarkID = null;
                String phaseBenchmarkID = null;
                if (Benchmark.isBenchmarkingEnabled()) {
                    savedBenchmarkID = t.getBenchmarkId();
                    this.benchmarkFeatures.put("documentName", doc.getName());
                    phaseBenchmarkID = Benchmark.createBenchmarkId((String)("phase__" + t.getName()), (String)this.getBenchmarkId());
                    t.setBenchmarkId(phaseBenchmarkID);
                }
                long startTime = Benchmark.startPoint();
                t.addProgressListener(pListener);
                t.addStatusListener(sListener);
                t.setActionContext(this.actionContext);
                t.transduce(doc, input, output);
                t.removeProgressListener(pListener);
                t.removeStatusListener(sListener);
                if (Benchmark.isBenchmarkingEnabled()) {
                    Benchmark.checkPoint((long)startTime, (String)phaseBenchmarkID, (Object)this, (Map)this.benchmarkFeatures);
                    t.setBenchmarkId(savedBenchmarkID);
                }
                this.fireStatusChanged("");
            }
            catch (JapeException e) {
                String location = "phase " + t.getName() + ", document " + doc.getName();
                e.setLocation(location);
                throw e;
            }
        }
        this.cleanUp();
    }

    @Override
    public void setEnableDebugging(boolean enableDebugging) {
        this.enableDebugging = enableDebugging;
        for (int i = 0; i < this.phases.size(); ++i) {
            this.phases.get(i).setEnableDebugging(enableDebugging);
        }
    }

    @Override
    public void cleanUp() {
        Iterator<Transducer> i = this.phases.iterator();
        while (i.hasNext()) {
            i.next().cleanUp();
        }
        this.benchmarkFeatures.remove("documentName");
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String pad) {
        String newline = Strings.getNl();
        StringBuffer buf = new StringBuffer(pad + "MPT: name(" + this.name + "); phases(" + newline + pad);
        Iterator<Transducer> i = this.phases.iterator();
        while (i.hasNext()) {
            buf.append(i.next().toString(Strings.addPadding((String)pad, (int)4)) + " ");
        }
        buf.append(newline + pad + ")." + newline);
        return buf.toString();
    }

    public List<Transducer> getPhases() {
        return this.phases;
    }

    public void setPhases(List<Transducer> phases) {
        this.phases = phases;
    }

    @Override
    public void runControllerExecutionStartedBlock(ActionContext ac, Controller c, Ontology o) throws ExecutionException {
        for (Transducer t : this.phases) {
            t.runControllerExecutionStartedBlock(ac, c, o);
        }
    }

    @Override
    public void runControllerExecutionFinishedBlock(ActionContext ac, Controller c, Ontology o) throws ExecutionException {
        for (Transducer t : this.phases) {
            t.runControllerExecutionFinishedBlock(ac, c, o);
        }
    }

    @Override
    public void runControllerExecutionAbortedBlock(ActionContext ac, Controller c, Throwable throwable, Ontology o) throws ExecutionException {
        for (Transducer t : this.phases) {
            t.runControllerExecutionAbortedBlock(ac, c, throwable, o);
        }
    }
}

