/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.jape.BasicPatternElement;
import gate.jape.ComplexPatternElement;
import gate.jape.Constraint;
import gate.jape.JapeConstants;
import gate.jape.PatternElement;
import gate.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ConstraintGroup
extends PatternElement
implements JapeConstants,
Serializable {
    private static final long serialVersionUID = -4671488370557996554L;
    private List<List<PatternElement>> patternElementDisjunction1 = new ArrayList<List<PatternElement>>();
    private PatternElement[][] patternElementDisjunction2;
    private List<PatternElement> currentConjunction = new ArrayList<PatternElement>();

    public ConstraintGroup() {
        this.patternElementDisjunction1.add(this.currentConjunction);
    }

    @Override
    public Object clone() {
        ConstraintGroup newPE = (ConstraintGroup)super.clone();
        newPE.currentConjunction = null;
        newPE.patternElementDisjunction1 = new ArrayList<List<PatternElement>>();
        Iterator<List<PatternElement>> disjunction = this.patternElementDisjunction1.iterator();
        while (disjunction.hasNext()) {
            newPE.createDisjunction();
            for (PatternElement pat : disjunction.next()) {
                newPE.addPatternElement((PatternElement)pat.clone());
            }
        }
        return newPE;
    }

    public void createDisjunction() {
        this.currentConjunction = new ArrayList<PatternElement>();
        this.patternElementDisjunction1.add(this.currentConjunction);
    }

    public void addPatternElement(PatternElement pe) {
        this.currentConjunction.add(pe);
    }

    public Iterator<ComplexPatternElement> getCPEs() {
        ArrayList<ComplexPatternElement> cpes = new ArrayList<ComplexPatternElement>();
        Iterator<List<PatternElement>> disjunction = this.patternElementDisjunction1.iterator();
        while (disjunction.hasNext()) {
            for (PatternElement pat : disjunction.next()) {
                Iterator<ComplexPatternElement> i = null;
                if (pat instanceof ComplexPatternElement) {
                    cpes.add((ComplexPatternElement)pat);
                    i = ((ComplexPatternElement)pat).getCPEs();
                } else if (pat instanceof ConstraintGroup) {
                    i = ((ConstraintGroup)pat).getCPEs();
                }
                if (i == null) continue;
                while (i.hasNext()) {
                    cpes.add(i.next());
                }
            }
        }
        return cpes.iterator();
    }

    public void getContainedAnnotationTypes(HashSet<String> set) {
        Iterator<List<PatternElement>> disjunction = this.patternElementDisjunction1.iterator();
        while (disjunction.hasNext()) {
            for (PatternElement pat : disjunction.next()) {
                if (pat instanceof BasicPatternElement) {
                    List<Constraint> constraints = ((BasicPatternElement)pat).getUnfinishedConstraints();
                    for (Constraint c : constraints) {
                        set.add(c.getAnnotType());
                    }
                    continue;
                }
                if (pat instanceof ComplexPatternElement) {
                    ((ComplexPatternElement)pat).getConstraintGroup().getContainedAnnotationTypes(set);
                    continue;
                }
                if (!(pat instanceof ConstraintGroup)) continue;
                ((ConstraintGroup)pat).getContainedAnnotationTypes(set);
            }
        }
    }

    @Override
    public void finish() {
        int i = 0;
        int j = 0;
        this.patternElementDisjunction2 = new PatternElement[this.patternElementDisjunction1.size()][];
        for (List<PatternElement> conjunction : this.patternElementDisjunction1) {
            this.patternElementDisjunction2[i] = new PatternElement[conjunction.size()];
            j = 0;
            Iterator<PatternElement> conjIter = conjunction.iterator();
            while (conjIter.hasNext()) {
                this.patternElementDisjunction2[i][j] = conjIter.next();
                this.patternElementDisjunction2[i][j].finish();
                ++j;
            }
            ++i;
        }
        this.patternElementDisjunction1 = null;
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String pad) {
        String newline = Strings.getNl();
        StringBuffer buf = new StringBuffer(pad + "CG: disjunction(" + newline);
        String newPad = Strings.addPadding((String)pad, (int)4);
        boolean firstTime = true;
        if (this.patternElementDisjunction1 != null) {
            Iterator<List<PatternElement>> disjunction = this.patternElementDisjunction1.iterator();
            while (disjunction.hasNext()) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    buf.append(newline + pad + "|" + newline);
                }
                Iterator<PatternElement> conjunction = disjunction.next().iterator();
                while (conjunction.hasNext()) {
                    buf.append(conjunction.next().toString(newPad) + newline);
                }
            }
        } else {
            int pEDLen = this.patternElementDisjunction2.length;
            if (firstTime) {
                firstTime = false;
            } else {
                buf.append(newline + pad + "|" + newline);
            }
            for (int i = 0; i < pEDLen; ++i) {
                int conjLen = this.patternElementDisjunction2[i].length;
                for (int j = 0; j < conjLen; ++j) {
                    buf.append(this.patternElementDisjunction2[i][j].toString(newPad) + newline);
                }
            }
        }
        buf.append(pad + ") CG." + newline);
        return buf.toString();
    }

    public PatternElement[][] getPatternElementDisjunction() {
        return this.patternElementDisjunction2;
    }
}

