/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.jape.Constraint;
import gate.jape.JapeConstants;
import gate.jape.PatternElement;
import gate.jape.SinglePhaseTransducer;
import gate.util.Pair;
import gate.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BasicPatternElement
extends PatternElement
implements JapeConstants,
Serializable {
    private static final long serialVersionUID = -6515011025898779462L;
    private List<Constraint> constraints1;
    private Constraint[] constraints2;
    private Map<Object, Constraint> constraintsMap = new HashMap<Object, Constraint>();
    private int lastFailurePoint = -1;
    private final boolean negationCompatMode;

    public BasicPatternElement(SinglePhaseTransducer spt) {
        this.constraints1 = new ArrayList<Constraint>();
        this.negationCompatMode = spt.isNegationCompatMode();
    }

    @Override
    public Object clone() {
        BasicPatternElement newPE = (BasicPatternElement)super.clone();
        newPE.constraintsMap = new HashMap<Object, Constraint>(this.constraintsMap);
        newPE.constraints1 = new ArrayList<Constraint>();
        int consLen = this.constraints1.size();
        for (int i = 0; i < consLen; ++i) {
            newPE.constraints1.add((Constraint)this.constraints1.get(i).clone());
        }
        return newPE;
    }

    public void addConstraint(Constraint newConstraint) {
        Constraint existingConstraint = null;
        String annotType = newConstraint.getAnnotType();
        Pair typeNegKey = new Pair((Object)annotType, (Object)newConstraint.isNegated());
        existingConstraint = this.negationCompatMode && newConstraint.isNegated() ? null : this.constraintsMap.get(typeNegKey);
        if (existingConstraint != null) {
            existingConstraint.addAttributes(newConstraint.getAttributeSeq());
        } else {
            this.constraintsMap.put(typeNegKey, newConstraint);
            this.constraints1.add(newConstraint);
        }
    }

    public boolean isMultiType() {
        return this.constraints2 != null ? this.constraints2.length > 1 : (this.constraints1 != null ? this.constraints1.size() > 1 : false);
    }

    @Override
    public void finish() {
        int j = 0;
        this.constraints2 = new Constraint[this.constraints1.size()];
        Iterator<Constraint> iterator = this.constraints1.iterator();
        while (iterator.hasNext()) {
            Constraint c;
            this.constraints2[j] = c = iterator.next();
            this.constraints2[j++].finish();
        }
        this.constraints1 = null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("{");
        Constraint[] constraints = this.getConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            result.append(constraints[i].shortDesc() + ",");
        }
        result.setCharAt(result.length() - 1, '}');
        return result.toString();
    }

    @Override
    public String toString(String pad) {
        String newline = Strings.getNl();
        String newPad = Strings.addPadding((String)pad, (int)4);
        StringBuffer buf = new StringBuffer(pad + "BPE: lastFailurePoint(" + this.lastFailurePoint + "); constraints(");
        if (this.constraints1 != null) {
            int len = this.constraints1.size();
            for (int i = 0; i < len; ++i) {
                buf.append(newline + this.constraints1.get(i).getDisplayString(newPad));
            }
        } else {
            int len = this.constraints2.length;
            for (int i = 0; i < len; ++i) {
                buf.append(newline + this.constraints2[i].getDisplayString(newPad));
            }
        }
        return buf.toString();
    }

    public String shortDesc() {
        String res = "";
        if (this.constraints1 != null) {
            int len = this.constraints1.size();
            for (int i = 0; i < len; ++i) {
                res = res + this.constraints1.get(i).toString();
            }
        } else {
            int len = this.constraints2.length;
            for (int i = 0; i < len; ++i) {
                res = res + this.constraints2[i].shortDesc();
            }
        }
        return res;
    }

    public List<Constraint> getUnfinishedConstraints() {
        return this.constraints1;
    }

    public Constraint[] getConstraints() {
        return this.constraints2;
    }
}

