/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.jape;

import gate.LanguageAnalyser;
import gate.Resource;
import gate.creole.ANNIEConstants;
import gate.creole.AbstractProcessingResource;
import gate.creole.AbstractVisualResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.ResourceReference;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.ProgressListener;
import gate.jape.parser.ParseCpslTokenManager;
import gate.jape.parser.SimpleCharStream;
import gate.jape.parser.Token;
import gate.util.BomStrippingInputStreamReader;
import gate.util.GateRuntimeException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

@CreoleResource(name="Jape Viewer", comment="A JAPE grammar file viewer", helpURL="http://gate.ac.uk/userguide/chap:jape", guiType=GuiType.LARGE, mainViewer=true, resourceDisplayed="gate.creole.Transducer")
public class JapeViewer
extends AbstractVisualResource
implements ANNIEConstants,
ProgressListener {
    private static final long serialVersionUID = -6026605466406110590L;
    private JTextPane textArea;
    private JTree treePhases;
    private JScrollPane treeScroll;
    private boolean updating = false;
    private LanguageAnalyser transducer;
    private Map<Integer, Style> colorMap = new HashMap<Integer, Style>();
    private Style defaultStyle;

    public Resource init() {
        this.initGuiComponents();
        return this;
    }

    private void initGuiComponents() {
        this.setLayout(new BorderLayout());
        this.textArea = new JTextPane();
        this.textArea.setEditable(false);
        JScrollPane textScroll = new JScrollPane(this.textArea, 20, 30);
        this.add(textScroll, "Center");
        this.treePhases = new JTree();
        this.treeScroll = new JScrollPane(this.treePhases, 20, 30);
        this.add(this.treeScroll, "West");
        this.treePhases.getSelectionModel().setSelectionMode(1);
        this.treePhases.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (JapeViewer.this.updating) {
                    return;
                }
                if (e.getPath().getLastPathComponent() == null) {
                    return;
                }
                try {
                    JapeViewer.this.readJAPEFileContents(new URL(((ResourceReference)JapeViewer.this.transducer.getParameterValue("grammarURL")).toURL(), e.getPath().getLastPathComponent() + ".jape"));
                }
                catch (ResourceInstantiationException | IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        this.defaultStyle = this.textArea.addStyle("default", null);
        Style style = this.textArea.addStyle("brackets", null);
        StyleConstants.setForeground(style, Color.red);
        this.colorMap.put(57, style);
        this.colorMap.put(58, style);
        this.colorMap.put(59, style);
        this.colorMap.put(60, style);
        this.colorMap.put(61, style);
        this.colorMap.put(62, style);
        style = this.textArea.addStyle("keywords", null);
        StyleConstants.setForeground(style, Color.blue);
        this.colorMap.put(27, style);
        this.colorMap.put(30, style);
        this.colorMap.put(28, style);
        this.colorMap.put(48, style);
        this.colorMap.put(24, style);
        this.colorMap.put(25, style);
        this.colorMap.put(26, style);
        this.colorMap.put(11, style);
        this.colorMap.put(12, style);
        style = this.textArea.addStyle("strings", null);
        StyleConstants.setForeground(style, new Color(0, 128, 128));
        this.colorMap.put(47, style);
        style = this.textArea.addStyle("comments", null);
        StyleConstants.setForeground(style, new Color(0, 128, 0));
        this.colorMap.put(66, style);
        this.colorMap.put(67, style);
        this.colorMap.put(68, style);
        this.colorMap.put(69, style);
        this.colorMap.put(70, style);
        this.colorMap.put(15, style);
        this.colorMap.put(16, style);
        this.colorMap.put(17, style);
        this.colorMap.put(18, style);
        this.colorMap.put(19, style);
    }

    public void setTarget(final Object target) {
        if (target == null) {
            throw new NullPointerException("JAPE viewer received a null target");
        }
        boolean targetOK = true;
        if (target instanceof LanguageAnalyser) {
            try {
                ((LanguageAnalyser)target).getParameterValue("grammarURL");
                ((LanguageAnalyser)target).getParameterValue("encoding");
            }
            catch (ResourceInstantiationException rie) {
                targetOK = false;
            }
        } else {
            targetOK = false;
        }
        if (!targetOK) {
            throw new IllegalArgumentException("The GATE jape viewer can only be used with a GATE jape transducer!\n" + target.getClass().toString() + " is not a GATE Jape Transducer!");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (JapeViewer.this.transducer != null && JapeViewer.this.transducer instanceof AbstractProcessingResource) {
                    ((AbstractProcessingResource)JapeViewer.this.transducer).removeProgressListener((ProgressListener)JapeViewer.this);
                }
                JapeViewer.this.transducer = (LanguageAnalyser)target;
                URL japeFileURL = null;
                try {
                    japeFileURL = ((ResourceReference)JapeViewer.this.transducer.getParameterValue("grammarURL")).toURL();
                }
                catch (ResourceInstantiationException | IOException rie) {
                    rie.printStackTrace();
                }
                if (japeFileURL == null) {
                    JapeViewer.this.textArea.setText("The source for this JAPE grammar is not available!");
                    JapeViewer.this.remove(JapeViewer.this.treeScroll);
                    return;
                }
                String japePhaseName = japeFileURL.getFile();
                japePhaseName = japePhaseName.substring(japePhaseName.lastIndexOf("/") + 1, japePhaseName.length() - 5);
                JapeViewer.this.treePhases.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(japePhaseName)));
                JapeViewer.this.treePhases.setSelectionRow(0);
                JapeViewer.this.readJAPEFileContents(japeFileURL);
                if (JapeViewer.this.transducer instanceof AbstractProcessingResource) {
                    ((AbstractProcessingResource)JapeViewer.this.transducer).addProgressListener((ProgressListener)JapeViewer.this);
                }
            }
        });
    }

    private void readJAPEFileContents(URL url) {
        if (this.treePhases.getLastSelectedPathComponent() == null) {
            return;
        }
        this.updating = true;
        try {
            BomStrippingInputStreamReader japeReader = null;
            String encoding = (String)this.transducer.getParameterValue("encoding");
            japeReader = encoding == null ? new BomStrippingInputStreamReader(url.openStream()) : new BomStrippingInputStreamReader(url.openStream(), encoding);
            BufferedReader br = new BufferedReader((Reader)japeReader);
            String content = br.readLine();
            StringBuilder japeFileContents = new StringBuilder();
            ArrayList<Integer> lineOffsets = new ArrayList<Integer>();
            while (content != null) {
                lineOffsets.add(japeFileContents.length());
                japeFileContents.append(content.replaceAll("\t", "   ")).append("\n");
                content = br.readLine();
            }
            this.textArea.setText(japeFileContents.toString());
            this.textArea.updateUI();
            br.close();
            ParseCpslTokenManager tokenManager = new ParseCpslTokenManager(new SimpleCharStream(new StringReader(japeFileContents.toString())));
            StyledDocument doc = this.textArea.getStyledDocument();
            doc.setCharacterAttributes(0, japeFileContents.length(), this.defaultStyle, true);
            ((DefaultMutableTreeNode)this.treePhases.getSelectionPath().getLastPathComponent()).removeAllChildren();
            while (true) {
                Token t = tokenManager.getNextToken();
                if (t.kind != 0) {
                    int end;
                    int start;
                    Style style;
                    Token special = t.specialToken;
                    while (special != null) {
                        style = this.colorMap.get(special.kind);
                        if (style != null) {
                            start = (Integer)lineOffsets.get(special.beginLine - 1) + special.beginColumn - 1;
                            end = (Integer)lineOffsets.get(special.endLine - 1) + special.endColumn - 1;
                            doc.setCharacterAttributes(start, end - start + 1, style, true);
                        }
                        special = special.specialToken;
                    }
                    style = this.colorMap.get(t.kind);
                    if (style != null) {
                        start = (Integer)lineOffsets.get(t.beginLine - 1) + t.beginColumn - 1;
                        end = (Integer)lineOffsets.get(t.endLine - 1) + t.endColumn - 1;
                        doc.setCharacterAttributes(start, end - start + 1, style, true);
                    }
                    if (t.kind != 13) continue;
                    ((DefaultMutableTreeNode)this.treePhases.getSelectionPath().getLastPathComponent()).add(new DefaultMutableTreeNode(t.toString()));
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            throw new GateRuntimeException((Throwable)ioe);
        }
        catch (ResourceInstantiationException rie) {
            throw new GateRuntimeException((Throwable)rie);
        }
        if (this.treePhases.getSelectionRows() != null && this.treePhases.getSelectionRows().length > 0) {
            this.treePhases.expandRow(this.treePhases.getSelectionRows()[0]);
        }
        this.updating = false;
    }

    public void processFinished() {
        this.setTarget(this.transducer);
    }

    public void progressChanged(int progress) {
    }
}

