/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.tokeniser;

import gate.Executable;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.AbstractProcessingResource;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.ResourceInstantiationException;
import gate.creole.ResourceReference;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.creole.tokeniser.SimpleTokeniser;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.util.Benchmark;
import gate.util.Benchmarkable;
import java.net.URISyntaxException;
import java.net.URL;

@CreoleResource(name="ANNIE English Tokeniser", comment="A customisable English tokeniser.", helpURL="http://gate.ac.uk/userguide/sec:annie:tokeniser", icon="tokeniser")
public class DefaultTokeniser
extends AbstractLanguageAnalyser
implements Benchmarkable {
    private static final long serialVersionUID = 3860943928124433852L;
    public static final String DEF_TOK_DOCUMENT_PARAMETER_NAME = "document";
    public static final String DEF_TOK_ANNOT_SET_PARAMETER_NAME = "annotationSetName";
    public static final String DEF_TOK_TOKRULES_URL_PARAMETER_NAME = "tokeniserRulesURL";
    public static final String DEF_TOK_GRAMRULES_URL_PARAMETER_NAME = "transducerGrammarURL";
    public static final String DEF_TOK_ENCODING_PARAMETER_NAME = "encoding";
    private static final boolean DEBUG = false;
    protected SimpleTokeniser tokeniser;
    protected AbstractLanguageAnalyser transducer;
    private ResourceReference tokeniserRulesURL;
    private String encoding;
    private ResourceReference transducerGrammarURL;
    private String annotationSetName;
    private String benchmarkId;

    public Resource init() throws ResourceInstantiationException {
        try {
            FeatureMap features;
            super.init();
            FeatureMap params = Factory.newFeatureMap();
            if (this.tokeniserRulesURL != null) {
                params.put((Object)"rulesURL", (Object)this.tokeniserRulesURL);
            }
            params.put((Object)DEF_TOK_ENCODING_PARAMETER_NAME, (Object)this.encoding);
            if (this.tokeniser == null) {
                this.fireStatusChanged("Creating a tokeniser");
                features = Factory.newFeatureMap();
                Gate.setHiddenAttribute((FeatureMap)features, (boolean)true);
                this.tokeniser = (SimpleTokeniser)Factory.createResource((String)"gate.creole.tokeniser.SimpleTokeniser", (FeatureMap)params, (FeatureMap)features);
                this.tokeniser.setName("Tokeniser " + System.currentTimeMillis());
            } else {
                this.tokeniser.setParameterValues(params);
                this.tokeniser.reInit();
            }
            this.fireProgressChanged(50);
            params = Factory.newFeatureMap();
            if (this.transducerGrammarURL != null) {
                params.put((Object)"grammarURL", (Object)this.transducerGrammarURL);
            }
            params.put((Object)DEF_TOK_ENCODING_PARAMETER_NAME, (Object)this.encoding);
            if (this.transducer == null) {
                this.fireStatusChanged("Creating a Jape transducer");
                features = Factory.newFeatureMap();
                Gate.setHiddenAttribute((FeatureMap)features, (boolean)true);
                this.transducer = (AbstractLanguageAnalyser)Factory.createResource((String)"gate.creole.Transducer", (FeatureMap)params, (FeatureMap)features);
                this.transducer.setName("Transducer " + System.currentTimeMillis());
            } else {
                this.transducer.setParameterValues(params);
                this.transducer.reInit();
            }
            this.fireProgressChanged(100);
            this.fireProcessFinished();
        }
        catch (ResourceInstantiationException rie) {
            throw rie;
        }
        catch (Exception e) {
            throw new ResourceInstantiationException(e);
        }
        return this;
    }

    public void cleanup() {
        Factory.deleteResource((Resource)this.transducer);
        Factory.deleteResource((Resource)this.tokeniser);
    }

    public void execute() throws ExecutionException {
        this.interrupted = false;
        FeatureMap params = null;
        this.fireProgressChanged(0);
        AbstractProcessingResource.IntervalProgressListener pListener = null;
        StatusListener sListener = null;
        try {
            params = Factory.newFeatureMap();
            params.put((Object)DEF_TOK_DOCUMENT_PARAMETER_NAME, (Object)this.document);
            params.put((Object)DEF_TOK_ANNOT_SET_PARAMETER_NAME, (Object)this.annotationSetName);
            this.tokeniser.setParameterValues(params);
            pListener = new AbstractProcessingResource.IntervalProgressListener((AbstractProcessingResource)this, 0, 50);
            sListener = new StatusListener(){

                public void statusChanged(String text) {
                    DefaultTokeniser.this.fireStatusChanged(text);
                }
            };
            this.tokeniser.addProgressListener((ProgressListener)pListener);
            this.tokeniser.addStatusListener(sListener);
            Benchmark.executeWithBenchmarking((Executable)this.tokeniser, (String)Benchmark.createBenchmarkId((String)"simpleTokeniser", (String)this.getBenchmarkId()), (Object)((Object)this), null);
        }
        catch (ResourceInstantiationException e) {
            try {
                throw new ExecutionException("The execution of the \"" + this.getName() + "\" tokeniser has been abruptly interrupted!", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.tokeniser.removeProgressListener((ProgressListener)pListener);
                this.tokeniser.removeStatusListener(sListener);
                this.tokeniser.setDocument(null);
                throw throwable;
            }
        }
        this.tokeniser.removeProgressListener((ProgressListener)pListener);
        this.tokeniser.removeStatusListener(sListener);
        this.tokeniser.setDocument(null);
        if (this.isInterrupted()) {
            throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" tokeniser has been abruptly interrupted!");
        }
        try {
            params = Factory.newFeatureMap();
            params.put((Object)DEF_TOK_DOCUMENT_PARAMETER_NAME, (Object)this.document);
            params.put((Object)"inputASName", (Object)this.annotationSetName);
            params.put((Object)"outputASName", (Object)this.annotationSetName);
            this.transducer.setParameterValues(params);
            pListener = new AbstractProcessingResource.IntervalProgressListener((AbstractProcessingResource)this, 50, 100);
            this.transducer.addProgressListener((ProgressListener)pListener);
            this.transducer.addStatusListener(sListener);
            Benchmark.executeWithBenchmarking((Executable)this.transducer, (String)Benchmark.createBenchmarkId((String)"transducer", (String)this.getBenchmarkId()), (Object)((Object)this), null);
        }
        catch (ResourceInstantiationException e) {
            throw new ExecutionException("The execution of the \"" + this.getName() + "\" tokeniser has been abruptly interrupted!", (Throwable)e);
        }
        finally {
            this.transducer.removeProgressListener((ProgressListener)pListener);
            this.transducer.removeStatusListener(sListener);
            this.transducer.setDocument(null);
        }
    }

    public synchronized void interrupt() {
        this.interrupted = true;
        this.tokeniser.interrupt();
        this.transducer.interrupt();
    }

    @CreoleParameter(defaultValue="resources/tokeniser/DefaultTokeniser.rules", comment="The URL to the rules file", suffixes="rules")
    public void setTokeniserRulesURL(ResourceReference tokeniserRulesURL) {
        this.tokeniserRulesURL = tokeniserRulesURL;
    }

    @Deprecated
    public void setTokeniserRulesURL(URL tokeniserRulesURL) {
        try {
            this.setTokeniserRulesURL(new ResourceReference(tokeniserRulesURL));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error converting URL to ResourceReference", e);
        }
    }

    public ResourceReference getTokeniserRulesURL() {
        return this.tokeniserRulesURL;
    }

    @CreoleParameter(defaultValue="UTF-8", comment="The encoding used for reading the definitions")
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @CreoleParameter(defaultValue="resources/tokeniser/postprocess.jape", comment="The URL to the postprocessing transducer", suffixes="jape")
    public void setTransducerGrammarURL(ResourceReference transducerGrammarURL) {
        this.transducerGrammarURL = transducerGrammarURL;
    }

    @Deprecated
    public void setTransducerGrammarURL(URL transducerGrammarURL) {
        try {
            this.setTransducerGrammarURL(new ResourceReference(transducerGrammarURL));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error converting URL to ResourceReference", e);
        }
    }

    public ResourceReference getTransducerGrammarURL() {
        return this.transducerGrammarURL;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="The annotation set to be used for the generated annotations")
    public void setAnnotationSetName(String annotationSetName) {
        this.annotationSetName = annotationSetName;
    }

    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public void setBenchmarkId(String benchmarkId) {
        this.benchmarkId = benchmarkId;
    }

    public String getBenchmarkId() {
        if (this.benchmarkId == null) {
            return this.getName();
        }
        return this.benchmarkId;
    }
}

