/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.orthomatcher;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.ResourceReference;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.creole.orthomatcher.AnnotationOrthography;
import gate.creole.orthomatcher.BasicAnnotationOrthography;
import gate.creole.orthomatcher.MatchRule0;
import gate.creole.orthomatcher.MatchRule1;
import gate.creole.orthomatcher.MatchRule10;
import gate.creole.orthomatcher.MatchRule11;
import gate.creole.orthomatcher.MatchRule12;
import gate.creole.orthomatcher.MatchRule13;
import gate.creole.orthomatcher.MatchRule14;
import gate.creole.orthomatcher.MatchRule15;
import gate.creole.orthomatcher.MatchRule16;
import gate.creole.orthomatcher.MatchRule17;
import gate.creole.orthomatcher.MatchRule2;
import gate.creole.orthomatcher.MatchRule3;
import gate.creole.orthomatcher.MatchRule4;
import gate.creole.orthomatcher.MatchRule5;
import gate.creole.orthomatcher.MatchRule6;
import gate.creole.orthomatcher.MatchRule7;
import gate.creole.orthomatcher.MatchRule8;
import gate.creole.orthomatcher.MatchRule9;
import gate.creole.orthomatcher.OrthoMatcherHelper;
import gate.creole.orthomatcher.OrthoMatcherRule;
import gate.util.BomStrippingInputStreamReader;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import gate.util.Out;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

@CreoleResource(name="ANNIE OrthoMatcher", comment="ANNIE orthographical coreference component.", helpURL="http://gate.ac.uk/userguide/sec:annie:orthomatcher", icon="ortho-matcher")
public class OrthoMatcher
extends AbstractLanguageAnalyser {
    private static final long serialVersionUID = -6258229350677707465L;
    protected static final Logger log = Logger.getLogger(OrthoMatcher.class);
    public static final boolean DEBUG = false;
    public static final String OM_DOCUMENT_PARAMETER_NAME = "document";
    public static final String OM_ANN_SET_PARAMETER_NAME = "annotationSetName";
    public static final String OM_CASE_SENSITIVE_PARAMETER_NAME = "caseSensitive";
    public static final String OM_ANN_TYPES_PARAMETER_NAME = "annotationTypes";
    public static final String OM_ORG_TYPE_PARAMETER_NAME = "organizationType";
    public static final String OM_PERSON_TYPE_PARAMETER_NAME = "personType";
    public static final String OM_EXT_LISTS_PARAMETER_NAME = "extLists";
    protected static final String CDGLISTNAME = "cdg";
    protected static final String ALIASLISTNAME = "alias";
    protected static final String ARTLISTNAME = "def_art";
    protected static final String PREPLISTNAME = "prepos";
    protected static final String CONNECTORLISTNAME = "connector";
    protected static final String SPURLISTNAME = "spur_match";
    protected static final String PUNCTUATION_VALUE = "punctuation";
    protected static final String THE_VALUE = "The";
    protected String annotationSetName;
    protected List<String> annotationTypes = new ArrayList<String>(10);
    protected String organizationType = "Organization";
    protected String personType = "Person";
    protected String unknownType = "Unknown";
    protected boolean extLists = true;
    protected Boolean highPrecisionOrgs = false;
    protected boolean matchingUnknowns = true;
    protected boolean allMatchingNeeded = false;
    protected boolean caseSensitive = false;
    protected HashMap<String, String> alias = new HashMap(100);
    protected Set<String> cdg = new HashSet<String>();
    protected HashMap<String, String> spur_match = new HashMap(100);
    protected HashMap<String, String> def_art = new HashMap(20);
    protected HashMap<String, String> connector = new HashMap(20);
    protected HashMap<String, String> prepos = new HashMap(30);
    protected AnnotationSet nameAllAnnots = null;
    protected HashMap<Integer, String> processedAnnots = new HashMap(150);
    protected HashMap<Integer, String> annots2Remove = new HashMap(75);
    protected List<List<Integer>> matchesDocFeature = new ArrayList<List<Integer>>();
    protected HashMap<Integer, List<Annotation>> tokensMap = new HashMap(150);
    protected Map<Integer, List<Annotation>> normalizedTokensMap = new HashMap<Integer, List<Annotation>>(150);
    protected Annotation shortAnnot;
    protected Annotation longAnnot;
    protected List<Annotation> tokensLongAnnot;
    protected List<Annotation> tokensShortAnnot;
    protected List<Annotation> normalizedTokensLongAnnot;
    protected List<Annotation> normalizedTokensShortAnnot;
    private ResourceReference definitionFileURL;
    private Double minimumNicknameLikelihood;
    private String encoding;
    private Map<Integer, OrthoMatcherRule> rules = new HashMap<Integer, OrthoMatcherRule>();
    private AnnotationOrthography orthoAnnotation;
    static Pattern periodPat = Pattern.compile("[\\.]+");
    static Pattern punctPat = Pattern.compile("[\\p{Punct}]+");
    static Pattern badMiddleTokens = Pattern.compile("[\u201c\u201d\u2018\u2019'\\(\\)\"]+|^de$|^von$");

    public Map<Integer, List<Annotation>> getTokensMap() {
        return this.tokensMap;
    }

    public OrthoMatcher() {
        this.annotationTypes.add(this.organizationType);
        this.annotationTypes.add(this.personType);
        this.annotationTypes.add("Location");
        this.annotationTypes.add("Date");
    }

    private void initRules() {
        this.rules.put(0, new MatchRule0(this));
        this.rules.put(1, new MatchRule1(this));
        this.rules.put(2, new MatchRule2(this));
        this.rules.put(3, new MatchRule3(this));
        this.rules.put(4, new MatchRule4(this));
        this.rules.put(5, new MatchRule5(this));
        this.rules.put(6, new MatchRule6(this));
        this.rules.put(7, new MatchRule7(this));
        this.rules.put(8, new MatchRule8(this));
        this.rules.put(9, new MatchRule9(this));
        this.rules.put(10, new MatchRule10(this));
        this.rules.put(11, new MatchRule11(this));
        this.rules.put(12, new MatchRule12(this));
        this.rules.put(13, new MatchRule13(this));
        this.rules.put(14, new MatchRule14(this));
        this.rules.put(15, new MatchRule15(this));
        this.rules.put(16, new MatchRule16(this));
        this.rules.put(17, new MatchRule17(this));
    }

    protected void modifyRules(Map<Integer, OrthoMatcherRule> rules) {
    }

    public Resource init() throws ResourceInstantiationException {
        if (this.definitionFileURL == null) {
            throw new ResourceInstantiationException("No URL provided for the definition file!");
        }
        String nicknameFile = null;
        BomStrippingInputStreamReader reader = null;
        try {
            reader = new BomStrippingInputStreamReader(this.definitionFileURL.openStream(), this.encoding);
            String lineRead = null;
            while ((lineRead = reader.readLine()) != null) {
                int index = lineRead.indexOf(":");
                if (index == -1) continue;
                String nameFile = lineRead.substring(0, index);
                String nameList = lineRead.substring(index + 1, lineRead.length());
                if (nameList.equals("nickname")) {
                    if (this.minimumNicknameLikelihood == null) {
                        throw new ResourceInstantiationException("No value for the required parameter minimumNicknameLikelihood!");
                    }
                    nicknameFile = nameFile;
                    continue;
                }
                this.createAnnotList(nameFile, nameList);
            }
            reader.close();
            URL nicknameURL = null;
            if (nicknameFile != null) {
                nicknameURL = new URL(this.definitionFileURL.toURL(), nicknameFile);
            }
            this.orthoAnnotation = new BasicAnnotationOrthography(this.personType, this.extLists, this.unknownType, nicknameURL, this.minimumNicknameLikelihood, this.encoding);
            this.initRules();
            this.modifyRules(this.rules);
        }
        catch (IOException ioe) {
            try {
                throw new ResourceInstantiationException((Exception)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return this;
    }

    public void execute() throws ExecutionException {
        try {
            if (this.document == null) {
                throw new ExecutionException("No document for namematch!");
            }
            this.fireStatusChanged("OrthoMatcher processing: " + this.document.getName());
            this.nameAllAnnots = this.annotationSetName == null || this.annotationSetName.equals("") ? this.document.getAnnotations() : this.document.getAnnotations(this.annotationSetName);
            if (this.nameAllAnnots == null || this.nameAllAnnots.isEmpty()) {
                Out.prln((String)"OrthoMatcher Warning: No annotations found for processing");
                return;
            }
            this.docCleanup();
            HashMap<String, List<List<Integer>>> matchesMap = (HashMap<String, List<List<Integer>>>)this.document.getFeatures().get((Object)"MatchesAnnots");
            if (!this.extLists) {
                this.cdg = this.orthoAnnotation.buildTables(this.nameAllAnnots);
            }
            this.matchNameAnnotations();
            if (!this.matchesDocFeature.isEmpty()) {
                if (matchesMap == null) {
                    matchesMap = new HashMap<String, List<List<Integer>>>();
                }
                matchesMap.put(this.nameAllAnnots.getName(), this.matchesDocFeature);
                this.document.getFeatures().put((Object)"MatchesAnnots", matchesMap);
                this.matchesDocFeature = new ArrayList<List<Integer>>();
                this.fireStatusChanged("OrthoMatcher completed");
            }
        }
        finally {
            this.nameAllAnnots = null;
            this.processedAnnots.clear();
            this.annots2Remove.clear();
            this.tokensMap.clear();
            this.normalizedTokensMap.clear();
            this.matchesDocFeature = new ArrayList<List<Integer>>();
            this.longAnnot = null;
            this.shortAnnot = null;
            this.tokensLongAnnot = null;
            this.tokensShortAnnot = null;
        }
    }

    protected void matchNameAnnotations() throws ExecutionException {
        for (String annotationType : this.annotationTypes) {
            AnnotationSet tokensNameAS;
            AnnotationSet nameAnnots = this.nameAllAnnots.get(annotationType);
            if (nameAnnots.isEmpty() || (tokensNameAS = this.nameAllAnnots.get("Token")).isEmpty()) continue;
            ArrayList<Annotation> sortedNameAnnots = new ArrayList<Annotation>((Collection<Annotation>)nameAnnots);
            Collections.sort(sortedNameAnnots, new OffsetComparator());
            for (int snaIndex = 0; snaIndex < sortedNameAnnots.size(); ++snaIndex) {
                ArrayList tokens;
                Annotation tempAnnot = (Annotation)sortedNameAnnots.get(snaIndex);
                Annotation nameAnnot = this.nameAllAnnots.get(tempAnnot.getId());
                String annotString = this.orthoAnnotation.getStringForAnnotation(nameAnnot, this.document);
                if (!this.caseSensitive) {
                    annotString = annotString.toLowerCase();
                }
                if ((tokens = new ArrayList(tokensNameAS.getContained(nameAnnot.getStartNode().getOffset(), nameAnnot.getEndNode().getOffset()))).isEmpty()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Didn't find any tokens for the following annotation.  We will be unable to perform coref on this annotation.  \n String:  " + this.orthoAnnotation.getStringForAnnotation(nameAnnot, this.document) + " Id: " + nameAnnot.getId() + " Type: " + nameAnnot.getType()));
                    continue;
                }
                Collections.sort(tokens, new OffsetComparator());
                this.tokensMap.put(nameAnnot.getId(), tokens);
                this.normalizedTokensMap.put(nameAnnot.getId(), new ArrayList(tokens));
                if (this.processedAnnots.containsValue(annotString) && (!nameAnnot.getType().equals(this.personType) || tokens.size() != 1)) {
                    Annotation returnAnnot = this.orthoAnnotation.updateMatches(nameAnnot, annotString, this.processedAnnots, this.nameAllAnnots, this.matchesDocFeature);
                    if (returnAnnot != null) {
                        this.processedAnnots.put(nameAnnot.getId(), annotString);
                        continue;
                    }
                } else if (this.processedAnnots.isEmpty()) {
                    this.processedAnnots.put(nameAnnot.getId(), annotString);
                    continue;
                }
                if (nameAnnot.getType().equals(this.personType)) {
                    annotString = this.orthoAnnotation.stripPersonTitle(annotString, nameAnnot, this.document, this.tokensMap, this.normalizedTokensMap, this.nameAllAnnots);
                    this.normalizePersonName(nameAnnot);
                } else if (nameAnnot.getType().equals(this.organizationType)) {
                    annotString = this.normalizeOrganizationName(annotString, nameAnnot);
                }
                if (null == annotString || "".equals(annotString) || tokens.isEmpty()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Annotation ID " + nameAnnot.getId() + " of type" + nameAnnot.getType() + " refers to a null or empty string or one with no tokens after normalization.  Unable to process further."));
                    continue;
                }
                this.matchWithPrevious(nameAnnot, annotString, sortedNameAnnots, snaIndex);
                this.processedAnnots.put(nameAnnot.getId(), annotString);
            }
            if (!this.matchingUnknowns) continue;
            this.matchUnknown(sortedNameAnnots);
        }
    }

    protected void matchUnknown(ArrayList<Annotation> sortedAnnotationsForAType) throws ExecutionException {
        AnnotationSet unknownAnnots = this.nameAllAnnots.get(this.unknownType);
        this.annots2Remove.clear();
        if (unknownAnnots.isEmpty()) {
            return;
        }
        AnnotationSet nameAllTokens = this.nameAllAnnots.get("Token");
        if (nameAllTokens.isEmpty()) {
            return;
        }
        Iterator iter = unknownAnnots.iterator();
        while (iter.hasNext()) {
            ArrayList tokens;
            Annotation unknown = (Annotation)iter.next();
            String unknownString = this.orthoAnnotation.getStringForAnnotation(unknown, this.document);
            if (!this.caseSensitive) {
                unknownString = unknownString.toLowerCase();
            }
            if ((tokens = new ArrayList(nameAllTokens.getContained(unknown.getStartNode().getOffset(), unknown.getEndNode().getOffset()))).isEmpty()) continue;
            Collections.sort(tokens, new OffsetComparator());
            this.tokensMap.put(unknown.getId(), tokens);
            this.normalizedTokensMap.put(unknown.getId(), tokens);
            if (this.processedAnnots.containsValue(unknownString)) {
                Annotation matchedAnnot = this.orthoAnnotation.updateMatches(unknown, unknownString, this.processedAnnots, this.nameAllAnnots, this.matchesDocFeature);
                if (matchedAnnot == null) {
                    log.debug((Object)("Orthomatcher: Unable to find the annotation: " + this.orthoAnnotation.getStringForAnnotation(unknown, this.document) + " in matchUnknown"));
                } else {
                    if (matchedAnnot.getType().equals(this.unknownType)) {
                        this.annots2Remove.put(unknown.getId(), this.annots2Remove.get(matchedAnnot.getId()));
                    } else {
                        this.annots2Remove.put(unknown.getId(), matchedAnnot.getType());
                    }
                    this.processedAnnots.put(unknown.getId(), unknownString);
                    unknown.getFeatures().put((Object)"NMRule", (Object)this.unknownType);
                    continue;
                }
            }
            if (tokens.size() == 1 && "hyphen".equals(unknown.getFeatures().get((Object)"kind")) && this.matchHyphenatedUnknowns(unknown, unknownString, iter)) continue;
            this.matchWithPrevious(unknown, unknownString, sortedAnnotationsForAType, sortedAnnotationsForAType.size());
        }
        if (!this.annots2Remove.isEmpty()) {
            for (Integer unknId : this.annots2Remove.keySet()) {
                Annotation unknown = this.nameAllAnnots.get(unknId);
                Integer newID = this.nameAllAnnots.add(unknown.getStartNode(), unknown.getEndNode(), this.annots2Remove.get(unknId), unknown.getFeatures());
                this.nameAllAnnots.remove((Object)unknown);
                List mList = (List)unknown.getFeatures().get((Object)"matches");
                mList.remove(unknId);
                mList.add(newID);
            }
        }
    }

    private boolean matchHyphenatedUnknowns(Annotation unknown, String unknownString, Iterator<Annotation> iter) {
        boolean matched = false;
        int stringEnd = unknownString.indexOf("-");
        if (this.processedAnnots.containsValue(unknownString = unknownString.substring(0, stringEnd))) {
            Integer newID;
            matched = true;
            Annotation matchedAnnot = this.orthoAnnotation.updateMatches(unknown, unknownString, this.processedAnnots, this.nameAllAnnots, this.matchesDocFeature);
            iter.remove();
            String newType = matchedAnnot.getType().equals(this.unknownType) ? this.annots2Remove.get(matchedAnnot.getId()) : matchedAnnot.getType();
            try {
                newID = this.nameAllAnnots.add(unknown.getStartNode().getOffset(), Long.valueOf(unknown.getStartNode().getOffset() + (long)stringEnd), newType, unknown.getFeatures());
            }
            catch (InvalidOffsetException ex) {
                throw new GateRuntimeException(ex.getMessage());
            }
            this.nameAllAnnots.remove((Object)unknown);
            List mList = (List)unknown.getFeatures().get((Object)"matches");
            mList.remove(unknown.getId());
            mList.add(newID);
        }
        return matched;
    }

    protected void matchWithPrevious(Annotation nameAnnot, String annotString, ArrayList<Annotation> listOfThisType, int startIndex) {
        boolean matchedUnknown = false;
        for (int curIndex = startIndex - 1; curIndex >= 0; --curIndex) {
            Integer prevId = listOfThisType.get(curIndex).getId();
            Annotation prevAnnot = this.nameAllAnnots.get(prevId);
            if (prevAnnot == null || !prevAnnot.getType().equals(nameAnnot.getType()) && !nameAnnot.getType().equals(this.unknownType) || nameAnnot.getType().equals(this.unknownType) && prevAnnot.getType().equals(this.unknownType) || this.orthoAnnotation.matchedAlready(nameAnnot, prevAnnot, this.matchesDocFeature, this.nameAllAnnots)) continue;
            if (prevAnnot.getType().equals(this.personType)) {
                String prevGender = (String)prevAnnot.getFeatures().get((Object)"gender");
                String nameGender = (String)nameAnnot.getFeatures().get((Object)"gender");
                if (prevGender != null && nameGender != null && (nameGender.equalsIgnoreCase("female") && prevGender.equalsIgnoreCase("male") || prevGender.equalsIgnoreCase("female") && nameGender.equalsIgnoreCase("male"))) continue;
            }
            boolean prevAnnotUsedToMatchWithLonger = prevAnnot.getFeatures().containsKey((Object)"matchedWithLonger");
            if (!this.matchAnnotations(nameAnnot, annotString, prevAnnot)) continue;
            this.orthoAnnotation.updateMatches(nameAnnot, prevAnnot, this.matchesDocFeature, this.nameAllAnnots);
            if (!prevAnnotUsedToMatchWithLonger && prevAnnot.getFeatures().containsKey((Object)"matchedWithLonger")) {
                this.propagatePropertyToExactMatchingMatches(prevAnnot, "matchedWithLonger", true);
            }
            if (!nameAnnot.getType().equals(this.unknownType)) break;
            matchedUnknown = true;
            if (prevAnnot.getType().equals(this.unknownType)) {
                this.annots2Remove.put(nameAnnot.getId(), this.annots2Remove.get(prevAnnot.getId()));
            } else {
                this.annots2Remove.put(nameAnnot.getId(), prevAnnot.getType());
            }
            nameAnnot.getFeatures().put((Object)"NMRule", (Object)this.unknownType);
            break;
        }
        if (matchedUnknown) {
            this.processedAnnots.put(nameAnnot.getId(), annotString);
        }
    }

    protected void propagatePropertyToExactMatchingMatches(Annotation updateAnnot, String featureName, Object value) {
        try {
            List matchesList = (List)updateAnnot.getFeatures().get((Object)"matches");
            if (matchesList == null || matchesList.isEmpty()) {
                return;
            }
            String updateAnnotString = this.orthoAnnotation.getStringForAnnotation(updateAnnot, this.document).toLowerCase();
            for (Integer nextId : matchesList) {
                Annotation a = this.nameAllAnnots.get(nextId);
                if (!this.orthoAnnotation.fuzzyMatch(this.orthoAnnotation.getStringForAnnotation(a, this.document), updateAnnotString)) continue;
                a.getFeatures().put((Object)featureName, value);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in propogatePropertyToExactMatchingMatches", (Throwable)e);
        }
    }

    protected boolean matchAnnotations(Annotation newAnnot, String annotString, Annotation prevAnnot) {
        if (newAnnot.overlaps(prevAnnot)) {
            return false;
        }
        String prevAnnotString = this.processedAnnots.get(prevAnnot.getId());
        if (prevAnnotString == null) {
            return false;
        }
        String longName = prevAnnotString;
        String shortName = annotString;
        this.longAnnot = prevAnnot;
        this.shortAnnot = newAnnot;
        boolean longerPrevious = true;
        if (shortName.length() > longName.length()) {
            String temp = longName;
            longName = shortName;
            shortName = temp;
            Annotation tempAnn = this.longAnnot;
            this.longAnnot = this.shortAnnot;
            this.shortAnnot = tempAnn;
            longerPrevious = false;
        }
        this.tokensLongAnnot = this.tokensMap.get(this.longAnnot.getId());
        this.normalizedTokensLongAnnot = this.normalizedTokensMap.get(this.longAnnot.getId());
        this.tokensShortAnnot = this.tokensMap.get(this.shortAnnot.getId());
        this.normalizedTokensShortAnnot = this.normalizedTokensMap.get(this.shortAnnot.getId());
        List matchesList = (List)prevAnnot.getFeatures().get((Object)"matches");
        if (matchesList == null || matchesList.isEmpty()) {
            return this.apply_rules_namematch(prevAnnot.getType(), shortName, longName, prevAnnot, newAnnot, longerPrevious);
        }
        if (this.apply_rules_namematch(prevAnnot.getType(), shortName, longName, prevAnnot, newAnnot, longerPrevious)) {
            if (this.allMatchingNeeded) {
                this.allMatchingNeeded = false;
                ArrayList<Integer> toMatchList = new ArrayList<Integer>(matchesList);
                toMatchList.remove(prevAnnot.getId());
                return this.matchOtherAnnots(toMatchList, newAnnot, annotString);
            }
            return true;
        }
        return false;
    }

    protected boolean matchOtherAnnots(List<Integer> toMatchList, Annotation newAnnot, String annotString) {
        if (toMatchList.isEmpty()) {
            return true;
        }
        boolean matchedAll = true;
        for (int i = 0; matchedAll && i < toMatchList.size(); ++i) {
            Annotation prevAnnot = this.nameAllAnnots.get(toMatchList.get(i));
            String prevAnnotString = this.processedAnnots.get(prevAnnot.getId());
            if (prevAnnotString == null) {
                try {
                    prevAnnotString = this.document.getContent().getContent(prevAnnot.getStartNode().getOffset(), prevAnnot.getEndNode().getOffset()).toString();
                }
                catch (InvalidOffsetException ioe) {
                    return false;
                }
            }
            String longName = prevAnnotString;
            String shortName = annotString;
            this.longAnnot = prevAnnot;
            this.shortAnnot = newAnnot;
            boolean longerPrevious = true;
            if (shortName.length() >= longName.length()) {
                String temp = longName;
                longName = shortName;
                shortName = temp;
                Annotation tempAnn = this.longAnnot;
                this.longAnnot = this.shortAnnot;
                this.shortAnnot = tempAnn;
                longerPrevious = false;
            }
            this.tokensLongAnnot = this.tokensMap.get(this.longAnnot.getId());
            this.normalizedTokensLongAnnot = this.normalizedTokensMap.get(this.longAnnot.getId());
            this.tokensShortAnnot = this.tokensMap.get(this.shortAnnot.getId());
            this.normalizedTokensShortAnnot = this.normalizedTokensMap.get(this.shortAnnot.getId());
            matchedAll = this.apply_rules_namematch(prevAnnot.getType(), shortName, longName, prevAnnot, newAnnot, longerPrevious);
        }
        return matchedAll;
    }

    protected void docCleanup() {
        Object matchesValue = this.document.getFeatures().get((Object)"MatchesAnnots");
        if (matchesValue != null && matchesValue instanceof Map) {
            ((Map)matchesValue).remove(this.nameAllAnnots.getName());
        } else if (matchesValue != null) {
            this.document.getFeatures().put((Object)"MatchesAnnots", new HashMap());
        }
        HashSet<String> fNames = new HashSet<String>();
        fNames.add("matches");
        AnnotationSet annots = this.nameAllAnnots.get(null, fNames);
        if (annots == null || annots.isEmpty()) {
            return;
        }
        Iterator iter = annots.iterator();
        while (iter.hasNext()) {
            while (iter.hasNext()) {
                ((Annotation)iter.next()).getFeatures().remove((Object)"matches");
            }
        }
    }

    protected void normalizePersonName(Annotation annot) throws ExecutionException {
        List<Annotation> tokens = this.normalizedTokensMap.get(annot.getId());
        for (int i = tokens.size() - 1; i >= 0; --i) {
            String tokenString = (String)tokens.get(i).getFeatures().get((Object)"string");
            String kind = (String)tokens.get(i).getFeatures().get((Object)"kind");
            if (!this.caseSensitive) {
                tokenString = tokenString.toLowerCase();
            }
            if (!kind.equals(PUNCTUATION_VALUE)) continue;
            tokens.get(i).getFeatures().put((Object)"ortho_stop", (Object)true);
        }
        ArrayList<Annotation> normalizedTokens = new ArrayList<Annotation>(tokens);
        for (int j = normalizedTokens.size() - 1; j >= 0; --j) {
            if (!((Annotation)normalizedTokens.get(j)).getFeatures().containsKey((Object)"ortho_stop")) continue;
            normalizedTokens.remove(j);
        }
        this.normalizedTokensMap.put(annot.getId(), normalizedTokens);
    }

    protected String normalizeOrganizationName(String annotString, Annotation annot) {
        List<Annotation> tokens = this.tokensMap.get(annot.getId());
        if (((String)tokens.get(0).getFeatures().get((Object)"string")).equalsIgnoreCase(THE_VALUE)) {
            tokens.remove(0);
        }
        if (tokens.size() > 0) {
            for (int i = tokens.size() - 1; i >= 0; --i) {
                String tokenString = (String)tokens.get(i).getFeatures().get((Object)"string");
                String kind = (String)tokens.get(i).getFeatures().get((Object)"kind");
                String category = (String)tokens.get(i).getFeatures().get((Object)"category");
                if (!this.caseSensitive) {
                    tokenString = tokenString.toLowerCase();
                }
                if (!kind.equals(PUNCTUATION_VALUE) && (category == null || !category.equals("DT") && !category.equals("IN")) && !this.cdg.contains(tokenString)) continue;
                tokens.get(i).getFeatures().put((Object)"ortho_stop", (Object)true);
            }
            String compareString = (String)tokens.get(tokens.size() - 1).getFeatures().get((Object)"string");
            if (!this.caseSensitive) {
                compareString = compareString.toLowerCase();
            }
            if (this.cdg.contains(compareString)) {
                tokens.remove(tokens.size() - 1);
            }
        }
        ArrayList<Annotation> normalizedTokens = new ArrayList<Annotation>(tokens);
        for (int j = normalizedTokens.size() - 1; j >= 0; --j) {
            if (!normalizedTokens.get(j).getFeatures().containsKey((Object)"ortho_stop")) continue;
            normalizedTokens.remove(j);
        }
        this.normalizedTokensMap.put(annot.getId(), normalizedTokens);
        StringBuffer newString = new StringBuffer(50);
        for (int i = 0; i < tokens.size(); ++i) {
            newString.append((String)tokens.get(i).getFeatures().get((Object)"string"));
            if (i == tokens.size() - 1) continue;
            newString.append(" ");
        }
        if (this.caseSensitive) {
            return newString.toString();
        }
        return newString.toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAnnotList(String nameFile, String nameList) throws IOException {
        URL fileURL = new URL(this.definitionFileURL.toURL(), nameFile);
        BomStrippingInputStreamReader bufferedReader = null;
        try {
            bufferedReader = new BomStrippingInputStreamReader(fileURL.openStream(), this.encoding);
            String lineRead = null;
            while ((lineRead = bufferedReader.readLine()) != null) {
                if (nameList.compareTo(CDGLISTNAME) == 0) {
                    Matcher matcher = punctPat.matcher(lineRead.toLowerCase().trim());
                    lineRead = matcher.replaceAll(" ").trim();
                    if (this.caseSensitive) {
                        this.cdg.add(lineRead);
                        continue;
                    }
                    this.cdg.add(lineRead.toLowerCase());
                    continue;
                }
                int index = lineRead.indexOf("\u00a3");
                if (index == -1) continue;
                String expr = lineRead.substring(0, index);
                if (!this.caseSensitive) {
                    expr = expr.toLowerCase();
                }
                String code = lineRead.substring(index + 1, lineRead.length());
                if (nameList.equals(ALIASLISTNAME)) {
                    this.alias.put(expr, code);
                    continue;
                }
                if (nameList.equals(ARTLISTNAME)) {
                    this.def_art.put(expr, code);
                    continue;
                }
                if (nameList.equals(PREPLISTNAME)) {
                    this.prepos.put(expr, code);
                    continue;
                }
                if (nameList.equals(CONNECTORLISTNAME)) {
                    this.connector.put(expr, code);
                    continue;
                }
                if (!nameList.equals(SPURLISTNAME)) continue;
                this.spur_match.put(expr, code);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
    }

    private boolean pairwise_person_name_match(String name1, String name2) {
        String shortName;
        String longName;
        if (name1.length() > name2.length()) {
            longName = name1;
            shortName = name2;
        } else {
            longName = name2;
            shortName = name1;
        }
        if (this.rules.get(0).value(longName, shortName)) {
            return false;
        }
        if (longName.equals(shortName) || this.rules.get(2).value(longName, shortName) || this.rules.get(3).value(longName, shortName)) {
            return true;
        }
        return this.rules.get(0).value(longName, shortName);
    }

    private boolean basic_person_match_criteria(String shortName, String longName, boolean[] mr) {
        return OrthoMatcherHelper.executeDisjunction(this.rules, new int[]{1, 5, 6, 13, 15, 16}, longName, shortName, mr);
    }

    private boolean apply_rules_namematch(String annotationType, String shortName, String longName, Annotation prevAnnot, Annotation followAnnot, boolean longerPrevious) {
        boolean[] mr = new boolean[this.rules.size()];
        if (this.rules.get(0).value(longName, shortName)) {
            return false;
        }
        if (OrthoMatcherHelper.executeDisjunction(this.rules, new int[]{2, 3}, longName, shortName, mr) || (annotationType.equals(this.organizationType) || annotationType.equals("Facility")) && (!this.highPrecisionOrgs.booleanValue() && OrthoMatcherHelper.executeDisjunction(this.rules, new int[]{4, 6, 7, 8, 9, 10, 11, 12, 14}, longName, shortName, mr) || this.highPrecisionOrgs.booleanValue() && OrthoMatcherHelper.executeDisjunction(this.rules, new int[]{7, 8, 10, 11, 17}, longName, shortName, mr))) {
            return true;
        }
        if (annotationType.equals(this.personType)) {
            if (this.noMatchRule1(longName, shortName, prevAnnot, longerPrevious) || this.noMatchRule2(longName, shortName)) {
                return false;
            }
            if (this.basic_person_match_criteria(shortName, longName, mr)) {
                if (longName.length() != shortName.length() && (mr[4] || mr[5] || mr[14] || mr[15])) {
                    if (longerPrevious) {
                        followAnnot.getFeatures().put((Object)"matchedWithLonger", (Object)true);
                    } else {
                        prevAnnot.getFeatures().put((Object)"matchedWithLonger", (Object)true);
                    }
                } else if (longName.length() == shortName.length() && mr[1] && prevAnnot.getFeatures().containsKey((Object)"matchedWithLonger")) {
                    followAnnot.getFeatures().put((Object)"matchedWithLonger", (Object)true);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Optional
    @CreoleParameter(comment="External lists otherwise internal", defaultValue="true")
    public void setExtLists(Boolean newExtLists) {
        this.extLists = newExtLists;
    }

    @Optional
    @CreoleParameter(comment="Should this resource diferentiate on case?", defaultValue="false")
    public void setCaseSensitive(Boolean newCase) {
        this.caseSensitive = newCase;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="Annotation set name where are the annotation types (annotationTypes)")
    public void setAnnotationSetName(String newAnnotationSetName) {
        this.annotationSetName = newAnnotationSetName;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="Name of the annotation types to use", defaultValue="Organization;Person;Location;Date")
    public void setAnnotationTypes(List<String> newType) {
        this.annotationTypes = newType;
    }

    @Optional
    @CreoleParameter(comment="Should we process 'Unknown' annotations?", defaultValue="true")
    public void setProcessUnknown(Boolean processOrNot) {
        this.matchingUnknowns = processOrNot;
    }

    @Optional
    @CreoleParameter(comment="Annotation name for the organizations", defaultValue="Organization")
    public void setOrganizationType(String newOrganizationType) {
        this.organizationType = newOrganizationType;
    }

    @Optional
    @CreoleParameter(comment="Annotation name for the persons", defaultValue="Person")
    public void setPersonType(String newPersonType) {
        this.personType = newPersonType;
    }

    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public List<String> getAnnotationTypes() {
        return this.annotationTypes;
    }

    public String getOrganizationType() {
        return this.organizationType;
    }

    public String getPersonType() {
        return this.personType;
    }

    public Boolean getExtLists() {
        return this.extLists;
    }

    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public Boolean getProcessUnknown() {
        return this.matchingUnknowns;
    }

    public boolean noMatchRule1(String s1, String s2, Annotation previousAnnot, boolean longerPrevious) {
        return !longerPrevious && previousAnnot.getFeatures().containsKey((Object)"matchedWithLonger");
    }

    private boolean detectBadMiddleTokens(List<Annotation> tokArray) {
        for (int j = 1; j < tokArray.size() - 1; ++j) {
            String currentToken = (String)tokArray.get(j).getFeatures().get((Object)"string");
            Matcher matcher = badMiddleTokens.matcher(currentToken.toLowerCase().trim());
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public boolean noMatchRule2(String s1, String s2) {
        block4: {
            boolean retval;
            block6: {
                block5: {
                    if (this.normalizedTokensLongAnnot.size() <= 2 || this.normalizedTokensShortAnnot.size() <= 2) break block4;
                    retval = false;
                    if (this.normalizedTokensLongAnnot.size() == this.normalizedTokensShortAnnot.size()) break block5;
                    String firstNameLong = (String)this.normalizedTokensLongAnnot.get(0).getFeatures().get((Object)"string");
                    String firstNameShort = (String)this.normalizedTokensShortAnnot.get(0).getFeatures().get((Object)"string");
                    String lastNameLong = (String)this.normalizedTokensLongAnnot.get(this.normalizedTokensLongAnnot.size() - 1).getFeatures().get((Object)"string");
                    String lastNameShort = (String)this.normalizedTokensShortAnnot.get(this.normalizedTokensShortAnnot.size() - 1).getFeatures().get((Object)"string");
                    if (!this.rules.get(1).value(firstNameLong, firstNameShort) || !this.rules.get(1).value(lastNameLong, lastNameShort)) break block6;
                    if (this.detectBadMiddleTokens(this.tokensLongAnnot) || this.detectBadMiddleTokens(this.tokensShortAnnot)) {
                        return false;
                    }
                    retval = true;
                    break block6;
                }
                for (int i = 1; i < this.normalizedTokensLongAnnot.size() - 1; ++i) {
                    String s1_middle = (String)this.normalizedTokensLongAnnot.get(i).getFeatures().get((Object)"string");
                    String s2_middle = (String)this.normalizedTokensShortAnnot.get(i).getFeatures().get((Object)"string");
                    if (!this.caseSensitive) {
                        s1_middle = s1_middle.toLowerCase();
                        s2_middle = s2_middle.toLowerCase();
                    }
                    if (this.rules.get(1).value(s1_middle, s2_middle) || OrthoMatcherHelper.initialMatch(s1_middle, s2_middle)) continue;
                    retval = true;
                    break;
                }
            }
            if (!retval || log.isDebugEnabled()) {
                // empty if block
            }
            return retval;
        }
        return false;
    }

    @CreoleParameter(comment="The URL to the definition file", defaultValue="resources/othomatcher/listsNM.def", suffixes="def")
    public void setDefinitionFileURL(ResourceReference definitionFileURL) {
        this.definitionFileURL = definitionFileURL;
    }

    @Deprecated
    public void setDefinitionFileURL(URL definitionFileURL) {
        try {
            this.setDefinitionFileURL(new ResourceReference(definitionFileURL));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error converting URL to ResourceReference", e);
        }
    }

    public ResourceReference getDefinitionFileURL() {
        return this.definitionFileURL;
    }

    @CreoleParameter(comment="The encoding used for reading the definition file", defaultValue="UTF-8")
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Double getMinimumNicknameLikelihood() {
        return this.minimumNicknameLikelihood;
    }

    @CreoleParameter(comment="Minimum likelihood that a name is a nickname", defaultValue="0.50")
    public void setMinimumNicknameLikelihood(Double minimumNicknameLikelihood) {
        this.minimumNicknameLikelihood = minimumNicknameLikelihood;
    }

    public Boolean getHighPrecisionOrgs() {
        return this.highPrecisionOrgs;
    }

    @Optional
    @CreoleParameter(comment="Use very safe features for matching orgs, such as ACME = ACME, Inc.", defaultValue="false")
    public void setHighPrecisionOrgs(Boolean highPrecisionOrgs) {
        this.highPrecisionOrgs = highPrecisionOrgs;
    }

    public void setOrthography(AnnotationOrthography orthography) {
        this.orthoAnnotation = orthography;
    }

    public AnnotationOrthography getOrthography() {
        return this.orthoAnnotation;
    }
}

