/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.orthomatcher;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.creole.ExecutionException;
import gate.creole.orthomatcher.AnnotationOrthography;
import gate.creole.orthomatcher.OrthoMatcherHelper;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Err;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class BasicAnnotationOrthography
implements AnnotationOrthography {
    private final boolean extLists;
    private final String personType;
    private final String unknownType;
    private Map<String, Set<String>> nicknameMap = new HashMap<String, Set<String>>();
    private final Double minimumNicknameLikelihood;
    protected static final Logger log = Logger.getLogger(BasicAnnotationOrthography.class);

    public BasicAnnotationOrthography(String personType, boolean extLists, String unknownType, URL nicknameFile, Double minimumNicknameLikelihood, String encoding) {
        this.personType = personType;
        this.extLists = extLists;
        this.unknownType = unknownType;
        this.minimumNicknameLikelihood = minimumNicknameLikelihood;
        try {
            if (nicknameFile != null) {
                this.initNicknames(encoding, nicknameFile);
            }
        }
        catch (IOException e) {
            log.warn((Object)"Could not load nickname map.", (Throwable)e);
        }
    }

    @Override
    public String getStringForAnnotation(Annotation a, Document d) throws ExecutionException {
        String annotString = OrthoMatcherHelper.getStringForSpan(a.getStartNode().getOffset(), a.getEndNode().getOffset(), d);
        annotString = annotString.replaceAll("\\s+", " ");
        return annotString;
    }

    @Override
    public boolean fuzzyMatch(String s1, String s2) {
        String s2Lower;
        String s1Lower = s1.toLowerCase();
        if (s1Lower.equals(s2Lower = s2.toLowerCase())) {
            return true;
        }
        Set<String> formalNameSet = this.nicknameMap.get(s1Lower);
        if (formalNameSet != null && formalNameSet.contains(s2Lower)) {
            return true;
        }
        formalNameSet = this.nicknameMap.get(s2Lower);
        return formalNameSet != null && formalNameSet.contains(s1Lower);
    }

    @Override
    public boolean allNonStopTokensInOtherAnnot(List<Annotation> firstName, List<Annotation> secondName, String TOKEN_STRING_FEATURE_NAME, boolean caseSensitive) {
        for (Annotation a : firstName) {
            if (a.getFeatures().containsKey((Object)"ortho_stop")) continue;
            String aString = (String)a.getFeatures().get((Object)TOKEN_STRING_FEATURE_NAME);
            boolean foundAMatchInSecond = false;
            for (Annotation b : secondName) {
                if (!OrthoMatcherHelper.straightCompare(aString, (String)b.getFeatures().get((Object)TOKEN_STRING_FEATURE_NAME), caseSensitive)) continue;
                foundAMatchInSecond = true;
                break;
            }
            if (foundAMatchInSecond) continue;
            return false;
        }
        return true;
    }

    @Override
    public String stripPersonTitle(String annotString, Annotation annot, Document doc, Map<Integer, List<Annotation>> tokensMap, Map<Integer, List<Annotation>> normalizedTokensMap, AnnotationSet nameAllAnnots) throws ExecutionException {
        FeatureMap queryFM = Factory.newFeatureMap();
        Long startAnnot = annot.getStartNode().getOffset();
        Long endAnnot = annot.getEndNode().getOffset();
        queryFM.clear();
        queryFM.put((Object)"majorType", (Object)"title");
        AnnotationSet as1 = nameAllAnnots.getContained(startAnnot, endAnnot);
        if (as1 == null || as1.isEmpty()) {
            return annotString;
        }
        AnnotationSet as = as1.get("Lookup", queryFM);
        if (as != null && !as.isEmpty()) {
            ArrayList titles = new ArrayList(as);
            Collections.sort(titles, new OffsetComparator());
            for (Annotation titleAnn : titles) {
                if (titleAnn.getStartNode().getOffset().compareTo(startAnnot) != 0) {
                    return annotString;
                }
                try {
                    String annotTitle = doc.getContent().getContent(titleAnn.getStartNode().getOffset(), titleAnn.getEndNode().getOffset()).toString();
                    if (annotTitle.length() >= annotString.length()) continue;
                    tokensMap.get(annot.getId()).remove(0);
                    normalizedTokensMap.get(annot.getId()).remove(0);
                    return annotString.substring(annotTitle.length() + 1, annotString.length());
                }
                catch (InvalidOffsetException ioe) {
                    throw new ExecutionException("Invalid offset of the annotation");
                }
            }
        }
        return annotString;
    }

    @Override
    public boolean matchedAlready(Annotation annot1, Annotation annot2, List<List<Integer>> matchesDocFeature, AnnotationSet nameAllAnnots) {
        List matchesList = (List)annot1.getFeatures().get((Object)"matches");
        if (matchesList == null || matchesList.isEmpty()) {
            return false;
        }
        return matchesList.contains(annot2.getId());
    }

    @Override
    public Annotation updateMatches(Annotation newAnnot, String annotString, Map<Integer, String> processedAnnots, AnnotationSet nameAllAnnots, List<List<Integer>> matchesDocFeature) {
        Annotation matchedAnnot = null;
        for (Integer id : processedAnnots.keySet()) {
            String oldString = processedAnnots.get(id);
            if (!annotString.equals(oldString)) continue;
            Annotation tempAnnot = nameAllAnnots.get(id);
            if (tempAnnot == null) {
                log.debug((Object)("Orthomatcher: TempAnnot is null when looking at " + annotString + " | " + oldString + " | old id: " + id));
                return null;
            }
            if (!newAnnot.getType().equals(this.unknownType) && !tempAnnot.getType().equals(newAnnot.getType())) continue;
            matchedAnnot = tempAnnot;
            break;
        }
        if (matchedAnnot == null) {
            return null;
        }
        ArrayList<Integer> matchesList = (ArrayList<Integer>)matchedAnnot.getFeatures().get((Object)"matches");
        if (matchesList == null || matchesList.isEmpty()) {
            if (matchesList == null) {
                matchesList = new ArrayList<Integer>();
                matchedAnnot.getFeatures().put((Object)"matches", matchesList);
                matchesDocFeature.add(matchesList);
            }
            matchesList.add(matchedAnnot.getId());
            matchesList.add(newAnnot.getId());
        } else {
            matchesList.add(newAnnot.getId());
        }
        newAnnot.getFeatures().put((Object)"matches", matchesList);
        return matchedAnnot;
    }

    @Override
    public void updateMatches(Annotation newAnnot, Annotation prevAnnot, List<List<Integer>> matchesDocFeature, AnnotationSet nameAllAnnots) {
        ArrayList<Integer> matchesList = (ArrayList<Integer>)prevAnnot.getFeatures().get((Object)"matches");
        if (matchesList == null || matchesList.isEmpty()) {
            if (matchesList == null) {
                matchesList = new ArrayList<Integer>();
                prevAnnot.getFeatures().put((Object)"matches", matchesList);
                matchesDocFeature.add(matchesList);
            }
            matchesList.add(prevAnnot.getId());
            matchesList.add(newAnnot.getId());
        } else {
            matchesList.add(newAnnot.getId());
        }
        newAnnot.getFeatures().put((Object)"matches", matchesList);
        if (prevAnnot.getType().equals(this.personType)) {
            String prevGender = (String)prevAnnot.getFeatures().get((Object)"gender");
            String newGender = (String)newAnnot.getFeatures().get((Object)"gender");
            boolean unknownPrevGender = this.isUnknownGender(prevGender);
            boolean unknownNewGender = this.isUnknownGender(newGender);
            if (unknownPrevGender && !unknownNewGender) {
                prevAnnot.getFeatures().put((Object)"gender", (Object)newGender);
            } else if (unknownNewGender && !unknownPrevGender) {
                newAnnot.getFeatures().put((Object)"gender", (Object)prevGender);
            }
        }
    }

    @Override
    public Set<String> buildTables(AnnotationSet nameAllAnnots) {
        FeatureMap tempMap = Factory.newFeatureMap();
        HashSet<String> cdg = new HashSet<String>();
        if (!this.extLists) {
            tempMap.clear();
            tempMap.put((Object)"majorType", (Object)"cdg");
            AnnotationSet nameAnnots = nameAllAnnots.get("Lookup", tempMap);
            if (nameAnnots == null || nameAnnots.isEmpty()) {
                return cdg;
            }
            for (Annotation annot : nameAnnots) {
                Long offsetStartAnnot = annot.getStartNode().getOffset();
                Long offsetEndAnnot = annot.getEndNode().getOffset();
                try {
                    Document doc = nameAllAnnots.getDocument();
                    String annotString = doc.getContent().getContent(offsetStartAnnot, offsetEndAnnot).toString();
                    cdg.add(annotString);
                }
                catch (InvalidOffsetException ioe) {
                    ioe.printStackTrace(Err.getPrintWriter());
                }
            }
        }
        return cdg;
    }

    @Override
    public boolean isUnknownGender(String gender) {
        if (gender == null) {
            return true;
        }
        return !gender.equalsIgnoreCase("male") && !gender.equalsIgnoreCase("female");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Set<String>> initNicknames(String nicknameFileEncoding, URL fileURL) throws IOException {
        Pattern spacePat = Pattern.compile("(\\s+)");
        this.nicknameMap = new HashMap<String, Set<String>>();
        BomStrippingInputStreamReader reader = null;
        try {
            reader = new BomStrippingInputStreamReader(fileURL.openStream(), nicknameFileEncoding);
            String lineRead = null;
            while ((lineRead = reader.readLine()) != null) {
                List<String> nickNameLine;
                if (lineRead.length() == 0 || lineRead.charAt(0) == '#' || (nickNameLine = Arrays.asList(spacePat.split(lineRead.toLowerCase().trim()))).size() != 3 && nickNameLine.size() != 4 && (nickNameLine.get(3) != "M" || nickNameLine.get(3) != "F") || OrthoMatcherHelper.round2Places(Double.valueOf(nickNameLine.get(2))) < OrthoMatcherHelper.round2Places(this.minimumNicknameLikelihood)) continue;
                if (this.nicknameMap.containsKey(nickNameLine.get(0))) {
                    this.nicknameMap.get(nickNameLine.get(0)).add(nickNameLine.get(1));
                    continue;
                }
                this.nicknameMap.put(nickNameLine.get(0), new HashSet<String>(Collections.singleton(nickNameLine.get(1))));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return this.nicknameMap;
    }
}

