/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gate.maven;

import gate.Gate;
import gate.creole.CreoleAnnotationHandler;
import gate.creole.Plugin;
import gate.util.GateClassLoader;
import gate.util.Strings;
import gate.util.asm.ClassReader;
import gate.util.asm.ClassVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

@Mojo(name="DumpCreoleToXML", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DumpCreoleToXML
extends AbstractMojo {
    private XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        File dir = new File(this.project.getBuild().getOutputDirectory());
        File creoleXML = new File(dir, "creole.xml");
        if (creoleXML == null || !creoleXML.exists()) {
            return;
        }
        File expandedXML = new File(dir, "META-INF/gate/creole.xml");
        expandedXML.getParentFile().mkdirs();
        GateClassLoader cl = null;
        try (FileOutputStream fos = new FileOutputStream(expandedXML);){
            Gate.init();
            cl = Gate.getClassLoader().getDisposableClassLoader(dir.toString());
            cl.addURL(dir.toURI().toURL());
            for (Artifact artifact : this.project.getArtifacts()) {
                if ("provided".equals(artifact.getScope()) || "test".equals(artifact.getScope()) || artifact == null || artifact.getFile() == null) continue;
                cl.addURL(artifact.getFile().toURI().toURL());
            }
            TargetPlugin plugin = new TargetPlugin(dir, this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
            CreoleAnnotationHandler annotationHandler = new CreoleAnnotationHandler((Plugin)plugin);
            Document creoleDoc = plugin.getCreoleXML();
            if (this.project.getDescription() != null && !this.project.getDescription().trim().equals("")) {
                creoleDoc.getRootElement().setAttribute("DESCRIPTION", this.project.getDescription());
            }
            if (this.project.getName() != null && !this.project.getName().trim().equals("")) {
                creoleDoc.getRootElement().setAttribute("NAME", this.project.getName());
            } else {
                creoleDoc.getRootElement().setAttribute("NAME", this.project.getArtifactId());
            }
            creoleDoc.getRootElement().setAttribute("VERSION", this.project.getVersion());
            String creoleMinGate = creoleDoc.getRootElement().getAttributeValue("GATE-MIN");
            if (creoleMinGate == null) {
                for (Object obj : this.project.getDependencies()) {
                    Dependency effectiveDependency = (Dependency)obj;
                    if (!effectiveDependency.getGroupId().equals("uk.ac.gate") || !effectiveDependency.getArtifactId().equals("gate-core")) continue;
                    creoleDoc.getRootElement().setAttribute("GATE-MIN", effectiveDependency.getVersion());
                    break;
                }
            }
            for (Plugin required : plugin.getRequiredPlugins()) {
                Gate.getCreoleRegister().registerPlugin(required);
            }
            annotationHandler.processAnnotations(creoleDoc);
            this.outputter.output(creoleDoc, (OutputStream)fos);
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("error expanding creole", e);
            }
            catch (Throwable throwable) {
                Gate.getClassLoader().forgetClassLoader(cl);
                throw throwable;
            }
        }
        Gate.getClassLoader().forgetClassLoader(cl);
    }

    private static class TargetPlugin
    extends Plugin.Maven {
        private File creoleFile;
        private Document parsedCreoleXml;

        public TargetPlugin(File dir, String group, String artifact, String version) throws MalformedURLException {
            super(group, artifact, version);
            this.baseURL = dir.toURI().toURL();
            this.creoleFile = new File(dir, "creole.xml");
        }

        public Document getMetadataXML() throws Exception {
            return this.getCreoleXML();
        }

        public Document getCreoleXML() throws Exception {
            if (this.parsedCreoleXml == null) {
                SAXBuilder builder = new SAXBuilder(false);
                this.parsedCreoleXml = builder.build((InputStream)new FileInputStream(this.creoleFile), this.getBaseURL().toExternalForm());
                Element creoleRoot = this.parsedCreoleXml.getRootElement();
                Comment comment = new Comment("this file is auto-generated, modifications will have no effect");
                creoleRoot.addContent(0, (Content)comment);
                String dir = this.creoleFile.getParent();
                if (!dir.endsWith(File.separator)) {
                    dir = dir + File.separator;
                }
                HashSet<String> resources = new HashSet<String>();
                this.scanDir(dir.length(), this.creoleFile.getParentFile(), resources);
                for (String resource : resources) {
                    Element resourceElement = new Element("RESOURCE");
                    Element classElement = new Element("CLASS");
                    classElement.setText(resource);
                    resourceElement.addContent((Content)classElement);
                    creoleRoot.addContent((Content)resourceElement);
                }
            }
            return this.parsedCreoleXml;
        }

        private void scanDir(int prefix, File dir, Set<String> resources) throws IOException {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    this.scanDir(prefix, file, resources);
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                String className = file.getAbsolutePath().substring(prefix);
                className = className.substring(0, className.length() - 6).replaceAll(Pattern.quote(Strings.getFileSep()), ".");
                ClassReader classReader = new ClassReader((InputStream)new FileInputStream(file));
                Gate.ResourceInfo resInfo = new Gate.ResourceInfo(null, className, null);
                Plugin.ResourceInfoVisitor visitor = new Plugin.ResourceInfoVisitor(resInfo);
                classReader.accept((ClassVisitor)visitor, 7);
                if (!visitor.isCreoleResource()) continue;
                resources.add(className);
            }
        }
    }
}

