/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class TickIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        Object stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -0.0f, -0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 16.0, 16.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -177.65851f, -355.18692f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new GeneralPath();
        shape.moveTo(180.53458, 364.34076);
        shape.quadTo(181.0303, 364.34076, 181.28671, 365.16125);
        shape.quadTo(181.79953, 366.69974, 182.02176, 366.69974);
        shape.quadTo(182.18414, 366.69974, 182.36363, 366.44333);
        shape.quadTo(185.97047, 360.6741, 189.0303, 357.11);
        shape.quadTo(189.82518, 356.18692, 191.56021, 356.18692);
        shape.quadTo(191.97047, 356.18692, 192.10722, 356.26382);
        shape.quadTo(192.25253, 356.34076, 192.25253, 356.45187);
        shape.quadTo(192.25253, 356.63135, 191.82518, 357.16125);
        shape.quadTo(186.87646, 363.11, 182.64569, 369.72537);
        shape.quadTo(182.35509, 370.18692, 181.44057, 370.18692);
        shape.quadTo(180.51749, 370.18692, 180.35509, 370.11);
        shape.quadTo(179.91919, 369.9134, 179.32945, 368.14417);
        shape.quadTo(178.66278, 366.18692, 178.66278, 365.68265);
        shape.quadTo(178.66278, 365.14417, 179.56021, 364.64844);
        shape.quadTo(180.10722, 364.34076, 180.53458, 364.34076);
        shape.closePath();
        paint = TickIcon.getColor(0, 0, 0, 255, disabled);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 2;
    }

    public static int getOrigY() {
        return 1;
    }

    public static int getOrigWidth() {
        return 16;
    }

    public static int getOrigHeight() {
        return 16;
    }

    public TickIcon() {
        this(TickIcon.getOrigWidth(), TickIcon.getOrigHeight(), false);
    }

    public TickIcon(boolean disabled) {
        this(TickIcon.getOrigWidth(), TickIcon.getOrigHeight(), disabled);
    }

    public TickIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public TickIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public TickIcon(int width, int height) {
        this(width, height, false);
    }

    public TickIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)TickIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)TickIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        TickIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

