/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ExitIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 48.0, 48.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.269833f, 0.0f, 0.0f, 1.269833f, -9.24356f, -4.225444f));
        paint = new RadialGradientPaint(new Point2D.Double(25.785715103149414, 23.071428298950195), 18.214285f, new Point2D.Double(25.785715103149414, 23.071428298950195), new float[]{0.0f, 1.0f}, new Color[]{ExitIcon.getColor(0, 0, 0, 255, disabled), ExitIcon.getColor(0, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new GeneralPath();
        shape.moveTo(44.0, 23.071428);
        shape.curveTo(44.0, 33.1309, 35.84519, 41.285713, 25.785715, 41.285713);
        shape.curveTo(15.726243, 41.285713, 7.57143, 33.1309, 7.57143, 23.071428);
        shape.curveTo(7.57143, 13.011956, 15.726243, 4.8571434, 25.785715, 4.8571434);
        shape.curveTo(35.84519, 4.8571434, 44.0, 13.011956, 44.0, 23.071428);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.175715f, 0.0f, 0.0f, 1.175715f, -6.816669f, -3.911156f));
        paint = new LinearGradientPaint(new Point2D.Double(7.1433796882629395, 23.071428298950195), new Point2D.Double(42.47125f, 23.071428298950195), new float[]{0.0f, 0.26988637f, 0.3790031f, 0.75f, 1.0f}, new Color[]{ExitIcon.getColor(238, 238, 236, 255, disabled), ExitIcon.getColor(198, 198, 191, 255, disabled), ExitIcon.getColor(249, 249, 248, 255, disabled), ExitIcon.getColor(200, 200, 194, 255, disabled), ExitIcon.getColor(238, 238, 236, 255, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new GeneralPath();
        shape.moveTo(44.0, 23.071428);
        shape.curveTo(44.0, 33.1309, 35.84519, 41.285713, 25.785715, 41.285713);
        shape.curveTo(15.726243, 41.285713, 7.57143, 33.1309, 7.57143, 23.071428);
        shape.curveTo(7.57143, 13.011956, 15.726243, 4.8571434, 25.785715, 4.8571434);
        shape.curveTo(35.84519, 4.8571434, 44.0, 13.011956, 44.0, 23.071428);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = ExitIcon.getColor(116, 121, 110, 255, disabled);
        stroke = new BasicStroke(0.8505457f, 1, 1, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(44.0, 23.071428);
        shape.curveTo(44.0, 33.1309, 35.84519, 41.285713, 25.785715, 41.285713);
        shape.curveTo(15.726243, 41.285713, 7.57143, 33.1309, 7.57143, 23.071428);
        shape.curveTo(7.57143, 13.011956, 15.726243, 4.8571434, 25.785715, 4.8571434);
        shape.curveTo(35.84519, 4.8571434, 44.0, 13.011956, 44.0, 23.071428);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(1.06849f, 0.0f, 0.0f, 1.06849f, -4.051771f, -2.437299f));
        paint = new RadialGradientPaint(new Point2D.Double(24.67343521118164, 17.224811553955078), 18.672388f, new Point2D.Double(24.67343521118164, 17.224811553955078), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{ExitIcon.getColor(209, 209, 204, 255, disabled), ExitIcon.getColor(209, 209, 209, 255, disabled), ExitIcon.getColor(185, 185, 185, 255, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.364252f, -9.115392E-17f, 9.115392E-17f, 1.364252f, -9.47947f, -5.618016f));
        shape = new GeneralPath();
        shape.moveTo(44.0, 23.071428);
        shape.curveTo(44.0, 33.1309, 35.84519, 41.285713, 25.785715, 41.285713);
        shape.curveTo(15.726243, 41.285713, 7.57143, 33.1309, 7.57143, 23.071428);
        shape.curveTo(7.57143, 13.011956, 15.726243, 4.8571434, 25.785715, 4.8571434);
        shape.curveTo(35.84519, 4.8571434, 44.0, 13.011956, 44.0, 23.071428);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        float alpha__0_0_3 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_3 = g.getClip();
        AffineTransform defaultTransform__0_0_3 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = ExitIcon.getColor(85, 87, 83, 255, disabled);
        stroke = new BasicStroke(3.0f, 1, 0, 10.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(19.1468, 14.674063);
        shape.curveTo(12.154448, 18.4869, 15.316371, 29.412893, 23.310312, 29.412893);
        shape.curveTo(31.220984, 29.412893, 34.76642, 19.054546, 27.473824, 14.674063);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_3;
        g.setTransform(defaultTransform__0_0_3);
        g.setClip(clip__0_0_3);
        float alpha__0_0_4 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_4 = g.getClip();
        AffineTransform defaultTransform__0_0_4 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = ExitIcon.getColor(85, 87, 83, 255, disabled);
        stroke = new BasicStroke(2.999999f, 1, 0, 10.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(23.364832, 19.364035);
        shape.lineTo(23.364832, 11.95091);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_4;
        g.setTransform(defaultTransform__0_0_4);
        g.setClip(clip__0_0_4);
        float alpha__0_0_5 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 0.88235295f));
        Shape clip__0_0_5 = g.getClip();
        AffineTransform defaultTransform__0_0_5 = g.getTransform();
        g.transform(new AffineTransform(1.04555f, 0.0f, 0.0f, 1.04555f, -3.460245f, -1.908039f));
        paint = new LinearGradientPaint(new Point2D.Double(25.785715103149414, 21.978363037109375), new Point2D.Double(25.785715103149414, 8.588278770446777), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{ExitIcon.getColor(255, 255, 255, 255, disabled), ExitIcon.getColor(255, 255, 255, 0, disabled), ExitIcon.getColor(255, 255, 255, 255, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        stroke = new BasicStroke(0.9564345f, 1, 1, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(44.0, 23.071428);
        shape.curveTo(44.0, 33.1309, 35.84519, 41.285713, 25.785715, 41.285713);
        shape.curveTo(15.726243, 41.285713, 7.57143, 33.1309, 7.57143, 23.071428);
        shape.curveTo(7.57143, 13.011956, 15.726243, 4.8571434, 25.785715, 4.8571434);
        shape.curveTo(35.84519, 4.8571434, 44.0, 13.011956, 44.0, 23.071428);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_5;
        g.setTransform(defaultTransform__0_0_5);
        g.setClip(clip__0_0_5);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 1;
    }

    public static int getOrigY() {
        return 2;
    }

    public static int getOrigWidth() {
        return 48;
    }

    public static int getOrigHeight() {
        return 48;
    }

    public ExitIcon() {
        this(ExitIcon.getOrigWidth(), ExitIcon.getOrigHeight(), false);
    }

    public ExitIcon(boolean disabled) {
        this(ExitIcon.getOrigWidth(), ExitIcon.getOrigHeight(), disabled);
    }

    public ExitIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public ExitIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public ExitIcon(int width, int height) {
        this(width, height, false);
    }

    public ExitIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)ExitIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)ExitIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        ExitIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

