/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.teamware;

import gate.Controller;
import gate.gui.teamware.AnnotationSetNameCellRenderer;
import gate.gui.teamware.AnnotationSetNameComboEditor;
import gate.gui.teamware.TeamwareUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InputOutputAnnotationSetsDialog {
    private Controller controller;
    private JPanel panel;
    private AnnotationSetsList inputList;
    private Set<String> inputSetNames;
    private AnnotationSetsList outputList;
    private Set<String> outputSetNames;
    private static final Comparator<String> NATURAL_COMPARATOR = new NaturalComparator();

    public InputOutputAnnotationSetsDialog(Controller controller) {
        this.controller = controller;
        this.initGuiComponents();
    }

    protected void initGuiComponents() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(1, 2, 5, 5));
        this.inputSetNames = TeamwareUtils.getInputAnnotationSets(this.controller);
        this.outputSetNames = TeamwareUtils.getOutputAnnotationSets(this.controller);
        Set<String> likelyInputSetNames = TeamwareUtils.getLikelyInputAnnotationSets(this.controller);
        Set<String> likelyOutputSetNames = TeamwareUtils.getLikelyOutputAnnotationSets(this.controller);
        this.inputList = new AnnotationSetsList(likelyInputSetNames, this.inputSetNames);
        this.outputList = new AnnotationSetsList(likelyOutputSetNames, this.outputSetNames);
        this.inputList.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input annotation sets"));
        this.outputList.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output annotation sets"));
        this.panel.add(this.inputList);
        this.panel.add(this.outputList);
    }

    public boolean showDialog(Component parent) {
        int selectedOption = JOptionPane.showConfirmDialog(parent, this.panel, "Select input and output annotation sets", 2, -1);
        if (selectedOption == 0) {
            int i;
            this.inputSetNames.clear();
            for (i = 0; i < this.inputList.listModel.size(); ++i) {
                this.inputSetNames.add((String)this.inputList.listModel.get(i));
            }
            this.outputSetNames.clear();
            for (i = 0; i < this.outputList.listModel.size(); ++i) {
                this.outputSetNames.add((String)this.outputList.listModel.get(i));
            }
            return true;
        }
        return false;
    }

    protected static class NaturalComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = -7376222886417999334L;

        protected NaturalComparator() {
        }

        @Override
        public int compare(String a, String b) {
            if (a == null) {
                if (b == null) {
                    return 0;
                }
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return a.compareTo(b);
        }
    }

    static class AnnotationSetsList
    extends JPanel {
        private JList<String> annotationSetsList;
        private DefaultListModel<String> listModel;
        private JComboBox<String> combo;
        private JButton addButton;
        private JButton removeButton;

        AnnotationSetsList(Collection<String> hintSetNames, Collection<String> initialSetNames) {
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.ipady = 2;
            c.weightx = 1.0;
            String[] hintSetNamesArray = hintSetNames.toArray(new String[hintSetNames.size()]);
            Arrays.sort(hintSetNamesArray, NATURAL_COMPARATOR);
            this.combo = new JComboBox<String>(hintSetNamesArray);
            this.combo.setEditable(true);
            this.combo.setEditor(new AnnotationSetNameComboEditor(this.combo.getEditor()));
            this.combo.setRenderer(new AnnotationSetNameCellRenderer());
            c.fill = 2;
            this.add(this.combo, c);
            AddAction addAction = new AddAction();
            RemoveAction removeAction = new RemoveAction();
            Box buttonsBox = Box.createHorizontalBox();
            buttonsBox.add(Box.createHorizontalGlue());
            this.addButton = new JButton(addAction);
            buttonsBox.add(this.addButton);
            buttonsBox.add(Box.createHorizontalStrut(5));
            this.removeButton = new JButton(removeAction);
            buttonsBox.add(this.removeButton);
            buttonsBox.add(Box.createHorizontalGlue());
            this.add((Component)buttonsBox, c);
            this.listModel = new DefaultListModel();
            String[] initialSetNamesArray = initialSetNames.toArray(new String[initialSetNames.size()]);
            Arrays.sort(initialSetNamesArray, NATURAL_COMPARATOR);
            for (String name : initialSetNamesArray) {
                this.listModel.addElement(name);
            }
            this.annotationSetsList = new JList<String>(this.listModel);
            this.annotationSetsList.setCellRenderer(new AnnotationSetNameCellRenderer());
            c.fill = 1;
            c.weighty = 1.0;
            this.add((Component)new JScrollPane(this.annotationSetsList), c);
        }

        protected class RemoveAction
        extends AbstractAction {
            RemoveAction() {
                super("Remove");
                this.putValue("ShortDescription", "Remove the selected value(s) from the list");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = AnnotationSetsList.this.annotationSetsList.getSelectedIndices();
                Arrays.sort(indices);
                for (int i = indices.length - 1; i >= 0; --i) {
                    AnnotationSetsList.this.listModel.remove(indices[i]);
                }
            }
        }

        protected class AddAction
        extends AbstractAction {
            AddAction() {
                super("Add");
                this.putValue("ShortDescription", "Add the edited value to the list");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                String selected = (String)AnnotationSetsList.this.combo.getSelectedItem();
                for (index = 0; index < AnnotationSetsList.this.listModel.size() && NATURAL_COMPARATOR.compare(AnnotationSetsList.this.listModel.get(index), selected) < 0; ++index) {
                }
                if (index == AnnotationSetsList.this.listModel.size()) {
                    AnnotationSetsList.this.listModel.addElement(selected);
                } else if (NATURAL_COMPARATOR.compare(AnnotationSetsList.this.listModel.get(index), selected) != 0) {
                    AnnotationSetsList.this.listModel.add(index, selected);
                }
            }
        }
    }
}

