/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.creole.manager;

import gate.Gate;
import gate.creole.Plugin;
import gate.resources.img.svg.DownloadIcon;
import gate.resources.img.svg.ProgressIcon;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ProgressPanel
extends JPanel
implements ComponentListener,
Plugin.DownloadListener {
    private Map<String, JProgressBar> progressMapping = new HashMap<String, JProgressBar>();
    private JProgressBar progressTotal;
    private JLabel message;
    private JLabel dlMsg;
    private JScrollPane scroller;
    private JPanel partProgress;

    public ProgressPanel() {
        this.setLayout(new BoxLayout(this, 1));
        int width = 400;
        this.progressTotal = new SafeJProgressBar();
        this.progressTotal.setAlignmentX(0.5f);
        this.progressTotal.setMaximumSize(new Dimension(width, this.progressTotal.getPreferredSize().height));
        this.progressTotal.setIndeterminate(true);
        this.message = new JLabel("");
        this.message.setIcon(new ProgressIcon(48, 48));
        this.message.setHorizontalTextPosition(4);
        this.message.setHorizontalAlignment(0);
        this.message.setAlignmentX(0.5f);
        this.dlMsg = new JLabel("Downloading CREOLE Plugin...");
        this.dlMsg.setIcon(new DownloadIcon(48, 48));
        this.dlMsg.setHorizontalTextPosition(4);
        this.dlMsg.setHorizontalAlignment(0);
        this.dlMsg.setAlignmentX(0.5f);
        this.dlMsg.setVisible(false);
        this.partProgress = new JPanel();
        this.partProgress.setLayout(new BoxLayout(this.partProgress, 1));
        this.scroller = new JScrollPane(this.partProgress);
        this.scroller.setAlignmentX(0.5f);
        this.scroller.setMaximumSize(new Dimension(width, this.progressTotal.getPreferredSize().height * 6));
        this.scroller.setPreferredSize(new Dimension(width, this.progressTotal.getPreferredSize().height * 6));
        this.add(Box.createVerticalGlue());
        this.add(this.message);
        this.add(Box.createVerticalStrut(5));
        this.add(this.progressTotal);
        this.add(Box.createVerticalStrut(10));
        this.add(this.dlMsg);
        this.add(Box.createVerticalStrut(5));
        this.add(this.scroller);
        this.add(Box.createVerticalGlue());
        this.addComponentListener(this);
    }

    public void rangeChanged(final int min, final int max) {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                ProgressPanel.this.progressTotal.setMinimum(min);
                ProgressPanel.this.progressTotal.setMaximum(max);
                ProgressPanel.this.progressTotal.setIndeterminate(min == max);
            }
        });
    }

    public void reset() {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                ProgressPanel.this.progressTotal.setMinimum(0);
                ProgressPanel.this.progressTotal.setMaximum(0);
                ProgressPanel.this.progressTotal.setIndeterminate(true);
                ProgressPanel.this.partProgress.removeAll();
                ProgressPanel.this.partProgress.validate();
                ProgressPanel.this.progressMapping.clear();
            }
        });
    }

    public void messageChanged(final String newMessage) {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                ProgressPanel.this.message.setText("<html><body>" + newMessage + "</body></html>");
            }
        });
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int width = Math.min(400, (int)((float)this.getSize().width * 0.6666667f));
        this.progressTotal.setMaximumSize(new Dimension(width, this.progressTotal.getPreferredSize().height));
        this.scroller.setMaximumSize(new Dimension(width, this.progressTotal.getPreferredSize().height * 6));
        this.scroller.setPreferredSize(new Dimension(width, this.progressTotal.getPreferredSize().height * 6));
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.componentResized(e);
    }

    @Override
    public void downloadStarted(String name) {
    }

    @Override
    public void downloadProgressed(final String name, final long totalBytes, final long transferredBytes) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JProgressBar progressBar = (JProgressBar)ProgressPanel.this.progressMapping.get(name);
                if (progressBar == null) {
                    progressBar = new JProgressBar(0);
                    progressBar.setMinimum(0);
                    progressBar.setMaximum(100);
                    progressBar.setValue(0);
                    progressBar.setStringPainted(true);
                    progressBar.setString(name);
                    progressBar.setIndeterminate(true);
                    ProgressPanel.this.progressMapping.put(name, progressBar);
                    ProgressPanel.this.partProgress.add(progressBar);
                    ProgressPanel.this.partProgress.validate();
                }
                if (totalBytes > 0L && transferredBytes > 0L) {
                    progressBar.setIndeterminate(false);
                    progressBar.setString(name + ": " + (int)Math.floor(transferredBytes * 100L / totalBytes) + "%");
                    progressBar.setValue((int)Math.floor(transferredBytes * 100L / totalBytes));
                }
            }
        });
    }

    @Override
    public void downloadSucceeded(String name) {
    }

    @Override
    public void downloadFailed(String name, Throwable cause) {
    }

    private static class SafeJProgressBar
    extends JProgressBar {
        private SafeJProgressBar() {
        }

        @Override
        public void setIndeterminate(boolean indeterminate) {
            if (Gate.runningOnMac() && (UIManager.getLookAndFeel() == null || UIManager.getLookAndFeel().getClass().getName().equals(UIManager.getSystemLookAndFeelClassName()))) {
                return;
            }
            super.setIndeterminate(indeterminate);
        }
    }
}

