/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.creole.BootStrap;
import gate.gui.MainFrame;
import gate.util.Err;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class BootStrapDialog
extends JDialog {
    MainFrame mainFrame = null;
    BootStrapDialog thisBootStrapDialog = null;
    BootStrap bootStrapWizard = null;
    String resourceName = null;
    String packageName = null;
    String resourceType = null;
    Map<String, String> resourceTypes = null;
    String className = null;
    Set<String> resourceInterfaces = null;
    String possibleInterfaces = null;
    String pathNewProject = null;
    JLabel resourceNameLabel = null;
    JTextField resourceNameTextField = null;
    JLabel packageNameLabel = null;
    JTextField packageNameTextField = null;
    JLabel resourceTypesLabel = null;
    JComboBox<String> resourceTypesComboBox = null;
    JLabel classNameLabel = null;
    JTextField classNameTextField = null;
    JLabel interfacesLabel = null;
    JTextField interfacesTextField = null;
    JLabel chooseFolderLabel = null;
    JTextField chooseFolderTextField = null;
    JButton chooseFolderButton = null;
    JButton createResourceButton = null;
    JButton cancelButton = null;
    JButton helpButton = null;
    JFileChooser fileChooser = null;

    public BootStrapDialog(MainFrame aMainFrame) {
        super(aMainFrame);
        this.mainFrame = aMainFrame;
        this.thisBootStrapDialog = this;
        this.setTitle("BootStrap Wizard");
        this.setDefaultCloseOperation(2);
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
    }

    private void doCreateResource() {
        this.resourceName = this.resourceNameTextField.getText();
        if (this.resourceName == null || "".equals(this.resourceName)) {
            this.thisBootStrapDialog.setModal(false);
            JOptionPane.showMessageDialog(this.mainFrame, "A name for the resource must be provided", "ERROR !", 0);
            this.thisBootStrapDialog.setModal(true);
            return;
        }
        this.packageName = this.packageNameTextField.getText();
        if (this.packageName == null || "".equals(this.packageName)) {
            this.thisBootStrapDialog.setModal(false);
            JOptionPane.showMessageDialog(this.mainFrame, "A package name must be provided", "ERROR !", 0);
            this.thisBootStrapDialog.setModal(true);
            return;
        }
        this.className = this.classNameTextField.getText();
        if (this.className == null || "".equals(this.className)) {
            this.thisBootStrapDialog.setModal(false);
            JOptionPane.showMessageDialog(this.mainFrame, "A name for the implementing class must be provided", "ERROR !", 0);
            this.thisBootStrapDialog.setModal(true);
            return;
        }
        this.pathNewProject = this.chooseFolderTextField.getText();
        if (this.pathNewProject == null || "".equals(this.pathNewProject)) {
            this.thisBootStrapDialog.setModal(false);
            JOptionPane.showMessageDialog(this.mainFrame, "A path to the creation folder must be provided", "ERROR !", 0);
            this.thisBootStrapDialog.setModal(true);
            return;
        }
        this.resourceType = (String)this.resourceTypesComboBox.getSelectedItem();
        this.resourceInterfaces = this.getSelectedInterfaces();
        Thread thread = new Thread(Thread.currentThread().getThreadGroup(), new CreateResourceRunner(), "BootstrapDialog1");
        thread.setPriority(1);
        thread.start();
    }

    public void initLocalData() {
        this.pathNewProject = ".";
        this.resourceTypes = new HashMap<String, String>();
        this.resourceTypes.put("LanguageResource", "gate.LanguageResource");
        this.resourceTypes.put("VisualResource", "gate.VisualResource");
        this.resourceTypes.put("ProcessingResource", "gate.ProcessingResource");
        this.possibleInterfaces = this.resourceTypes.get("LanguageResource");
        if (this.possibleInterfaces == null) {
            this.possibleInterfaces = "";
        }
    }

    public void initGuiComponents() {
        Point ownerLocation;
        Dimension ownerSize;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setModal(true);
        this.resourceNameLabel = new JLabel("Resource name, e.g. myMorph");
        this.resourceNameLabel.setToolTipText("The name of the resource you want to create");
        this.resourceNameLabel.setOpaque(true);
        this.resourceNameLabel.setAlignmentX(0.0f);
        this.resourceNameTextField = new JTextField();
        this.resourceNameTextField.setAlignmentX(0.0f);
        this.resourceNameTextField.setColumns(40);
        Dimension dim = new Dimension(this.resourceNameTextField.getPreferredSize().width, this.resourceNameTextField.getPreferredSize().height);
        this.resourceNameTextField.setPreferredSize(dim);
        this.resourceNameTextField.setMinimumSize(dim);
        this.packageNameLabel = new JLabel("Resource package, e.g. sheffield.creole.morph");
        this.packageNameLabel.setToolTipText("The Java package of the resource you want to create");
        this.packageNameLabel.setOpaque(true);
        this.packageNameLabel.setAlignmentX(0.0f);
        this.packageNameTextField = new JTextField();
        this.packageNameTextField.setAlignmentX(0.0f);
        this.packageNameTextField.setColumns(40);
        dim = new Dimension(this.packageNameTextField.getPreferredSize().width, this.packageNameTextField.getPreferredSize().height);
        this.packageNameTextField.setPreferredSize(dim);
        this.packageNameTextField.setMinimumSize(dim);
        this.resourceTypesLabel = new JLabel("Resource type");
        this.resourceTypesLabel.setToolTipText("Resources must be LRs, PRs or VRs");
        this.resourceTypesLabel.setOpaque(true);
        this.resourceTypesLabel.setAlignmentX(0.0f);
        Vector<String> comboCont = new Vector<String>(this.resourceTypes.keySet());
        Collections.sort(comboCont);
        this.resourceTypesComboBox = new JComboBox<String>(comboCont);
        this.resourceTypesComboBox.setEditable(false);
        this.resourceTypesComboBox.setAlignmentX(0.0f);
        this.classNameLabel = new JLabel("Implementing class name, e.g. Morpher");
        this.classNameLabel.setToolTipText("The name of the class that impements this resource");
        this.classNameLabel.setOpaque(true);
        this.classNameLabel.setAlignmentX(0.0f);
        this.classNameTextField = new JTextField();
        this.classNameTextField.setAlignmentX(0.0f);
        this.classNameTextField.setColumns(40);
        dim = new Dimension(this.classNameTextField.getPreferredSize().width, this.classNameTextField.getPreferredSize().height);
        this.classNameTextField.setPreferredSize(dim);
        this.classNameTextField.setMinimumSize(dim);
        this.interfacesLabel = new JLabel("Interfaces implemented");
        this.interfacesLabel.setToolTipText("Any additional interfaces implemented, separated by comma");
        this.interfacesLabel.setOpaque(true);
        this.interfacesLabel.setAlignmentX(0.0f);
        this.interfacesTextField = new JTextField(this.possibleInterfaces);
        this.interfacesTextField.setAlignmentX(0.0f);
        this.interfacesTextField.setColumns(40);
        dim = new Dimension(this.interfacesTextField.getPreferredSize().width, this.interfacesTextField.getPreferredSize().height);
        this.interfacesTextField.setPreferredSize(dim);
        this.interfacesTextField.setMinimumSize(dim);
        this.chooseFolderLabel = new JLabel("Create in folder ...");
        this.chooseFolderLabel.setOpaque(true);
        this.chooseFolderLabel.setAlignmentX(0.0f);
        this.chooseFolderLabel.setToolTipText("Select the name of the folder where you want the resource to be created.");
        this.chooseFolderButton = new JButton("Browse");
        this.chooseFolderButton.setAlignmentX(0.0f);
        this.chooseFolderTextField = new JTextField();
        this.chooseFolderTextField.setAlignmentX(0.0f);
        this.chooseFolderTextField.setColumns(35);
        dim = new Dimension(this.chooseFolderTextField.getPreferredSize().width, this.chooseFolderTextField.getPreferredSize().height);
        this.chooseFolderTextField.setPreferredSize(dim);
        this.chooseFolderTextField.setMinimumSize(dim);
        this.createResourceButton = new JButton("Finish");
        this.getRootPane().setDefaultButton(this.createResourceButton);
        this.cancelButton = new JButton("Cancel");
        this.helpButton = new JButton("Help");
        this.fileChooser = new JFileChooser();
        Box mainBox = new Box(1);
        Box currentBox = new Box(1);
        currentBox.add(this.resourceNameLabel);
        currentBox.add(this.resourceNameTextField);
        mainBox.add(currentBox);
        mainBox.add(Box.createRigidArea(new Dimension(0, 10)));
        currentBox = new Box(1);
        currentBox.add(this.packageNameLabel);
        currentBox.add(this.packageNameTextField);
        mainBox.add(currentBox);
        mainBox.add(Box.createRigidArea(new Dimension(0, 10)));
        currentBox = new Box(1);
        currentBox.add(this.resourceTypesLabel);
        currentBox.add(this.resourceTypesComboBox);
        mainBox.add(currentBox);
        mainBox.add(Box.createRigidArea(new Dimension(0, 10)));
        currentBox = new Box(1);
        currentBox.add(this.classNameLabel);
        currentBox.add(this.classNameTextField);
        mainBox.add(currentBox);
        mainBox.add(Box.createRigidArea(new Dimension(0, 10)));
        currentBox = new Box(1);
        currentBox.add(this.interfacesLabel);
        currentBox.add(this.interfacesTextField);
        mainBox.add(currentBox);
        mainBox.add(Box.createRigidArea(new Dimension(0, 10)));
        currentBox = new Box(1);
        currentBox.add(this.chooseFolderLabel);
        JPanel tmpBox = new JPanel();
        tmpBox.setLayout(new BoxLayout(tmpBox, 0));
        tmpBox.setAlignmentX(0.0f);
        tmpBox.add(this.chooseFolderTextField);
        tmpBox.add(this.chooseFolderButton);
        currentBox.add(tmpBox);
        mainBox.add(currentBox);
        mainBox.add(Box.createRigidArea(new Dimension(0, 20)));
        tmpBox = new JPanel();
        tmpBox.setLayout(new BoxLayout(tmpBox, 0));
        tmpBox.setAlignmentX(0.0f);
        tmpBox.add(Box.createHorizontalGlue());
        tmpBox.add(this.createResourceButton);
        tmpBox.add(Box.createRigidArea(new Dimension(25, 0)));
        tmpBox.add(this.cancelButton);
        tmpBox.add(Box.createRigidArea(new Dimension(25, 0)));
        tmpBox.add(this.helpButton);
        tmpBox.add(Box.createHorizontalGlue());
        mainBox.add(tmpBox);
        this.getContentPane().add(Box.createVerticalGlue());
        this.getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
        this.getContentPane().add(mainBox);
        this.getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
        this.getContentPane().add(Box.createVerticalGlue());
        this.pack();
        if (this.getOwner() == null) {
            ownerSize = Toolkit.getDefaultToolkit().getScreenSize();
            ownerLocation = new Point(0, 0);
        } else {
            ownerSize = this.getOwner().getSize();
            ownerLocation = this.getOwner().getLocation();
            if (ownerSize.height == 0 || ownerSize.width == 0 || !this.getOwner().isVisible()) {
                ownerSize = Toolkit.getDefaultToolkit().getScreenSize();
                ownerLocation = new Point(0, 0);
            }
        }
        Dimension frameSize = this.getSize();
        if (frameSize.height > ownerSize.height) {
            frameSize.height = ownerSize.height;
        }
        if (frameSize.width > ownerSize.width) {
            frameSize.width = ownerSize.width;
        }
        this.setLocation(ownerLocation.x + (ownerSize.width - frameSize.width) / 2, ownerLocation.y + (ownerSize.height - frameSize.height) / 2);
    }

    public void initListeners() {
        this.createResourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BootStrapDialog.this.doCreateResource();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BootStrapDialog.this.thisBootStrapDialog.setVisible(false);
                BootStrapDialog.this.dispose();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().showHelpFrame("http://gate.ac.uk/userguide/sec:api:bootstrap", "gate.gui.BootStrapDialog");
            }
        });
        this.resourceTypesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedItem = (String)BootStrapDialog.this.resourceTypesComboBox.getSelectedItem();
                BootStrapDialog.this.possibleInterfaces = BootStrapDialog.this.resourceTypes.get(selectedItem);
                BootStrapDialog.this.interfacesTextField.setText(BootStrapDialog.this.possibleInterfaces);
            }
        });
        this.chooseFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BootStrapDialog.this.fileChooser.setDialogTitle("Select the path for this resource");
                BootStrapDialog.this.fileChooser.setFileSelectionMode(1);
                if (BootStrapDialog.this.fileChooser.showOpenDialog(BootStrapDialog.this.mainFrame) == 0) {
                    BootStrapDialog.this.pathNewProject = BootStrapDialog.this.fileChooser.getSelectedFile().toString();
                    BootStrapDialog.this.fileChooser.setCurrentDirectory(BootStrapDialog.this.fileChooser.getCurrentDirectory());
                }
                BootStrapDialog.this.chooseFolderTextField.setText(BootStrapDialog.this.pathNewProject);
            }
        });
        InputMap inputMap = ((JComponent)this.getContentPane()).getInputMap(2);
        ActionMap actionMap = ((JComponent)this.getContentPane()).getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "Apply");
        actionMap.put("Apply", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BootStrapDialog.this.createResourceButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "Cancel");
        actionMap.put("Cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BootStrapDialog.this.cancelButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("F1"), "Help");
        actionMap.put("Help", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BootStrapDialog.this.helpButton.doClick();
            }
        });
    }

    public Set<String> getSelectedInterfaces() {
        String interfaces = this.interfacesTextField.getText();
        this.resourceInterfaces = new HashSet<String>();
        if (interfaces == null || "".equals(interfaces)) {
            return this.resourceInterfaces;
        }
        StringTokenizer tokenizer = new StringTokenizer(interfaces, ",");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            this.resourceInterfaces.add(token);
        }
        return this.resourceInterfaces;
    }

    class CreateResourceRunner
    implements Runnable {
        @Override
        public void run() {
            try {
                BootStrapDialog.this.bootStrapWizard = new BootStrap();
                BootStrapDialog.this.bootStrapWizard.createResource(BootStrapDialog.this.resourceName, BootStrapDialog.this.packageName, BootStrapDialog.this.resourceType, BootStrapDialog.this.className, BootStrapDialog.this.resourceInterfaces, BootStrapDialog.this.pathNewProject);
                BootStrapDialog.this.thisBootStrapDialog.setVisible(false);
                BootStrapDialog.this.thisBootStrapDialog.dispose();
                JOptionPane.showMessageDialog(BootStrapDialog.this.mainFrame, BootStrapDialog.this.resourceName + " creation succeeded !\nLook for it in " + BootStrapDialog.this.pathNewProject, "DONE !", -1);
            }
            catch (Exception e) {
                BootStrapDialog.this.thisBootStrapDialog.setModal(false);
                e.printStackTrace(Err.getPrintWriter());
                JOptionPane.showMessageDialog(BootStrapDialog.this.mainFrame, e.getMessage() + "\n Resource creation stopped !", "BootStrap error !", 0);
                BootStrapDialog.this.thisBootStrapDialog.setModal(true);
            }
        }
    }
}

