/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.store;

import gate.creole.annic.apache.lucene.index.IndexWriter;
import java.io.IOException;

public abstract class Lock {
    public static final long LOCK_POLL_INTERVAL = 1000L;

    public abstract boolean obtain() throws IOException;

    public boolean obtain(long lockWaitTimeout) throws IOException {
        boolean locked = this.obtain();
        int maxSleepCount = (int)(lockWaitTimeout / 1000L);
        int sleepCount = 0;
        while (!locked) {
            if (++sleepCount == maxSleepCount) {
                throw new IOException("Lock obtain timed out: " + this.toString());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new IOException(e.toString());
            }
            locked = this.obtain();
        }
        return locked;
    }

    public abstract void release();

    public abstract boolean isLocked();

    public static abstract class With {
        private Lock lock;
        private long lockWaitTimeout;

        @Deprecated
        public With(Lock lock) {
            this(lock, IndexWriter.COMMIT_LOCK_TIMEOUT);
        }

        public With(Lock lock, long lockWaitTimeout) {
            this.lock = lock;
            this.lockWaitTimeout = lockWaitTimeout;
        }

        protected abstract Object doBody() throws IOException;

        public Object run() throws IOException {
            boolean locked = false;
            try {
                locked = this.lock.obtain(this.lockWaitTimeout);
                Object object = this.doBody();
                return object;
            }
            finally {
                if (locked) {
                    this.lock.release();
                }
            }
        }
    }
}

