/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic;

import gate.creole.annic.Hit;
import gate.creole.annic.PatternAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Pattern
extends Hit {
    private static final long serialVersionUID = 3258126955659604530L;
    protected int leftContextStartOffset;
    protected int rightContextEndOffset;
    protected String patternText;
    protected List<PatternAnnotation> annotations;

    public Pattern(String docID, String annotationSetName, String patternText, int startOffset, int endOffset, int leftContextStartOffset, int rightContextEndOffset, List<PatternAnnotation> annotations, String queryString) {
        super(docID, annotationSetName, startOffset, endOffset, queryString);
        this.patternText = patternText;
        this.leftContextStartOffset = leftContextStartOffset;
        this.rightContextEndOffset = rightContextEndOffset;
        this.annotations = annotations;
    }

    public List<PatternAnnotation> getPatternAnnotations(int startOffset, int endOffset) {
        ArrayList<PatternAnnotation> annots = new ArrayList<PatternAnnotation>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            PatternAnnotation ga1 = this.annotations.get(i);
            if (ga1.getStartOffset() < startOffset || ga1.getEndOffset() > endOffset) continue;
            annots.add(ga1);
        }
        return annots;
    }

    public PatternAnnotation[] getPatternAnnotations() {
        return this.annotations.toArray(new PatternAnnotation[0]);
    }

    public PatternAnnotation[] getPatternAnnotations(String type) {
        ArrayList<PatternAnnotation> annots = new ArrayList<PatternAnnotation>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            PatternAnnotation ga1 = this.annotations.get(i);
            if (!ga1.getType().equals(type)) continue;
            annots.add(ga1);
        }
        return annots.toArray(new PatternAnnotation[0]);
    }

    public PatternAnnotation[] getPatternAnnotations(String type, String feature) {
        ArrayList<PatternAnnotation> annots = new ArrayList<PatternAnnotation>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Map<String, String> features;
            PatternAnnotation ga1 = this.annotations.get(i);
            if (!ga1.getType().equals(type) || (features = ga1.getFeatures()) == null || !features.keySet().contains(feature)) continue;
            annots.add(ga1);
        }
        return annots.toArray(new PatternAnnotation[0]);
    }

    public String getPatternText() {
        return this.patternText;
    }

    public String getPatternText(int startOffset, int endOffset) {
        return this.patternText.substring(startOffset - this.leftContextStartOffset, endOffset - this.leftContextStartOffset);
    }

    public int getLeftContextStartOffset() {
        return this.leftContextStartOffset;
    }

    public int getRightContextEndOffset() {
        return this.rightContextEndOffset;
    }
}

