/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Annotation;
import gate.AnnotationSet;
import gate.FeatureMap;
import gate.Gate;
import gate.TextualDocument;
import gate.event.StatusListener;
import gate.util.Err;
import gate.util.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class DocumentXmlUtils {
    public static final int DOC_SIZE_MULTIPLICATION_FACTOR = 40;
    public static final Map<Character, String> entitiesMap = new HashMap<Character, String>();

    public static String toXml(TextualDocument doc) {
        StringBuffer xmlContent = new StringBuffer(40 * doc.getContent().size().intValue());
        xmlContent.append("<?xml version=\"1.0\" encoding=\"");
        xmlContent.append(doc.getEncoding());
        xmlContent.append("\" ?>");
        xmlContent.append(Strings.getNl());
        xmlContent.append("<GateDocument>\n");
        xmlContent.append("<!-- The document's features-->\n\n");
        xmlContent.append("<GateDocumentFeatures>\n");
        xmlContent.append(DocumentXmlUtils.featuresToXml(doc.getFeatures(), null));
        xmlContent.append("</GateDocumentFeatures>\n");
        xmlContent.append("<!-- The document content area with serialized nodes -->\n\n");
        xmlContent.append("<TextWithNodes>");
        xmlContent.append(DocumentXmlUtils.textWithNodes(doc, doc.getContent().toString()));
        xmlContent.append("</TextWithNodes>\n");
        StatusListener sListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
        if (sListener != null) {
            sListener.statusChanged("Saving the default annotation set ");
        }
        xmlContent.append("<!-- The default annotation set -->\n\n");
        DocumentXmlUtils.annotationSetToXml(doc.getAnnotations(), xmlContent);
        Map<String, AnnotationSet> namedAnnotSets = doc.getNamedAnnotationSets();
        if (namedAnnotSets != null) {
            for (AnnotationSet annotSet : namedAnnotSets.values()) {
                xmlContent.append("<!-- Named annotation set -->\n\n");
                if (sListener != null) {
                    sListener.statusChanged("Saving " + annotSet.getName() + " annotation set ");
                }
                DocumentXmlUtils.annotationSetToXml(annotSet, xmlContent);
            }
        }
        xmlContent.append("</GateDocument>");
        if (sListener != null) {
            sListener.statusChanged("Done !");
        }
        return xmlContent.toString();
    }

    public static StringBuffer featuresToXml(FeatureMap aFeatureMap, Map<String, StringBuffer> normalizedFeatureNames) {
        if (aFeatureMap == null) {
            return new StringBuffer();
        }
        StringBuffer buffer = new StringBuffer(1024);
        Set keySet = aFeatureMap.keySet();
        for (Object key : keySet) {
            Iterator iter;
            Object value = aFeatureMap.get(key);
            if (key == null || value == null) continue;
            String keyClassName = null;
            String keyItemClassName = null;
            String valueClassName = null;
            String valueItemClassName = null;
            String key2String = key.toString();
            String value2String = value.toString();
            Object item = null;
            if (key instanceof String || key instanceof Number || key instanceof Collection) {
                keyClassName = key.getClass().getName();
            }
            if (value instanceof String || value instanceof Number || value instanceof Collection) {
                valueClassName = value.getClass().getName();
            }
            if (keyClassName == null || valueClassName == null) continue;
            if (key instanceof Collection) {
                StringBuffer keyStrBuff = new StringBuffer();
                iter = ((Collection)key).iterator();
                if (iter.hasNext()) {
                    item = iter.next();
                    keyItemClassName = item instanceof Number ? item.getClass().getName() : String.class.getName();
                    keyStrBuff.append(item.toString());
                }
                while (iter.hasNext()) {
                    item = iter.next();
                    keyStrBuff.append(";").append(item.toString());
                }
                key2String = keyStrBuff.toString();
            }
            if (value instanceof Collection) {
                StringBuffer valueStrBuff = new StringBuffer();
                iter = ((Collection)value).iterator();
                if (iter.hasNext()) {
                    item = iter.next();
                    valueItemClassName = item instanceof Number ? item.getClass().getName() : String.class.getName();
                    valueStrBuff.append(item.toString());
                }
                while (iter.hasNext()) {
                    item = iter.next();
                    valueStrBuff.append(";").append(item.toString());
                }
                value2String = valueStrBuff.toString();
            }
            buffer.append("<Feature>\n  <Name");
            if (keyClassName != null) {
                buffer.append(" className=\"").append(keyClassName).append("\"");
            }
            if (keyItemClassName != null) {
                buffer.append(" itemClassName=\"").append(keyItemClassName).append("\"");
            }
            buffer.append(">");
            StringBuffer normalizedKey = new StringBuffer(key2String);
            if (normalizedFeatureNames != null) {
                normalizedKey = normalizedFeatureNames.get(key2String);
                if (normalizedKey == null) {
                    normalizedKey = DocumentXmlUtils.combinedNormalisation(key2String);
                    normalizedFeatureNames.put(key2String, normalizedKey);
                }
            } else {
                normalizedKey = DocumentXmlUtils.combinedNormalisation(key2String);
            }
            buffer.append(normalizedKey);
            buffer.append("</Name>\n  <Value");
            if (valueClassName != null) {
                buffer.append(" className=\"").append(valueClassName).append("\"");
            }
            if (valueItemClassName != null) {
                buffer.append(" itemClassName=\"").append(valueItemClassName).append("\"");
            }
            buffer.append(">");
            buffer.append(DocumentXmlUtils.combinedNormalisation(value2String));
            buffer.append("</Value>\n</Feature>\n");
        }
        return buffer;
    }

    public static StringBuffer combinedNormalisation(String inputString) {
        if (inputString == null) {
            return new StringBuffer("");
        }
        StringBuffer buffer = new StringBuffer(inputString);
        for (int i = buffer.length() - 1; i >= 0; --i) {
            char currentchar = buffer.charAt(i);
            if (!DocumentXmlUtils.isXmlChar(currentchar)) {
                buffer.replace(i, i + 1, " ");
                continue;
            }
            if (currentchar != '<' && currentchar != '>' && currentchar != '&' && currentchar != '\'' && currentchar != '\"' && currentchar != '\u00a0' && currentchar != '\u00a9') continue;
            buffer.replace(i, i + 1, entitiesMap.get(new Character(currentchar)));
        }
        return buffer;
    }

    public static StringBuffer filterNonXmlChars(StringBuffer aStrBuffer) {
        if (aStrBuffer == null) {
            return new StringBuffer("");
        }
        char space = ' ';
        for (int i = aStrBuffer.length() - 1; i >= 0; --i) {
            if (DocumentXmlUtils.isXmlChar(aStrBuffer.charAt(i))) continue;
            aStrBuffer.setCharAt(i, space);
        }
        return aStrBuffer;
    }

    public static boolean isXmlChar(char ch) {
        if (ch == '\t' || ch == '\n' || ch == '\r') {
            return true;
        }
        if (' ' <= ch && ch <= '\ud7ff') {
            return true;
        }
        if ('\ue000' <= ch && ch <= '\ufffd') {
            return true;
        }
        return '\u10000' <= ch && ch <= '\u10ffff';
    }

    public static StringBuffer replaceCharsWithEntities(String anInputString) {
        if (anInputString == null) {
            return new StringBuffer("");
        }
        StringBuffer strBuff = new StringBuffer(anInputString);
        for (int i = strBuff.length() - 1; i >= 0; --i) {
            Character ch = new Character(strBuff.charAt(i));
            if (!entitiesMap.keySet().contains(ch)) continue;
            strBuff.replace(i, i + 1, entitiesMap.get(ch));
        }
        return strBuff;
    }

    public static String textWithNodes(TextualDocument doc, String aText) {
        if (aText == null) {
            return "";
        }
        StringBuffer textWithNodes = DocumentXmlUtils.filterNonXmlChars(new StringBuffer(aText));
        TreeMap<Long, Character> offsets2CharsMap = new TreeMap<Long, Character>();
        if (aText.length() != 0) {
            DocumentXmlUtils.buildEntityMapFromString(aText, offsets2CharsMap);
        }
        TreeSet<Long> offsetsSet = new TreeSet<Long>();
        for (Annotation annot : doc.getAnnotations()) {
            offsetsSet.add(annot.getStartNode().getOffset());
            offsetsSet.add(annot.getEndNode().getOffset());
        }
        Map<String, AnnotationSet> namedAnnotSets = doc.getNamedAnnotationSets();
        if (namedAnnotSets != null) {
            for (AnnotationSet annotSet : namedAnnotSets.values()) {
                for (Annotation annotTmp : annotSet) {
                    offsetsSet.add(annotTmp.getStartNode().getOffset());
                    offsetsSet.add(annotTmp.getEndNode().getOffset());
                }
            }
        }
        if (offsetsSet.isEmpty()) {
            return DocumentXmlUtils.replaceCharsWithEntities(aText).toString();
        }
        StringBuffer modifiedBuffer = new StringBuffer(textWithNodes.length() * 2);
        int lastCharactercopied = 0;
        TreeSet<Long> allOffsets = new TreeSet<Long>();
        allOffsets.addAll(offsetsSet);
        allOffsets.addAll(offsets2CharsMap.keySet());
        for (Long nextOffset : allOffsets) {
            int nextOffsetint = nextOffset.intValue();
            if (nextOffsetint > lastCharactercopied) {
                modifiedBuffer.append(textWithNodes.substring(lastCharactercopied, nextOffsetint));
                lastCharactercopied = nextOffsetint;
            }
            if (offsetsSet.contains(nextOffset)) {
                modifiedBuffer.append("<Node id=\"").append(nextOffsetint).append("\"/>");
            }
            if (!offsets2CharsMap.containsKey(nextOffset)) continue;
            String entityString = entitiesMap.get(offsets2CharsMap.get(nextOffset));
            ++lastCharactercopied;
            modifiedBuffer.append(entityString);
        }
        modifiedBuffer.append(textWithNodes.substring(lastCharactercopied, textWithNodes.length()));
        return modifiedBuffer.toString();
    }

    public static void buildEntityMapFromString(String aScanString, SortedMap<Long, Character> aMapToFill) {
        if (aScanString == null || aMapToFill == null) {
            return;
        }
        if (entitiesMap == null || entitiesMap.isEmpty()) {
            Err.prln("WARNING: Entities map was not initialised !");
            return;
        }
        for (Character c : entitiesMap.keySet()) {
            int fromIndex = 0;
            while (-1 != fromIndex) {
                fromIndex = aScanString.indexOf(c.charValue(), fromIndex);
                if (-1 == fromIndex) continue;
                aMapToFill.put(new Long(fromIndex), c);
                ++fromIndex;
            }
        }
    }

    public static void annotationSetToXml(AnnotationSet anAnnotationSet, StringBuffer buffer) {
        if (anAnnotationSet == null) {
            buffer.append("<AnnotationSet>\n");
            buffer.append("</AnnotationSet>\n");
            return;
        }
        if (anAnnotationSet.getName() == null) {
            buffer.append("<AnnotationSet>\n");
        } else {
            buffer.append("<AnnotationSet Name=\"");
            buffer.append(anAnnotationSet.getName());
            buffer.append("\" >\n");
        }
        HashMap<String, StringBuffer> convertedKeys = new HashMap<String, StringBuffer>();
        for (Annotation annot : anAnnotationSet) {
            buffer.append("<Annotation Id=\"");
            buffer.append(annot.getId());
            buffer.append("\" Type=\"");
            buffer.append(annot.getType());
            buffer.append("\" StartNode=\"");
            buffer.append(annot.getStartNode().getOffset());
            buffer.append("\" EndNode=\"");
            buffer.append(annot.getEndNode().getOffset());
            buffer.append("\">\n");
            buffer.append(DocumentXmlUtils.featuresToXml(annot.getFeatures(), convertedKeys));
            buffer.append("</Annotation>\n");
        }
        buffer.append("</AnnotationSet>\n");
    }

    public static void annotationSetToXml(AnnotationSet anAnnotationSet, String annotationSetNameToUse, StringBuffer buffer) {
        if (anAnnotationSet == null) {
            buffer.append("<AnnotationSet>\n");
            buffer.append("</AnnotationSet>\n");
            return;
        }
        if (annotationSetNameToUse == null || annotationSetNameToUse.trim().length() == 0) {
            buffer.append("<AnnotationSet>\n");
        } else {
            buffer.append("<AnnotationSet Name=\"");
            buffer.append(annotationSetNameToUse);
            buffer.append("\" >\n");
        }
        HashMap<String, StringBuffer> convertedKeys = new HashMap<String, StringBuffer>();
        for (Annotation annot : anAnnotationSet) {
            buffer.append("<Annotation Id=\"");
            buffer.append(annot.getId());
            buffer.append("\" Type=\"");
            buffer.append(annot.getType());
            buffer.append("\" StartNode=\"");
            buffer.append(annot.getStartNode().getOffset());
            buffer.append("\" EndNode=\"");
            buffer.append(annot.getEndNode().getOffset());
            buffer.append("\">\n");
            buffer.append(DocumentXmlUtils.featuresToXml(annot.getFeatures(), convertedKeys));
            buffer.append("</Annotation>\n");
        }
        buffer.append("</AnnotationSet>\n");
    }

    static {
        entitiesMap.put(new Character('<'), "&lt;");
        entitiesMap.put(new Character('>'), "&gt;");
        entitiesMap.put(new Character('&'), "&amp;");
        entitiesMap.put(new Character('\''), "&apos;");
        entitiesMap.put(new Character('\"'), "&quot;");
        entitiesMap.put(new Character('\u00a0'), "&#160;");
        entitiesMap.put(new Character('\u00a9'), "&#169;");
    }
}

