/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SunUnsafeReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.XStream12FieldKeySorter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.io.xml.XStream11NameCoder;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import gate.Controller;
import gate.Corpus;
import gate.DataStore;
import gate.Gate;
import gate.LanguageAnalyser;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.VisualResource;
import gate.creole.AnalyserRunningStrategy;
import gate.creole.ConditionalController;
import gate.creole.ConditionalSerialAnalyserController;
import gate.creole.Plugin;
import gate.creole.ResourceInstantiationException;
import gate.creole.ResourceReference;
import gate.creole.RunningStrategy;
import gate.creole.SerialAnalyserController;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.persist.PersistenceException;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Files;
import gate.util.GateRuntimeException;
import gate.util.NameBearer;
import gate.util.persistence.AbstractPersistence;
import gate.util.persistence.AnalyserRunningStrategyPersistence;
import gate.util.persistence.CollectionPersistence;
import gate.util.persistence.ConditionalControllerPersistence;
import gate.util.persistence.ConditionalSerialAnalyserControllerPersistence;
import gate.util.persistence.ControllerPersistence;
import gate.util.persistence.CorpusPersistence;
import gate.util.persistence.DSPersistence;
import gate.util.persistence.GateApplication;
import gate.util.persistence.LRPersistence;
import gate.util.persistence.LanguageAnalyserPersistence;
import gate.util.persistence.MapPersistence;
import gate.util.persistence.PRPersistence;
import gate.util.persistence.Persistence;
import gate.util.persistence.SerialAnalyserControllerPersistence;
import gate.util.persistence.UnconditionalRunningStrategyPersistence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceManager {
    private static final boolean DEBUG = false;
    private static final XStream xstream;
    private static final String[] STARTOFXMLAPPLICATIONFILES;
    private static Map<Class<?>, Class<?>> persistentReplacementTypes;
    private static ThreadLocal<LinkedList<Map<ObjectHolder, Persistence>>> existingPersistentReplacements;
    private static ThreadLocal<LinkedList<Map<ObjectHolder, Object>>> existingTransientValues;
    static ThreadLocal<LinkedList<File>> persistenceFile;
    static ThreadLocal<LinkedList<ResourceReference>> persistenceURL;
    private static ThreadLocal<LinkedList<Boolean>> useGateHome;
    private static ThreadLocal<LinkedList<Boolean>> warnAboutGateHome;
    private static ThreadLocal<LinkedList<BooleanFlag>> haveWarnedAboutGateHome;
    private static ThreadLocal<LinkedList<BooleanFlag>> haveWarnedAboutResourceshome;

    public static Serializable getPersistentRepresentation(Object target) throws PersistenceException {
        StatusListener sListener;
        if (target == null) {
            return null;
        }
        Persistence res = existingPersistentReplacements.get().getFirst().get(new ObjectHolder(target));
        if (res != null) {
            return res;
        }
        Class<?> type = target.getClass();
        Class<?> newType = PersistenceManager.getMostSpecificPersistentType(type);
        if (newType == null) {
            if (target instanceof Serializable) {
                return (Serializable)target;
            }
            throw new PersistenceException("Could not find a serialisable replacement for " + type);
        }
        try {
            res = (Persistence)newType.newInstance();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        if (target instanceof NameBearer && (sListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener")) != null) {
            sListener.statusChanged("Storing " + ((NameBearer)target).getName());
        }
        res.extractDataFromSource(target);
        existingPersistentReplacements.get().getFirst().put(new ObjectHolder(target), res);
        return res;
    }

    public static Object getTransientRepresentation(Object target) throws PersistenceException, ResourceInstantiationException {
        return PersistenceManager.getTransientRepresentation(target, null, null);
    }

    public static Object getTransientRepresentation(Object target, String containingControllerName, Map<String, Map<String, Object>> initParamOverrides) throws PersistenceException, ResourceInstantiationException {
        if (target == null || target instanceof SlashDevSlashNull) {
            return null;
        }
        if (target instanceof Persistence) {
            ObjectHolder resultKey = new ObjectHolder(target);
            Object result = existingTransientValues.get().getFirst().get(resultKey);
            if (result != null) {
                return result;
            }
            if (containingControllerName != null && target instanceof AbstractPersistence) {
                ((AbstractPersistence)target).containingControllerName = containingControllerName;
                ((AbstractPersistence)target).initParamOverrides = initParamOverrides;
            }
            result = ((Persistence)target).createObject();
            existingTransientValues.get().getFirst().put(resultKey, result);
            return result;
        }
        return target;
    }

    protected static Class<?> getMostSpecificPersistentType(Class<?> type) {
        ArrayList<Class<Object>> expansionSet = new ArrayList<Class<Object>>();
        expansionSet.add(type);
        ArrayList userInterfaces = new ArrayList();
        ArrayList gateInterfaces = new ArrayList();
        ArrayList javaInterfaces = new ArrayList();
        while (!expansionSet.isEmpty()) {
            Iterator typesIter = expansionSet.iterator();
            while (typesIter.hasNext()) {
                Class<?> clazz = persistentReplacementTypes.get(typesIter.next());
                if (clazz == null) continue;
                return clazz;
            }
            if (type != null) {
                type = type.getSuperclass();
            }
            userInterfaces.clear();
            gateInterfaces.clear();
            javaInterfaces.clear();
            for (Class clazz : expansionSet) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> anIterf = interfaces[i];
                    String interfType = anIterf.getName();
                    if (interfType.startsWith("java")) {
                        javaInterfaces.add(anIterf);
                        continue;
                    }
                    if (interfType.startsWith("gate")) {
                        gateInterfaces.add(anIterf);
                        continue;
                    }
                    userInterfaces.add(anIterf);
                }
            }
            expansionSet.clear();
            if (type != null) {
                expansionSet.add(type);
            }
            expansionSet.addAll(userInterfaces);
            expansionSet.addAll(gateInterfaces);
            expansionSet.addAll(javaInterfaces);
        }
        return null;
    }

    public static boolean isContainedWithin(File file, File directory) {
        Path dir = directory.toPath();
        try {
            dir = dir.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path filePath = file.toPath();
        try {
            filePath = filePath.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return filePath.startsWith(dir);
    }

    public static String getRelativePath(URL context, URL target) {
        try {
            return URLHolder.getRelativeUri(context.toURI(), target.toURI());
        }
        catch (URISyntaxException e) {
            throw new GateRuntimeException("Unable to construct relative path between " + context + " and " + target);
        }
    }

    public static void saveObjectToFile(Object obj, File file) throws PersistenceException, IOException {
        PersistenceManager.saveObjectToFile(obj, file, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveObjectToFile(Object obj, File file, boolean usegatehome, boolean warnaboutgatehome) throws PersistenceException, IOException {
        ProgressListener pListener = (ProgressListener)Gate.getListeners().get("gate.event.ProgressListener");
        StatusListener sListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
        long startTime = System.currentTimeMillis();
        if (pListener != null) {
            pListener.progressChanged(0);
        }
        ObjectOutputStream oos = null;
        PrettyPrintWriter writer = null;
        warnAboutGateHome.get().addFirst(warnaboutgatehome);
        useGateHome.get().addFirst(usegatehome);
        PersistenceManager.startPersistingTo(file);
        try {
            if (Gate.getUseXMLSerialization()) {
                FileWriter fileWriter = new FileWriter(file);
                writer = new PrettyPrintWriter((Writer)fileWriter, (NameCoder)new XmlFriendlyNameCoder("-", "_"));
            } else {
                oos = new ObjectOutputStream(new FileOutputStream(file));
            }
            Serializable persistentList = PersistenceManager.getPersistentRepresentation(new ArrayList<Plugin>(Gate.getCreoleRegister().getPlugins()));
            Serializable persistentObject = PersistenceManager.getPersistentRepresentation(obj);
            if (Gate.getUseXMLSerialization()) {
                GateApplication gateApplication = new GateApplication();
                gateApplication.urlList = persistentList;
                gateApplication.application = persistentObject;
                xstream.marshal((Object)gateApplication, (HierarchicalStreamWriter)writer);
            } else {
                oos.writeObject(persistentList);
                oos.writeObject(persistentObject);
            }
        }
        finally {
            PersistenceManager.finishedPersisting();
            if (oos != null) {
                oos.flush();
                oos.close();
            }
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            long endTime = System.currentTimeMillis();
            if (sListener != null) {
                sListener.statusChanged("Storing completed in " + NumberFormat.getInstance().format((double)(endTime - startTime) / 1000.0) + " seconds");
            }
            if (pListener != null) {
                pListener.processFinished();
            }
        }
    }

    private static void startPersistingTo(File file) {
        haveWarnedAboutGateHome.get().addFirst(new BooleanFlag(false));
        haveWarnedAboutResourceshome.get().addFirst(new BooleanFlag(false));
        persistenceFile.get().addFirst(file);
        existingPersistentReplacements.get().addFirst(new HashMap());
    }

    public static File currentPersistenceFile() {
        return persistenceFile.get().getFirst();
    }

    public static List<File> currentPersistenceFileStack() {
        return Collections.unmodifiableList((List)persistenceFile.get());
    }

    private static Boolean currentWarnAboutGateHome() {
        return warnAboutGateHome.get().getFirst();
    }

    private static Boolean currentUseGateHome() {
        return false;
    }

    private static BooleanFlag currentHaveWarnedAboutGateHome() {
        return haveWarnedAboutGateHome.get().getFirst();
    }

    private static BooleanFlag currentHaveWarnedAboutResourceshome() {
        return haveWarnedAboutResourceshome.get().getFirst();
    }

    private static void finishedPersisting() {
        persistenceFile.get().removeFirst();
        if (persistenceFile.get().isEmpty()) {
            persistenceFile.remove();
        }
        existingPersistentReplacements.get().removeFirst();
        if (existingPersistentReplacements.get().isEmpty()) {
            existingPersistentReplacements.remove();
        }
    }

    public static Object loadObjectFromFile(File file) throws PersistenceException, IOException, ResourceInstantiationException {
        try {
            return PersistenceManager.loadObjectFromUri(file.toURI());
        }
        catch (URISyntaxException e) {
            throw new PersistenceException(e);
        }
    }

    public static Object loadObjectFromUrl(URL url) throws PersistenceException, IOException, ResourceInstantiationException {
        try {
            return PersistenceManager.loadObjectFromUri(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new PersistenceException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static Object loadObjectFromUri(URI uri) throws PersistenceException, IOException, ResourceInstantiationException, URISyntaxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void startLoadingFrom(ResourceReference rr) {
        persistenceURL.get().addFirst(rr);
        existingTransientValues.get().addFirst(new HashMap());
    }

    private static void clearCurrentTransients() {
        existingTransientValues.get().getFirst().clear();
    }

    public static ResourceReference currentPersistenceURL() {
        return persistenceURL.get().getFirst();
    }

    public static List<ResourceReference> currentPersistenceURLStack() {
        return Collections.unmodifiableList((List)persistenceURL.get());
    }

    private static void finishedLoading() {
        persistenceURL.get().removeFirst();
        if (persistenceURL.get().isEmpty()) {
            persistenceURL.remove();
        }
        existingTransientValues.get().removeFirst();
        if (existingTransientValues.get().isEmpty()) {
            existingTransientValues.remove();
        }
    }

    private static boolean isXmlApplicationFile(URL url) throws IOException {
        String firstLine;
        try (BomStrippingInputStreamReader fileReader = null;){
            fileReader = new BomStrippingInputStreamReader(url.openStream());
            firstLine = ((BufferedReader)fileReader).readLine();
        }
        if (firstLine == null) {
            return false;
        }
        for (String startOfXml : STARTOFXMLAPPLICATIONFILES) {
            if (firstLine.length() < startOfXml.length() || !firstLine.substring(0, startOfXml.length()).equals(startOfXml)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> registerPersistentEquivalent(Class<?> transientType, Class<?> persistentType) throws PersistenceException {
        if (!Persistence.class.isAssignableFrom(persistentType)) {
            throw new PersistenceException("Persistent equivalent types have to implement " + Persistence.class.getName() + "!\n" + persistentType.getName() + " does not!");
        }
        return persistentReplacementTypes.put(transientType, persistentType);
    }

    static {
        STARTOFXMLAPPLICATIONFILES = new String[]{"<gate.util.persistence.GateApplication>", "<?xml", "<!DOCTYPE"};
        xstream = new XStream((ReflectionProvider)new SunUnsafeReflectionProvider(new FieldDictionary((FieldKeySorter)new XStream12FieldKeySorter())), (HierarchicalStreamDriver)new StaxDriver((NameCoder)new XStream11NameCoder())){

            protected boolean useXStream11XmlFriendlyMapper() {
                return true;
            }
        };
        xstream.setClassLoader((ClassLoader)Gate.getClassLoader());
        Gate.configureXStreamSecurity(xstream);
        persistentReplacementTypes = new HashMap();
        try {
            PersistenceManager.registerPersistentEquivalent(VisualResource.class, SlashDevSlashNull.class);
            PersistenceManager.registerPersistentEquivalent(URL.class, URLHolder.class);
            PersistenceManager.registerPersistentEquivalent(ResourceReference.class, RRPersistence.class);
            PersistenceManager.registerPersistentEquivalent(Plugin.Directory.class, URLHolder.class);
            PersistenceManager.registerPersistentEquivalent(Plugin.Component.class, SlashDevSlashNull.class);
            PersistenceManager.registerPersistentEquivalent(Map.class, MapPersistence.class);
            PersistenceManager.registerPersistentEquivalent(Collection.class, CollectionPersistence.class);
            PersistenceManager.registerPersistentEquivalent(ProcessingResource.class, PRPersistence.class);
            PersistenceManager.registerPersistentEquivalent(DataStore.class, DSPersistence.class);
            PersistenceManager.registerPersistentEquivalent(LanguageResource.class, LRPersistence.class);
            PersistenceManager.registerPersistentEquivalent(Corpus.class, CorpusPersistence.class);
            PersistenceManager.registerPersistentEquivalent(Controller.class, ControllerPersistence.class);
            PersistenceManager.registerPersistentEquivalent(ConditionalController.class, ConditionalControllerPersistence.class);
            PersistenceManager.registerPersistentEquivalent(ConditionalSerialAnalyserController.class, ConditionalSerialAnalyserControllerPersistence.class);
            PersistenceManager.registerPersistentEquivalent(LanguageAnalyser.class, LanguageAnalyserPersistence.class);
            PersistenceManager.registerPersistentEquivalent(SerialAnalyserController.class, SerialAnalyserControllerPersistence.class);
            PersistenceManager.registerPersistentEquivalent(AnalyserRunningStrategy.class, AnalyserRunningStrategyPersistence.class);
            PersistenceManager.registerPersistentEquivalent(RunningStrategy.UnconditionalRunningStrategy.class, UnconditionalRunningStrategyPersistence.class);
        }
        catch (PersistenceException pe) {
            pe.printStackTrace();
        }
        class ThreadLocalStack<T>
        extends ThreadLocal<LinkedList<T>> {
            ThreadLocalStack() {
            }

            @Override
            protected LinkedList<T> initialValue() {
                return new LinkedList();
            }
        }
        existingPersistentReplacements = new ThreadLocalStack<Map<ObjectHolder, Persistence>>();
        existingTransientValues = new ThreadLocalStack<Map<ObjectHolder, Object>>();
        persistenceFile = new ThreadLocalStack<File>();
        persistenceURL = new ThreadLocalStack<ResourceReference>();
        useGateHome = new ThreadLocalStack<Boolean>();
        warnAboutGateHome = new ThreadLocalStack<Boolean>();
        haveWarnedAboutGateHome = new ThreadLocalStack<BooleanFlag>();
        haveWarnedAboutResourceshome = new ThreadLocalStack<BooleanFlag>();
    }

    private static final class BooleanFlag {
        private boolean flag;

        BooleanFlag(boolean initial) {
            this.flag = initial;
        }

        public void setValue(boolean value) {
            this.flag = value;
        }

        public boolean getValue() {
            return this.flag;
        }
    }

    public static class NotComparableException
    extends RuntimeException {
        public NotComparableException(String message) {
            super(message);
        }

        public NotComparableException() {
        }
    }

    public static class ClassComparator
    implements Comparator<Class<?>>,
    Serializable {
        private static final long serialVersionUID = 6632907018933862733L;

        @Override
        public int compare(Class<?> c1, Class<?> c2) {
            if (c1.equals(c2)) {
                return 0;
            }
            if (c1.isAssignableFrom(c2)) {
                return 1;
            }
            if (c2.isAssignableFrom(c1)) {
                return -1;
            }
            throw new NotComparableException();
        }
    }

    public static class URLHolder
    implements Persistence {
        static final Logger logger = LoggerFactory.getLogger(URLHolder.class);
        String urlString;
        private static final String relativePathMarker = "$relpath$";
        private static final String gatehomePathMarker = "$gatehome$";
        private static final String gatepluginsPathMarker = "$gateplugins$";
        private static final String syspropMarker = "$sysprop:";
        private static final String resourceshomePathMarker = "$resourceshome$";
        private static final String resourceshomePropertyName = "gate.user.resourceshome";
        private static File resourceshomePath = null;
        private static Boolean haveResourceshomePath = null;
        private static File gatehomePath = null;
        static final long serialVersionUID = 7943459208429026229L;
        private static final Pattern goUpPattern = Pattern.compile("^((?:\\.\\." + Pattern.quote(FileSystems.getDefault().getSeparator()) + ")+).*");

        public static String relativize(File outFile, File urlFile) throws URISyntaxException {
            String relPath;
            String pathMarker;
            block17: {
                File outFileReal = URLHolder.getCanonicalFileIfPossible(outFile);
                File urlFileReal = URLHolder.getCanonicalFileIfPossible(urlFile);
                File outDir = outFile.getParentFile();
                File outDirReal = URLHolder.getCanonicalFileIfPossible(outDir);
                File outDirOfReal = URLHolder.getCanonicalFileIfPossible(outFileReal.getParentFile());
                logger.debug("urlFile=" + urlFile + ", urlFileReal" + urlFileReal);
                logger.debug("outDir=" + outDir + ", outDirReal" + outDirReal);
                pathMarker = relativePathMarker;
                File gateHomePathReal = URLHolder.getGateHomePath();
                File resourceshomeDirReal = URLHolder.getResourceshomePath();
                if (PersistenceManager.currentUseGateHome().booleanValue()) {
                    if (!PersistenceManager.isContainedWithin(outFileReal, gateHomePathReal) && PersistenceManager.isContainedWithin(urlFileReal, gateHomePathReal)) {
                        logger.debug("Setting path marker to $gatehome$");
                        if (PersistenceManager.currentWarnAboutGateHome().booleanValue() && !PersistenceManager.currentHaveWarnedAboutGateHome().getValue()) {
                            logger.warn("\nYour application is using some of the resources/plugins distributed with GATE, and may not work as expected with different versions of GATE. You should consider making private local copies of the plug-ins, and distributing those with your application.");
                            PersistenceManager.currentHaveWarnedAboutGateHome().setValue(true);
                        }
                        if (PersistenceManager.currentUseGateHome().booleanValue()) {
                            pathMarker = gatehomePathMarker;
                        }
                    } else if (resourceshomeDirReal != null && !PersistenceManager.isContainedWithin(outFileReal, resourceshomeDirReal) && PersistenceManager.isContainedWithin(urlFileReal, resourceshomeDirReal)) {
                        if (PersistenceManager.currentWarnAboutGateHome().booleanValue() && !PersistenceManager.currentHaveWarnedAboutResourceshome().getValue()) {
                            logger.warn("\nYour application is using resources from your project path at " + URLHolder.getResourceshomePath() + ". Restoring the application will only work if the same project path is set.");
                            PersistenceManager.currentHaveWarnedAboutResourceshome().setValue(true);
                        }
                        if (PersistenceManager.currentUseGateHome().booleanValue()) {
                            pathMarker = resourceshomePathMarker;
                        }
                    }
                }
                relPath = null;
                try {
                    if (pathMarker.equals(relativePathMarker)) {
                        relPath = URLHolder.getRelativeFilePathString(outDir, urlFile);
                        logger.debug("First relative path string attempt got " + relPath);
                        if (relPath.startsWith("../")) {
                            logger.debug("upslength is " + URLHolder.upsLength(relPath));
                            String tmpPath = relPath;
                            if (java.nio.file.Files.isSymbolicLink(outFile.toPath())) {
                                tmpPath = URLHolder.getRelativeFilePathString(outDirOfReal, urlFileReal);
                                logger.debug("trying outDirOfReal " + tmpPath);
                                logger.debug("upslength is " + URLHolder.upsLength(tmpPath));
                            } else {
                                tmpPath = URLHolder.getRelativeFilePathString(outDirReal, urlFileReal);
                                logger.debug("trying outDirReal " + tmpPath);
                                logger.debug("upslength is " + URLHolder.upsLength(tmpPath));
                            }
                            if (URLHolder.upsLength(tmpPath) < URLHolder.upsLength(relPath)) {
                                relPath = tmpPath;
                            }
                            logger.debug("Using tmpPath " + relPath);
                        }
                        break block17;
                    }
                    if (pathMarker.equals(gatehomePathMarker)) {
                        relPath = URLHolder.getRelativeFilePathString(gateHomePathReal, urlFileReal);
                        break block17;
                    }
                    if (pathMarker.equals(resourceshomePathMarker)) {
                        relPath = URLHolder.getRelativeFilePathString(resourceshomeDirReal, urlFileReal);
                        break block17;
                    }
                    throw new GateRuntimeException("Unexpected error when persisting URL " + urlFile);
                }
                catch (IllegalArgumentException e) {
                    logger.warn("Could not convert " + urlFile + " to a relative path - storing as absolute", (Throwable)e);
                    return urlFile.toURI().toString();
                }
            }
            return pathMarker + relPath;
        }

        @Override
        public void extractDataFromSource(Object source) throws PersistenceException {
            try {
                URL url = null;
                if (source instanceof URL) {
                    url = (URL)source;
                } else if (source instanceof Plugin.Directory) {
                    url = ((Plugin.Directory)source).getBaseURL();
                }
                if (url == null) {
                    throw new UnsupportedOperationException("Whatever you are trying to persist isn't a URL");
                }
                if (url.getProtocol().equals("file")) {
                    File outFile = PersistenceManager.currentPersistenceFile();
                    File urlFile = Files.fileFromURL(url);
                    logger.debug("Trying to persist " + url + " for " + outFile);
                    this.urlString = URLHolder.relativize(outFile, urlFile);
                } else {
                    this.urlString = ((URL)source).toExternalForm();
                }
            }
            catch (ClassCastException | URISyntaxException e) {
                throw new PersistenceException(e);
            }
        }

        @Override
        public Object createObject() throws PersistenceException {
            try {
                return URLHolder.unpackPersistentRepresentation(PersistenceManager.currentPersistenceURL().toURL().toURI(), this.urlString).toURL();
            }
            catch (IOException | URISyntaxException e1) {
                throw new PersistenceException(e1);
            }
        }

        public static URI unpackPersistentRepresentation(URI context, String persistent) throws PersistenceException {
            try {
                if (persistent.startsWith(relativePathMarker)) {
                    URI ret = URLHolder.combineContextAndRelative(context, persistent.substring(relativePathMarker.length()), true);
                    logger.debug("CurrentPresistenceURL is " + context + " created=" + ret);
                    return ret;
                }
                if (persistent.startsWith(gatehomePathMarker)) {
                    throw new GateRuntimeException("$gatehome$ variable no longer supported, please upgrade your application");
                }
                if (persistent.startsWith(gatepluginsPathMarker)) {
                    throw new GateRuntimeException("$gateplugins$ variable no longer supported, please upgrade your application");
                }
                if (persistent.startsWith(resourceshomePathMarker)) {
                    if (URLHolder.getResourceshomePath() == null) {
                        throw new GateRuntimeException("Cannot restore URL " + persistent + "property " + resourceshomePropertyName + " is not set");
                    }
                    URL resourceshomeurl = URLHolder.getResourceshomePath().toURI().toURL();
                    return URLHolder.combineContextAndRelative(resourceshomeurl.toURI(), persistent.substring(resourceshomePathMarker.length()), false);
                }
                if (persistent.startsWith(syspropMarker)) {
                    String urlRestString = persistent.substring(syspropMarker.length());
                    int dollarindex = urlRestString.indexOf("$");
                    if (dollarindex > 0) {
                        String syspropname = urlRestString.substring(0, dollarindex);
                        String propvalue = System.getProperty(syspropname);
                        if (propvalue == null) {
                            throw new PersistenceException("Property '" + syspropname + "' is null in " + persistent);
                        }
                        URI propuri = new File(propvalue).toURI();
                        if (dollarindex == urlRestString.length()) {
                            return propuri;
                        }
                        return URLHolder.combineContextAndRelative(propuri, urlRestString.substring(dollarindex + 1), false);
                    }
                    if (dollarindex == 0) {
                        throw new PersistenceException("No property name after '$sysprop:' in " + persistent);
                    }
                    throw new PersistenceException("No ending $ after '$sysprop:' in " + persistent);
                }
                return new URI(persistent);
            }
            catch (MalformedURLException | URISyntaxException mue) {
                throw new PersistenceException(mue);
            }
        }

        public static URI combineContextAndRelative(URI context, String relative, boolean contextIsFile) {
            if (relative == null) {
                relative = "";
            }
            if (relative.startsWith("/")) {
                relative = relative.substring(1);
            }
            if (relative.isEmpty()) {
                if (!contextIsFile) {
                    return context;
                }
                return context.resolve(".");
            }
            if (context.isOpaque()) {
                try {
                    URL tmpUrl = new URL(context.toURL(), relative);
                    return tmpUrl.toURI();
                }
                catch (Exception ex) {
                    throw new GateRuntimeException("Could not create a URL from context " + context + " and relative part " + relative, ex);
                }
            }
            return context.resolve(relative).normalize();
        }

        private static File getGateHomePath() {
            if (gatehomePath != null) {
                return gatehomePath;
            }
            gatehomePath = URLHolder.getCanonicalFileIfPossible(Gate.getGateHome());
            return gatehomePath;
        }

        private static File getResourceshomePath() {
            if (haveResourceshomePath == null) {
                String resourceshomeString = System.getProperty(resourceshomePropertyName);
                if (resourceshomeString == null) {
                    haveResourceshomePath = false;
                    return null;
                }
                resourceshomePath = new File(resourceshomeString);
                resourceshomePath = URLHolder.getCanonicalFileIfPossible(resourceshomePath);
                haveResourceshomePath = true;
                return resourceshomePath;
            }
            if (haveResourceshomePath.booleanValue()) {
                return resourceshomePath;
            }
            return null;
        }

        private static File getCanonicalFileIfPossible(File file) {
            if (file == null) {
                return file;
            }
            File tmp = file;
            try {
                tmp = tmp.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return tmp;
        }

        private static String getRelativeFilePathString(File dir, File file) {
            Path dirPath = dir.toPath();
            Path filePath = file.toPath();
            try {
                dirPath = dirPath.toRealPath(LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                filePath = filePath.toRealPath(LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            URI dirUri = dirPath.toUri();
            URI fileUri = filePath.toUri();
            return URLHolder.getRelativeUri(dirUri, fileUri);
        }

        private static int upsLength(String path) {
            Matcher m = goUpPattern.matcher(path);
            if (m.matches()) {
                return m.group(1).length();
            }
            return 0;
        }

        public static String getRelativeUri(URI context, URI target) {
            int commonPathElements;
            if (!Objects.equals(context.getHost(), target.getHost())) {
                throw new IllegalArgumentException("Can't create relative path between " + context + " and " + target + " as they are on different hosts.");
            }
            String contextPath = context.getRawPath();
            String targetPath = target.getRawPath();
            String[] targetComponents = targetPath.split("/", -1);
            String[] contextComponents = contextPath.split("/", -1);
            for (commonPathElements = 0; commonPathElements < targetComponents.length && commonPathElements < contextComponents.length && Objects.equals(targetComponents[commonPathElements], contextComponents[commonPathElements]); ++commonPathElements) {
            }
            return Stream.concat(IntStream.range(commonPathElements, contextComponents.length - 1).mapToObj(i -> ".."), IntStream.range(commonPathElements, targetComponents.length).mapToObj(i -> targetComponents[i])).collect(Collectors.joining("/"));
        }
    }

    public static class RRPersistence
    implements Persistence {
        private static final long serialVersionUID = 6543151074741224114L;
        String uriString;

        public String toString() {
            return this.uriString;
        }

        @Override
        public void extractDataFromSource(Object source) throws PersistenceException {
            try {
                URI uri = null;
                if (source instanceof ResourceReference) {
                    uri = ((ResourceReference)source).toURI();
                }
                if (uri == null) {
                    throw new UnsupportedOperationException("Whatever you are trying to persist isn't a URL");
                }
                if (uri.getScheme() != null && uri.getScheme().equals("file")) {
                    File outFile = PersistenceManager.currentPersistenceFile();
                    File urlFile = new File(uri);
                    this.uriString = URLHolder.relativize(outFile, urlFile);
                } else {
                    this.uriString = ((ResourceReference)source).toExternalForm();
                }
            }
            catch (ClassCastException | URISyntaxException e) {
                throw new PersistenceException(e);
            }
        }

        @Override
        public Object createObject() throws PersistenceException, ResourceInstantiationException {
            try {
                return new ResourceReference(URLHolder.unpackPersistentRepresentation(PersistenceManager.currentPersistenceURL().toURI(), this.uriString));
            }
            catch (URISyntaxException e) {
                throw new PersistenceException(e);
            }
        }
    }

    public static class SlashDevSlashNull
    implements Persistence {
        static final long serialVersionUID = -8665414981783519937L;

        @Override
        public void extractDataFromSource(Object source) throws PersistenceException {
        }

        @Override
        public Object createObject() throws PersistenceException, ResourceInstantiationException {
            return null;
        }
    }

    protected static class ObjectHolder {
        private Object target;

        ObjectHolder(Object target) {
            this.target = target;
        }

        public int hashCode() {
            return System.identityHashCode(this.target);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ObjectHolder) {
                return ((ObjectHolder)obj).target == this.target;
            }
            return false;
        }

        public Object getTarget() {
            return this.target;
        }
    }
}

