/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.Corpus;
import gate.Document;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.persistence.LRPersistence;
import gate.util.persistence.PersistenceManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CorpusPersistence
extends LRPersistence {
    protected List<Serializable> docList;
    static final long serialVersionUID = 6181534551802883626L;

    @Override
    public void extractDataFromSource(Object source) throws PersistenceException {
        if (!(source instanceof Corpus)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can only be used for " + Corpus.class.getName() + " objects!\n" + source.getClass().getName() + " is not a " + Corpus.class.getName());
        }
        Corpus corpus = (Corpus)source;
        super.extractDataFromSource(source);
        if (this.dsData == null) {
            this.docList = new ArrayList<Serializable>();
            Iterator docIter = corpus.iterator();
            while (docIter.hasNext()) {
                this.docList.add(PersistenceManager.getPersistentRepresentation(docIter.next()));
            }
        } else {
            this.docList = null;
        }
    }

    @Override
    public Object createObject() throws PersistenceException, ResourceInstantiationException {
        Corpus corpus = (Corpus)super.createObject();
        if (this.docList != null && !this.docList.isEmpty() && corpus.isEmpty()) {
            Iterator<Serializable> docIter = this.docList.iterator();
            while (docIter.hasNext()) {
                corpus.add((Document)PersistenceManager.getTransientRepresentation(docIter.next(), this.containingControllerName, this.initParamOverrides));
            }
        }
        return corpus;
    }
}

