/*
 * Decompiled with CFR 0.152.
 */
package gate.util.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;

public class SimpleModelResolver
implements ModelResolver {
    private final RepositorySystem system;
    private final RepositorySystemSession session;
    private final Set<String> repositoryIds;
    private List<RemoteRepository> repositories;

    public SimpleModelResolver(RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> remoteRepositories) {
        this.system = system;
        this.session = session;
        this.repositories = new ArrayList<RemoteRepository>(remoteRepositories);
        this.repositoryIds = new HashSet<String>(remoteRepositories.size() < 3 ? 3 : remoteRepositories.size());
        for (RemoteRepository repository : remoteRepositories) {
            this.repositoryIds.add(repository.getId());
        }
    }

    private SimpleModelResolver(SimpleModelResolver original) {
        this.session = original.session;
        this.system = original.system;
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
        if (!this.repositoryIds.add(repository.getId())) {
            return;
        }
        this.repositories.add(ArtifactDescriptorUtils.toRemoteRepository((Repository)repository));
    }

    public ModelResolver newCopy() {
        return new SimpleModelResolver(this);
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        try {
            ArtifactRequest request = new ArtifactRequest((Artifact)pomArtifact, this.repositories, null);
            pomArtifact = this.system.resolveArtifact(this.session, request).getArtifact();
        }
        catch (ArtifactResolutionException ex) {
            throw new UnresolvableModelException(ex.getMessage(), groupId, artifactId, version, (Throwable)ex);
        }
        File pomFile = pomArtifact.getFile();
        return new FileModelSource(pomFile);
    }

    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
    }

    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
    }
}

