/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Gate;
import gate.util.Files;
import gate.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Tools {
    private static final boolean DEBUG = false;
    static long sym = 0L;
    private static boolean unicodeEnabled = false;

    public static synchronized Long gensym() {
        return sym++;
    }

    public static synchronized Long genTime() {
        return new Date().getTime();
    }

    public static void setUnicodeEnabled(boolean value) {
        unicodeEnabled = value;
    }

    public static boolean isUnicodeEnabled() {
        return unicodeEnabled;
    }

    public static List<Class<?>> findSubclasses(Class<?> parentClass) {
        Package[] packages = Package.getPackages();
        ArrayList result = new ArrayList();
        for (int i = 0; i < packages.length; ++i) {
            String packageDir = packages[i].getName();
            if (!packageDir.startsWith("/")) {
                packageDir = "/" + packageDir;
            }
            packageDir = packageDir.replace('.', Strings.getPathSep().charAt(0));
            URL packageURL = Gate.getClassLoader().getResource(packageDir);
            if (packageURL == null) continue;
            File directory = Files.fileFromURL(packageURL);
            if (directory.exists()) {
                String[] files = directory.list();
                for (int j = 0; j < files.length; ++j) {
                    if (!files[j].endsWith(".class")) continue;
                    String classname = files[j].substring(0, files[j].length() - 6);
                    try {
                        Class<?> aClass = Class.forName(packages[i] + "." + classname, true, Gate.getClassLoader());
                        if (!parentClass.isAssignableFrom(aClass)) continue;
                        result.add(aClass);
                        continue;
                    }
                    catch (ClassNotFoundException aClass) {
                        // empty catch block
                    }
                }
                continue;
            }
            try {
                JarURLConnection conn = (JarURLConnection)packageURL.openConnection();
                String starts = conn.getEntryName();
                JarFile jFile = conn.getJarFile();
                Enumeration<JarEntry> e = jFile.entries();
                while (e.hasMoreElements()) {
                    String entryname = e.nextElement().getName();
                    if (!entryname.startsWith(starts) || entryname.lastIndexOf(47) > starts.length() || !entryname.endsWith(".class")) continue;
                    String classname = entryname.substring(0, entryname.length() - 6);
                    if (classname.startsWith("/")) {
                        classname = classname.substring(1);
                    }
                    classname = classname.replace('/', '.');
                    try {
                        Class<?> aClass = Class.forName(packages[i] + "." + classname, true, Gate.getClassLoader());
                        if (!parentClass.isAssignableFrom(aClass)) continue;
                        result.add(aClass);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Constructor<?> getMostSpecificConstructor(Class<?> targetClass, Class<?> paramClass) throws NoSuchMethodException {
        void var6_8;
        if (targetClass.isInterface()) {
            throw new NoSuchMethodException(targetClass.getName() + " is an interface, so cannot have constructors");
        }
        Constructor<?>[] targetClassConstructors = targetClass.getConstructors();
        ArrayList applicableConstructors = new ArrayList();
        Constructor<?>[] constructorArray = targetClassConstructors;
        int n = constructorArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            Constructor<?> c = constructorArray[var6_8];
            Class<?>[] constructorParams = c.getParameterTypes();
            if (constructorParams.length == 1 && constructorParams[0].isAssignableFrom(paramClass)) {
                applicableConstructors.add(c);
            }
            ++var6_8;
        }
        if (applicableConstructors.size() == 0) {
            throw new NoSuchMethodException("No applicable constructors for " + targetClass.getName() + "(" + paramClass.getName() + ")");
        }
        Constructor mostSpecificConstructor = null;
        if (applicableConstructors.size() == 1) {
            mostSpecificConstructor = (Constructor)applicableConstructors.get(0);
        } else {
            block1: for (Constructor constructor : applicableConstructors) {
                Class<?> c1ParamType = constructor.getParameterTypes()[0];
                for (Constructor constructor2 : applicableConstructors) {
                    Class<?> c2ParamType = constructor2.getParameterTypes()[0];
                    if (c2ParamType.isAssignableFrom(c1ParamType)) continue;
                    continue block1;
                }
                mostSpecificConstructor = constructor;
                break;
            }
        }
        if (mostSpecificConstructor == null) {
            throw new NoSuchMethodException("Ambiguous constructors for " + targetClass.getName() + "(" + paramClass.getName() + ")");
        }
        return mostSpecificConstructor;
    }

    public static final void printStackTrace(PrintStream pStream) {
        StackTraceElement[] stackTraceElems;
        for (StackTraceElement ste : stackTraceElems = Thread.currentThread().getStackTrace()) {
            pStream.println(ste.toString());
        }
    }
}

