/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.util.Strings;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class OptionsMap
extends TreeMap<Object, Object> {
    private static final long serialVersionUID = 1005431810071035036L;

    @Override
    public Object put(Object key, Object value) {
        if (value instanceof Font) {
            Font font = (Font)value;
            String family = font.getFamily();
            int size = font.getSize();
            boolean italic = font.isItalic();
            boolean bold = font.isBold();
            value = family + "#" + size + "#" + italic + "#" + bold;
        }
        return super.put(key.toString(), Strings.toString(value));
    }

    @Override
    public Object put(Object key, LinkedHashSet<String> value) {
        return super.put(key.toString(), Strings.toString(value));
    }

    @Override
    public Object put(Object key, Map<String, String> value) {
        return super.put(key.toString(), Strings.toString(value));
    }

    public Integer getInt(Object key) {
        try {
            return Integer.decode((String)this.get(key));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer getInt(Object key, Integer defaultValue) {
        Integer value = this.getInt(key);
        return value != null ? value : defaultValue;
    }

    public File getFile(Object key) {
        try {
            return new File((String)this.get(key));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Double getDouble(Object key) {
        try {
            return Double.valueOf((String)this.get(key));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Boolean getBoolean(Object key) {
        try {
            return Boolean.valueOf((String)this.get(key));
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean getBoolean(Object key, Boolean defaultValue) {
        try {
            if (this.containsKey(key)) {
                return Boolean.valueOf((String)this.get(key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public String getString(Object key) {
        try {
            return (String)this.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Font getFont(Object key) {
        try {
            String stringValue = (String)this.get(key);
            if (stringValue == null) {
                return null;
            }
            StringTokenizer strTok = new StringTokenizer(stringValue, "#", false);
            String family = strTok.nextToken();
            int size = Integer.parseInt(strTok.nextToken());
            boolean italic = Boolean.valueOf(strTok.nextToken());
            boolean bold = Boolean.valueOf(strTok.nextToken());
            HashMap<TextAttribute, Object> fontAttrs = new HashMap<TextAttribute, Object>();
            fontAttrs.put(TextAttribute.FAMILY, family);
            fontAttrs.put(TextAttribute.SIZE, Float.valueOf(size));
            if (bold) {
                fontAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            } else {
                fontAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
            }
            if (italic) {
                fontAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            } else {
                fontAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            }
            return new Font(fontAttrs);
        }
        catch (Exception e) {
            return null;
        }
    }

    public LinkedHashSet<String> getSet(Object key) {
        return Strings.toSet((String)this.get(key), ", ");
    }

    public Map<String, String> getMap(Object key) {
        return Strings.toMap((String)this.get(key));
    }

    public Map<String, String> getStringMap() {
        HashMap<String, String> data = new HashMap<String, String>();
        for (Map.Entry entry : this.entrySet()) {
            data.put((String)entry.getKey(), (String)entry.getValue());
        }
        return data;
    }
}

