/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Gate;
import gate.GateConstants;
import gate.util.Err;
import gate.util.GateClassLoader;
import gate.util.GateException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public abstract class Javac
implements GateConstants {
    private static Javac compiler = null;
    public static final String DEFAULT_COMPILER = "gate.util.compilers.Eclipse";

    public static void loadClasses(Map<String, String> sources, GateClassLoader classLoader) throws GateException {
        if (compiler == null) {
            Javac.setCompilerTypeFromUserConfig();
        }
        if (classLoader == null) {
            Err.println("A null classloader was provided, using the Top-Level GATE classloader instead!");
            classLoader = Gate.getClassLoader();
        }
        compiler.compile(sources, classLoader);
    }

    private static void setCompilerTypeFromUserConfig() throws GateException {
        String compilerType = Gate.getUserConfig().getString("Compiler_type");
        if (compilerType == null) {
            compilerType = DEFAULT_COMPILER;
        }
        try {
            compiler = Javac.createCompilerInstance(compilerType);
        }
        catch (GateException ge) {
            if (DEFAULT_COMPILER.equals(compilerType)) {
                throw ge;
            }
            compilerType = "gate.util.compilers." + compilerType;
            try {
                compiler = Javac.createCompilerInstance(compilerType);
            }
            catch (GateException ge2) {
                if (DEFAULT_COMPILER.equals(compilerType)) {
                    throw ge2;
                }
                Err.prln("Unable to load compiler class " + compilerType + ", falling back to default of " + DEFAULT_COMPILER);
                compilerType = DEFAULT_COMPILER;
                compiler = Javac.createCompilerInstance(compilerType);
            }
        }
    }

    private static Javac createCompilerInstance(String compilerType) throws GateException {
        Class<?> compilerClass = null;
        try {
            compilerClass = Gate.getClassLoader().loadClass(compilerType, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (compilerClass == null || !Javac.class.isAssignableFrom(compilerClass)) {
            throw new GateException("Unable to load Java compiler class " + compilerType);
        }
        try {
            Constructor<?> noArgConstructor = compilerClass.getConstructor(new Class[0]);
            return (Javac)noArgConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException iae) {
            throw new GateException("Cannot access Java compiler class " + compilerType, iae);
        }
        catch (InstantiationException ie) {
            throw new GateException("Cannot instantiate Java compiler class " + compilerType, ie);
        }
        catch (NoSuchMethodException nsme) {
            throw new GateException("Java compiler class " + compilerType + " does not have a no-argument constructor", nsme);
        }
        catch (InvocationTargetException ite) {
            throw new GateException("Exception when constructing Java compiler of type " + compilerType, ite.getCause());
        }
        catch (ExceptionInInitializerError eiie) {
            throw new GateException("Exception when initializing Java compiler class " + compilerType, eiie.getCause());
        }
    }

    public abstract void compile(Map<String, String> var1, GateClassLoader var2) throws GateException;
}

