/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Controller;
import gate.Corpus;
import gate.CorpusController;
import gate.DataStore;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.persist.SerialDataStore;
import gate.util.AnnotationDiffer;
import gate.util.Err;
import gate.util.Files;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.OffsetComparator;
import gate.util.Out;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.SwingUtilities;

public class CorpusBenchmarkTool {
    private static final String MARKED_DIR_NAME = "marked";
    private static final String CLEAN_DIR_NAME = "clean";
    private static final String CVS_DIR_NAME = "Cvs";
    private static final String PROCESSED_DIR_NAME = "processed";
    private static final String ERROR_DIR_NAME = "err";
    private double precisionSumCalc = 0.0;
    private double recallSumCalc = 0.0;
    private double fMeasureSumCalc = 0.0;
    private File startDir;
    private File currDir;
    private static List<String> annotTypes;
    private Controller application = null;
    private File applicationFile = null;
    private double precisionSum = 0.0;
    private double recallSum = 0.0;
    private double fMeasureSum = 0.0;
    private Map<String, Double> precisionByType = new HashMap<String, Double>();
    private Map<String, Integer> prCountByType = new HashMap<String, Integer>();
    private Map<String, Double> recallByType = new HashMap<String, Double>();
    private Map<String, Integer> recCountByType = new HashMap<String, Integer>();
    private Map<String, Double> fMeasureByType = new HashMap<String, Double>();
    private Map<String, Integer> fMeasureCountByType = new HashMap<String, Integer>();
    private Map<String, Long> missingByType = new HashMap<String, Long>();
    private Map<String, Long> spurByType = new HashMap<String, Long>();
    private Map<String, Long> correctByType = new HashMap<String, Long>();
    private Map<String, Long> partialByType = new HashMap<String, Long>();
    static boolean hasProcessed;
    private double proc_precisionSum = 0.0;
    private double proc_recallSum = 0.0;
    private double proc_fMeasureSum = 0.0;
    private Map<String, Double> proc_precisionByType = new HashMap<String, Double>();
    private Map<String, Integer> proc_prCountByType = new HashMap<String, Integer>();
    private Map<String, Double> proc_recallByType = new HashMap<String, Double>();
    private Map<String, Integer> proc_recCountByType = new HashMap<String, Integer>();
    private Map<String, Double> proc_fMeasureByType = new HashMap<String, Double>();
    private Map<String, Integer> proc_fMeasureCountByType = new HashMap<String, Integer>();
    private Map<String, Long> proc_missingByType = new HashMap<String, Long>();
    private Map<String, Long> proc_spurByType = new HashMap<String, Long>();
    private Map<String, Long> proc_correctByType = new HashMap<String, Long>();
    private Map<String, Long> proc_partialByType = new HashMap<String, Long>();
    double beta = 1.0;
    private int docNumber = 0;
    private boolean isGenerateMode = false;
    private boolean isVerboseMode = false;
    private boolean isMoreInfoMode = false;
    private Set<String> diffFeaturesSet;
    private boolean isMarkedStored = false;
    private boolean isMarkedClean = false;
    private boolean isMarkedDS = false;
    private String annotSetName = "Key";
    private String outputSetName = null;
    private double threshold = 0.5;
    private Properties configs = new Properties();
    private static int corpusWordCount;
    private String documentEncoding = "";
    private static String usage;

    public void initPRs() {
        if (this.applicationFile == null) {
            throw new GateRuntimeException("Application not set!");
        }
        try {
            Out.prln("App file is: " + this.applicationFile.getAbsolutePath());
            this.application = (Controller)PersistenceManager.loadObjectFromFile(this.applicationFile);
        }
        catch (Exception ex) {
            throw new GateRuntimeException("Corpus Benchmark Tool:" + ex.getMessage(), ex);
        }
    }

    public void unloadPRs() {
        if (this.isMarkedStored) {
            return;
        }
    }

    public void execute() {
        this.execute(this.startDir);
        if (this.application != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Iterator<ProcessingResource> iter = new ArrayList<ProcessingResource>(CorpusBenchmarkTool.this.application.getPRs()).iterator();
                    while (iter.hasNext()) {
                        Factory.deleteResource(iter.next());
                    }
                    Factory.deleteResource(CorpusBenchmarkTool.this.application);
                }
            });
        }
    }

    public void init() {
        block26: {
            File propFile = new File(this.getStartDirectory(), "corpus_tool.properties");
            if (!propFile.exists()) {
                propFile = new File("corpus_tool.properties");
            }
            Out.prln("Loading properties from " + propFile.getAbsolutePath());
            if (propFile.exists()) {
                try (FileInputStream inputStream = new FileInputStream(propFile);){
                    String types;
                    String encodingString;
                    String setName;
                    this.configs.load(inputStream);
                    String thresholdString = this.configs.getProperty("threshold");
                    if (thresholdString != null && !thresholdString.equals("")) {
                        thresholdString = thresholdString.trim();
                        this.threshold = Double.valueOf(thresholdString);
                        Out.prln("New threshold is: " + this.threshold + "<P>\n");
                    }
                    if ((setName = this.configs.getProperty("annotSetName")) != null && !setName.equals("")) {
                        setName = setName.trim();
                        Out.prln("Annotation set in marked docs is: " + setName + " <P>\n");
                        this.annotSetName = setName;
                    }
                    if ((setName = this.configs.getProperty("outputSetName")) != null && !setName.equals("")) {
                        setName = setName.trim();
                        Out.prln("Annotation set in processed docs is: " + setName + " <P>\n");
                        this.outputSetName = setName;
                    }
                    if ((encodingString = this.configs.getProperty("encoding")) != null && !encodingString.equals("")) {
                        this.documentEncoding = encodingString = encodingString.trim();
                        Out.prln("New encoding is: " + this.documentEncoding + "<P>\n");
                    }
                    if ((types = this.configs.getProperty("annotTypes")) != null && !types.equals("")) {
                        types = types.trim();
                        Out.prln("Using annotation types from the properties file. <P>\n");
                        StringTokenizer strTok = new StringTokenizer(types, ";");
                        annotTypes = new ArrayList<String>();
                        while (strTok.hasMoreTokens()) {
                            annotTypes.add(strTok.nextToken());
                        }
                    } else {
                        annotTypes = new ArrayList<String>();
                        annotTypes.add("Organization");
                        annotTypes.add("Person");
                        annotTypes.add("Date");
                        annotTypes.add("Location");
                        annotTypes.add("Address");
                        annotTypes.add("Money");
                        annotTypes.add("Percent");
                        annotTypes.add("GPE");
                        annotTypes.add("Facility");
                    }
                    String features = this.configs.getProperty("annotFeatures");
                    HashSet<String> result = new HashSet<String>();
                    if (features != null && !features.equals("")) {
                        features = features.trim();
                        Out.pr("Using annotation features from the properties file. \n");
                        StringTokenizer tok = new StringTokenizer(features, ";");
                        while (tok.hasMoreTokens()) {
                            String current = tok.nextToken();
                            result.add(current);
                        }
                    }
                    this.diffFeaturesSet = result;
                    Out.prln("Features: " + this.diffFeaturesSet + " <P>\n");
                    break block26;
                }
                catch (IOException ex) {
                    throw new GateRuntimeException("Error loading " + propFile.getAbsolutePath(), ex);
                }
            }
            Err.prln(propFile.getAbsolutePath() + " does not exist, using default settings");
            this.configs = new Properties();
        }
        if (!this.isMarkedStored) {
            this.initPRs();
        }
    }

    public void execute(File dir) {
        if (dir == null) {
            return;
        }
        this.currDir = dir;
        File processedDir = null;
        File cleanDir = null;
        File markedDir = null;
        File errorDir = null;
        ArrayList<File> subDirs = new ArrayList<File>();
        File[] dirArray = this.currDir.listFiles();
        if (dirArray == null) {
            return;
        }
        for (int i = 0; i < dirArray.length; ++i) {
            if (dirArray[i].isFile() || dirArray[i].getName().equals(CVS_DIR_NAME)) continue;
            if (dirArray[i].getName().equals(CLEAN_DIR_NAME)) {
                cleanDir = dirArray[i];
                continue;
            }
            if (dirArray[i].getName().equals(MARKED_DIR_NAME)) {
                markedDir = dirArray[i];
                continue;
            }
            if (dirArray[i].getName().equals(PROCESSED_DIR_NAME)) {
                processedDir = dirArray[i];
                continue;
            }
            if (dirArray[i].getName().equals(ERROR_DIR_NAME)) {
                errorDir = dirArray[i];
                continue;
            }
            subDirs.add(dirArray[i]);
        }
        if (cleanDir == null) {
            return;
        }
        Out.prln("Processing directory: " + this.currDir + "<P>");
        if (this.isGenerateMode) {
            this.generateCorpus(cleanDir, processedDir);
        } else {
            this.evaluateCorpus(cleanDir, processedDir, markedDir, errorDir);
        }
        if (subDirs.isEmpty()) {
            return;
        }
        for (int j = 0; j < subDirs.size(); ++j) {
            this.execute((File)subDirs.get(j));
        }
    }

    public static void main(String[] args) throws GateException {
        String appName;
        File appFile;
        int i;
        Out.prln("<HTML>");
        Out.prln("<HEAD>");
        Out.prln("<TITLE> Corpus benchmark tool: ran with args ");
        for (int argC = 0; argC < args.length; ++argC) {
            Out.pr(args[argC] + " ");
        }
        Out.pr(" on " + new Date() + "</TITLE> </HEAD>");
        Out.prln("<BODY>");
        Out.prln("Please wait while GATE tools are initialised. <P>");
        Gate.init();
        CorpusBenchmarkTool corpusTool = new CorpusBenchmarkTool();
        if (args.length < 1) {
            throw new GateException(usage);
        }
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            if (args[i].equals("-generate")) {
                Out.prln("Generating the corpus... <P>");
                corpusTool.setGenerateMode(true);
                continue;
            }
            if (args[i].equals("-marked_clean")) {
                Out.prln("Evaluating current grammars against human-annotated...<P>");
                corpusTool.setMarkedClean(true);
                continue;
            }
            if (args[i].equals("-marked_stored")) {
                Out.prln("Evaluating stored documents against human-annotated...<P>");
                corpusTool.setMarkedStored(true);
                continue;
            }
            if (args[i].equals("-marked_ds")) {
                Out.prln("Looking for marked docs in a datastore...<P>");
                corpusTool.setMarkedDS(true);
                continue;
            }
            if (args[i].equals("-verbose")) {
                Out.prln("Running in verbose mode. Will generate annotation information when precision/recall are lower than " + corpusTool.getThreshold() + "<P>");
                corpusTool.setVerboseMode(true);
                continue;
            }
            if (!args[i].equals("-moreinfo")) continue;
            Out.prln("Show more details in document table...<P>");
            corpusTool.setMoreInfo(true);
        }
        String dirName = args[i];
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            throw new GateException(usage);
        }
        if (!(appFile = new File(appName = args[++i])).isFile()) {
            throw new GateException(usage);
        }
        corpusTool.setApplicationFile(appFile);
        corpusTool.init();
        corpusWordCount = 0;
        Out.prln("Measuring annotaitions of types: " + annotTypes + "<P>");
        corpusTool.setStartDirectory(dir);
        corpusTool.execute();
        if (!corpusTool.getGenerateMode()) {
            corpusTool.printStatistics();
        }
        Out.prln("<BR>Overall average precision: " + corpusTool.getPrecisionAverage());
        Out.prln("<BR>Overall average recall: " + corpusTool.getRecallAverage());
        Out.prln("<BR>Overall average fMeasure: " + corpusTool.getFMeasureAverage());
        if (corpusWordCount == 0) {
            Out.prln("<BR>No Token annotations to count words in the corpus.");
        } else {
            Out.prln("<BR>Overall word count: " + corpusWordCount);
        }
        if (hasProcessed) {
            Out.prln("<P>Old Processed: ");
            Out.prln("<BR>Overall average precision: " + corpusTool.getPrecisionAverageProc());
            Out.prln("<BR>Overall average recall: " + corpusTool.getRecallAverageProc());
            Out.prln("<BR>Overall average fMeasure: " + corpusTool.getFMeasureAverageProc());
        }
        Out.prln("<BR>Finished! <P>");
        Out.prln("</BODY>");
        Out.prln("</HTML>");
        System.exit(0);
    }

    public void setGenerateMode(boolean mode) {
        this.isGenerateMode = mode;
    }

    public boolean getGenerateMode() {
        return this.isGenerateMode;
    }

    public boolean getVerboseMode() {
        return this.isVerboseMode;
    }

    public void setVerboseMode(boolean mode) {
        this.isVerboseMode = mode;
    }

    public void setMoreInfo(boolean mode) {
        this.isMoreInfoMode = mode;
    }

    public boolean getMoreInfo() {
        return this.isMoreInfoMode;
    }

    public void setDiffFeaturesList(Set<String> features) {
        this.diffFeaturesSet = features;
    }

    public Set<String> getDiffFeaturesList() {
        return this.diffFeaturesSet;
    }

    public void setMarkedStored(boolean mode) {
        this.isMarkedStored = mode;
    }

    public boolean getMarkedStored() {
        return this.isMarkedStored;
    }

    public void setMarkedClean(boolean mode) {
        this.isMarkedClean = mode;
    }

    public boolean getMarkedClean() {
        return this.isMarkedClean;
    }

    public void setMarkedDS(boolean mode) {
        this.isMarkedDS = mode;
    }

    public boolean getMarkedDS() {
        return this.isMarkedDS;
    }

    public void setApplicationFile(File newAppFile) {
        this.applicationFile = newAppFile;
    }

    public double getPrecisionAverage() {
        return this.precisionSum / (double)this.docNumber;
    }

    public double getRecallAverage() {
        return this.recallSum / (double)this.docNumber;
    }

    public double getFMeasureAverage() {
        return this.fMeasureSum / (double)this.docNumber;
    }

    public double getPrecisionAverageProc() {
        return this.proc_precisionSum / (double)this.docNumber;
    }

    public double getRecallAverageProc() {
        return this.proc_recallSum / (double)this.docNumber;
    }

    public double getFMeasureAverageProc() {
        return this.proc_fMeasureSum / (double)this.docNumber;
    }

    public boolean isGenerateMode() {
        return this.isGenerateMode;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double newValue) {
        this.threshold = newValue;
    }

    public File getStartDirectory() {
        return this.startDir;
    }

    public void setStartDirectory(File dir) {
        this.startDir = dir;
    }

    protected void generateCorpus(File fileDir, File outputDir) {
        if (fileDir == null) {
            return;
        }
        File outDir = outputDir;
        if (outputDir == null) {
            outDir = new File(this.currDir, PROCESSED_DIR_NAME);
        } else if (!Files.rmdir(outDir)) {
            Out.prln("cannot delete old output directory: " + outDir);
        }
        outDir.mkdir();
        try {
            SerialDataStore sds = new SerialDataStore(outDir.toURI().toURL().toString());
            sds.create();
            sds.open();
            File[] files = fileDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                Out.prln("Processing and storing document: " + files[i].toURI().toURL() + "<P>");
                FeatureMap params = Factory.newFeatureMap();
                params.put("sourceUrl", files[i].toURI().toURL());
                params.put("encoding", this.documentEncoding);
                FeatureMap features = Factory.newFeatureMap();
                final Document doc = (Document)Factory.createResource("gate.corpora.DocumentImpl", params, features);
                doc.setName(files[i].getName());
                this.processDocument(doc);
                final LanguageResource lr = sds.adopt(doc);
                sds.sync(lr);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Factory.deleteResource(doc);
                        Factory.deleteResource(lr);
                    }
                });
            }
            sds.close();
        }
        catch (MalformedURLException ex) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + ex.getMessage()).initCause(ex);
        }
        catch (PersistenceException ex1) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + ex1.getMessage()).initCause(ex1);
        }
        catch (ResourceInstantiationException ex2) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + ex2.getMessage()).initCause(ex2);
        }
    }

    protected void evaluateCorpus(File fileDir, File processedDir, File markedDir, File errorDir) {
        boolean processMarked;
        if (fileDir == null || !fileDir.exists()) {
            return;
        }
        if (processedDir == null || !processedDir.exists()) {
            if (this.isMarkedStored) {
                Out.prln("Cannot evaluate because no processed documents exist.");
                return;
            }
            this.isMarkedClean = true;
        }
        File errDir = null;
        if (this.isMoreInfoMode) {
            errDir = errorDir;
            if (errDir == null) {
                errDir = new File(this.currDir, ERROR_DIR_NAME);
            } else if (!Files.rmdir(errDir)) {
                Out.prln("cannot delete old error directory: " + errDir);
            }
            Out.prln("Create error directory: " + errDir + "<BR><BR>");
            errDir.mkdir();
        }
        boolean bl = processMarked = markedDir != null && markedDir.exists();
        if (!processMarked && (this.isMarkedStored || this.isMarkedClean)) {
            Out.prln("Cannot evaluate because no human-annotated documents exist.");
            return;
        }
        if (this.isMarkedStored) {
            this.evaluateMarkedStored(markedDir, processedDir, errDir);
            return;
        }
        if (this.isMarkedClean) {
            this.evaluateMarkedClean(markedDir, fileDir, errDir);
            return;
        }
        Document persDoc = null;
        Document cleanDoc = null;
        Document markedDoc = null;
        try {
            DataStore sds = Factory.openDataStore("gate.persist.SerialDataStore", processedDir.toURI().toURL().toExternalForm());
            List<String> lrIDs = sds.getLrIds("gate.corpora.DocumentImpl");
            for (int i = 0; i < lrIDs.size(); ++i) {
                String docID = lrIDs.get(i);
                FeatureMap features = Factory.newFeatureMap();
                features.put("DataStore", sds);
                features.put("LRPersistenceId", docID);
                FeatureMap hparams = Factory.newFeatureMap();
                persDoc = (Document)Factory.createResource("gate.corpora.DocumentImpl", features, hparams);
                if (this.isMoreInfoMode) {
                    StringBuffer errName = new StringBuffer(persDoc.getName());
                    errName.replace(persDoc.getName().lastIndexOf("."), persDoc.getName().length(), ".err");
                    Out.prln("<H2><a href=\"err/" + errName.toString() + "\">" + persDoc.getName() + "</a></H2>");
                } else {
                    Out.prln("<H2>" + persDoc.getName() + "</H2>");
                }
                File cleanDocFile = new File(fileDir, persDoc.getName());
                if (!cleanDocFile.exists()) {
                    Out.prln("Warning: Cannot find original document " + persDoc.getName() + " in " + fileDir);
                } else {
                    FeatureMap params = Factory.newFeatureMap();
                    params.put("sourceUrl", cleanDocFile.toURI().toURL());
                    params.put("encoding", this.documentEncoding);
                    cleanDoc = (Document)Factory.createResource("gate.corpora.DocumentImpl", params, hparams);
                    cleanDoc.setName(persDoc.getName());
                }
                StringBuffer docName = new StringBuffer(persDoc.getName());
                if (!this.isMarkedDS) {
                    docName.replace(persDoc.getName().lastIndexOf("."), docName.length(), ".xml");
                    File markedDocFile = new File(markedDir, docName.toString());
                    if (!processMarked || !markedDocFile.exists()) {
                        Out.prln("Warning: Cannot find human-annotated document " + markedDocFile + " in " + markedDir);
                    } else {
                        FeatureMap params = Factory.newFeatureMap();
                        params.put("sourceUrl", markedDocFile.toURI().toURL());
                        params.put("encoding", this.documentEncoding);
                        markedDoc = (Document)Factory.createResource("gate.corpora.DocumentImpl", params, hparams);
                        markedDoc.setName(persDoc.getName());
                    }
                } else {
                    DataStore sds1 = Factory.openDataStore("gate.persist.SerialDataStore", markedDir.toURI().toURL().toExternalForm());
                    List<String> lrIDs1 = sds1.getLrIds("gate.corpora.DocumentImpl");
                    boolean found = false;
                    int k = 0;
                    while (k < lrIDs1.size() && !found) {
                        String docID1 = lrIDs1.get(k);
                        FeatureMap features1 = Factory.newFeatureMap();
                        features1.put("DataStore", sds1);
                        features1.put("LRPersistenceId", docID1);
                        Document tempDoc = (Document)Factory.createResource("gate.corpora.DocumentImpl", features1, hparams);
                        if (((String)tempDoc.getFeatures().get("gate.SourceURL")).endsWith(persDoc.getName())) {
                            found = true;
                            markedDoc = tempDoc;
                            continue;
                        }
                        ++k;
                    }
                }
                this.evaluateDocuments(persDoc, cleanDoc, markedDoc, errDir);
                if (persDoc != null) {
                    final Document pd = persDoc;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Factory.deleteResource(pd);
                        }
                    });
                }
                if (cleanDoc != null) {
                    final Document cd = cleanDoc;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Factory.deleteResource(cd);
                        }
                    });
                }
                if (markedDoc == null) continue;
                final Document md = markedDoc;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Factory.deleteResource(md);
                    }
                });
            }
            sds.close();
        }
        catch (MalformedURLException ex) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + ex.getMessage()).initCause(ex);
        }
        catch (PersistenceException ex1) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + ex1.getMessage()).initCause(ex1);
        }
        catch (ResourceInstantiationException ex2) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + ex2.getMessage()).initCause(ex2);
        }
    }

    protected void evaluateMarkedStored(File markedDir, File storedDir, File errDir) {
        Document persDoc = null;
        Document cleanDoc = null;
        Document markedDoc = null;
        try {
            DataStore sds = Factory.openDataStore("gate.persist.SerialDataStore", storedDir.toURI().toURL().toExternalForm());
            List<String> lrIDs = sds.getLrIds("gate.corpora.DocumentImpl");
            for (int i = 0; i < lrIDs.size(); ++i) {
                String docID = lrIDs.get(i);
                FeatureMap features = Factory.newFeatureMap();
                features.put("DataStore", sds);
                features.put("LRPersistenceId", docID);
                FeatureMap hparams = Factory.newFeatureMap();
                persDoc = (Document)Factory.createResource("gate.corpora.DocumentImpl", features, hparams);
                if (this.isMoreInfoMode) {
                    StringBuffer errName = new StringBuffer(persDoc.getName());
                    errName.replace(persDoc.getName().lastIndexOf("."), persDoc.getName().length(), ".err");
                    Out.prln("<H2><a href=\"err/" + errName.toString() + "\">" + persDoc.getName() + "</a></H2>");
                } else {
                    Out.prln("<H2>" + persDoc.getName() + "</H2>");
                }
                if (!this.isMarkedDS) {
                    StringBuffer docName = new StringBuffer(persDoc.getName());
                    docName.replace(persDoc.getName().lastIndexOf("."), docName.length(), ".xml");
                    File markedDocFile = new File(markedDir, docName.toString());
                    if (!markedDocFile.exists()) {
                        Out.prln("Warning: Cannot find human-annotated document " + markedDocFile + " in " + markedDir);
                    } else {
                        FeatureMap params = Factory.newFeatureMap();
                        params.put("sourceUrl", markedDocFile.toURI().toURL());
                        params.put("encoding", this.documentEncoding);
                        markedDoc = (Document)Factory.createResource("gate.corpora.DocumentImpl", params, hparams);
                        markedDoc.setName(persDoc.getName());
                    }
                } else {
                    try {
                        DataStore sds1 = Factory.openDataStore("gate.persist.SerialDataStore", markedDir.toURI().toURL().toExternalForm());
                        List<String> lrIDs1 = sds1.getLrIds("gate.corpora.DocumentImpl");
                        boolean found = false;
                        int k = 0;
                        while (k < lrIDs1.size() && !found) {
                            String docID1 = lrIDs1.get(k);
                            FeatureMap features1 = Factory.newFeatureMap();
                            features1.put("DataStore", sds1);
                            features1.put("LRPersistenceId", docID1);
                            Document tempDoc = (Document)Factory.createResource("gate.corpora.DocumentImpl", features1, hparams);
                            if (((String)tempDoc.getFeatures().get("gate.SourceURL")).endsWith(persDoc.getName())) {
                                found = true;
                                markedDoc = tempDoc;
                                continue;
                            }
                            ++k;
                        }
                    }
                    catch (MalformedURLException ex) {
                        Out.prln("Error finding marked directory " + markedDir.getAbsolutePath());
                    }
                    catch (PersistenceException ex1) {
                        Out.prln("Error opening marked as a datastore (-marked_ds specified)");
                    }
                    catch (ResourceInstantiationException ex2) {
                        Out.prln("Error opening marked as a datastore (-marked_ds specified)");
                    }
                }
                this.evaluateDocuments(persDoc, cleanDoc, markedDoc, errDir);
                if (persDoc != null) {
                    final Document pd = persDoc;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Factory.deleteResource(pd);
                        }
                    });
                }
                if (markedDoc == null) continue;
                final Document md = markedDoc;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Factory.deleteResource(md);
                    }
                });
            }
            sds.close();
        }
        catch (MalformedURLException ex) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + ex.getMessage()).initCause(ex);
        }
        catch (PersistenceException ex1) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + ex1.getMessage()).initCause(ex1);
        }
        catch (ResourceInstantiationException ex2) {
            throw (GateRuntimeException)new GateRuntimeException("CorpusBenchmark: " + ex2.getMessage()).initCause(ex2);
        }
    }

    protected void evaluateMarkedClean(File markedDir, File cleanDir, File errDir) {
        Document persDoc = null;
        Document cleanDoc = null;
        Document markedDoc = null;
        File[] cleanDocs = cleanDir.listFiles();
        for (int i = 0; i < cleanDocs.length; ++i) {
            block23: {
                if (!cleanDocs[i].isFile()) continue;
                FeatureMap params = Factory.newFeatureMap();
                try {
                    params.put("sourceUrl", cleanDocs[i].toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    Out.prln("Cannot create document from file: " + cleanDocs[i].getAbsolutePath());
                    continue;
                }
                params.put("encoding", this.documentEncoding);
                FeatureMap hparams = Factory.newFeatureMap();
                try {
                    cleanDoc = (Document)Factory.createResource("gate.corpora.DocumentImpl", params, hparams, cleanDocs[i].getName());
                }
                catch (ResourceInstantiationException ex) {
                    Out.prln("Cannot create document from file: " + cleanDocs[i].getAbsolutePath());
                    continue;
                }
                if (this.isMoreInfoMode) {
                    StringBuffer errName = new StringBuffer(cleanDocs[i].getName());
                    errName.replace(cleanDocs[i].getName().lastIndexOf("."), cleanDocs[i].getName().length(), ".err");
                    Out.prln("<H2><a href=\"err/" + errName.toString() + "\">" + cleanDocs[i].getName() + "</a></H2>");
                } else {
                    Out.prln("<H2>" + cleanDocs[i].getName() + "</H2>");
                }
                if (!this.isMarkedDS) {
                    StringBuffer docName = new StringBuffer(cleanDoc.getName());
                    docName.replace(cleanDoc.getName().lastIndexOf("."), docName.length(), ".xml");
                    File markedDocFile = new File(markedDir, docName.toString());
                    if (!markedDocFile.exists()) {
                        Out.prln("Warning: Cannot find human-annotated document " + markedDocFile + " in " + markedDir);
                        continue;
                    }
                    params = Factory.newFeatureMap();
                    try {
                        params.put("sourceUrl", markedDocFile.toURI().toURL());
                    }
                    catch (MalformedURLException ex) {
                        Out.prln("Cannot create document from file: " + markedDocFile.getAbsolutePath());
                        continue;
                    }
                    params.put("encoding", this.documentEncoding);
                    try {
                        markedDoc = (Document)Factory.createResource("gate.corpora.DocumentImpl", params, hparams, cleanDoc.getName());
                        break block23;
                    }
                    catch (ResourceInstantiationException ex) {
                        Out.prln("Cannot create document from file: " + markedDocFile.getAbsolutePath());
                        continue;
                    }
                }
                try {
                    DataStore sds1 = Factory.openDataStore("gate.persist.SerialDataStore", markedDir.toURI().toURL().toExternalForm());
                    List<String> lrIDs1 = sds1.getLrIds("gate.corpora.DocumentImpl");
                    boolean found = false;
                    int k = 0;
                    while (k < lrIDs1.size() && !found) {
                        String docID1 = lrIDs1.get(k);
                        FeatureMap features1 = Factory.newFeatureMap();
                        features1.put("DataStore", sds1);
                        features1.put("LRPersistenceId", docID1);
                        Document tempDoc = (Document)Factory.createResource("gate.corpora.DocumentImpl", features1, hparams);
                        if (((String)tempDoc.getFeatures().get("gate.SourceURL")).endsWith(cleanDoc.getName())) {
                            found = true;
                            markedDoc = tempDoc;
                            continue;
                        }
                        ++k;
                    }
                }
                catch (MalformedURLException ex) {
                    Out.prln("Error finding marked directory " + markedDir.getAbsolutePath());
                }
                catch (PersistenceException ex1) {
                    Out.prln("Error opening marked as a datastore (-marked_ds specified)");
                }
                catch (ResourceInstantiationException ex2) {
                    Out.prln("Error opening marked as a datastore (-marked_ds specified)");
                }
            }
            try {
                this.evaluateDocuments(persDoc, cleanDoc, markedDoc, errDir);
            }
            catch (ResourceInstantiationException ex) {
                ex.printStackTrace();
                Out.prln("Evaluate failed on document: " + cleanDoc.getName());
            }
            if (persDoc != null) {
                final Document pd = persDoc;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Factory.deleteResource(pd);
                    }
                });
            }
            if (cleanDoc != null) {
                final Document cd = cleanDoc;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Factory.deleteResource(cd);
                    }
                });
            }
            if (markedDoc == null) continue;
            final Document md = markedDoc;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Factory.deleteResource(md);
                }
            });
        }
    }

    protected void processDocument(Document doc) {
        try {
            if (this.application instanceof CorpusController) {
                Corpus tempCorpus = Factory.newCorpus("temp");
                tempCorpus.add(doc);
                ((CorpusController)this.application).setCorpus(tempCorpus);
                this.application.execute();
                Factory.deleteResource(tempCorpus);
                tempCorpus = null;
            } else {
                Iterator<ProcessingResource> iter = this.application.getPRs().iterator();
                while (iter.hasNext()) {
                    iter.next().setParameterValue("document", doc);
                }
                this.application.execute();
            }
        }
        catch (ResourceInstantiationException ex) {
            throw (RuntimeException)new RuntimeException("Error executing application: " + ex.getMessage()).initCause(ex);
        }
        catch (ExecutionException ex) {
            throw (RuntimeException)new RuntimeException("Error executing application: " + ex.getMessage()).initCause(ex);
        }
    }

    protected void evaluateDocuments(Document persDoc, Document cleanDoc, Document markedDoc, File errDir) throws ResourceInstantiationException {
        if (cleanDoc == null && markedDoc == null) {
            return;
        }
        if (annotTypes == null || annotTypes.isEmpty()) {
            return;
        }
        if (cleanDoc != null && !this.isMarkedStored) {
            this.processDocument(cleanDoc);
            int wordCount = this.countWords(cleanDoc);
            if (wordCount == 0) {
                Out.prln("<BR>No Token annotations to count words in the document.");
            } else {
                Out.prln("<BR>Word count: " + wordCount);
            }
            corpusWordCount += wordCount;
            if (!this.isMarkedClean) {
                this.evaluateAllThree(persDoc, cleanDoc, markedDoc, errDir);
            } else {
                this.evaluateTwoDocs(markedDoc, cleanDoc, errDir);
            }
        } else {
            this.evaluateTwoDocs(markedDoc, persDoc, errDir);
        }
    }

    protected int countWords(Document annotDoc) {
        int count = 0;
        if (annotDoc == null) {
            return 0;
        }
        AnnotationSet tokens = annotDoc.getAnnotations(this.outputSetName).get("Token");
        if (tokens == null) {
            return 0;
        }
        for (Annotation currAnnotation : tokens) {
            Object feature = currAnnotation.getFeatures().get("kind");
            if (feature == null || !"word".equalsIgnoreCase((String)feature)) continue;
            ++count;
        }
        return count;
    }

    protected void evaluateAllThree(Document persDoc, Document cleanDoc, Document markedDoc, File errDir) throws ResourceInstantiationException {
        this.printTableHeader();
        Writer errWriter = null;
        if (this.isMoreInfoMode && errDir != null) {
            StringBuffer docName = new StringBuffer(cleanDoc.getName());
            docName.replace(cleanDoc.getName().lastIndexOf("."), docName.length(), ".err");
            File errFile = new File(errDir, docName.toString());
            try {
                errWriter = new FileWriter(errFile, false);
            }
            catch (Exception ex) {
                Out.prln("Exception when creating the error file " + errFile + ": " + ex.getMessage());
                errWriter = null;
            }
        }
        for (int jj = 0; jj < annotTypes.size(); ++jj) {
            String annotType = annotTypes.get(jj);
            AnnotationDiffer annotDiffer = this.measureDocs(markedDoc, cleanDoc, annotType);
            if (annotDiffer == null) continue;
            ++this.docNumber;
            this.updateStatistics(annotDiffer, annotType);
            AnnotationDiffer annotDiffer1 = this.measureDocs(markedDoc, persDoc, annotType);
            Out.prln("<TR>");
            if (this.isMoreInfoMode && annotDiffer1 != null && (annotDiffer1.getPrecisionAverage() != annotDiffer.getPrecisionAverage() || annotDiffer1.getRecallAverage() != annotDiffer.getRecallAverage())) {
                Out.prln("<TD> " + annotType + "_new</TD>");
            } else {
                Out.prln("<TD> " + annotType + "</TD>");
            }
            if (this.isMoreInfoMode) {
                if (annotDiffer1 != null) {
                    this.updateStatisticsProc(annotDiffer1, annotType);
                }
                Out.prln("<TD>" + annotDiffer.getCorrectMatches() + "</TD>");
                Out.prln("<TD>" + annotDiffer.getPartiallyCorrectMatches() + "</TD>");
                Out.prln("<TD>" + annotDiffer.getMissing() + "</TD>");
                Out.prln("<TD>" + annotDiffer.getSpurious() + "</TD>");
            }
            Out.prln("<TD>");
            if (annotDiffer1 != null) {
                if (annotDiffer1.getPrecisionAverage() < annotDiffer.getPrecisionAverage()) {
                    Out.prln("<P><Font color=blue> ");
                    Out.prln(annotDiffer.getPrecisionAverage());
                    if (!this.isMoreInfoMode) {
                        Out.pr("<BR>Precision increase on human-marked from ");
                        Out.pr(annotDiffer1.getPrecisionAverage() + " to ");
                        Out.prln(annotDiffer.getPrecisionAverage());
                    }
                    Out.prln(" </Font></P>");
                } else if (annotDiffer1.getPrecisionAverage() > annotDiffer.getPrecisionAverage()) {
                    Out.prln("<P><Font color=red> ");
                    Out.prln(annotDiffer.getPrecisionAverage());
                    if (!this.isMoreInfoMode) {
                        Out.pr("<BR>Precision decrease on human-marked from ");
                        Out.pr(annotDiffer1.getPrecisionAverage() + " to ");
                        Out.prln(annotDiffer.getPrecisionAverage());
                    }
                    Out.prln(" </Font></P>");
                } else {
                    Out.prln("<P> " + annotDiffer.getPrecisionAverage() + " </P>");
                }
            } else {
                Out.prln("<P> " + annotDiffer.getPrecisionAverage() + " </P>");
            }
            Out.prln("</TD>");
            Out.prln("<TD>");
            if (annotDiffer1 != null) {
                if (annotDiffer1.getRecallAverage() < annotDiffer.getRecallAverage()) {
                    Out.prln("<P><Font color=blue> ");
                    Out.prln(annotDiffer.getRecallAverage());
                    if (!this.isMoreInfoMode) {
                        Out.pr("<BR>Recall increase on human-marked from ");
                        Out.pr(annotDiffer1.getRecallAverage() + " to ");
                        Out.prln(annotDiffer.getRecallAverage());
                    }
                    Out.prln(" </Font></P>");
                } else if (annotDiffer1.getRecallAverage() > annotDiffer.getRecallAverage()) {
                    Out.prln("<P><Font color=red> ");
                    Out.prln(annotDiffer.getRecallAverage());
                    if (!this.isMoreInfoMode) {
                        Out.pr("<BR>Recall decrease on human-marked from ");
                        Out.pr(annotDiffer1.getRecallAverage() + " to ");
                        Out.prln(annotDiffer.getRecallAverage());
                    }
                    Out.prln(" </Font></P>");
                } else {
                    Out.prln("<P> " + annotDiffer.getRecallAverage() + " </P>");
                }
            } else {
                Out.prln("<P> " + annotDiffer.getRecallAverage() + " </P>");
            }
            Out.prln("</TD>");
            if (this.isVerboseMode) {
                Out.prln("<TD>");
                if (annotDiffer.getRecallAverage() < this.threshold || annotDiffer.getPrecisionAverage() < this.threshold) {
                    this.printAnnotations(annotDiffer, markedDoc, cleanDoc);
                } else {
                    Out.prln("&nbsp;");
                }
                Out.prln("</TD>");
            }
            Out.prln("</TR>");
            if (this.isMoreInfoMode && annotDiffer1 != null && (annotDiffer1.getPrecisionAverage() != annotDiffer.getPrecisionAverage() || annotDiffer1.getRecallAverage() != annotDiffer.getRecallAverage())) {
                Out.prln("<TR>");
                Out.prln("<TD> " + annotType + "_old</TD>");
                Out.prln("<TD>" + annotDiffer1.getCorrectMatches() + "</TD>");
                Out.prln("<TD>" + annotDiffer1.getPartiallyCorrectMatches() + "</TD>");
                Out.prln("<TD>" + annotDiffer1.getMissing() + "</TD>");
                Out.prln("<TD>" + annotDiffer1.getSpurious() + "</TD>");
                Out.prln("<TD>");
                if (annotDiffer1.getPrecisionAverage() < annotDiffer.getPrecisionAverage()) {
                    Out.prln("<P><Font color=blue> " + annotDiffer1.getPrecisionAverage() + "</Font></P>");
                } else if (annotDiffer1.getPrecisionAverage() > annotDiffer.getPrecisionAverage()) {
                    Out.prln("<P><Font color=red> " + annotDiffer1.getPrecisionAverage() + " </Font></P>");
                } else {
                    Out.prln(annotDiffer1.getPrecisionAverage());
                }
                Out.prln("</TD>");
                Out.prln("<TD>");
                if (annotDiffer1.getRecallAverage() < annotDiffer.getRecallAverage()) {
                    Out.prln("<P><Font color=blue> " + annotDiffer1.getRecallAverage() + " </Font></P>");
                } else if (annotDiffer1.getRecallAverage() > annotDiffer.getRecallAverage()) {
                    Out.prln("<P><Font color=red> " + annotDiffer1.getRecallAverage() + " </Font></P>");
                } else {
                    Out.prln(annotDiffer1.getRecallAverage());
                }
                Out.prln("</TD>");
                if (this.isVerboseMode) {
                    Out.prln("<TD>");
                    if (annotDiffer.getRecallAverage() < this.threshold || annotDiffer.getPrecisionAverage() < this.threshold) {
                        this.printAnnotations(annotDiffer, markedDoc, cleanDoc);
                    } else {
                        Out.prln("&nbsp;");
                    }
                    Out.prln("</TD>");
                }
                Out.prln("</TR>");
            }
            if (!this.isMoreInfoMode || errDir == null) continue;
            this.storeAnnotations(annotType, annotDiffer, markedDoc, cleanDoc, errWriter);
        }
        Out.prln("</TABLE>");
        try {
            if (errWriter != null) {
                errWriter.close();
            }
        }
        catch (Exception ex) {
            Out.prln("Exception on close of error file " + errWriter + ": " + ex.getMessage());
        }
    }

    protected void evaluateTwoDocs(Document keyDoc, Document respDoc, File errDir) throws ResourceInstantiationException {
        this.printTableHeader();
        Writer errWriter = null;
        if (this.isMoreInfoMode && errDir != null) {
            StringBuffer docName = new StringBuffer(keyDoc.getName());
            docName.replace(keyDoc.getName().lastIndexOf("."), docName.length(), ".err");
            File errFile = new File(errDir, docName.toString());
            try {
                errWriter = new FileWriter(errFile, false);
            }
            catch (Exception ex) {
                Out.prln("Exception when creating the error file " + errFile + ": " + ex.getMessage());
                errWriter = null;
            }
        }
        for (int jj = 0; jj < annotTypes.size(); ++jj) {
            String annotType = annotTypes.get(jj);
            AnnotationDiffer annotDiff = this.measureDocs(keyDoc, respDoc, annotType);
            if (annotDiff == null) continue;
            ++this.docNumber;
            this.updateStatistics(annotDiff, annotType);
            Out.prln("<TR>");
            Out.prln("<TD>" + annotType + "</TD>");
            if (this.isMoreInfoMode) {
                Out.prln("<TD>" + annotDiff.getCorrectMatches() + "</TD>");
                Out.prln("<TD>" + annotDiff.getPartiallyCorrectMatches() + "</TD>");
                Out.prln("<TD>" + annotDiff.getMissing() + "</TD>");
                Out.prln("<TD>" + annotDiff.getSpurious() + "</TD>");
            }
            Out.prln("<TD>" + annotDiff.getPrecisionAverage() + "</TD>");
            Out.prln("<TD>" + annotDiff.getRecallAverage() + "</TD>");
            if (this.isVerboseMode) {
                Out.prln("<TD>");
                if (annotDiff.getRecallAverage() < this.threshold || annotDiff.getPrecisionAverage() < this.threshold) {
                    this.printAnnotations(annotDiff, keyDoc, respDoc);
                } else {
                    Out.prln("&nbsp;");
                }
                Out.prln("</TD>");
            }
            Out.prln("</TR>");
            if (!this.isMoreInfoMode || errDir == null) continue;
            this.storeAnnotations(annotType, annotDiff, keyDoc, respDoc, errWriter);
        }
        Out.prln("</TABLE>");
        try {
            if (errWriter != null) {
                errWriter.close();
            }
        }
        catch (Exception ex) {
            Out.prln("Exception on close of error file " + errWriter + ": " + ex.getMessage());
        }
    }

    protected void printTableHeader() {
        Out.prln("<TABLE BORDER=1");
        Out.pr("<TR> <TD><B>Annotation Type</B></TD> ");
        if (this.isMoreInfoMode) {
            Out.pr("<TD><B>Correct</B></TD> <TD><B>Partially Correct</B></TD> <TD><B>Missing</B></TD> <TD><B>Spurious<B></TD>");
        }
        Out.pr("<TD><B>Precision</B></TD> <TD><B>Recall</B></TD>");
        if (this.isVerboseMode) {
            Out.pr("<TD><B>Annotations</B></TD>");
        }
        Out.prln("</TR>");
    }

    protected void updateStatistics(AnnotationDiffer annotDiffer, String annotType) {
        double precisionAverage = (annotDiffer.getPrecisionLenient() + annotDiffer.getPrecisionStrict()) / 2.0;
        if (Double.isNaN(precisionAverage)) {
            precisionAverage = 0.0;
        }
        this.precisionSum += precisionAverage;
        double recallAverage = (annotDiffer.getRecallLenient() + annotDiffer.getRecallStrict()) / 2.0;
        if (Double.isNaN(recallAverage)) {
            recallAverage = 0.0;
        }
        this.recallSum += recallAverage;
        double fMeasureAverage = (annotDiffer.getFMeasureLenient(1.0) + annotDiffer.getFMeasureStrict(1.0)) / 2.0;
        if (Double.isNaN(fMeasureAverage)) {
            fMeasureAverage = 0.0;
        }
        this.fMeasureSum += fMeasureAverage;
        Double oldPrecision = this.precisionByType.get(annotType);
        if (oldPrecision == null) {
            this.precisionByType.put(annotType, precisionAverage);
        } else {
            this.precisionByType.put(annotType, oldPrecision + precisionAverage);
        }
        Integer precCount = this.prCountByType.get(annotType);
        if (precCount == null) {
            this.prCountByType.put(annotType, 1);
        } else {
            this.prCountByType.put(annotType, precCount + 1);
        }
        Double oldFMeasure = this.fMeasureByType.get(annotType);
        if (oldFMeasure == null) {
            this.fMeasureByType.put(annotType, fMeasureAverage);
        } else {
            this.fMeasureByType.put(annotType, oldFMeasure + fMeasureAverage);
        }
        Integer fCount = this.fMeasureCountByType.get(annotType);
        if (fCount == null) {
            this.fMeasureCountByType.put(annotType, 1);
        } else {
            this.fMeasureCountByType.put(annotType, fCount + 1);
        }
        Double oldRecall = this.recallByType.get(annotType);
        if (oldRecall == null) {
            this.recallByType.put(annotType, recallAverage);
        } else {
            this.recallByType.put(annotType, oldRecall + recallAverage);
        }
        Integer recCount = this.recCountByType.get(annotType);
        if (recCount == null) {
            this.recCountByType.put(annotType, 1);
        } else {
            this.recCountByType.put(annotType, recCount + 1);
        }
        Long oldMissingNo = this.missingByType.get(annotType);
        if (oldMissingNo == null) {
            this.missingByType.put(annotType, new Long(annotDiffer.getMissing()));
        } else {
            this.missingByType.put(annotType, new Long(oldMissingNo + (long)annotDiffer.getMissing()));
        }
        Long oldCorrectNo = this.correctByType.get(annotType);
        if (oldCorrectNo == null) {
            this.correctByType.put(annotType, new Long(annotDiffer.getCorrectMatches()));
        } else {
            this.correctByType.put(annotType, new Long(oldCorrectNo + (long)annotDiffer.getCorrectMatches()));
        }
        Long oldPartialNo = this.partialByType.get(annotType);
        if (oldPartialNo == null) {
            this.partialByType.put(annotType, new Long(annotDiffer.getPartiallyCorrectMatches()));
        } else {
            this.partialByType.put(annotType, new Long(oldPartialNo + (long)annotDiffer.getPartiallyCorrectMatches()));
        }
        Long oldSpuriousNo = this.spurByType.get(annotType);
        if (oldSpuriousNo == null) {
            this.spurByType.put(annotType, new Long(annotDiffer.getSpurious()));
        } else {
            this.spurByType.put(annotType, new Long(oldSpuriousNo + (long)annotDiffer.getSpurious()));
        }
    }

    protected void updateStatisticsProc(AnnotationDiffer annotDiffer, String annotType) {
        hasProcessed = true;
        double precisionAverage = (annotDiffer.getPrecisionLenient() + annotDiffer.getPrecisionStrict()) / 2.0;
        if (Double.isNaN(precisionAverage)) {
            precisionAverage = 0.0;
        }
        this.proc_precisionSum += precisionAverage;
        double recallAverage = (annotDiffer.getRecallLenient() + annotDiffer.getRecallStrict()) / 2.0;
        if (Double.isNaN(recallAverage)) {
            recallAverage = 0.0;
        }
        this.proc_recallSum += recallAverage;
        double fMeasureAverage = (annotDiffer.getFMeasureLenient(1.0) + annotDiffer.getFMeasureStrict(1.0)) / 2.0;
        if (Double.isNaN(fMeasureAverage)) {
            fMeasureAverage = 0.0;
        }
        this.proc_fMeasureSum += fMeasureAverage;
        Double oldPrecision = this.proc_precisionByType.get(annotType);
        if (oldPrecision == null) {
            this.proc_precisionByType.put(annotType, precisionAverage);
        } else {
            this.proc_precisionByType.put(annotType, oldPrecision + precisionAverage);
        }
        Integer precCount = this.proc_prCountByType.get(annotType);
        if (precCount == null) {
            this.proc_prCountByType.put(annotType, new Integer(1));
        } else {
            this.proc_prCountByType.put(annotType, new Integer(precCount + 1));
        }
        Double oldFMeasure = this.proc_fMeasureByType.get(annotType);
        if (oldFMeasure == null) {
            this.proc_fMeasureByType.put(annotType, fMeasureAverage);
        } else {
            this.proc_fMeasureByType.put(annotType, oldFMeasure + fMeasureAverage);
        }
        Integer fCount = this.proc_fMeasureCountByType.get(annotType);
        if (fCount == null) {
            this.proc_fMeasureCountByType.put(annotType, 1);
        } else {
            this.proc_fMeasureCountByType.put(annotType, fCount + 1);
        }
        Double oldRecall = this.proc_recallByType.get(annotType);
        if (oldRecall == null) {
            this.proc_recallByType.put(annotType, new Double(recallAverage));
        } else {
            this.proc_recallByType.put(annotType, new Double(oldRecall + recallAverage));
        }
        Integer recCount = this.proc_recCountByType.get(annotType);
        if (recCount == null) {
            this.proc_recCountByType.put(annotType, new Integer(1));
        } else {
            this.proc_recCountByType.put(annotType, new Integer(recCount + 1));
        }
        Long oldMissingNo = this.proc_missingByType.get(annotType);
        if (oldMissingNo == null) {
            this.proc_missingByType.put(annotType, new Long(annotDiffer.getMissing()));
        } else {
            this.proc_missingByType.put(annotType, new Long(oldMissingNo + (long)annotDiffer.getMissing()));
        }
        Long oldCorrectNo = this.proc_correctByType.get(annotType);
        if (oldCorrectNo == null) {
            this.proc_correctByType.put(annotType, new Long(annotDiffer.getCorrectMatches()));
        } else {
            this.proc_correctByType.put(annotType, new Long(oldCorrectNo + (long)annotDiffer.getCorrectMatches()));
        }
        Long oldPartialNo = this.proc_partialByType.get(annotType);
        if (oldPartialNo == null) {
            this.proc_partialByType.put(annotType, new Long(annotDiffer.getPartiallyCorrectMatches()));
        } else {
            this.proc_partialByType.put(annotType, new Long(oldPartialNo + (long)annotDiffer.getPartiallyCorrectMatches()));
        }
        Long oldSpuriousNo = this.proc_spurByType.get(annotType);
        if (oldSpuriousNo == null) {
            this.proc_spurByType.put(annotType, new Long(annotDiffer.getSpurious()));
        } else {
            this.proc_spurByType.put(annotType, new Long(oldSpuriousNo + (long)annotDiffer.getSpurious()));
        }
    }

    public void printStatistics() {
        Out.prln("<H2> Statistics </H2>");
        if (annotTypes == null) {
            Out.prln("No types given for evaluation, cannot obtain precision/recall");
            return;
        }
        Out.prln("<table border=1>");
        Out.prln("<TR> <TD><B>Annotation Type</B></TD> <TD><B>Correct</B></TD><TD><B>Partially Correct</B></TD> <TD><B>Missing</B></TD><TD><B>Spurious</B></TD> <TD><B>Precision</B></TD><TD><B>Recall</B></TD> <TD><B>F-Measure</B></TD> </TR>");
        for (int i = 0; i < annotTypes.size(); ++i) {
            String annotType = annotTypes.get(i);
            this.printStatsForType(annotType);
        }
        Out.prln("</table>");
    }

    protected void printStatsForType(String annotType) {
        String strFmes;
        long correct = this.correctByType.get(annotType) == null ? 0L : this.correctByType.get(annotType);
        long partial = this.partialByType.get(annotType) == null ? 0L : this.partialByType.get(annotType);
        long spurious = this.spurByType.get(annotType) == null ? 0L : this.spurByType.get(annotType);
        long missing = this.missingByType.get(annotType) == null ? 0L : this.missingByType.get(annotType);
        long actual = correct + partial + spurious;
        long possible = correct + partial + missing;
        double precision = 0.0;
        if (actual != 0L) {
            precision = ((double)correct + 0.5 * (double)partial) / (double)actual;
        }
        double recall = 0.0;
        if (possible != 0L) {
            recall = ((double)correct + 0.5 * (double)partial) / (double)possible;
        }
        double fmeasure = 0.0;
        if (this.beta * this.beta * precision + recall != 0.0) {
            fmeasure = (this.beta * this.beta + 1.0) * precision * recall / (this.beta * this.beta * precision + recall);
        }
        long proc_correct = 0L;
        long proc_partial = 0L;
        long proc_spurious = 0L;
        long proc_missing = 0L;
        long proc_actual = 0L;
        long proc_possible = 0L;
        double proc_precision = 0.0;
        double proc_recall = 0.0;
        double proc_fmeasure = 0.0;
        if (hasProcessed) {
            proc_correct = this.proc_correctByType.get(annotType) == null ? 0L : this.proc_correctByType.get(annotType);
            proc_partial = this.proc_partialByType.get(annotType) == null ? 0L : this.proc_partialByType.get(annotType);
            proc_spurious = this.proc_spurByType.get(annotType) == null ? 0L : this.proc_spurByType.get(annotType);
            proc_missing = this.proc_missingByType.get(annotType) == null ? 0L : this.proc_missingByType.get(annotType);
            proc_actual = proc_correct + proc_partial + proc_spurious;
            proc_possible = proc_correct + proc_partial + proc_missing;
            proc_precision = ((double)proc_correct + 0.5 * (double)proc_partial) / (double)proc_actual;
            proc_recall = ((double)proc_correct + 0.5 * (double)proc_partial) / (double)proc_possible;
            proc_fmeasure = (this.beta * this.beta + 1.0) * proc_precision * proc_recall / (this.beta * this.beta * proc_precision + proc_recall);
        }
        Out.prln("<TR>");
        if (hasProcessed) {
            Out.prln("<TD>" + annotType + "_new</TD>");
        } else {
            Out.prln("<TD>" + annotType + "</TD>");
        }
        Out.prln("<TD>" + correct + "</TD>");
        Out.prln("<TD>" + partial + "</TD>");
        Out.prln("<TD>" + missing + "</TD>");
        Out.prln("<TD>" + spurious + "</TD>");
        String strPrec = this.isMoreInfoMode ? this.avgPrint(precision, 4) : Double.toString(precision);
        String strRec = this.isMoreInfoMode ? this.avgPrint(recall, 4) : Double.toString(recall);
        String string = strFmes = this.isMoreInfoMode ? this.avgPrint(fmeasure, 4) : Double.toString(fmeasure);
        if (hasProcessed && precision < proc_precision) {
            Out.prln("<TD><Font color=red>" + strPrec + "</TD>");
        } else if (hasProcessed && precision > proc_precision) {
            Out.prln("<TD><Font color=blue>" + strPrec + "</TD>");
        } else {
            Out.prln("<TD>" + strPrec + "</TD>");
        }
        if (hasProcessed && recall < proc_recall) {
            Out.prln("<TD><Font color=red>" + strRec + "</TD>");
        } else if (hasProcessed && recall > proc_recall) {
            Out.prln("<TD><Font color=blue>" + strRec + "</TD>");
        } else {
            Out.prln("<TD>" + strRec + "</TD>");
        }
        Out.prln("<TD>" + strFmes + "</TD>");
        Out.prln("</TR>");
        if (hasProcessed) {
            String strProcFmes;
            Out.prln("<TR>");
            Out.prln("<TD>" + annotType + "_old</TD>");
            Out.prln("<TD>" + proc_correct + "</TD>");
            Out.prln("<TD>" + proc_partial + "</TD>");
            Out.prln("<TD>" + proc_missing + "</TD>");
            Out.prln("<TD>" + proc_spurious + "</TD>");
            String strProcPrec = this.isMoreInfoMode ? this.avgPrint(proc_precision, 4) : Double.toString(proc_precision);
            String strProcRec = this.isMoreInfoMode ? this.avgPrint(proc_recall, 4) : Double.toString(proc_recall);
            String string2 = strProcFmes = this.isMoreInfoMode ? this.avgPrint(proc_fmeasure, 4) : Double.toString(proc_fmeasure);
            if (precision < proc_precision) {
                Out.prln("<TD><Font color=red>" + strProcPrec + "</TD>");
            } else if (precision > proc_precision) {
                Out.prln("<TD><Font color=blue>" + strProcPrec + "</TD>");
            } else {
                Out.prln("<TD>" + strProcPrec + "</TD>");
            }
            if (recall < proc_recall) {
                Out.prln("<TD><Font color=red>" + strProcRec + "</TD>");
            } else if (recall > proc_recall) {
                Out.prln("<TD><Font color=blue>" + strProcRec + "</TD>");
            } else {
                Out.prln("<TD>" + strProcRec + "</TD>");
            }
            Out.prln("<TD>" + strProcFmes + "</TD>");
            Out.prln("</TR>");
        }
    }

    protected String avgPrint(double value, int count) {
        double power = Math.pow(10.0, count);
        double newvalue = (double)Math.round(value * power) / power;
        return Double.toString(newvalue);
    }

    public double getPrecisionAverageCalc() {
        return this.precisionSumCalc;
    }

    public double getRecallAverageCalc() {
        return this.recallSumCalc;
    }

    public double getFmeasureAverageCalc() {
        return this.fMeasureSumCalc;
    }

    protected void calculateAvgTotal() {
        if (annotTypes == null) {
            return;
        }
        long missingSum = 0L;
        long spuriousSum = 0L;
        long partialSum = 0L;
        long correctSum = 0L;
        for (int i = 0; i < annotTypes.size(); ++i) {
            String annotType = annotTypes.get(i);
            long correct = this.correctByType.get(annotType) == null ? 0L : this.correctByType.get(annotType);
            long partial = this.partialByType.get(annotType) == null ? 0L : this.partialByType.get(annotType);
            long spurious = this.spurByType.get(annotType) == null ? 0L : this.spurByType.get(annotType);
            long missing = this.missingByType.get(annotType) == null ? 0L : this.missingByType.get(annotType);
            correctSum += correct;
            partialSum += partial;
            spuriousSum += spurious;
            missingSum += missing;
        }
        long actual = correctSum + partialSum + spuriousSum;
        long possible = correctSum + partialSum + missingSum;
        this.precisionSumCalc = actual == 0L ? 0.0 : ((double)correctSum + 0.5 * (double)partialSum) / (double)actual;
        this.recallSumCalc = possible == 0L ? 0.0 : ((double)correctSum + 0.5 * (double)partialSum) / (double)actual;
        this.fMeasureSumCalc = this.precisionSumCalc == 0.0 && this.recallSumCalc == 0.0 ? 0.0 : (this.beta * this.beta + 1.0) * this.precisionSumCalc * this.recallSumCalc / (this.beta * this.beta * this.precisionSumCalc + this.recallSumCalc);
    }

    protected AnnotationDiffer measureDocs(Document keyDoc, Document respDoc, String annotType) throws ResourceInstantiationException {
        AnnotationSet responses;
        AnnotationSet keys;
        if (keyDoc == null || respDoc == null) {
            return null;
        }
        if (this.annotSetName != null && keyDoc.getAnnotations(this.annotSetName).get(annotType) == null) {
            return null;
        }
        if ((this.annotSetName == null || this.annotSetName.equals("")) && keyDoc.getAnnotations().get(annotType) == null) {
            return null;
        }
        AnnotationDiffer annotDiffer = new AnnotationDiffer();
        annotDiffer.setSignificantFeaturesSet(this.diffFeaturesSet);
        if (this.annotSetName == null || this.annotSetName.equals("")) {
            keys = keyDoc.getAnnotations().get(annotType);
            responses = respDoc.getAnnotations().get(annotType);
        } else {
            keys = keyDoc.getAnnotations(this.annotSetName).get(annotType);
            responses = respDoc.getAnnotations(this.outputSetName).get(annotType);
        }
        annotDiffer.calculateDiff(keys, responses);
        return annotDiffer;
    }

    protected void storeAnnotations(String type, AnnotationDiffer annotDiffer, Document keyDoc, Document respDoc, Writer errFileWriter) {
        if (errFileWriter == null) {
            return;
        }
        try {
            OffsetComparator comp = new OffsetComparator();
            TreeSet<Annotation> sortedSet = new TreeSet<Annotation>(comp);
            Set<Annotation> missingSet = annotDiffer.getAnnotationsOfType(2);
            sortedSet.clear();
            sortedSet.addAll(missingSet);
            this.storeAnnotations(type + ".miss", sortedSet, keyDoc, errFileWriter);
            Set<Annotation> spuriousSet = annotDiffer.getAnnotationsOfType(3);
            sortedSet.clear();
            sortedSet.addAll(spuriousSet);
            this.storeAnnotations(type + ".spur", sortedSet, respDoc, errFileWriter);
            Set<Annotation> partialSet = annotDiffer.getAnnotationsOfType(1);
            sortedSet.clear();
            sortedSet.addAll(partialSet);
            this.storeAnnotations(type + ".part", sortedSet, respDoc, errFileWriter);
        }
        catch (Exception ex) {
            Out.prln("Exception on close of error file " + errFileWriter + ": " + ex.getMessage());
        }
    }

    protected void storeAnnotations(String type, Set<Annotation> set, Document doc, Writer file) throws IOException {
        if (set == null || set.isEmpty()) {
            return;
        }
        for (Annotation ann : set) {
            file.write(type);
            file.write(".");
            file.write(doc.getContent().toString().substring(ann.getStartNode().getOffset().intValue(), ann.getEndNode().getOffset().intValue()));
            file.write(".");
            file.write(ann.getStartNode().getOffset().toString());
            file.write(".");
            file.write(ann.getEndNode().getOffset().toString());
            file.write("\n");
        }
    }

    protected void printAnnotations(AnnotationDiffer annotDiff, Document keyDoc, Document respDoc) {
        Out.pr("MISSING ANNOTATIONS in the automatic texts: ");
        Set<Annotation> missingSet = annotDiff.getAnnotationsOfType(2);
        this.printAnnotations(missingSet, keyDoc);
        Out.prln("<BR>");
        Out.pr("SPURIOUS ANNOTATIONS in the automatic texts: ");
        Set<Annotation> spuriousSet = annotDiff.getAnnotationsOfType(3);
        this.printAnnotations(spuriousSet, respDoc);
        Out.prln("</BR>");
        Out.pr("PARTIALLY CORRECT ANNOTATIONS in the automatic texts: ");
        Set<Annotation> partialSet = annotDiff.getAnnotationsOfType(1);
        this.printAnnotations(partialSet, respDoc);
    }

    protected void printAnnotations(Set<Annotation> set, Document doc) {
        if (set == null || set.isEmpty()) {
            return;
        }
        for (Annotation ann : set) {
            Out.prln("<B>" + doc.getContent().toString().substring(ann.getStartNode().getOffset().intValue(), ann.getEndNode().getOffset().intValue()) + "</B>: <I>[" + ann.getStartNode().getOffset() + "," + ann.getEndNode().getOffset() + "]</I>");
        }
    }

    static {
        hasProcessed = false;
        corpusWordCount = 0;
        usage = "usage: CorpusBenchmarkTool [-generate|-marked_stored|-marked_clean] [-verbose] [-moreinfo] directory-name application";
    }
}

