/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JFontChooser
extends JPanel {
    JComboBox<String> familyCombo;
    JCheckBox italicChk;
    JCheckBox boldChk;
    JComboBox<String> sizeCombo;
    JTextArea sampleTextArea;
    private Font fontValue;

    public JFontChooser() {
        this(UIManager.getFont("Button.font"));
    }

    public JFontChooser(Font initialFont) {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        this.setFontValue(initialFont);
    }

    public static Font showDialog(Component parent, String title, Font initialfont) {
        Window windowParent = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (windowParent == null) {
            throw new IllegalArgumentException("The supplied parent component has no window ancestor");
        }
        final JDialog dialog = windowParent instanceof Frame ? new JDialog((Frame)windowParent, title, true) : new JDialog((Dialog)windowParent, title, true);
        dialog.getContentPane().setLayout(new BoxLayout(dialog.getContentPane(), 1));
        final JFontChooser fontChooser = new JFontChooser(initialfont);
        dialog.getContentPane().add(fontChooser);
        JButton okBtn = new JButton("OK");
        JButton cancelBtn = new JButton("Cancel");
        JPanel buttonsBox = new JPanel();
        buttonsBox.setLayout(new BoxLayout(buttonsBox, 0));
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.add(okBtn);
        buttonsBox.add(Box.createHorizontalStrut(30));
        buttonsBox.add(cancelBtn);
        buttonsBox.add(Box.createHorizontalGlue());
        dialog.getContentPane().add(buttonsBox);
        dialog.pack();
        fontChooser.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                dialog.pack();
            }
        });
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                fontChooser.setFontValue(null);
            }
        });
        dialog.setVisible(true);
        return fontChooser.getFontValue();
    }

    protected void initLocalData() {
    }

    protected void initGuiComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.familyCombo = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.familyCombo.setSelectedItem(UIManager.getFont("Label.font").getFamily());
        this.sizeCombo = new JComboBox<String>(new String[]{"6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26"});
        this.sizeCombo.setSelectedItem(Integer.toString(UIManager.getFont("Label.font").getSize()));
        this.italicChk = new JCheckBox("<html><i>Italic</i></html>", false);
        this.boldChk = new JCheckBox("<html><i=b>Bold</b></html>", false);
        JPanel fontBox = new JPanel();
        fontBox.setLayout(new BoxLayout(fontBox, 0));
        fontBox.add(this.familyCombo);
        fontBox.add(this.sizeCombo);
        fontBox.setBorder(BorderFactory.createTitledBorder(" Font "));
        this.add(fontBox);
        this.add(Box.createVerticalStrut(10));
        JPanel effectsBox = new JPanel();
        effectsBox.setLayout(new BoxLayout(effectsBox, 0));
        effectsBox.add(this.italicChk);
        effectsBox.add(this.boldChk);
        effectsBox.setBorder(BorderFactory.createTitledBorder(" Effects "));
        this.add(effectsBox);
        this.add(Box.createVerticalStrut(10));
        this.sampleTextArea = new JTextArea("Type your sample here...");
        JPanel samplePanel = new JPanel();
        samplePanel.setLayout(new BoxLayout(samplePanel, 0));
        samplePanel.add(this.sampleTextArea);
        samplePanel.setBorder(BorderFactory.createTitledBorder(" Sample "));
        this.add(samplePanel);
        this.add(Box.createVerticalStrut(10));
    }

    protected void initListeners() {
        this.familyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFontChooser.this.updateFont();
            }
        });
        this.sizeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFontChooser.this.updateFont();
            }
        });
        this.boldChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFontChooser.this.updateFont();
            }
        });
        this.italicChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFontChooser.this.updateFont();
            }
        });
    }

    protected void updateFont() {
        HashMap<TextAttribute, Object> fontAttrs = new HashMap<TextAttribute, Object>();
        fontAttrs.put(TextAttribute.FAMILY, this.familyCombo.getSelectedItem());
        fontAttrs.put(TextAttribute.SIZE, Float.valueOf((String)this.sizeCombo.getSelectedItem()));
        if (this.boldChk.isSelected()) {
            fontAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            fontAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
        if (this.italicChk.isSelected()) {
            fontAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            fontAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        }
        Font newFont = new Font(fontAttrs);
        Font oldFont = this.fontValue;
        this.fontValue = newFont;
        this.sampleTextArea.setFont(newFont);
        String text = this.sampleTextArea.getText();
        this.sampleTextArea.setText("");
        this.sampleTextArea.setText(text);
        this.sampleTextArea.repaint(100L);
        this.firePropertyChange("fontValue", oldFont, newFont);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final JFrame frame = new JFrame("Foo frame");
        frame.setDefaultCloseOperation(2);
        JButton btn = new JButton("Show dialog");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(JFontChooser.showDialog(frame, "Fonter", UIManager.getFont("Button.font")));
            }
        });
        frame.getContentPane().add(btn);
        frame.setSize(new Dimension(300, 300));
        frame.setVisible(true);
        System.out.println("Font: " + UIManager.getFont("Button.font"));
        JFontChooser.showDialog(frame, "Fonter", UIManager.getFont("Button.font"));
    }

    public void setFontValue(Font newfontValue) {
        this.boldChk.setSelected(newfontValue.isBold());
        this.italicChk.setSelected(newfontValue.isItalic());
        this.familyCombo.setSelectedItem(newfontValue.getName());
        this.sizeCombo.setSelectedItem(Integer.toString(newfontValue.getSize()));
        this.fontValue = newfontValue;
    }

    public Font getFontValue() {
        return this.fontValue;
    }
}

