/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyEventDispatcher;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.FocusManager;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BlockingGlassPane
extends JPanel {
    private int blockCount = 0;
    private BlockMouse blockMouse = new BlockMouse();
    private BlockKeys blockKeys = new BlockKeys();

    public BlockingGlassPane() {
        this.setVisible(false);
        this.setOpaque(false);
        this.addMouseListener(this.blockMouse);
    }

    public void block(boolean block) {
        if (block) {
            if (this.blockCount == 0) {
                this.setVisible(true);
                this.setCursor(Cursor.getPredefinedCursor(3));
                FocusManager.getCurrentManager().addKeyEventDispatcher(this.blockKeys);
            }
            ++this.blockCount;
        } else {
            --this.blockCount;
            if (this.blockCount == 0) {
                FocusManager.getCurrentManager().removeKeyEventDispatcher(this.blockKeys);
                this.setCursor(Cursor.getDefaultCursor());
                this.setVisible(false);
            }
        }
    }

    public boolean isBlocked() {
        return this.blockCount > 0;
    }

    private class BlockMouse
    extends MouseAdapter {
        private BlockMouse() {
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private class BlockKeys
    implements KeyEventDispatcher {
        private BlockKeys() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent ev) {
            Component source = ev.getComponent();
            if (source != null && SwingUtilities.isDescendingFrom(source, BlockingGlassPane.this.getParent())) {
                Toolkit.getDefaultToolkit().beep();
                ev.consume();
                return true;
            }
            return false;
        }
    }
}

