/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class YellowBallIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        Shape shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 48.0, 48.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 0.6f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.070555f, 0.0f, 0.0f, 0.525f, -0.892755f, 22.5f));
        paint = new RadialGradientPaint(new Point2D.Double(23.85714340209961, 40.0), 17.142857f, new Point2D.Double(23.85714340209961, 40.0), new float[]{0.0f, 1.0f}, new Color[]{YellowBallIcon.getColor(0, 0, 0, 255, disabled), YellowBallIcon.getColor(0, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.5f, 1.893048E-14f, 20.0f));
        shape = new GeneralPath();
        ((Path2D.Float)shape).moveTo(41.0, 40.0);
        ((Path2D.Float)shape).curveTo(41.0, 44.733868, 33.324883, 48.571426, 23.857143, 48.571426);
        ((Path2D.Float)shape).curveTo(14.389405, 48.571426, 6.714287, 44.733868, 6.714287, 40.0);
        ((Path2D.Float)shape).curveTo(6.714287, 35.266132, 14.389405, 31.428572, 23.857143, 31.428572);
        ((Path2D.Float)shape).curveTo(33.324883, 31.428572, 41.0, 35.266132, 41.0, 40.0);
        ((Path2D)shape).closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        float alpha__0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_1 = g.getClip();
        AffineTransform defaultTransform__0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_1_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_1_0 = g.getClip();
        AffineTransform defaultTransform__0_1_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(36.91797637939453, 66.2880630493164), new Point2D.Double(19.071495056152344, 5.541010856628418), new float[]{0.0f, 1.0f}, new Color[]{YellowBallIcon.getColor(164, 164, 0, 255, disabled), YellowBallIcon.getColor(255, 255, 23, 255, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.920488f, 0.0f, 0.0f, 0.920488f, 2.368532f, 0.97408f));
        shape = new Ellipse2D.Double(2.500030517578125, 1.5000743865966797, 42.99993896484375, 42.99993896484375);
        g.setPaint(paint);
        g.fill(shape);
        paint = YellowBallIcon.getColor(178, 178, 0, 255, disabled);
        stroke = new BasicStroke(0.99999976f, 0, 0, 4.0f, null, 0.0f);
        shape = new Ellipse2D.Double(2.500030517578125, 1.5000743865966797, 42.99993896484375, 42.99993896484375);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_1_0;
        g.setTransform(defaultTransform__0_1_0);
        g.setClip(clip__0_1_0);
        float alpha__0_1_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 0.34659088f));
        Shape clip__0_1_1 = g.getClip();
        AffineTransform defaultTransform__0_1_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = YellowBallIcon.getColor(204, 0, 0, 0, disabled);
        shape = new Ellipse2D.Double(3.46136474609375, 2.461406707763672, 41.077266693115234, 41.077266693115234);
        g.setPaint(paint);
        g.fill(shape);
        paint = new LinearGradientPaint(new Point2D.Double(43.93581008911133, 53.83598327636719), new Point2D.Double(20.064685821533203, -8.562670707702637), new float[]{0.0f, 1.0f}, new Color[]{YellowBallIcon.getColor(255, 230, 155, 255, disabled), YellowBallIcon.getColor(255, 255, 255, 255, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.856093f, 0.0f, 0.0f, 0.856093f, 1.818275f, 0.197769f));
        stroke = new BasicStroke(0.99999887f, 0, 0, 4.0f, null, 0.0f);
        shape = new Ellipse2D.Double(3.46136474609375, 2.461406707763672, 41.077266693115234, 41.077266693115234);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_1_1;
        g.setTransform(defaultTransform__0_1_1);
        g.setClip(clip__0_1_1);
        origAlpha = alpha__0_1;
        g.setTransform(defaultTransform__0_1);
        g.setClip(clip__0_1);
        float alpha__0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_2 = g.getClip();
        AffineTransform defaultTransform__0_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_2_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_2_0 = g.getClip();
        AffineTransform defaultTransform__0_2_0 = g.getTransform();
        g.transform(new AffineTransform(1.002994f, 0.0f, 0.0f, 1.002994f, -0.07185874f, 0.01968356f));
        paint = new LinearGradientPaint(new Point2D.Double(21.993772506713867, 33.9553f), new Point2D.Double(20.917078018188477, 15.81460189819336), new float[]{0.0f, 1.0f}, new Color[]{YellowBallIcon.getColor(255, 254, 255, 85, disabled), YellowBallIcon.getColor(255, 254, 255, 55, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new GeneralPath();
        ((Path2D.Float)shape).moveTo(43.370686, 21.715487);
        ((GeneralPath)shape).curveTo(43.370686, 32.5461, 33.016357, 15.449178, 24.695948, 22.101873);
        ((GeneralPath)shape).curveTo(16.569626, 28.599384, 4.098984, 34.292423, 4.098984, 23.461805);
        ((GeneralPath)shape).curveTo(4.098984, 12.377753, 12.79438, 2.094803, 23.625, 2.094803);
        ((GeneralPath)shape).curveTo(34.45562, 2.094803, 43.370686, 10.884868, 43.370686, 21.715487);
        ((GeneralPath)shape).closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_2_0;
        g.setTransform(defaultTransform__0_2_0);
        g.setClip(clip__0_2_0);
        origAlpha = alpha__0_2;
        g.setTransform(defaultTransform__0_2);
        g.setClip(clip__0_2);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 3;
    }

    public static int getOrigY() {
        return 2;
    }

    public static int getOrigWidth() {
        return 48;
    }

    public static int getOrigHeight() {
        return 48;
    }

    public YellowBallIcon() {
        this(YellowBallIcon.getOrigWidth(), YellowBallIcon.getOrigHeight(), false);
    }

    public YellowBallIcon(boolean disabled) {
        this(YellowBallIcon.getOrigWidth(), YellowBallIcon.getOrigHeight(), disabled);
    }

    public YellowBallIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public YellowBallIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public YellowBallIcon(int width, int height) {
        this(width, height, false);
    }

    public YellowBallIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)YellowBallIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)YellowBallIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        YellowBallIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

