/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class OpenFileIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        Shape shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(0.9666919f, 0.0f, 0.0f, 0.9666919f, 0.13174409f, 1.0722115f));
        float alpha__0_0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0_0 = g.getTransform();
        g.transform(new AffineTransform(-0.880954f, -0.473203f, 0.365772f, -0.930705f, 0.0f, 0.0f));
        paint = OpenFileIcon.getColor(255, 97, 0, 255, disabled);
        shape = new Rectangle2D.Double(-65.68597412109375, -33.63661575317383, 48.274662017822266, 40.721622467041016);
        g.setPaint(paint);
        g.fill(shape);
        paint = OpenFileIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.1889937f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(-65.68597412109375, -33.63661575317383, 48.274662017822266, 40.721622467041016);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0_0;
        g.setTransform(defaultTransform__0_0_0_0);
        g.setClip(clip__0_0_0_0);
        float alpha__0_0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_0_1 = g.getTransform();
        g.transform(new AffineTransform(-0.882966f, -0.469436f, 0.49617f, -0.868225f, 0.0f, 0.0f));
        paint = OpenFileIcon.getColor(245, 176, 134, 255, disabled);
        shape = new Rectangle2D.Double(-70.21683502197266, -33.98326873779297, 48.297786712646484, 36.08956f);
        g.setPaint(paint);
        g.fill(shape);
        paint = OpenFileIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.1195971f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(-70.21683502197266, -33.98326873779297, 48.297786712646484, 36.08956f);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0_1;
        g.setTransform(defaultTransform__0_0_0_1);
        g.setClip(clip__0_0_0_1);
        float alpha__0_0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_0_2 = g.getTransform();
        g.transform(new AffineTransform(-0.882966f, -0.469436f, 0.49617f, -0.868225f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(-30.031288146972656, -25.22644805908203), new Point2D.Double(-49.83999f, 1.81808f), new float[]{0.0f, 1.0f}, new Color[]{OpenFileIcon.getColor(255, 97, 0, 255, disabled), OpenFileIcon.getColor(255, 97, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new Rectangle2D.Double(-70.54749298095703, -33.77324676513672, 48.2977180480957, 36.08952713012695);
        g.setPaint(paint);
        g.fill(shape);
        paint = OpenFileIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.1195956f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(-70.54749298095703, -33.77324676513672, 48.2977180480957, 36.08952713012695);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0_2;
        g.setTransform(defaultTransform__0_0_0_2);
        g.setClip(clip__0_0_0_2);
        float alpha__0_0_0_3 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_3 = g.getClip();
        AffineTransform defaultTransform__0_0_0_3 = g.getTransform();
        g.transform(new AffineTransform(0.877779f, 0.479065f, -0.437943f, 0.899003f, 0.0f, 0.0f));
        paint = OpenFileIcon.getColor(245, 176, 134, 255, disabled);
        shape = new Rectangle2D.Double(21.09636f, 19.323244094848633, 47.253204345703125, 4.883510589599609);
        g.setPaint(paint);
        g.fill(shape);
        paint = OpenFileIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.96075296f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(21.09636f, 19.323244094848633, 47.253204345703125, 4.883510589599609);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0_3;
        g.setTransform(defaultTransform__0_0_0_3);
        g.setClip(clip__0_0_0_3);
        float alpha__0_0_0_4 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_4 = g.getClip();
        AffineTransform defaultTransform__0_0_0_4 = g.getTransform();
        g.transform(new AffineTransform(0.881872f, 0.471488f, -0.471488f, 0.881872f, 0.0f, 0.0f));
        float alpha__0_0_0_4_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_4_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0_4_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = OpenFileIcon.getColor(0, 0, 0, 255, disabled);
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(44.939804, 9.99171);
        ((GeneralPath)shape).lineTo(49.967144, 9.99171);
        ((GeneralPath)shape).lineTo(49.967144, 10.9878025);
        ((GeneralPath)shape).lineTo(46.123398, 10.9878025);
        ((GeneralPath)shape).lineTo(46.123398, 13.565926);
        ((GeneralPath)shape).lineTo(49.592144, 13.565926);
        ((GeneralPath)shape).lineTo(49.592144, 14.562018);
        ((GeneralPath)shape).lineTo(46.123398, 14.562018);
        ((GeneralPath)shape).lineTo(46.123398, 18.73975);
        ((GeneralPath)shape).lineTo(44.939804, 18.73975);
        ((GeneralPath)shape).lineTo(44.939804, 9.99171);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0_4_0;
        g.setTransform(defaultTransform__0_0_0_4_0);
        g.setClip(clip__0_0_0_4_0);
        float alpha__0_0_0_4_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_4_1 = g.getClip();
        AffineTransform defaultTransform__0_0_0_4_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = OpenFileIcon.getColor(0, 0, 0, 255, disabled);
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(51.85386, 9.99171);
        ((GeneralPath)shape).lineTo(53.037453, 9.99171);
        ((GeneralPath)shape).lineTo(53.037453, 18.73975);
        ((GeneralPath)shape).lineTo(51.85386, 18.73975);
        ((GeneralPath)shape).lineTo(51.85386, 9.99171);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0_4_1;
        g.setTransform(defaultTransform__0_0_0_4_1);
        g.setClip(clip__0_0_0_4_1);
        float alpha__0_0_0_4_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_4_2 = g.getClip();
        AffineTransform defaultTransform__0_0_0_4_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = OpenFileIcon.getColor(0, 0, 0, 255, disabled);
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(55.39292, 9.99171);
        ((GeneralPath)shape).lineTo(56.576515, 9.99171);
        ((GeneralPath)shape).lineTo(56.576515, 17.743656);
        ((GeneralPath)shape).lineTo(60.836277, 17.743656);
        ((GeneralPath)shape).lineTo(60.836277, 18.73975);
        ((GeneralPath)shape).lineTo(55.39292, 18.73975);
        ((GeneralPath)shape).lineTo(55.39292, 9.99171);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0_4_2;
        g.setTransform(defaultTransform__0_0_0_4_2);
        g.setClip(clip__0_0_0_4_2);
        float alpha__0_0_0_4_3 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_4_3 = g.getClip();
        AffineTransform defaultTransform__0_0_0_4_3 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = OpenFileIcon.getColor(0, 0, 0, 255, disabled);
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(62.0726, 9.99171);
        ((GeneralPath)shape).lineTo(67.60385, 9.99171);
        ((GeneralPath)shape).lineTo(67.60385, 10.9878025);
        ((GeneralPath)shape).lineTo(63.2562, 10.9878025);
        ((GeneralPath)shape).lineTo(63.2562, 13.577644);
        ((GeneralPath)shape).lineTo(67.42221, 13.577644);
        ((GeneralPath)shape).lineTo(67.42221, 14.573737);
        ((GeneralPath)shape).lineTo(63.2562, 14.573737);
        ((GeneralPath)shape).lineTo(63.2562, 17.743656);
        ((GeneralPath)shape).lineTo(67.70932, 17.743656);
        ((GeneralPath)shape).lineTo(67.70932, 18.73975);
        ((GeneralPath)shape).lineTo(62.072605, 18.73975);
        ((GeneralPath)shape).lineTo(62.072605, 9.99171);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0_4_3;
        g.setTransform(defaultTransform__0_0_0_4_3);
        g.setClip(clip__0_0_0_4_3);
        origAlpha = alpha__0_0_0_4;
        g.setTransform(defaultTransform__0_0_0_4);
        g.setClip(clip__0_0_0_4);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 2;
    }

    public static int getOrigY() {
        return 2;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public OpenFileIcon() {
        this(OpenFileIcon.getOrigWidth(), OpenFileIcon.getOrigHeight(), false);
    }

    public OpenFileIcon(boolean disabled) {
        this(OpenFileIcon.getOrigWidth(), OpenFileIcon.getOrigHeight(), disabled);
    }

    public OpenFileIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public OpenFileIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public OpenFileIcon(int width, int height) {
        this(width, height, false);
    }

    public OpenFileIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)OpenFileIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)OpenFileIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        OpenFileIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

