/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ApplicationIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(0.537991f, 0.0f, 0.0f, 0.530136f, 17.24195f, 12.59654f));
        float alpha__0_0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = ApplicationIcon.getColor(255, 97, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(4.042755, -19.365057);
        shape.curveTo(-7.8215437, -17.997686, 9.529157, -10.300208, -0.89474475, -4.615057);
        shape.curveTo(-11.318646, 1.0700942, -8.966936, -17.377476, -16.363495, -8.240057);
        shape.curveTo(-23.760054, 0.8973612, -5.9015875, -5.6261516, -9.144745, 5.572443);
        shape.curveTo(-12.387902, 16.771038, -24.11123, 2.111303, -22.707245, 13.666193);
        shape.curveTo(-21.303259, 25.221083, -13.419629, 8.326636, -7.582245, 18.478693);
        shape.curveTo(-1.7448606, 28.630749, -20.683088, 26.36878, -11.300995, 33.57244);
        shape.curveTo(-1.9189007, 40.776108, -8.58071, 23.351362, 2.9177554, 26.509943);
        shape.curveTo(14.41622, 29.668522, -0.63404477, 41.096066, 11.230255, 39.72869);
        shape.curveTo(23.094555, 38.36132, 5.7126045, 30.663845, 16.136505, 24.978693);
        shape.curveTo(26.560406, 19.293543, 24.239948, 37.741108, 31.636505, 28.603693);
        shape.curveTo(39.033062, 19.466274, 21.143349, 25.98979, 24.386505, 14.791193);
        shape.curveTo(27.629662, 3.5925972, 39.38424, 18.252333, 37.980255, 6.697443);
        shape.curveTo(36.576267, -4.8574457, 28.66139, 12.036998, 22.824005, 1.8849432);
        shape.curveTo(16.986622, -8.267112, 35.924847, -5.9738936, 26.542755, -13.177557);
        shape.curveTo(17.160662, -20.38122, 23.85372, -2.9877279, 12.355255, -6.146307);
        shape.curveTo(0.85679024, -9.304885, 15.907053, -20.732428, 4.042755, -19.365057);
        shape.closePath();
        shape.moveTo(7.7927556, -1.1150568);
        shape.curveTo(13.463302, -1.1150568, 18.074005, 3.769375, 18.074005, 9.791193);
        shape.curveTo(18.074005, 15.81301, 13.4633, 20.697443, 7.7927556, 20.697443);
        shape.curveTo(2.1222112, 20.697443, -2.4884946, 15.813011, -2.4884946, 9.791193);
        shape.curveTo(-2.4884946, 3.7693741, 2.1222103, -1.1150568, 7.7927556, -1.1150568);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = ApplicationIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.013f, 0, 1, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(4.042755, -19.365057);
        shape.curveTo(-7.8215437, -17.997686, 9.529157, -10.300208, -0.89474475, -4.615057);
        shape.curveTo(-11.318646, 1.0700942, -8.966936, -17.377476, -16.363495, -8.240057);
        shape.curveTo(-23.760054, 0.8973612, -5.9015875, -5.6261516, -9.144745, 5.572443);
        shape.curveTo(-12.387902, 16.771038, -24.11123, 2.111303, -22.707245, 13.666193);
        shape.curveTo(-21.303259, 25.221083, -13.419629, 8.326636, -7.582245, 18.478693);
        shape.curveTo(-1.7448606, 28.630749, -20.683088, 26.36878, -11.300995, 33.57244);
        shape.curveTo(-1.9189007, 40.776108, -8.58071, 23.351362, 2.9177554, 26.509943);
        shape.curveTo(14.41622, 29.668522, -0.63404477, 41.096066, 11.230255, 39.72869);
        shape.curveTo(23.094555, 38.36132, 5.7126045, 30.663845, 16.136505, 24.978693);
        shape.curveTo(26.560406, 19.293543, 24.239948, 37.741108, 31.636505, 28.603693);
        shape.curveTo(39.033062, 19.466274, 21.143349, 25.98979, 24.386505, 14.791193);
        shape.curveTo(27.629662, 3.5925972, 39.38424, 18.252333, 37.980255, 6.697443);
        shape.curveTo(36.576267, -4.8574457, 28.66139, 12.036998, 22.824005, 1.8849432);
        shape.curveTo(16.986622, -8.267112, 35.924847, -5.9738936, 26.542755, -13.177557);
        shape.curveTo(17.160662, -20.38122, 23.85372, -2.9877279, 12.355255, -6.146307);
        shape.curveTo(0.85679024, -9.304885, 15.907053, -20.732428, 4.042755, -19.365057);
        shape.closePath();
        shape.moveTo(7.7927556, -1.1150568);
        shape.curveTo(13.463302, -1.1150568, 18.074005, 3.769375, 18.074005, 9.791193);
        shape.curveTo(18.074005, 15.81301, 13.4633, 20.697443, 7.7927556, 20.697443);
        shape.curveTo(2.1222112, 20.697443, -2.4884946, 15.813011, -2.4884946, 9.791193);
        shape.curveTo(-2.4884946, 3.7693741, 2.1222103, -1.1150568, 7.7927556, -1.1150568);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0_0;
        g.setTransform(defaultTransform__0_0_0_0);
        g.setClip(clip__0_0_0_0);
        float alpha__0_0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(41.272727966308594, 20.0), new Point2D.Double(9.090909004211426, 59.73617935180664), new float[]{0.0f, 1.0f}, new Color[]{ApplicationIcon.getColor(255, 173, 93, 240, disabled), ApplicationIcon.getColor(255, 173, 93, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.858769f, 0.0f, 0.0f, 1.886309f, -32.04879f, -23.76094f));
        shape = new GeneralPath();
        shape.moveTo(1.8552552, -16.615057);
        shape.curveTo(4.3268423, -12.389599, 6.242616, -5.570594, 0.26150525, -2.8650568);
        shape.curveTo(-5.1689677, 1.0453773, -10.645211, -3.5740318, -12.988495, -8.458807);
        shape.curveTo(-19.622936, -4.5127587, -12.27151, -3.6567068, -8.957245, -1.5213068);
        shape.curveTo(-3.2207208, 4.286322, -10.468309, 15.572569, -18.207245, 11.603693);
        shape.curveTo(-23.99832, 10.346797, -19.449268, 19.469612, -15.488495, 13.916193);
        shape.curveTo(-6.724279, 9.93738, 0.04226026, 25.43532, -9.401818, 28.759712);
        shape.curveTo(-15.546361, 29.988605, -5.8175397, 36.645508, -6.6217256, 30.13041);
        shape.curveTo(-4.8541536, 20.229397, 12.328064, 24.536419, 9.105716, 34.04833);
        shape.curveTo(5.100879, 40.209793, 17.702448, 38.351902, 11.460828, 33.28359);
        shape.curveTo(6.6353965, 24.179485, 23.370386, 17.270996, 26.605255, 27.197443);
        shape.curveTo(30.13475, 31.97409, 33.165424, 22.257687, 26.011505, 23.541193);
        shape.curveTo(17.15425, 19.561945, 24.492996, 4.430459, 33.261505, 9.134943);
        shape.curveTo(39.271023, 10.077248, 34.20037, 1.1481862, 30.105255, 6.9786935);
        shape.curveTo(21.087711, 10.299201, 15.245074, -5.318059, 24.886505, -8.302557);
        shape.curveTo(29.8154, -11.232163, 20.011862, -14.728683, 21.199005, -8.052557);
        shape.curveTo(17.609556, 1.1128032, 1.6049923, -5.5786176, 6.292755, -14.740057);
        shape.curveTo(8.431012, -18.796041, 3.7487464, -16.879204, 1.8552552, -16.615057);
        shape.closePath();
        shape.moveTo(8.105255, -2.8963068);
        shape.curveTo(20.221607, -2.7038107, 24.260914, 15.523604, 13.660882, 21.061708);
        shape.curveTo(4.0272064, 27.488108, -8.142912, 15.464196, -3.7384946, 5.353693);
        shape.curveTo(-1.8222617, 0.4545682, 2.7822824, -2.9495928, 8.105255, -2.8963068);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0_1;
        g.setTransform(defaultTransform__0_0_0_1);
        g.setClip(clip__0_0_0_1);
        float alpha__0_0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_0_2 = g.getTransform();
        g.transform(new AffineTransform(0.844092f, 1.037574f, -1.071672f, 0.817236f, 14.44683f, -50.0582f));
        paint = ApplicationIcon.getColor(0, 0, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(35.454544, 31.636364);
        shape.curveTo(35.454544, 33.343426, 34.111397, 34.727272, 32.454544, 34.727272);
        shape.curveTo(30.79769, 34.727272, 29.454544, 33.343426, 29.454544, 31.636364);
        shape.curveTo(29.454544, 29.929302, 30.79769, 28.545456, 32.454544, 28.545456);
        shape.curveTo(34.111397, 28.545456, 35.454544, 29.929302, 35.454544, 31.636364);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0_2;
        g.setTransform(defaultTransform__0_0_0_2);
        g.setClip(clip__0_0_0_2);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(0.537991f, 0.0f, 0.0f, 0.530136f, 43.54928f, 25.59654f));
        float alpha__0_0_1_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_0 = g.getClip();
        AffineTransform defaultTransform__0_0_1_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = ApplicationIcon.getColor(255, 97, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(4.042755, -19.365057);
        shape.curveTo(-7.8215437, -17.997686, 9.529157, -10.300208, -0.89474475, -4.615057);
        shape.curveTo(-11.318646, 1.0700942, -8.966936, -17.377476, -16.363495, -8.240057);
        shape.curveTo(-23.760054, 0.8973612, -5.9015875, -5.6261516, -9.144745, 5.572443);
        shape.curveTo(-12.387902, 16.771038, -24.11123, 2.111303, -22.707245, 13.666193);
        shape.curveTo(-21.303259, 25.221083, -13.419629, 8.326636, -7.582245, 18.478693);
        shape.curveTo(-1.7448606, 28.630749, -20.683088, 26.36878, -11.300995, 33.57244);
        shape.curveTo(-1.9189007, 40.776108, -8.58071, 23.351362, 2.9177554, 26.509943);
        shape.curveTo(14.41622, 29.668522, -0.63404477, 41.096066, 11.230255, 39.72869);
        shape.curveTo(23.094555, 38.36132, 5.7126045, 30.663845, 16.136505, 24.978693);
        shape.curveTo(26.560406, 19.293543, 24.239948, 37.741108, 31.636505, 28.603693);
        shape.curveTo(39.033062, 19.466274, 21.143349, 25.98979, 24.386505, 14.791193);
        shape.curveTo(27.629662, 3.5925972, 39.38424, 18.252333, 37.980255, 6.697443);
        shape.curveTo(36.576267, -4.8574457, 28.66139, 12.036998, 22.824005, 1.8849432);
        shape.curveTo(16.986622, -8.267112, 35.924847, -5.9738936, 26.542755, -13.177557);
        shape.curveTo(17.160662, -20.38122, 23.85372, -2.9877279, 12.355255, -6.146307);
        shape.curveTo(0.85679024, -9.304885, 15.907053, -20.732428, 4.042755, -19.365057);
        shape.closePath();
        shape.moveTo(7.7927556, -1.1150568);
        shape.curveTo(13.463302, -1.1150568, 18.074005, 3.769375, 18.074005, 9.791193);
        shape.curveTo(18.074005, 15.81301, 13.4633, 20.697443, 7.7927556, 20.697443);
        shape.curveTo(2.1222112, 20.697443, -2.4884946, 15.813011, -2.4884946, 9.791193);
        shape.curveTo(-2.4884946, 3.7693741, 2.1222103, -1.1150568, 7.7927556, -1.1150568);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = ApplicationIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.013f, 0, 1, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(4.042755, -19.365057);
        shape.curveTo(-7.8215437, -17.997686, 9.529157, -10.300208, -0.89474475, -4.615057);
        shape.curveTo(-11.318646, 1.0700942, -8.966936, -17.377476, -16.363495, -8.240057);
        shape.curveTo(-23.760054, 0.8973612, -5.9015875, -5.6261516, -9.144745, 5.572443);
        shape.curveTo(-12.387902, 16.771038, -24.11123, 2.111303, -22.707245, 13.666193);
        shape.curveTo(-21.303259, 25.221083, -13.419629, 8.326636, -7.582245, 18.478693);
        shape.curveTo(-1.7448606, 28.630749, -20.683088, 26.36878, -11.300995, 33.57244);
        shape.curveTo(-1.9189007, 40.776108, -8.58071, 23.351362, 2.9177554, 26.509943);
        shape.curveTo(14.41622, 29.668522, -0.63404477, 41.096066, 11.230255, 39.72869);
        shape.curveTo(23.094555, 38.36132, 5.7126045, 30.663845, 16.136505, 24.978693);
        shape.curveTo(26.560406, 19.293543, 24.239948, 37.741108, 31.636505, 28.603693);
        shape.curveTo(39.033062, 19.466274, 21.143349, 25.98979, 24.386505, 14.791193);
        shape.curveTo(27.629662, 3.5925972, 39.38424, 18.252333, 37.980255, 6.697443);
        shape.curveTo(36.576267, -4.8574457, 28.66139, 12.036998, 22.824005, 1.8849432);
        shape.curveTo(16.986622, -8.267112, 35.924847, -5.9738936, 26.542755, -13.177557);
        shape.curveTo(17.160662, -20.38122, 23.85372, -2.9877279, 12.355255, -6.146307);
        shape.curveTo(0.85679024, -9.304885, 15.907053, -20.732428, 4.042755, -19.365057);
        shape.closePath();
        shape.moveTo(7.7927556, -1.1150568);
        shape.curveTo(13.463302, -1.1150568, 18.074005, 3.769375, 18.074005, 9.791193);
        shape.curveTo(18.074005, 15.81301, 13.4633, 20.697443, 7.7927556, 20.697443);
        shape.curveTo(2.1222112, 20.697443, -2.4884946, 15.813011, -2.4884946, 9.791193);
        shape.curveTo(-2.4884946, 3.7693741, 2.1222103, -1.1150568, 7.7927556, -1.1150568);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1_0;
        g.setTransform(defaultTransform__0_0_1_0);
        g.setClip(clip__0_0_1_0);
        float alpha__0_0_1_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(41.272727966308594, 20.0), new Point2D.Double(9.090909004211426, 59.73617935180664), new float[]{0.0f, 1.0f}, new Color[]{ApplicationIcon.getColor(255, 173, 93, 240, disabled), ApplicationIcon.getColor(255, 173, 93, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.858769f, 0.0f, 0.0f, 1.886309f, -80.94799f, -48.28294f));
        shape = new GeneralPath();
        shape.moveTo(1.8552552, -16.615057);
        shape.curveTo(4.3268423, -12.389599, 6.242616, -5.570594, 0.26150525, -2.8650568);
        shape.curveTo(-5.1689677, 1.0453773, -10.645211, -3.5740318, -12.988495, -8.458807);
        shape.curveTo(-19.622936, -4.5127587, -12.27151, -3.6567068, -8.957245, -1.5213068);
        shape.curveTo(-3.2207208, 4.286322, -10.468309, 15.572569, -18.207245, 11.603693);
        shape.curveTo(-23.99832, 10.346797, -19.449268, 19.469612, -15.488495, 13.916193);
        shape.curveTo(-6.724279, 9.93738, 0.04226026, 25.43532, -9.401818, 28.759712);
        shape.curveTo(-15.546361, 29.988605, -5.8175397, 36.645508, -6.6217256, 30.13041);
        shape.curveTo(-4.8541536, 20.229397, 12.328064, 24.536419, 9.105716, 34.04833);
        shape.curveTo(5.100879, 40.209793, 17.702448, 38.351902, 11.460828, 33.28359);
        shape.curveTo(6.6353965, 24.179485, 23.370386, 17.270996, 26.605255, 27.197443);
        shape.curveTo(30.13475, 31.97409, 33.165424, 22.257687, 26.011505, 23.541193);
        shape.curveTo(17.15425, 19.561945, 24.492996, 4.430459, 33.261505, 9.134943);
        shape.curveTo(39.271023, 10.077248, 34.20037, 1.1481862, 30.105255, 6.9786935);
        shape.curveTo(21.087711, 10.299201, 15.245074, -5.318059, 24.886505, -8.302557);
        shape.curveTo(29.8154, -11.232163, 20.011862, -14.728683, 21.199005, -8.052557);
        shape.curveTo(17.609556, 1.1128032, 1.6049923, -5.5786176, 6.292755, -14.740057);
        shape.curveTo(8.431012, -18.796041, 3.7487464, -16.879204, 1.8552552, -16.615057);
        shape.closePath();
        shape.moveTo(8.105255, -2.8963068);
        shape.curveTo(20.221607, -2.7038107, 24.260914, 15.523604, 13.660882, 21.061708);
        shape.curveTo(4.0272064, 27.488108, -8.142912, 15.464196, -3.7384946, 5.353693);
        shape.curveTo(-1.8222617, 0.4545682, 2.7822824, -2.9495928, 8.105255, -2.8963068);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_1_1;
        g.setTransform(defaultTransform__0_0_1_1);
        g.setClip(clip__0_0_1_1);
        float alpha__0_0_1_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_2 = g.getClip();
        AffineTransform defaultTransform__0_0_1_2 = g.getTransform();
        g.transform(new AffineTransform(0.844092f, 1.037574f, -1.071672f, 0.817236f, 14.44683f, -50.0582f));
        paint = ApplicationIcon.getColor(0, 0, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(35.454544, 31.636364);
        shape.curveTo(35.454544, 33.343426, 34.111397, 34.727272, 32.454544, 34.727272);
        shape.curveTo(30.79769, 34.727272, 29.454544, 33.343426, 29.454544, 31.636364);
        shape.curveTo(29.454544, 29.929302, 30.79769, 28.545456, 32.454544, 28.545456);
        shape.curveTo(34.111397, 28.545456, 35.454544, 29.929302, 35.454544, 31.636364);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_1_2;
        g.setTransform(defaultTransform__0_0_1_2);
        g.setClip(clip__0_0_1_2);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(0.525266f, 0.116322f, -0.114624f, 0.517596f, 13.5078f, 39.80751f));
        float alpha__0_0_2_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2_0 = g.getClip();
        AffineTransform defaultTransform__0_0_2_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = ApplicationIcon.getColor(255, 97, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(4.042755, -19.365057);
        shape.curveTo(-7.8215437, -17.997686, 9.529157, -10.300208, -0.89474475, -4.615057);
        shape.curveTo(-11.318646, 1.0700942, -8.966936, -17.377476, -16.363495, -8.240057);
        shape.curveTo(-23.760054, 0.8973612, -5.9015875, -5.6261516, -9.144745, 5.572443);
        shape.curveTo(-12.387902, 16.771038, -24.11123, 2.111303, -22.707245, 13.666193);
        shape.curveTo(-21.303259, 25.221083, -13.419629, 8.326636, -7.582245, 18.478693);
        shape.curveTo(-1.7448606, 28.630749, -20.683088, 26.36878, -11.300995, 33.57244);
        shape.curveTo(-1.9189007, 40.776108, -8.58071, 23.351362, 2.9177554, 26.509943);
        shape.curveTo(14.41622, 29.668522, -0.63404477, 41.096066, 11.230255, 39.72869);
        shape.curveTo(23.094555, 38.36132, 5.7126045, 30.663845, 16.136505, 24.978693);
        shape.curveTo(26.560406, 19.293543, 24.239948, 37.741108, 31.636505, 28.603693);
        shape.curveTo(39.033062, 19.466274, 21.143349, 25.98979, 24.386505, 14.791193);
        shape.curveTo(27.629662, 3.5925972, 39.38424, 18.252333, 37.980255, 6.697443);
        shape.curveTo(36.576267, -4.8574457, 28.66139, 12.036998, 22.824005, 1.8849432);
        shape.curveTo(16.986622, -8.267112, 35.924847, -5.9738936, 26.542755, -13.177557);
        shape.curveTo(17.160662, -20.38122, 23.85372, -2.9877279, 12.355255, -6.146307);
        shape.curveTo(0.85679024, -9.304885, 15.907053, -20.732428, 4.042755, -19.365057);
        shape.closePath();
        shape.moveTo(7.7927556, -1.1150568);
        shape.curveTo(13.463302, -1.1150568, 18.074005, 3.769375, 18.074005, 9.791193);
        shape.curveTo(18.074005, 15.81301, 13.4633, 20.697443, 7.7927556, 20.697443);
        shape.curveTo(2.1222112, 20.697443, -2.4884946, 15.813011, -2.4884946, 9.791193);
        shape.curveTo(-2.4884946, 3.7693741, 2.1222103, -1.1150568, 7.7927556, -1.1150568);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = ApplicationIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.013f, 0, 1, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(4.042755, -19.365057);
        shape.curveTo(-7.8215437, -17.997686, 9.529157, -10.300208, -0.89474475, -4.615057);
        shape.curveTo(-11.318646, 1.0700942, -8.966936, -17.377476, -16.363495, -8.240057);
        shape.curveTo(-23.760054, 0.8973612, -5.9015875, -5.6261516, -9.144745, 5.572443);
        shape.curveTo(-12.387902, 16.771038, -24.11123, 2.111303, -22.707245, 13.666193);
        shape.curveTo(-21.303259, 25.221083, -13.419629, 8.326636, -7.582245, 18.478693);
        shape.curveTo(-1.7448606, 28.630749, -20.683088, 26.36878, -11.300995, 33.57244);
        shape.curveTo(-1.9189007, 40.776108, -8.58071, 23.351362, 2.9177554, 26.509943);
        shape.curveTo(14.41622, 29.668522, -0.63404477, 41.096066, 11.230255, 39.72869);
        shape.curveTo(23.094555, 38.36132, 5.7126045, 30.663845, 16.136505, 24.978693);
        shape.curveTo(26.560406, 19.293543, 24.239948, 37.741108, 31.636505, 28.603693);
        shape.curveTo(39.033062, 19.466274, 21.143349, 25.98979, 24.386505, 14.791193);
        shape.curveTo(27.629662, 3.5925972, 39.38424, 18.252333, 37.980255, 6.697443);
        shape.curveTo(36.576267, -4.8574457, 28.66139, 12.036998, 22.824005, 1.8849432);
        shape.curveTo(16.986622, -8.267112, 35.924847, -5.9738936, 26.542755, -13.177557);
        shape.curveTo(17.160662, -20.38122, 23.85372, -2.9877279, 12.355255, -6.146307);
        shape.curveTo(0.85679024, -9.304885, 15.907053, -20.732428, 4.042755, -19.365057);
        shape.closePath();
        shape.moveTo(7.7927556, -1.1150568);
        shape.curveTo(13.463302, -1.1150568, 18.074005, 3.769375, 18.074005, 9.791193);
        shape.curveTo(18.074005, 15.81301, 13.4633, 20.697443, 7.7927556, 20.697443);
        shape.curveTo(2.1222112, 20.697443, -2.4884946, 15.813011, -2.4884946, 9.791193);
        shape.curveTo(-2.4884946, 3.7693741, 2.1222103, -1.1150568, 7.7927556, -1.1150568);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_2_0;
        g.setTransform(defaultTransform__0_0_2_0);
        g.setClip(clip__0_0_2_0);
        float alpha__0_0_2_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2_1 = g.getClip();
        AffineTransform defaultTransform__0_0_2_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(41.272727966308594, 20.0), new Point2D.Double(9.090909004211426, 59.73617935180664), new float[]{0.0f, 1.0f}, new Color[]{ApplicationIcon.getColor(255, 173, 93, 240, disabled), ApplicationIcon.getColor(255, 173, 93, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.814802f, -0.40785f, 0.401895f, 1.841689f, -40.51238f, -67.80385f));
        shape = new GeneralPath();
        shape.moveTo(1.8552552, -16.615057);
        shape.curveTo(4.3268423, -12.389599, 6.242616, -5.570594, 0.26150525, -2.8650568);
        shape.curveTo(-5.1689677, 1.0453773, -10.645211, -3.5740318, -12.988495, -8.458807);
        shape.curveTo(-19.622936, -4.5127587, -12.27151, -3.6567068, -8.957245, -1.5213068);
        shape.curveTo(-3.2207208, 4.286322, -10.468309, 15.572569, -18.207245, 11.603693);
        shape.curveTo(-23.99832, 10.346797, -19.449268, 19.469612, -15.488495, 13.916193);
        shape.curveTo(-6.724279, 9.93738, 0.04226026, 25.43532, -9.401818, 28.759712);
        shape.curveTo(-15.546361, 29.988605, -5.8175397, 36.645508, -6.6217256, 30.13041);
        shape.curveTo(-4.8541536, 20.229397, 12.328064, 24.536419, 9.105716, 34.04833);
        shape.curveTo(5.100879, 40.209793, 17.702448, 38.351902, 11.460828, 33.28359);
        shape.curveTo(6.6353965, 24.179485, 23.370386, 17.270996, 26.605255, 27.197443);
        shape.curveTo(30.13475, 31.97409, 33.165424, 22.257687, 26.011505, 23.541193);
        shape.curveTo(17.15425, 19.561945, 24.492996, 4.430459, 33.261505, 9.134943);
        shape.curveTo(39.271023, 10.077248, 34.20037, 1.1481862, 30.105255, 6.9786935);
        shape.curveTo(21.087711, 10.299201, 15.245074, -5.318059, 24.886505, -8.302557);
        shape.curveTo(29.8154, -11.232163, 20.011862, -14.728683, 21.199005, -8.052557);
        shape.curveTo(17.609556, 1.1128032, 1.6049923, -5.5786176, 6.292755, -14.740057);
        shape.curveTo(8.431012, -18.796041, 3.7487464, -16.879204, 1.8552552, -16.615057);
        shape.closePath();
        shape.moveTo(8.105255, -2.8963068);
        shape.curveTo(20.221607, -2.7038107, 24.260914, 15.523604, 13.660882, 21.061708);
        shape.curveTo(4.0272064, 27.488108, -8.142912, 15.464196, -3.7384946, 5.353693);
        shape.curveTo(-1.8222617, 0.4545682, 2.7822824, -2.9495928, 8.105255, -2.8963068);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_2_1;
        g.setTransform(defaultTransform__0_0_2_1);
        g.setClip(clip__0_0_2_1);
        float alpha__0_0_2_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2_2 = g.getTransform();
        g.transform(new AffineTransform(0.844092f, 1.037574f, -1.071672f, 0.817236f, 14.44683f, -50.0582f));
        paint = ApplicationIcon.getColor(0, 0, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(35.454544, 31.636364);
        shape.curveTo(35.454544, 33.343426, 34.111397, 34.727272, 32.454544, 34.727272);
        shape.curveTo(30.79769, 34.727272, 29.454544, 33.343426, 29.454544, 31.636364);
        shape.curveTo(29.454544, 29.929302, 30.79769, 28.545456, 32.454544, 28.545456);
        shape.curveTo(34.111397, 28.545456, 35.454544, 29.929302, 35.454544, 31.636364);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_2_2;
        g.setTransform(defaultTransform__0_0_2_2);
        g.setClip(clip__0_0_2_2);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 0;
    }

    public static int getOrigY() {
        return 2;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public ApplicationIcon() {
        this(ApplicationIcon.getOrigWidth(), ApplicationIcon.getOrigHeight(), false);
    }

    public ApplicationIcon(boolean disabled) {
        this(ApplicationIcon.getOrigWidth(), ApplicationIcon.getOrigHeight(), disabled);
    }

    public ApplicationIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public ApplicationIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public ApplicationIcon(int width, int height) {
        this(width, height, false);
    }

    public ApplicationIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)ApplicationIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)ApplicationIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        ApplicationIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

